/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.util.AminoAcid;
import java.util.Enumeration;
import java.util.Hashtable;

public class AminoAcidInfo {
    private static AminoAcid[] aminoAcids = new AminoAcid[]{new AminoAcid("A", "ALA", "Alanine", 0.616f, 0.0f), new AminoAcid("B", "ASX", "Asparagine", 0.0f, 0.0f), new AminoAcid("C", "CYS", "Cysteine", 0.68f, 0.0f), new AminoAcid("D", "ASP", "Aspartic Acid", 0.028f, 0.0f), new AminoAcid("E", "GLU", "Glutamic Acid", 0.043f, 0.0f), new AminoAcid("F", "PHE", "Phenylalanine", 1.0f, 0.0f), new AminoAcid("G", "GLY", "Glycine", 0.501f, 0.0f), new AminoAcid("H", "HIS", "Histidine", 0.165f, 0.0f), new AminoAcid("I", "ILE", "Isoleucine", 0.943f, 0.0f), new AminoAcid("J", "UNK", "UNKNOWN", 0.0f, 0.0f), new AminoAcid("K", "LYS", "Lysine", 0.283f, 0.0f), new AminoAcid("L", "LEU", "Leucine", 0.943f, 0.0f), new AminoAcid("M", "MET", "Methionine", 0.738f, 0.0f), new AminoAcid("N", "ASN", "Asparagine", 0.236f, 0.0f), new AminoAcid("O", "UNK", "UNKNOWN", 0.0f, 0.0f), new AminoAcid("P", "PRO", "Proline", 0.711f, 0.0f), new AminoAcid("Q", "GLN", "Glutamine", 0.251f, 0.0f), new AminoAcid("R", "ARG", "Arginine", 0.0f, 0.0f), new AminoAcid("S", "SER", "Serine", 0.359f, 0.0f), new AminoAcid("T", "THR", "Threonine", 0.45f, 0.0f), new AminoAcid("U", "UNK", "UNKNOWN", 0.0f, 0.0f), new AminoAcid("V", "VAL", "Valine", 0.825f, 0.0f), new AminoAcid("W", "TRP", "Tryptophane", 0.878f, 0.0f), new AminoAcid("X", "UNK", "UNKNOWN", 0.0f, 0.0f), new AminoAcid("Y", "TYR", "Tyrosine", 0.88f, 0.0f), new AminoAcid("Z", "GLX", "Glutamic Acid", 0.043f, 0.0f), new AminoAcid(".", "end", "End Chain", 0.0f, 0.0f)};
    private static Hashtable letterHash = new Hashtable();
    private static Hashtable codeHash = new Hashtable();
    private static Hashtable nameHash = new Hashtable();
    private static Hashtable nonStandardCodes = new Hashtable();

    public static int getNameCount() {
        return aminoAcids.length;
    }

    public static String getCodeFromLetter(String string) {
        if (string == null) {
            return null;
        }
        AminoAcid aminoAcid = (AminoAcid)letterHash.get(string);
        if (aminoAcid == null) {
            return null;
        }
        return aminoAcid.code;
    }

    public static String getCodeFromLetter(byte by) {
        byte[] byArray = new byte[]{by};
        return AminoAcidInfo.getCodeFromLetter(new String(byArray));
    }

    public static String getLetterFromCode(String string) {
        if (string == null) {
            return null;
        }
        AminoAcid aminoAcid = (AminoAcid)codeHash.get(string);
        if (aminoAcid == null) {
            return null;
        }
        return aminoAcid.letter;
    }

    public static String getNameFromCode(String string) {
        if (string == null) {
            return null;
        }
        AminoAcid aminoAcid = (AminoAcid)codeHash.get(string);
        if (aminoAcid == null) {
            return null;
        }
        return aminoAcid.name;
    }

    public static String getNameFromLetter(String string) {
        if (string == null) {
            return null;
        }
        AminoAcid aminoAcid = (AminoAcid)letterHash.get(string);
        if (aminoAcid == null) {
            return null;
        }
        return aminoAcid.name;
    }

    public static float getHydrophobicityFromCode(String string) {
        if (string == null) {
            return 0.0f;
        }
        AminoAcid aminoAcid = (AminoAcid)codeHash.get(string);
        if (aminoAcid == null) {
            return 0.0f;
        }
        return aminoAcid.hydrophobicity;
    }

    public static Enumeration getCodes() {
        return codeHash.keys();
    }

    public static Enumeration getLetters() {
        return letterHash.keys();
    }

    public static Enumeration getNames() {
        return nameHash.keys();
    }

    public static AminoAcid getFromCode(String string) {
        return (AminoAcid)codeHash.get(string);
    }

    public static AminoAcid getFromLetter(String string) {
        return (AminoAcid)letterHash.get(string);
    }

    public static AminoAcid getFromName(String string) {
        return (AminoAcid)nameHash.get(string);
    }

    public static void main(String[] stringArray) {
        System.err.println("AminoAcidInfo: ALA = " + AminoAcidInfo.getNameFromCode("ALA"));
        System.err.println("AminoAcidInfo: SVA = non-standard " + AminoAcidInfo.getNameFromCode("SVA"));
        System.err.println("AminoAcidInfo: B = " + AminoAcidInfo.getNameFromLetter("B"));
        System.err.println("AminoAcidInfo: GLU = " + AminoAcidInfo.getFromCode("GLU"));
        System.err.println("AminoAcidInfo: Z = " + AminoAcidInfo.getFromLetter("Z"));
    }

    static {
        nonStandardCodes.put("143", "CYS");
        nonStandardCodes.put("1LU", "LEU");
        nonStandardCodes.put("1PA", "PHE");
        nonStandardCodes.put("2AS", "ASP");
        nonStandardCodes.put("2LU", "LEU");
        nonStandardCodes.put("2ML", "LEU");
        nonStandardCodes.put("2MR", "ARG");
        nonStandardCodes.put("3AH", "HIS");
        nonStandardCodes.put("3MD", "ASP");
        nonStandardCodes.put("5CS", "CYS");
        nonStandardCodes.put("5HP", "GLU");
        nonStandardCodes.put("AA3", "ALA");
        nonStandardCodes.put("AA4", "ALA");
        nonStandardCodes.put("AAR", "ARG");
        nonStandardCodes.put("ABA", "ALA");
        nonStandardCodes.put("ACB", "ASP");
        nonStandardCodes.put("ACL", "ARG");
        nonStandardCodes.put("ADY", "ADN");
        nonStandardCodes.put("AEI", "ASP");
        nonStandardCodes.put("AFA", "ASN");
        nonStandardCodes.put("AGM", "ARG");
        nonStandardCodes.put("AHB", "ARG");
        nonStandardCodes.put("AHO", "ALA");
        nonStandardCodes.put("AHP", "ALA");
        nonStandardCodes.put("AIB", "ALA");
        nonStandardCodes.put("ALC", "ALA");
        nonStandardCodes.put("ALG", "ARG");
        nonStandardCodes.put("ALM", "ALA");
        nonStandardCodes.put("ALN", "ALA");
        nonStandardCodes.put("ALO", "THR");
        nonStandardCodes.put("ALS", "ALA");
        nonStandardCodes.put("ALT", "ALA");
        nonStandardCodes.put("ALY", "LYS");
        nonStandardCodes.put("APH", "ALA");
        nonStandardCodes.put("API", "LYS");
        nonStandardCodes.put("ARM", "ARG");
        nonStandardCodes.put("ARO", "ARG");
        nonStandardCodes.put("ASA", "ASP");
        nonStandardCodes.put("ASB", "ASP");
        nonStandardCodes.put("ASI", "ASP");
        nonStandardCodes.put("ASK", "ASP");
        nonStandardCodes.put("ASL", "ASP");
        nonStandardCodes.put("ASQ", "ASP");
        nonStandardCodes.put("AYA", "ALA");
        nonStandardCodes.put("B1F", "PHE");
        nonStandardCodes.put("B2A", "ALA");
        nonStandardCodes.put("B2F", "PHE");
        nonStandardCodes.put("B2I", "ILE");
        nonStandardCodes.put("B2V", "VAL");
        nonStandardCodes.put("BAL", "ALA");
        nonStandardCodes.put("BCS", "CYS");
        nonStandardCodes.put("BCX", "CYS");
        nonStandardCodes.put("BFD", "ASP");
        nonStandardCodes.put("BHD", "ASP");
        nonStandardCodes.put("BLE", "LEU");
        nonStandardCodes.put("BLY", "LYS");
        nonStandardCodes.put("BMT", "THR");
        nonStandardCodes.put("BNN", "ALA");
        nonStandardCodes.put("BOR", "ARG");
        nonStandardCodes.put("BSE", "SER");
        nonStandardCodes.put("BTA", "LEU");
        nonStandardCodes.put("BTC", "CYS");
        nonStandardCodes.put("BTR", "TRP");
        nonStandardCodes.put("BUC", "CYS");
        nonStandardCodes.put("BUG", "LEU");
        nonStandardCodes.put("C5C", "CYS");
        nonStandardCodes.put("C6C", "CYS");
        nonStandardCodes.put("CAB", "ALA");
        nonStandardCodes.put("CAF", "CYS");
        nonStandardCodes.put("CAS", "CYS");
        nonStandardCodes.put("CAY", "CYS");
        nonStandardCodes.put("CCS", "CYS");
        nonStandardCodes.put("CEA", "CYS");
        nonStandardCodes.put("CGU", "GLU");
        nonStandardCodes.put("CHG", "ALA");
        nonStandardCodes.put("CHP", "GLY");
        nonStandardCodes.put("CLB", "ALA");
        nonStandardCodes.put("CLD", "ALA");
        nonStandardCodes.put("CLE", "LEU");
        nonStandardCodes.put("CLG", "LYS");
        nonStandardCodes.put("CLH", "LYS");
        nonStandardCodes.put("CME", "CYS");
        nonStandardCodes.put("CMT", "CYS");
        nonStandardCodes.put("CR5", "GLY");
        nonStandardCodes.put("CRO", "GLY");
        nonStandardCodes.put("CRQ", "GLN");
        nonStandardCodes.put("CS8", "COA");
        nonStandardCodes.put("CSA", "CYS");
        nonStandardCodes.put("CSB", "CYS");
        nonStandardCodes.put("CSD", "CYS");
        nonStandardCodes.put("CSE", "CYS");
        nonStandardCodes.put("CSI", "GLY");
        nonStandardCodes.put("CSO", "CYS");
        nonStandardCodes.put("CSP", "CYS");
        nonStandardCodes.put("CSR", "CYS");
        nonStandardCodes.put("CSS", "CYS");
        nonStandardCodes.put("CSU", "CYS");
        nonStandardCodes.put("CSW", "CYS");
        nonStandardCodes.put("CSX", "CYS");
        nonStandardCodes.put("CSZ", "CYS");
        nonStandardCodes.put("CTH", "THR");
        nonStandardCodes.put("CXM", "MET");
        nonStandardCodes.put("CY1", "CYS");
        nonStandardCodes.put("CY3", "CYS");
        nonStandardCodes.put("CY4", "CYS");
        nonStandardCodes.put("CYD", "CYS");
        nonStandardCodes.put("CYF", "CYS");
        nonStandardCodes.put("CYG", "CYS");
        nonStandardCodes.put("CYM", "CYS");
        nonStandardCodes.put("CYQ", "CYS");
        nonStandardCodes.put("CZZ", "CYS");
        nonStandardCodes.put("DAB", "ALA");
        nonStandardCodes.put("DAH", "PHE");
        nonStandardCodes.put("DAL", "ALA");
        nonStandardCodes.put("DAR", "ARG");
        nonStandardCodes.put("DAS", "ASP");
        nonStandardCodes.put("DBS", "SER");
        nonStandardCodes.put("DBY", "TYR");
        nonStandardCodes.put("DCY", "CYS");
        nonStandardCodes.put("DGL", "GLU");
        nonStandardCodes.put("DGN", "GLN");
        nonStandardCodes.put("DHA", "ALA");
        nonStandardCodes.put("DHI", "HIS");
        nonStandardCodes.put("DHN", "VAL");
        nonStandardCodes.put("DIL", "ILE");
        nonStandardCodes.put("DIV", "VAL");
        nonStandardCodes.put("DLE", "LEU");
        nonStandardCodes.put("DLS", "LYS");
        nonStandardCodes.put("DLY", "LYS");
        nonStandardCodes.put("DMH", "ASN");
        nonStandardCodes.put("DMK", "ASP");
        nonStandardCodes.put("DNE", "LEU");
        nonStandardCodes.put("DNL", "LYS");
        nonStandardCodes.put("DNM", "LEU");
        nonStandardCodes.put("DNP", "ALA");
        nonStandardCodes.put("DOH", "ASP");
        nonStandardCodes.put("DPH", "PHE");
        nonStandardCodes.put("DPL", "PRO");
        nonStandardCodes.put("DPN", "PHE");
        nonStandardCodes.put("DPP", "ALA");
        nonStandardCodes.put("DPR", "PRO");
        nonStandardCodes.put("DSE", "SER");
        nonStandardCodes.put("DSN", "SER");
        nonStandardCodes.put("DSP", "ASP");
        nonStandardCodes.put("DTH", "THR");
        nonStandardCodes.put("DTR", "TRP");
        nonStandardCodes.put("DTY", "TYR");
        nonStandardCodes.put("DVA", "VAL");
        nonStandardCodes.put("EFC", "CYS");
        nonStandardCodes.put("EHP", "PHE");
        nonStandardCodes.put("ESC", "MET");
        nonStandardCodes.put("FGL", "GLY");
        nonStandardCodes.put("FLA", "ALA");
        nonStandardCodes.put("FLE", "LEU");
        nonStandardCodes.put("FLT", "TYR");
        nonStandardCodes.put("FME", "MET");
        nonStandardCodes.put("FOE", "CYS");
        nonStandardCodes.put("FOG", "PHE");
        nonStandardCodes.put("FPA", "PHE");
        nonStandardCodes.put("FTR", "TRP");
        nonStandardCodes.put("FTY", "TYR");
        nonStandardCodes.put("GGL", "GLU");
        nonStandardCodes.put("GHP", "GLY");
        nonStandardCodes.put("GL3", "GLY");
        nonStandardCodes.put("GLH", "GLN");
        nonStandardCodes.put("GLZ", "GLY");
        nonStandardCodes.put("GMA", "GLU");
        nonStandardCodes.put("GMU", "5MU");
        nonStandardCodes.put("GPL", "LYS");
        nonStandardCodes.put("GSC", "GLY");
        nonStandardCodes.put("GT9", "CYS");
        nonStandardCodes.put("H5M", "PRO");
        nonStandardCodes.put("HAC", "ALA");
        nonStandardCodes.put("HAR", "ARG");
        nonStandardCodes.put("HIC", "HIS");
        nonStandardCodes.put("HIP", "HIS");
        nonStandardCodes.put("HMF", "ALA");
        nonStandardCodes.put("HMR", "ARG");
        nonStandardCodes.put("HPC", "PHE");
        nonStandardCodes.put("HPE", "PHE");
        nonStandardCodes.put("HPQ", "PHE");
        nonStandardCodes.put("HSE", "SER");
        nonStandardCodes.put("HSL", "SER");
        nonStandardCodes.put("HTI", "CYS");
        nonStandardCodes.put("HTR", "TRP");
        nonStandardCodes.put("HV5", "ALA");
        nonStandardCodes.put("HYP", "PRO");
        nonStandardCodes.put("IAS", "ASP");
        nonStandardCodes.put("IGL", "GLY");
        nonStandardCodes.put("IIL", "ILE");
        nonStandardCodes.put("ILG", "GLU");
        nonStandardCodes.put("ILX", "ILE");
        nonStandardCodes.put("IML", "ILE");
        nonStandardCodes.put("IPG", "GLY");
        nonStandardCodes.put("IYR", "TYR");
        nonStandardCodes.put("KCX", "LYS");
        nonStandardCodes.put("LCX", "LYS");
        nonStandardCodes.put("LEF", "LEU");
        nonStandardCodes.put("LLP", "LYS");
        nonStandardCodes.put("LLY", "LYS");
        nonStandardCodes.put("LPG", "GLY");
        nonStandardCodes.put("LPS", "SER");
        nonStandardCodes.put("LTR", "TRP");
        nonStandardCodes.put("LYM", "LYS");
        nonStandardCodes.put("LYN", "LYS");
        nonStandardCodes.put("LYX", "LYS");
        nonStandardCodes.put("LYZ", "LYS");
        nonStandardCodes.put("M3L", "LYS");
        nonStandardCodes.put("MAA", "ALA");
        nonStandardCodes.put("MAI", "ARG");
        nonStandardCodes.put("MC1", "SER");
        nonStandardCodes.put("MCL", "LYS");
        nonStandardCodes.put("MEA", "PHE");
        nonStandardCodes.put("MEN", "ASN");
        nonStandardCodes.put("MEQ", "GLN");
        nonStandardCodes.put("MGG", "ARG");
        nonStandardCodes.put("MGN", "GLN");
        nonStandardCodes.put("MGY", "GLY");
        nonStandardCodes.put("MHL", "LEU");
        nonStandardCodes.put("MHO", "MET");
        nonStandardCodes.put("MHS", "HIS");
        nonStandardCodes.put("MIS", "SER");
        nonStandardCodes.put("MLE", "LEU");
        nonStandardCodes.put("MLY", "LYS");
        nonStandardCodes.put("MLZ", "LYS");
        nonStandardCodes.put("MME", "MET");
        nonStandardCodes.put("MNL", "LEU");
        nonStandardCodes.put("MNV", "VAL");
        nonStandardCodes.put("MPQ", "GLY");
        nonStandardCodes.put("MSA", "GLY");
        nonStandardCodes.put("MSE", "MET");
        nonStandardCodes.put("MSO", "MET");
        nonStandardCodes.put("MTY", "TYR");
        nonStandardCodes.put("MVA", "VAL");
        nonStandardCodes.put("NAL", "ALA");
        nonStandardCodes.put("NAM", "ALA");
        nonStandardCodes.put("NC1", "SER");
        nonStandardCodes.put("NCB", "ALA");
        nonStandardCodes.put("NEM", "HIS");
        nonStandardCodes.put("NEP", "HIS");
        nonStandardCodes.put("NIY", "TYR");
        nonStandardCodes.put("NLE", "LEU");
        nonStandardCodes.put("NLN", "LEU");
        nonStandardCodes.put("NLP", "LEU");
        nonStandardCodes.put("NMC", "GLY");
        nonStandardCodes.put("NNH", "ARG");
        nonStandardCodes.put("NPH", "CYS");
        nonStandardCodes.put("NRQ", "MET");
        nonStandardCodes.put("NVA", "VAL");
        nonStandardCodes.put("OAS", "SER");
        nonStandardCodes.put("OCS", "CYS");
        nonStandardCodes.put("OCY", "CYS");
        nonStandardCodes.put("OMT", "MET");
        nonStandardCodes.put("OPR", "ARG");
        nonStandardCodes.put("ORN", "ALA");
        nonStandardCodes.put("P2Y", "PRO");
        nonStandardCodes.put("PAQ", "TYR");
        nonStandardCodes.put("PAS", "ASP");
        nonStandardCodes.put("PAT", "TRP");
        nonStandardCodes.put("PBB", "CYS");
        nonStandardCodes.put("PBF", "PHE");
        nonStandardCodes.put("PCA", "GLU");
        nonStandardCodes.put("PCC", "PRO");
        nonStandardCodes.put("PCS", "PHE");
        nonStandardCodes.put("PEC", "CYS");
        nonStandardCodes.put("PG1", "SER");
        nonStandardCodes.put("PGY", "GLY");
        nonStandardCodes.put("PHA", "PHE");
        nonStandardCodes.put("PHD", "ASP");
        nonStandardCodes.put("PHI", "PHE");
        nonStandardCodes.put("PHL", "PHE");
        nonStandardCodes.put("PHM", "PHE");
        nonStandardCodes.put("PLE", "LEU");
        nonStandardCodes.put("POM", "PRO");
        nonStandardCodes.put("PPH", "LEU");
        nonStandardCodes.put("PPN", "PHE");
        nonStandardCodes.put("PR3", "CYS");
        nonStandardCodes.put("PRR", "ALA");
        nonStandardCodes.put("PRS", "PRO");
        nonStandardCodes.put("PTH", "TYR");
        nonStandardCodes.put("PTM", "TYR");
        nonStandardCodes.put("PTR", "TYR");
        nonStandardCodes.put("PYA", "ALA");
        nonStandardCodes.put("PYX", "CYS");
        nonStandardCodes.put("RAB", "ADE");
        nonStandardCodes.put("S1H", "SER");
        nonStandardCodes.put("SAC", "SER");
        nonStandardCodes.put("SAR", "GLY");
        nonStandardCodes.put("SBD", "SER");
        nonStandardCodes.put("SBL", "SER");
        nonStandardCodes.put("SCH", "CYS");
        nonStandardCodes.put("SCS", "CYS");
        nonStandardCodes.put("SCY", "CYS");
        nonStandardCodes.put("SDP", "SER");
        nonStandardCodes.put("SEB", "SER");
        nonStandardCodes.put("SEC", "ALA");
        nonStandardCodes.put("SEG", "ALA");
        nonStandardCodes.put("SEL", "SER");
        nonStandardCodes.put("SEP", "SER");
        nonStandardCodes.put("SET", "SER");
        nonStandardCodes.put("SHC", "CYS");
        nonStandardCodes.put("SHP", "GLY");
        nonStandardCodes.put("SHR", "LYS");
        nonStandardCodes.put("SLZ", "LYS");
        nonStandardCodes.put("SMC", "CYS");
        nonStandardCodes.put("SME", "MET");
        nonStandardCodes.put("SMF", "PHE");
        nonStandardCodes.put("SNC", "CYS");
        nonStandardCodes.put("SOC", "CYS");
        nonStandardCodes.put("STY", "TYR");
        nonStandardCodes.put("SUI", "ASP");
        nonStandardCodes.put("SVA", "SER");
        nonStandardCodes.put("TBG", "GLY");
        nonStandardCodes.put("TBM", "THR");
        nonStandardCodes.put("THC", "THR");
        nonStandardCodes.put("TIH", "ALA");
        nonStandardCodes.put("TMB", "THR");
        nonStandardCodes.put("TMD", "THR");
        nonStandardCodes.put("TNB", "CYS");
        nonStandardCodes.put("TNR", "SER");
        nonStandardCodes.put("TPL", "TRP");
        nonStandardCodes.put("TPO", "THR");
        nonStandardCodes.put("TPQ", "TYR");
        nonStandardCodes.put("TRF", "TRP");
        nonStandardCodes.put("TRG", "LYS");
        nonStandardCodes.put("TRN", "TRP");
        nonStandardCodes.put("TRO", "TRP");
        nonStandardCodes.put("TRQ", "TRP");
        nonStandardCodes.put("TRW", "TRP");
        nonStandardCodes.put("TRX", "TRP");
        nonStandardCodes.put("TYB", "TYR");
        nonStandardCodes.put("TYI", "TYR");
        nonStandardCodes.put("TYN", "TYR");
        nonStandardCodes.put("TYQ", "TYR");
        nonStandardCodes.put("TYS", "TYR");
        nonStandardCodes.put("TYT", "TYR");
        nonStandardCodes.put("TYY", "TYR");
        nonStandardCodes.put("VAD", "VAL");
        nonStandardCodes.put("VAF", "VAL");
        nonStandardCodes.put("XYA", "ADE");
        nonStandardCodes.put("YCM", "CYS");
        nonStandardCodes.put("YOF", "TYR");
        for (int i = 0; i < aminoAcids.length; ++i) {
            letterHash.put(AminoAcidInfo.aminoAcids[i].letter, aminoAcids[i]);
            codeHash.put(AminoAcidInfo.aminoAcids[i].code, aminoAcids[i]);
            nameHash.put(AminoAcidInfo.aminoAcids[i].name, aminoAcids[i]);
        }
        Enumeration enumeration = nonStandardCodes.keys();
        while (enumeration.hasMoreElements()) {
            AminoAcid aminoAcid;
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || (string = (String)nonStandardCodes.get(string2)) == null || (aminoAcid = (AminoAcid)codeHash.get(string)) == null) continue;
            codeHash.put(string2, aminoAcid);
        }
    }
}

