/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponentRegistry;

public class AtomStats {
    public static double[][] getAtomCoordinateBounds(Structure structure) {
        if (structure == null) {
            throw new IllegalArgumentException("null structure");
        }
        int n = structure.getStructureComponentCount(StructureComponentRegistry.TYPE_ATOM);
        double[][] dArray = new double[2][3];
        if (n <= 0) {
            return dArray;
        }
        Atom atom = (Atom)structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_ATOM, 0);
        dArray[0][0] = atom.coordinate[0];
        dArray[0][1] = atom.coordinate[1];
        dArray[0][2] = atom.coordinate[2];
        dArray[1][0] = atom.coordinate[0];
        dArray[1][1] = atom.coordinate[1];
        dArray[1][2] = atom.coordinate[2];
        for (int i = 1; i < n; ++i) {
            atom = (Atom)structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_ATOM, i);
            if (atom.coordinate[0] < dArray[0][0]) {
                dArray[0][0] = atom.coordinate[0];
            }
            if (atom.coordinate[1] < dArray[0][1]) {
                dArray[0][1] = atom.coordinate[1];
            }
            if (atom.coordinate[2] < dArray[0][2]) {
                dArray[0][2] = atom.coordinate[2];
            }
            if (atom.coordinate[0] > dArray[1][0]) {
                dArray[1][0] = atom.coordinate[0];
            }
            if (atom.coordinate[1] > dArray[1][1]) {
                dArray[1][1] = atom.coordinate[1];
            }
            if (!(atom.coordinate[2] > dArray[1][2])) continue;
            dArray[1][2] = atom.coordinate[2];
        }
        return dArray;
    }

    public static double[] getAtomCoordinateAverage(Structure structure) throws IllegalArgumentException {
        if (structure == null) {
            throw new IllegalArgumentException("null structure");
        }
        int n = structure.getStructureComponentCount(StructureComponentRegistry.TYPE_ATOM);
        double[] dArray = new double[3];
        if (n <= 0) {
            return dArray;
        }
        Atom atom = (Atom)structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_ATOM, 0);
        for (int i = 1; i < n; ++i) {
            atom = (Atom)structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_ATOM, i);
            dArray[0] = dArray[0] + atom.coordinate[0];
            dArray[1] = dArray[1] + atom.coordinate[1];
            dArray[2] = dArray[2] + atom.coordinate[2];
        }
        dArray[0] = dArray[0] / (double)n;
        dArray[1] = dArray[1] / (double)n;
        dArray[2] = dArray[2] / (double)n;
        return dArray;
    }
}

