/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.util.Algebra;
import edu.sdsc.mbt.util.AtomStats;
import edu.sdsc.mbt.util.ChemicalComponentBonds;
import edu.sdsc.mbt.util.ExcessiveDivisionException;
import edu.sdsc.mbt.util.Octree;
import edu.sdsc.mbt.util.OctreeAtomItem;
import edu.sdsc.mbt.util.OctreeDataItem;
import edu.sdsc.mbt.util.Status;
import java.util.Hashtable;
import java.util.Vector;

public class BondFactory {
    private static double covalentBondLimit = 1.9;
    private static double peptideBondLimit = 2.3;
    private static double disulphideBondLimit = 3.0;
    private static double hydrogenBondLimit = 4.5;

    public static Vector generateBonds(Structure structure) {
        return BondFactory.generateBonds(structure, covalentBondLimit);
    }

    public static Vector generateBonds(Structure structure, double d) {
        double[][] dArray = AtomStats.getAtomCoordinateBounds(structure);
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        double[] dArray4 = new double[]{dArray3[0] - dArray2[0], dArray3[1] - dArray2[1], dArray3[2] - dArray2[2]};
        double[] dArray5 = new double[]{d * 0.5, d * 0.5, d * 0.5};
        int[] nArray = new int[]{(int)(dArray4[0] / dArray5[0]), (int)(dArray4[1] / dArray5[1]), (int)(dArray4[2] / dArray5[2])};
        int n = structure.getStructureComponentCount(StructureComponentRegistry.TYPE_ATOM);
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>(n);
        int[] nArray2 = new int[3];
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Atom atom = (Atom)structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_ATOM, i);
            nArray2[0] = (int)((atom.coordinate[0] - dArray2[0]) / dArray5[0]);
            nArray2[1] = (int)((atom.coordinate[1] - dArray2[1]) / dArray5[1]);
            nArray2[2] = (int)((atom.coordinate[2] - dArray2[2]) / dArray5[2]);
            n2 = (nArray2[0] * nArray[1] + nArray2[1]) * nArray[2] + nArray2[2];
            hashtable.put(new Integer(n2), new Integer(i));
        }
        Vector<Bond> vector = new Vector<Bond>();
        for (int i = 0; i < n; ++i) {
            Atom atom = (Atom)structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_ATOM, i);
            nArray2[0] = (int)((atom.coordinate[0] - dArray2[0]) / dArray5[0]);
            nArray2[1] = (int)((atom.coordinate[1] - dArray2[1]) / dArray5[1]);
            nArray2[2] = (int)((atom.coordinate[2] - dArray2[2]) / dArray5[2]);
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    for (int i2 = -1; i2 <= 1; ++i2) {
                        Atom atom2;
                        int n3;
                        Integer n4;
                        if (j == 0 && k == 0 && i2 == 0 || (n4 = (Integer)hashtable.get(new Integer(n2 = ((nArray2[0] + j) * nArray[1] + (nArray2[1] + k)) * nArray[2] + (nArray2[2] + i2)))) == null || i >= (n3 = n4.intValue()) || !(BondFactory.distance(atom, atom2 = (Atom)structure.getStructureComponentByIndex(StructureComponentRegistry.TYPE_ATOM, n3)) <= d)) continue;
                        Bond bond = new Bond(atom, atom2);
                        vector.add(bond);
                    }
                }
            }
        }
        return vector;
    }

    public static Vector generateCovalentBonds(Vector vector, double d) {
        Object object;
        Object object2;
        int n;
        Vector vector2 = null;
        try {
            n = vector.size();
            OctreeDataItem[] octreeDataItemArray = new OctreeAtomItem[n];
            for (int i = 0; i < n; ++i) {
                object2 = (Atom)vector.elementAt(i);
                octreeDataItemArray[i] = new OctreeAtomItem((Atom)object2, i);
            }
            object = new double[]{0.0, 0.0, 0.0};
            object2 = new Octree(((double[])object).length, octreeDataItemArray, (double[])object);
            ((Octree)object2).build();
            vector2 = ((Octree)object2).getBondsVector(d);
        }
        catch (ExcessiveDivisionException excessiveDivisionException) {
            Status.output(1, "Some atom coordinates may be too close to create bonds (" + excessiveDivisionException.toString() + ").");
            vector2 = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Status.output(1, "Not enough memory to create bonds (" + outOfMemoryError.toString() + ").");
            vector2 = null;
        }
        catch (StackOverflowError stackOverflowError) {
            Status.output(1, "Not enough stack space to create bonds (" + stackOverflowError.toString() + ").");
            vector2 = null;
        }
        if (vector2 == null) {
            return null;
        }
        n = vector2.size();
        for (int i = n - 1; i >= 0; --i) {
            object = (Bond)vector2.elementAt(i);
            object2 = ((Bond)object).getAtom(0);
            Atom atom = ((Bond)object).getAtom(1);
            if (((Atom)object2).element.equals("H") && atom.element.equals("H")) {
                vector2.remove(i);
            }
            if (object2 == atom) {
                vector2.remove(i);
            }
            if (object2.hashCode() != atom.hashCode()) continue;
            vector2.remove(i);
        }
        return vector2;
    }

    public static Vector generateCovalentBonds(Vector vector) {
        return BondFactory.generateCovalentBonds(vector, covalentBondLimit);
    }

    public static void generateCovalentBonds(StructureMap structureMap) {
        if (structureMap == null) {
            return;
        }
        int n = structureMap.getResidueCount();
        for (int i = 0; i < n; ++i) {
            StructureComponent structureComponent;
            Atom atom;
            Object object;
            int n2;
            Residue residue = structureMap.getResidue(i);
            String string = residue.getCompoundCode();
            String string2 = residue.getClassification();
            Atom atom2 = residue.getAlphaAtom();
            if ((string2 == "Amino Acid" || string2 == "Nucleic Acid") && (n2 = i + 1) < n) {
                String string3;
                Residue residue2 = structureMap.getResidue(n2);
                object = residue.getChainId();
                if (((String)object).equals(string3 = residue2.getChainId())) {
                    atom = residue.getPolymerTailAtom();
                    structureComponent = residue2.getPolymerHeadAtom();
                    if (atom != null && structureComponent != null) {
                        structureMap.addBond(new Bond(atom, (Atom)structureComponent));
                    }
                }
            }
            if (ChemicalComponentBonds.knownCompound(string)) {
                n2 = residue.getAtomCount();
                if (n2 <= 1) continue;
                for (int j = 0; j < n2; ++j) {
                    object = residue.getAtom(j);
                    if (object == null) continue;
                    for (int k = j; k < n2; ++k) {
                        atom = residue.getAtom(k);
                        if (atom == null || object == atom || (structureComponent = new Bond((Atom)object, atom)) == null) continue;
                        if (object == atom) {
                            structureMap.removeBond((Bond)structureComponent);
                            continue;
                        }
                        String string4 = ChemicalComponentBonds.bondType((Atom)object, atom);
                        if (string4 == null || string4 == "UNKN") continue;
                        if (string4 == "NONE") {
                            structureMap.removeBond((Bond)structureComponent);
                            continue;
                        }
                        if (string4 == "SING") {
                            ((Bond)structureComponent).setOrder(1.0f);
                        } else if (string4 == "DOUB") {
                            ((Bond)structureComponent).setOrder(2.0f);
                        } else if (string4 == "TRIP") {
                            ((Bond)structureComponent).setOrder(3.0f);
                        } else if (string4 == "AROM") {
                            ((Bond)structureComponent).setOrder(1.5f);
                        }
                        if (!(((Bond)structureComponent).getDistance() < peptideBondLimit)) continue;
                        structureMap.addBond((Bond)structureComponent);
                    }
                }
                continue;
            }
            structureMap.addBonds(BondFactory.generateCovalentBonds(residue.getAtoms(), covalentBondLimit));
        }
    }

    public static void generateCovalentBonds(StructureMap structureMap, double d) {
        double d2 = peptideBondLimit;
        BondFactory.generateCovalentBonds(structureMap);
        peptideBondLimit = d2;
    }

    public static double distance(Atom atom, Atom atom2) {
        return Algebra.distance(atom.coordinate, atom2.coordinate);
    }
}

