/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.util.SharedObjects;
import edu.sdsc.mbt.util.Status;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class ChemicalComponentBonds {
    public static final String BOND_TYPE_UNKNOWN = "UNKN";
    public static final String BOND_TYPE_NONE = "NONE";
    public static final String BOND_TYPE_SINGLE = "SING";
    public static final String BOND_TYPE_DOUBLE = "DOUB";
    public static final String BOND_TYPE_TRIPPLE = "TRIP";
    public static final String BOND_TYPE_AROMATIC = "AROM";
    private static Hashtable bonds = ChemicalComponentBonds.load("ChemicalComponentBonds.dat");

    private static Hashtable load(String string) {
        Hashtable hashtable = new Hashtable();
        Class<?> clazz = null;
        String string2 = "edu.sdsc.mbt.util.ChemicalComponentBonds";
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Status.output(2, "ChemicalComponentBonds: No class: " + string2);
            return null;
        }
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            Status.output(2, "ChemicalComponentBonds: No dictionary: " + string);
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        SharedObjects sharedObjects = new SharedObjects();
        String string3 = null;
        while (true) {
            try {
                string3 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break;
            }
            if (string3 == null) break;
            String[] stringArray = string3.split("\t");
            if (stringArray == null || stringArray.length != 4) {
                Status.output(2, "ChemicalComponentBonds: No dictionary: " + string);
                return null;
            }
            Hashtable<String, String> hashtable2 = (Hashtable<String, String>)hashtable.get(stringArray[0]);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable<String, String>();
                hashtable.put(stringArray[0], hashtable2);
            }
            String string4 = stringArray[1] + ":" + stringArray[2];
            String string5 = (String)hashtable2.get(string4 = sharedObjects.share(string4));
            if (string5 != null) continue;
            if (stringArray[3].startsWith(BOND_TYPE_AROMATIC)) {
                stringArray[3] = BOND_TYPE_AROMATIC;
            } else if (stringArray[3].startsWith(BOND_TYPE_SINGLE)) {
                stringArray[3] = BOND_TYPE_SINGLE;
            } else if (stringArray[3].startsWith(BOND_TYPE_DOUBLE)) {
                stringArray[3] = BOND_TYPE_DOUBLE;
            } else if (stringArray[3].startsWith(BOND_TYPE_TRIPPLE)) {
                stringArray[3] = BOND_TYPE_TRIPPLE;
            }
            hashtable2.put(string4, stringArray[3]);
        }
        sharedObjects = null;
        return hashtable;
    }

    public static String bondType(Atom atom, Atom atom2) {
        if (bonds == null) {
            return BOND_TYPE_UNKNOWN;
        }
        if (atom == null) {
            throw new NullPointerException("atom0 is null");
        }
        if (atom2 == null) {
            throw new NullPointerException("atom1 is null");
        }
        if (atom.structure != atom2.structure) {
            return BOND_TYPE_UNKNOWN;
        }
        if (atom.residue_id != atom2.residue_id) {
            return BOND_TYPE_UNKNOWN;
        }
        if (!atom.compound.equals(atom2.compound)) {
            return BOND_TYPE_UNKNOWN;
        }
        if (!atom.chain_id.equals(atom2.chain_id)) {
            return BOND_TYPE_UNKNOWN;
        }
        Hashtable hashtable = (Hashtable)bonds.get(atom.compound);
        if (hashtable == null) {
            return BOND_TYPE_UNKNOWN;
        }
        String string = atom.name + ":" + atom2.name;
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return string2;
        }
        string = atom2.name + ":" + atom.name;
        string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return string2;
        }
        return BOND_TYPE_NONE;
    }

    public static String bondType(Bond bond) {
        if (bond == null) {
            throw new NullPointerException("bond is null");
        }
        return ChemicalComponentBonds.bondType(bond.getAtom(0), bond.getAtom(1));
    }

    public static boolean knownCompound(String string) {
        if (string == null) {
            return false;
        }
        if (bonds == null) {
            return false;
        }
        Hashtable hashtable = (Hashtable)bonds.get(string);
        return hashtable != null;
    }

    public static void main(String[] stringArray) {
        Atom atom = new Atom();
        atom.chain_id = "A";
        atom.compound = "ALA";
        atom.name = "CA";
        Atom atom2 = new Atom();
        atom2.chain_id = "A";
        atom2.compound = "ALA";
        atom2.name = "CB";
        Atom atom3 = new Atom();
        atom3.chain_id = "A";
        atom3.compound = "ALA";
        atom3.name = "O";
        Atom atom4 = new Atom();
        atom4.chain_id = "A";
        atom4.compound = "XXX";
        atom4.name = "C";
        Atom atom5 = new Atom();
        atom5.chain_id = "A";
        atom5.compound = "XXX";
        atom5.name = "N";
        System.err.println("type = " + ChemicalComponentBonds.bondType(atom, atom2));
        System.err.println("type = " + ChemicalComponentBonds.bondType(atom, atom3));
        System.err.println("type = " + ChemicalComponentBonds.bondType(atom4, atom5));
    }
}

