/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

public class CodonInfo {
    private static final String[][][] codons = new String[][][]{{{"F", "F", "L", "L"}, {"S", "S", "S", "S"}, {"Y", "Y", ".", "."}, {"C", "C", ".", "W"}}, {{"L", "L", "L", "L"}, {"P", "P", "P", "P"}, {"H", "H", "Q", "Q"}, {"R", "R", "R", "R"}}, {{"I", "I", "I", "I"}, {"T", "T", "T", "T"}, {"B", "B", "K", "K"}, {"S", "S", "R", "R"}}, {{"V", "V", "V", "V"}, {"A", "A", "A", "A"}, {"D", "D", "E", "E"}, {"G", "G", "G", "G"}}};
    private static final String[] letters = new String[]{"U", "C", "A", "G"};

    private static final int getBaseIndex(char c) {
        if (c == 'U') {
            return 0;
        }
        if (c == 'C') {
            return 1;
        }
        if (c == 'A') {
            return 2;
        }
        if (c == 'G') {
            return 3;
        }
        return -1;
    }

    private static final String getBaseLetter(int n) {
        if (n < 0) {
            return null;
        }
        if (n > letters.length) {
            return null;
        }
        return letters[n];
    }

    public static int getCodonCount() {
        return 64;
    }

    public static String getAminoAcidLetter(String string) {
        if (string == null) {
            return null;
        }
        int n = CodonInfo.getBaseIndex(string.charAt(0));
        int n2 = CodonInfo.getBaseIndex(string.charAt(1));
        int n3 = CodonInfo.getBaseIndex(string.charAt(2));
        if (n < 0 || n2 < 0 || n3 < 0) {
            return null;
        }
        if (n >= codons.length) {
            return null;
        }
        if (n2 >= codons[n].length) {
            return null;
        }
        if (n3 >= codons[n][n2].length) {
            return null;
        }
        return codons[n][n2][n3];
    }

    public static String getAminoAcidLetter(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        if (string3 == null) {
            return null;
        }
        int n = CodonInfo.getBaseIndex(string.charAt(0));
        int n2 = CodonInfo.getBaseIndex(string2.charAt(0));
        int n3 = CodonInfo.getBaseIndex(string3.charAt(0));
        if (n < 0 || n2 < 0 || n3 < 0) {
            return null;
        }
        if (n >= codons.length) {
            return null;
        }
        if (n2 >= codons[n].length) {
            return null;
        }
        if (n3 >= codons[n][n2].length) {
            return null;
        }
        return codons[n][n2][n3];
    }
}

