/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.util.BondInfo;
import edu.sdsc.mbt.util.ExcessiveDivisionException;
import edu.sdsc.mbt.util.Octree;
import edu.sdsc.mbt.util.OctreeAtomItem;
import edu.sdsc.mbt.util.OctreeDataItem;
import java.util.ListIterator;
import java.util.Vector;

public class DerivedInformation {
    private StructureMap structureMap;
    private Structure structure;
    private double energyThreshold = -0.5;
    private double hBondCutoffDistance = 8.0;
    private double energyFactor = 332.0;
    private double charge1 = 0.42;
    private double charge2 = 0.2;
    private char[] ssFlags = null;
    private int[][] chains = null;

    public DerivedInformation(Structure structure) {
        this.structure = structure;
        this.structureMap = new StructureMap(structure);
    }

    public DerivedInformation(Structure structure, StructureMap structureMap) {
        this.structure = structure;
        this.structureMap = structureMap;
    }

    public Object[] setSsExtendedFlags() {
        char c;
        char c2;
        char c3;
        int n;
        int n2;
        char c4;
        int n3;
        char c5;
        int n4;
        int n5;
        int n6;
        char c6 = '\u0000';
        int n7 = this.structureMap.getResidueCount();
        char[] cArray = new char[n7];
        this.ssFlags = new char[n7];
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        byte by = 1;
        int n8 = 2;
        int n9 = 4;
        int n10 = 8;
        int n11 = 16;
        Residue residue = null;
        for (n6 = 0; n6 < n7; ++n6) {
            residue = this.structureMap.getResidue(n6);
            if (residue.getClassification() == "Amino Acid") {
                ++c6;
                this.ssFlags[n6] = 32;
            } else {
                this.ssFlags[n6] = 45;
            }
            nArray2[n6] = -1;
            nArray[n6] = -1;
        }
        int[] nArray3 = new int[c6];
        int[] nArray4 = new int[c6];
        int[] nArray5 = new int[c6];
        byte[] byArray = new byte[c6];
        double[] dArray = new double[c6];
        double[] dArray2 = new double[c6];
        n6 = -1;
        for (int i = 0; i < n7; ++i) {
            if (this.structureMap.getResidue(i).getClassification() != "Amino Acid") continue;
            nArray5[++n6] = i;
        }
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        double[] dArray11 = new double[3];
        double[] dArray12 = new double[3];
        double[] dArray13 = new double[3];
        double[] dArray14 = new double[3];
        double d = System.currentTimeMillis();
        Atom atom = new Atom();
        Atom atom2 = new Atom();
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        double[][] dArray15 = new double[c6][3];
        OctreeDataItem[] octreeDataItemArray = new OctreeAtomItem[c6];
        String string = "NONE";
        for (char c7 = '\u0000'; c7 < c6; ++c7) {
            atom = this.structureMap.getResidue(nArray5[c7]).getAlphaAtom();
            if (atom == null) {
                System.err.println("AA " + nArray5[c7] + "  Does not seem to have a CA atom ");
            }
            dArray15[c7][0] = atom.coordinate[0];
            dArray15[c7][1] = atom.coordinate[1];
            dArray15[c7][2] = atom.coordinate[2];
            octreeDataItemArray[c7] = new OctreeAtomItem(atom, c7);
            if (!atom.chain_id.equals(string)) {
                vector.add(new Integer(nArray5[c7]));
                if (c7 > '\u0000') {
                    vector2.add(new Integer(nArray5[c7 - 1]));
                }
                string = new String(atom.chain_id);
            }
            nArray3[c7] = -1;
            nArray4[c7] = -1;
            dArray[c7] = 1.0E10;
            dArray2[c7] = 1.0E10;
        }
        vector2.add(new Integer(c6 - 1));
        vector.trimToSize();
        vector2.trimToSize();
        this.chains = new int[vector.size()][2];
        ListIterator listIterator = vector.listIterator();
        ListIterator listIterator2 = vector2.listIterator();
        int n12 = 0;
        while (listIterator.hasNext()) {
            this.chains[n12][0] = (Integer)listIterator.next();
            this.chains[n12][1] = (Integer)listIterator2.next();
            ++n12;
        }
        double d2 = System.currentTimeMillis();
        d = System.currentTimeMillis();
        double[] dArray16 = new double[3];
        dArray16[2] = 0.0;
        dArray16[1] = 0.0;
        dArray16[0] = 0.0;
        Octree octree = new Octree(3, octreeDataItemArray, dArray16);
        try {
            octree.build();
        }
        catch (ExcessiveDivisionException excessiveDivisionException) {
            System.err.println(excessiveDivisionException.toString());
        }
        Vector vector3 = octree.getHBondInfoVector(this.hBondCutoffDistance);
        vector3.trimToSize();
        d2 = System.currentTimeMillis();
        ListIterator listIterator3 = vector3.listIterator();
        ListIterator listIterator4 = vector3.listIterator();
        double d3 = 0.0;
        double d4 = 0.0;
        int n13 = 0;
        d = System.currentTimeMillis();
        int n14 = -1;
        while (listIterator3.hasNext()) {
            double d5;
            boolean bl;
            boolean bl2;
            double d6;
            double d7;
            int n15;
            BondInfo bondInfo = (BondInfo)listIterator3.next();
            int n16 = bondInfo.index1;
            n5 = bondInfo.index2;
            boolean bl3 = false;
            boolean bl4 = false;
            residue = this.structureMap.getResidue(nArray5[n16]);
            int n17 = 0;
            int n18 = residue.getAtomCount() - 1;
            int n19 = residue.getAlphaAtomIndex();
            if (n16 != n14) {
                n15 = 0;
                for (n4 = n17; n15 < 1 && n4 <= n18; ++n4) {
                    d7 = System.currentTimeMillis();
                    atom = residue.getAtom(n4);
                    ++n13;
                    d6 = System.currentTimeMillis();
                    d3 += d6 - d7;
                    if (!atom.name.equals("N")) continue;
                    dArray4[0] = atom.coordinate[0];
                    dArray4[1] = atom.coordinate[1];
                    dArray4[2] = atom.coordinate[2];
                    ++n15;
                }
                n15 = 0;
                bl2 = false;
                bl = false;
                for (n4 = n19 + 1; n15 < 2 && n4 <= n18; ++n4) {
                    d7 = System.currentTimeMillis();
                    atom = residue.getAtom(n4);
                    ++n13;
                    d6 = System.currentTimeMillis();
                    d3 += d6 - d7;
                    if (atom.name.equals("C") && !bl2) {
                        dArray3[0] = atom.coordinate[0];
                        dArray3[1] = atom.coordinate[1];
                        dArray3[2] = atom.coordinate[2];
                        ++n15;
                        bl2 = true;
                    }
                    if (!atom.name.equals("O") || bl) continue;
                    dArray5[0] = atom.coordinate[0];
                    dArray5[1] = atom.coordinate[1];
                    dArray5[2] = atom.coordinate[2];
                    ++n15;
                    bl = true;
                }
                if (n16 == 0) {
                    this.diff(dArray6, dArray5, dArray3);
                    this.normalize(dArray6, dArray6);
                    this.scale(dArray6, dArray6, 1.008);
                    this.add(dArray6, dArray4, dArray6);
                } else {
                    residue = this.structureMap.getResidue(nArray5[n16 - 1]);
                    n17 = 0;
                    n18 = residue.getAtomCount() - 1;
                    n19 = residue.getAlphaAtomIndex();
                    n15 = 0;
                    bl2 = false;
                    bl = false;
                    for (n4 = n19 + 1; n15 < 2 && n4 <= n18; ++n4) {
                        d7 = System.currentTimeMillis();
                        atom = residue.getAtom(n4);
                        ++n13;
                        d6 = System.currentTimeMillis();
                        d3 += d6 - d7;
                        if (atom.name.equals("C") && !bl2) {
                            dArray11[0] = atom.coordinate[0];
                            dArray11[1] = atom.coordinate[1];
                            dArray11[2] = atom.coordinate[2];
                            ++n15;
                            bl2 = true;
                        }
                        if (!atom.name.equals("O") || bl) continue;
                        dArray13[0] = atom.coordinate[0];
                        dArray13[1] = atom.coordinate[1];
                        dArray13[2] = atom.coordinate[2];
                        ++n15;
                        bl = true;
                    }
                    d5 = this.dist(dArray11, dArray4);
                    if (d5 <= 2.0) {
                        this.diff(dArray6, dArray11, dArray13);
                    } else {
                        this.diff(dArray6, dArray5, dArray3);
                    }
                    this.normalize(dArray6, dArray6);
                    this.scale(dArray6, dArray6, 1.008);
                    this.add(dArray6, dArray4, dArray6);
                }
                n14 = n16;
            }
            residue = this.structureMap.getResidue(nArray5[n5]);
            n17 = 0;
            n18 = residue.getAtomCount() - 1;
            n19 = residue.getAlphaAtomIndex();
            n15 = 0;
            for (n4 = n17; n15 < 1 && n4 <= n18; ++n4) {
                d7 = System.currentTimeMillis();
                atom = residue.getAtom(n4);
                ++n13;
                d6 = System.currentTimeMillis();
                d3 += d6 - d7;
                if (!atom.name.equals("N")) continue;
                dArray8[0] = atom.coordinate[0];
                dArray8[1] = atom.coordinate[1];
                dArray8[2] = atom.coordinate[2];
                ++n15;
            }
            n15 = 0;
            bl2 = false;
            bl = false;
            for (n4 = n19 + 1; n15 < 2 && n4 <= n18; ++n4) {
                d7 = System.currentTimeMillis();
                atom = residue.getAtom(n4);
                ++n13;
                d6 = System.currentTimeMillis();
                d3 += d6 - d7;
                if (atom.name.equals("C") && !bl2) {
                    dArray7[0] = atom.coordinate[0];
                    dArray7[1] = atom.coordinate[1];
                    dArray7[2] = atom.coordinate[2];
                    ++n15;
                    bl2 = true;
                }
                if (!atom.name.equals("O") || bl) continue;
                dArray9[0] = atom.coordinate[0];
                dArray9[1] = atom.coordinate[1];
                dArray9[2] = atom.coordinate[2];
                ++n15;
                bl = true;
            }
            residue = this.structureMap.getResidue(nArray5[n5 - 1]);
            n17 = 0;
            n18 = residue.getAtomCount() - 1;
            n19 = residue.getAlphaAtomIndex();
            n15 = 0;
            bl2 = false;
            bl = false;
            for (n4 = n19 + 1; n15 < 2 && n4 <= n18; ++n4) {
                d7 = System.currentTimeMillis();
                atom = residue.getAtom(n4);
                ++n13;
                d6 = System.currentTimeMillis();
                d3 += d6 - d7;
                if (atom.name.equals("C") && !bl2) {
                    dArray11[0] = atom.coordinate[0];
                    dArray11[1] = atom.coordinate[1];
                    dArray11[2] = atom.coordinate[2];
                    ++n15;
                    bl2 = true;
                }
                if (!atom.name.equals("O")) continue;
                dArray13[0] = atom.coordinate[0];
                dArray13[1] = atom.coordinate[1];
                dArray13[2] = atom.coordinate[2];
                ++n15;
                bl = true;
            }
            d5 = this.dist(dArray11, dArray8);
            if (d5 <= 2.0) {
                this.diff(dArray10, dArray11, dArray13);
            } else {
                this.diff(dArray10, dArray9, dArray7);
            }
            this.normalize(dArray10, dArray10);
            this.scale(dArray10, dArray10, 1.008);
            this.add(dArray10, dArray8, dArray10);
            double d8 = 1.0 / this.dist(dArray5, dArray8) + 1.0 / this.dist(dArray3, dArray10) - 1.0 / this.dist(dArray5, dArray10) - 1.0 / this.dist(dArray3, dArray8);
            if ((d8 *= this.energyFactor * this.charge1 * this.charge2) < -0.5 & d8 < dArray[n16]) {
                nArray3[n16] = n5;
                nArray4[n5] = n16;
                dArray[n16] = d8;
            } else {
                bl3 = true;
            }
            d8 = 1.0 / this.dist(dArray4, dArray9) + 1.0 / this.dist(dArray6, dArray7) - 1.0 / this.dist(dArray6, dArray9) - 1.0 / this.dist(dArray4, dArray7);
            if ((d8 *= this.energyFactor * this.charge1 * this.charge2) < -0.5 & d8 < dArray2[n16]) {
                nArray4[n16] = n5;
                nArray3[n5] = n16;
                dArray2[n16] = d8;
            } else {
                bl4 = true;
            }
            if (!(bl3 & bl4)) continue;
            listIterator3.remove();
        }
        d2 = System.currentTimeMillis();
        block29: for (c5 = '\u0000'; c5 < c6; ++c5) {
            if (nArray3[c5] <= -1) continue;
            n4 = nArray5[nArray3[c5]] - nArray5[c5];
            switch (n4) {
                case 3: {
                    char c8 = c5;
                    byArray[c8] = (byte)(byArray[c8] | by);
                    continue block29;
                }
                case 4: {
                    char c9 = c5;
                    byArray[c9] = (byte)(byArray[c9] | n8);
                    continue block29;
                }
                case 5: {
                    char c10 = c5;
                    byArray[c10] = (byte)(byArray[c10] | n9);
                    continue block29;
                }
            }
        }
        for (c5 = '\u0000'; c5 < c6; ++c5) {
            if (nArray3[c5] <= -1 || nArray3[nArray3[c5]] != c5) continue;
            char c11 = c5;
            byArray[c11] = (byte)(byArray[c11] | n10);
            if (nArray[nArray5[c5]] == -1) {
                nArray[nArray5[c5]] = nArray5[nArray3[c5]];
            } else if (nArray[nArray5[c5]] != nArray5[nArray3[c5]]) {
                nArray2[nArray5[c5]] = nArray5[nArray3[c5]];
            }
            int n20 = nArray3[c5];
            byArray[n20] = (byte)(byArray[n20] | n10);
            if (nArray[nArray5[nArray3[c5]]] == -1) {
                nArray[nArray5[nArray3[c5]]] = nArray5[c5];
                continue;
            }
            if (nArray[nArray5[nArray3[c5]]] == nArray5[c5]) continue;
            nArray2[nArray5[nArray3[c5]]] = nArray5[c5];
        }
        for (n3 = 0; n3 < c6 - 2; ++n3) {
            if (nArray3[n3] <= -1 || (n5 = nArray4[n3 + 2]) <= -1 || nArray5[nArray3[n3]] - nArray5[n5] != 2) continue;
            ++n5;
            char c12 = c5 = n3 + 1;
            byArray[c12] = (byte)(byArray[c12] | n10);
            if (nArray[nArray5[c5]] == -1) {
                nArray[nArray5[c5]] = nArray5[n5];
            } else if (nArray[nArray5[c5]] != nArray5[n5]) {
                nArray2[nArray5[c5]] = nArray5[n5];
            }
            int n21 = n5;
            byArray[n21] = (byte)(byArray[n21] | n10);
            if (nArray[nArray5[n5]] == -1) {
                nArray[nArray5[n5]] = nArray5[c5];
                continue;
            }
            if (nArray[nArray5[n5]] == nArray5[c5]) continue;
            nArray2[nArray5[n5]] = nArray5[c5];
        }
        for (n3 = 1; n3 < c6; ++n3) {
            n5 = nArray3[n3 - 1];
            if (n5 <= -1 || nArray3[n5] <= -1 || nArray5[nArray3[n5]] - nArray5[n3] != 1) continue;
            int n22 = n3;
            byArray[n22] = (byte)(byArray[n22] | n11);
            if (nArray[nArray5[n3]] == -1) {
                nArray[nArray5[n3]] = nArray5[n5];
            } else if (nArray[nArray5[n3]] != nArray5[n5]) {
                nArray2[nArray5[n3]] = nArray5[n5];
            }
            int n23 = n5;
            byArray[n23] = (byte)(byArray[n23] | n11);
            if (nArray[nArray5[n5]] == -1) {
                nArray[nArray5[n5]] = nArray5[n3];
                continue;
            }
            if (nArray[nArray5[n5]] == nArray5[n3]) continue;
            nArray2[nArray5[n5]] = nArray5[n3];
        }
        for (n3 = 0; n3 < c6; ++n3) {
            if (!(nArray4[n3] > -1 & nArray3[n3] > -1) || nArray5[nArray3[n3]] - nArray5[nArray4[n3]] != 2) continue;
            n5 = nArray4[n3] + 1;
            int n24 = n3;
            byArray[n24] = (byte)(byArray[n24] | n11);
            if (nArray[nArray5[n3]] == -1) {
                nArray[nArray5[n3]] = nArray5[n5];
            } else if (nArray[nArray5[n3]] != nArray5[n5]) {
                nArray2[nArray5[n3]] = nArray5[n5];
            }
            int n25 = n5;
            byArray[n25] = (byte)(byArray[n25] | n11);
            if (nArray[nArray5[n5]] == -1) {
                nArray[nArray5[n5]] = nArray5[n3];
                continue;
            }
            if (nArray[nArray5[n5]] == nArray5[n3]) continue;
            nArray2[nArray5[n5]] = nArray5[n3];
        }
        for (c4 = '\u0001'; c4 < c6; ++c4) {
            n3 = 0;
            if (nArray[nArray5[c4]] > -1) {
                n5 = c4 - 1;
                if (nArray[nArray5[n5]] > -1) {
                    n2 = Math.abs(nArray[nArray5[n5]] - nArray[nArray5[c4]]);
                    n3 = n2 > 2 ? 1 : 0;
                } else if (nArray2[nArray5[n5]] > -1) {
                    n2 = Math.abs(nArray2[nArray5[n5]] - nArray[nArray5[c4]]);
                    n3 = n2 <= 2 ? 1 : 0;
                } else if (c4 > '\u0001') {
                    n5 = c4 - 2;
                    if (nArray[nArray5[n5]] > -1) {
                        n2 = Math.abs(nArray[nArray5[n5]] - nArray[nArray5[c4]]);
                        n3 = n2 > 2 ? 1 : 0;
                    } else if (nArray2[nArray5[n5]] > -1) {
                        n2 = Math.abs(nArray2[nArray5[n5]] - nArray[nArray5[c4]]);
                        int n26 = n3 = n2 <= 2 ? 1 : 0;
                    }
                }
            }
            if (n3 == 0) continue;
            n5 = nArray[nArray5[c4]];
            nArray[nArray5[c4]] = nArray2[nArray5[c4]];
            nArray2[nArray5[c4]] = n5;
        }
        c4 = 'h';
        for (n = 0; n < c6 - 1; ++n) {
            n5 = n + 1;
            if ((byArray[n] & n8) > 0 && (byArray[n5] & n8) > 0) {
                this.ssFlags[nArray5[n5]] = c4;
                this.ssFlags[nArray5[n5 + 1]] = c4 = (char)Character.toUpperCase(c4);
                if (n5 < c6 - 2) {
                    this.ssFlags[nArray5[n5 + 2]] = c4;
                }
                if (n5 >= c6 - 3) continue;
                this.ssFlags[nArray5[n5 + 3]] = c4;
                continue;
            }
            c4 = 'h';
        }
        block36: for (c3 = '\u0000'; c3 < c6; ++c3) {
            if (nArray[nArray5[c3]] <= -1) continue;
            c4 = 'e';
            c2 = c3 + 1;
            while (c2 < c6) {
                if (nArray[nArray5[c2]] > -1) {
                    n2 = 2;
                } else {
                    if (++c2 >= c6) continue block36;
                    if (nArray[nArray5[c2]] > -1) {
                        n2 = 3;
                    } else {
                        if (++c2 >= c6 || nArray[nArray5[c2]] <= -1) continue block36;
                        n2 = 2;
                    }
                }
                n = Math.abs(nArray[nArray5[c3]] - nArray[nArray5[c2]]);
                if (n <= n2) {
                    block38: for (c = c3; c <= c2; ++c) {
                        switch (this.ssFlags[nArray5[c]]) {
                            case ' ': 
                            case 'e': {
                                this.ssFlags[nArray5[c]] = c4;
                            }
                            case 'E': {
                                c4 = 'E';
                                continue block38;
                            }
                        }
                    }
                }
                c3 = c2++;
            }
        }
        block39: for (c3 = '\u0000'; c3 < c6; ++c3) {
            if (nArray2[nArray5[c3]] <= -1) continue;
            c4 = 'e';
            c2 = c3 + 1;
            while (c2 < c6) {
                if (nArray2[nArray5[c2]] > -1) {
                    n2 = 2;
                } else {
                    if (++c2 >= c6) continue block39;
                    if (nArray2[nArray5[c2]] > -1) {
                        n2 = 3;
                    } else {
                        if (++c2 >= c6 || nArray2[nArray5[c2]] <= -1) continue block39;
                        n2 = 2;
                    }
                }
                n = Math.abs(nArray2[nArray5[c3]] - nArray2[nArray5[c2]]);
                if (n <= n2) {
                    block41: for (c = c3; c <= c2; ++c) {
                        switch (this.ssFlags[nArray5[c]]) {
                            case ' ': 
                            case 'e': {
                                this.ssFlags[nArray5[c]] = c4;
                            }
                            case 'E': {
                                c4 = 'E';
                                continue block41;
                            }
                        }
                    }
                }
                c3 = c2++;
            }
        }
        c4 = 'i';
        for (c3 = '\u0000'; c3 < c6; ++c3) {
            if ((byArray[c3] & n9) > 0 && (byArray[c3 + 1] & n9) > 0) {
                for (c2 = '\u0001'; c2 <= '\u0005'; ++c2) {
                    n5 = c3 + c2;
                    if (this.ssFlags[nArray5[n5]] != ' ') continue;
                    this.ssFlags[nArray5[n5]] = c4;
                    c4 = 'I';
                }
                continue;
            }
            c4 = 'i';
        }
        c4 = 'g';
        for (c3 = '\u0000'; c3 < c6; ++c3) {
            if ((byArray[c3] & by) > 0 && (byArray[c3 + 1] & by) > 0) {
                for (c2 = '\u0001'; c2 <= '\u0003'; ++c2) {
                    n5 = c3 + c2;
                    if (this.ssFlags[nArray5[n5]] != ' ') continue;
                    this.ssFlags[nArray5[n5]] = c4;
                    c4 = 'G';
                }
                continue;
            }
            c4 = 'g';
        }
        block46: for (c2 = '\u0000'; c2 < c6; ++c2) {
            switch (this.ssFlags[nArray5[c2]]) {
                case 'G': 
                case 'I': 
                case 'g': 
                case 'i': {
                    c4 = Character.toUpperCase(this.ssFlags[nArray5[c2]]);
                    c3 = Character.toUpperCase(this.ssFlags[nArray5[c2 - 1]]);
                    n3 = c2 > '\u0000' ? (c4 != c3 ? 1 : 0) : 1;
                    c3 = Character.toUpperCase(this.ssFlags[nArray5[c2 + 1]]);
                    if (c2 < c6 - 1) {
                        int n27 = n3 = n3 != 0 && c4 != c3 ? 1 : 0;
                    }
                    if (n3 == 0) continue block46;
                    this.ssFlags[nArray5[c2]] = 116;
                    continue block46;
                }
            }
        }
        for (c2 = '\u0000'; c2 < c6; ++c2) {
            if ((byArray[c2] & n9) <= 0) continue;
            n3 = c2 > '\u0000' ? ((byArray[c2 - 1] & n9) <= 0 ? 1 : 0) : 1;
            int n28 = n3 = n3 != 0 && (byArray[c2 + 1] & n9) <= 0 ? 1 : 0;
            if (n3 == 0) continue;
            c4 = 't';
            for (c = '\u0001'; c <= '\u0005'; ++c) {
                n5 = c2 + c;
                if (this.ssFlags[nArray5[n5]] != ' ') continue;
                this.ssFlags[nArray5[n5]] = c4;
                c4 = Character.toUpperCase(c4);
            }
        }
        for (c2 = '\u0000'; c2 < c6; ++c2) {
            if ((byArray[c2] & n8) <= 0) continue;
            n3 = c2 > '\u0000' ? ((byArray[c2 - 1] & n8) <= 0 ? 1 : 0) : 1;
            int n29 = n3 = n3 != 0 && (byArray[c2 + 1] & n8) <= 0 ? 1 : 0;
            if (n3 == 0) continue;
            c4 = 't';
            for (c = '\u0001'; c <= '\u0004'; ++c) {
                n5 = c2 + c;
                if (this.ssFlags[nArray5[n5]] != ' ') continue;
                this.ssFlags[nArray5[n5]] = c4;
                c4 = Character.toUpperCase(c4);
            }
        }
        for (c2 = '\u0000'; c2 < c6; ++c2) {
            if ((byArray[c2] & by) <= 0) continue;
            n3 = c2 > '\u0000' ? ((byArray[c2 - 1] & by) <= 0 ? 1 : 0) : 1;
            int n30 = n3 = n3 != 0 && (byArray[c2 + 1] & by) <= 0 ? 1 : 0;
            if (n3 == 0) continue;
            c4 = 't';
            for (c = '\u0001'; c <= '\u0003'; ++c) {
                n5 = c2 + c;
                if (this.ssFlags[nArray5[n5]] != ' ') continue;
                this.ssFlags[nArray5[n5]] = c4;
                c4 = Character.toUpperCase(c4);
            }
        }
        vector3.trimToSize();
        return vector3.toArray();
    }

    public char[] getSsFlags() {
        return this.ssFlags;
    }

    public int getNumberOfChains() {
        return this.chains.length;
    }

    public int getChain(int[] nArray) {
        for (int i = 0; i < this.chains.length; ++i) {
            if (nArray[0] >= this.chains[i][1]) continue;
            return i;
        }
        return 100000;
    }

    public boolean getFragments(Vector vector, Vector vector2) {
        if (this.chains.length == 0) {
            return false;
        }
        int n = this.structureMap.getResidueCount();
        if (this.ssFlags == null) {
            System.out.println("getFragments: null ssFlags. One should first run setSsExtendedFlags on this class");
        }
        this.reinterpretSsFlags();
        String string = new String();
        int n2 = 0;
        char c = this.ssFlags[0];
        if (c == '-') {
            n2 = -1;
        }
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = this.chains[n4][0];
        for (int i = 0; i < this.ssFlags.length; ++i) {
            boolean bl3 = bl = i == n5;
            if (bl) {
                if (n4 < this.chains.length - 1) {
                    n5 = this.chains[++n4][0];
                }
                c = this.ssFlags[i];
                n2 = i;
                continue;
            }
            if (this.ssFlags[i] == c && i != this.ssFlags.length - 1) continue;
            int[] nArray = new int[2];
            switch (c) {
                case '-': {
                    n2 = i;
                    break;
                }
                case ' ': {
                    string = StructureComponentRegistry.TYPE_COIL;
                    nArray[0] = n2;
                    char c2 = Character.toUpperCase(this.ssFlags[i]);
                    switch (c2) {
                        case '-': {
                            nArray[1] = i - 1;
                            n2 = -1;
                            break;
                        }
                        case 'T': {
                            nArray[1] = i - 1;
                            n2 = i - 1;
                            break;
                        }
                        case 'E': 
                        case 'H': {
                            nArray[1] = i;
                            n2 = i;
                        }
                    }
                    vector.add(nArray);
                    vector2.add(string);
                    ++n3;
                    break;
                }
                case 'T': {
                    string = StructureComponentRegistry.TYPE_TURN;
                    nArray[0] = n2;
                    char c2 = Character.toUpperCase(this.ssFlags[i]);
                    switch (c2) {
                        case '-': {
                            nArray[1] = i - 1;
                            n2 = -1;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case ' ': 
                        case 'E': 
                        case 'H': {
                            nArray[1] = i;
                            n2 = i;
                            vector.add(nArray);
                            vector2.add(string);
                        }
                    }
                    ++n3;
                    break;
                }
                case 'H': {
                    string = StructureComponentRegistry.TYPE_HELIX;
                    nArray[0] = n2;
                    char c2 = Character.toUpperCase(this.ssFlags[i]);
                    switch (c2) {
                        case '-': {
                            nArray[1] = i - 1;
                            n2 = -1;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case ' ': 
                        case 'T': {
                            nArray[1] = i - 1;
                            n2 = i - 1;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case 'E': 
                        case 'H': {
                            nArray[1] = i - 1;
                            vector.add(nArray);
                            vector2.add(string);
                            ++n3;
                            nArray = new int[]{i - 1, i};
                            string = StructureComponentRegistry.TYPE_TURN;
                            n2 = i;
                            vector.add(nArray);
                            vector2.add(string);
                        }
                    }
                    ++n3;
                    break;
                }
                case 'E': {
                    string = StructureComponentRegistry.TYPE_STRAND;
                    nArray[0] = n2;
                    char c2 = Character.toUpperCase(this.ssFlags[i]);
                    switch (c2) {
                        case '-': {
                            nArray[1] = i - 1;
                            n2 = -1;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case ' ': 
                        case 'T': {
                            nArray[1] = i - 1;
                            n2 = i - 1;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case 'E': 
                        case 'H': {
                            nArray[1] = i - 1;
                            vector.add(nArray);
                            vector2.add(string);
                            ++n3;
                            nArray = new int[]{i - 1, i};
                            string = StructureComponentRegistry.TYPE_TURN;
                            n2 = i;
                            vector.add(nArray);
                            vector2.add(string);
                        }
                    }
                    ++n3;
                }
            }
            c = Character.toUpperCase(this.ssFlags[i]);
        }
        if (vector.size() == 0) {
            return false;
        }
        ListIterator listIterator = vector.listIterator();
        ListIterator listIterator2 = vector2.listIterator();
        this.openDistanceGaps(vector, vector2);
        return true;
    }

    public boolean getDisjointFragments(Vector vector, Vector vector2) {
        int[] nArray;
        if (this.chains.length == 0) {
            return false;
        }
        int n = this.structureMap.getResidueCount();
        if (this.ssFlags == null) {
            System.out.println("getFragments: null ssFlags. One should first run setSsExtendedFlags on this class");
        }
        this.reinterpretSsFlags();
        String string = new String();
        int n2 = 0;
        char c = this.ssFlags[0];
        if (c == '-') {
            n2 = -1;
        }
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = this.chains[n4][0];
        int n6 = 0;
        for (int i = 0; i < this.ssFlags.length; ++i) {
            bl2 = i == n6;
            boolean bl3 = bl = i == n5;
            if (bl) {
                n6 = this.chains[n4][1];
                if (n4 < this.chains.length - 1) {
                    n5 = this.chains[++n4][0];
                }
                c = this.ssFlags[i];
                n2 = i;
                continue;
            }
            if (this.ssFlags[i] == c && !bl2) continue;
            nArray = new int[2];
            switch (c) {
                case '-': {
                    n2 = i;
                    break;
                }
                case ' ': {
                    string = StructureComponentRegistry.TYPE_COIL;
                    nArray[0] = n2;
                    char c2 = Character.toUpperCase(this.ssFlags[i]);
                    switch (c2) {
                        case '-': {
                            nArray[1] = i - 1;
                            n2 = -1;
                            break;
                        }
                        case 'T': {
                            nArray[1] = i - 1;
                            n2 = i;
                            break;
                        }
                        case 'E': 
                        case 'H': {
                            nArray[1] = i - 1;
                            n2 = i;
                            break;
                        }
                        case ' ': {
                            nArray[1] = i;
                        }
                    }
                    vector.add(nArray);
                    vector2.add(string);
                    ++n3;
                    break;
                }
                case 'T': {
                    string = StructureComponentRegistry.TYPE_TURN;
                    nArray[0] = n2;
                    char c2 = Character.toUpperCase(this.ssFlags[i]);
                    switch (c2) {
                        case '-': {
                            nArray[1] = i - 1;
                            n2 = -1;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case 'T': {
                            if (!bl2) break;
                            nArray[1] = i;
                            n2 = i;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case ' ': 
                        case 'E': 
                        case 'H': {
                            nArray[1] = i - 1;
                            n2 = i;
                            vector.add(nArray);
                            vector2.add(string);
                        }
                    }
                    ++n3;
                    break;
                }
                case 'H': {
                    string = StructureComponentRegistry.TYPE_HELIX;
                    nArray[0] = n2;
                    char c2 = Character.toUpperCase(this.ssFlags[i]);
                    switch (c2) {
                        case '-': {
                            nArray[1] = i - 1;
                            n2 = -1;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case 'H': {
                            if (!bl2) break;
                            nArray[1] = i;
                            n2 = i;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case ' ': 
                        case 'T': {
                            nArray[1] = i - 1;
                            n2 = i;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case 'E': {
                            nArray[1] = i - 1;
                            vector.add(nArray);
                            vector2.add(string);
                            ++n3;
                            n2 = i;
                        }
                    }
                    ++n3;
                    break;
                }
                case 'E': {
                    string = StructureComponentRegistry.TYPE_STRAND;
                    nArray[0] = n2;
                    char c2 = Character.toUpperCase(this.ssFlags[i]);
                    switch (c2) {
                        case '-': {
                            nArray[1] = i - 1;
                            n2 = -1;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case ' ': 
                        case 'T': {
                            nArray[1] = i - 1;
                            n2 = i;
                            vector.add(nArray);
                            vector2.add(string);
                            break;
                        }
                        case 'E': 
                        case 'H': {
                            nArray[1] = i - 1;
                            vector.add(nArray);
                            vector2.add(string);
                            ++n3;
                            n2 = i;
                        }
                    }
                    ++n3;
                }
            }
            c = Character.toUpperCase(this.ssFlags[i]);
        }
        if (n2 == this.ssFlags.length - 1 && this.ssFlags[this.ssFlags.length - 1] == ' ') {
            nArray = new int[]{n2, this.ssFlags.length - 1};
            vector.add(nArray);
            vector2.add(StructureComponentRegistry.TYPE_COIL);
        }
        if (n2 == this.ssFlags.length - 1 && Character.toUpperCase(this.ssFlags[this.ssFlags.length - 1]) == 'T') {
            nArray = new int[]{n2, this.ssFlags.length - 1};
            vector.add(nArray);
            vector2.add(StructureComponentRegistry.TYPE_COIL);
        }
        if (vector.size() == 0) {
            return false;
        }
        ListIterator listIterator = vector.listIterator();
        ListIterator listIterator2 = vector2.listIterator();
        this.openDistanceGaps(vector, vector2);
        return true;
    }

    private void reinterpretSsFlags() {
        int n;
        int n2;
        block5: for (n2 = 0; n2 < this.ssFlags.length; ++n2) {
            switch (this.ssFlags[n2]) {
                case 'B': 
                case 'I': 
                case 'b': 
                case 'i': {
                    this.ssFlags[n2] = 32;
                    continue block5;
                }
                case 'g': {
                    this.ssFlags[n2] = 104;
                    continue block5;
                }
                case 'G': {
                    this.ssFlags[n2] = 72;
                    continue block5;
                }
            }
        }
        if (this.ssFlags[0] == ' ' && Character.toUpperCase(this.ssFlags[1]) == 'T') {
            this.ssFlags[0] = 84;
        }
        for (n2 = 1; n2 < this.ssFlags.length - 2; ++n2) {
            if ((this.ssFlags[n2] != ' ' || Character.toUpperCase(this.ssFlags[n2 - 1]) != 'T' || this.ssFlags[n2 + 1] == ' ') && (this.ssFlags[n2] != ' ' || Character.toUpperCase(this.ssFlags[n2 + 1]) != 'T')) continue;
            this.ssFlags[n2] = 84;
        }
        if (this.ssFlags[this.ssFlags.length - 1] == ' ' && Character.toUpperCase(this.ssFlags[this.ssFlags.length - 2]) == 'T') {
            this.ssFlags[this.ssFlags.length - 1] = 84;
        }
        for (n2 = 1; n2 < this.ssFlags.length; ++n2) {
            if (this.ssFlags[n2] != 't' || this.ssFlags[n2 - 1] != 'T') continue;
            this.ssFlags[n2] = 84;
        }
        n2 = 0;
        int n3 = 1;
        char c = Character.toUpperCase(this.ssFlags[0]);
        for (n = 0; n < this.ssFlags.length; ++n) {
            if (this.ssFlags[n] == c) {
                ++n3;
                continue;
            }
            if ((c == 'H' || c == 'E') && n3 < 3) {
                for (int i = n2; i < n; ++i) {
                    this.ssFlags[i] = 32;
                }
            }
            n2 = n;
            c = Character.toUpperCase(this.ssFlags[n]);
            n3 = 1;
        }
        for (n = 1; n < this.ssFlags.length - 1; ++n) {
            if (this.ssFlags[n] == '-' || this.ssFlags[n - 1] != '-' || this.ssFlags[n + 1] != '-') continue;
            this.ssFlags[n] = 45;
        }
    }

    private void openDistanceGaps(Vector vector, Vector vector2) {
        int n;
        double d = 5.0;
        int[] nArray = null;
        Atom atom = new Atom();
        int n2 = 0;
        String string = null;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        Residue residue = null;
        vector.trimToSize();
        nArray = (int[])vector.get(n2);
        while (nArray != null) {
            int n3 = nArray[0];
            residue = this.structureMap.getResidue(n3);
            atom = residue.getAlphaAtom();
            dArray[0] = atom.coordinate[0];
            dArray[1] = atom.coordinate[1];
            dArray[2] = atom.coordinate[2];
            n = nArray[1] - nArray[0] + 1;
            int n4 = n2 + 1;
            for (int i = 1; i < n; ++i) {
                residue = this.structureMap.getResidue(i + n3);
                atom = residue.getAlphaAtom();
                dArray2[0] = atom.coordinate[0];
                dArray2[1] = atom.coordinate[1];
                dArray2[2] = atom.coordinate[2];
                if (!(this.dist(dArray, dArray2) <= d)) {
                    int[] nArray2;
                    string = (String)vector2.elementAt(n2);
                    nArray[1] = n3 + i - 1;
                    if (nArray[1] - nArray[0] <= 1) {
                        nArray2 = (int[])vector.get(n2 - 1);
                        if (nArray2[1] >= nArray[0] - 1) {
                            nArray2[1] = nArray[1];
                            vector.remove(n2);
                            vector2.remove(n2);
                            n4 = n2;
                        } else {
                            vector2.set(n2, "NONE");
                        }
                    }
                    int[] nArray3 = new int[]{nArray[1], n3 + i};
                    vector.insertElementAt(nArray3, n4);
                    if (i < n - 1) {
                        nArray3 = new int[]{n3 + i, n + n3 - 1};
                        vector.add(n4, nArray3);
                        vector2.insertElementAt(string, n4);
                        break;
                    }
                    nArray2 = (int[])vector.get(n2 + 1);
                    nArray2[0] = n3 + i;
                    break;
                }
                dArray[0] = dArray2[0];
                dArray[1] = dArray2[1];
                dArray[2] = dArray2[2];
            }
            if (n2 < vector.size() - 1) {
                nArray = (int[])vector.get(++n2);
                continue;
            }
            nArray = null;
        }
        n2 = 0;
        nArray = (int[])vector.get(n2);
        while (nArray != null) {
            n = nArray[1] - nArray[0] + 1;
            if (n < 3 && (vector2.elementAt(n2) == StructureComponentRegistry.TYPE_HELIX || vector2.elementAt(n2) == StructureComponentRegistry.TYPE_HELIX)) {
                vector2.set(n2, StructureComponentRegistry.TYPE_COIL);
            }
            if (n2 < vector.size() - 1) {
                nArray = (int[])vector.get(++n2);
                continue;
            }
            nArray = null;
        }
    }

    public void setConformationType(Vector vector) {
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        this.setSsExtendedFlags();
        this.getDisjointFragments(vector2, vector3);
        vector2.trimToSize();
        vector3.trimToSize();
        Residue residue = null;
        for (int i = 0; i < vector2.size(); ++i) {
            int[] nArray = (int[])vector2.elementAt(i);
            String string = (String)vector3.elementAt(i);
            residue = (Residue)vector.elementAt(nArray[0]);
            String string2 = residue.getChainId();
            System.err.println("Fragment from " + nArray[0] + " to " + nArray[1] + "  Type  " + string);
            Chain chain = this.structureMap.getChain(string2);
            int n = chain.getResidueIndex(residue);
            chain.setFragment(n, n + nArray[1] - nArray[0], string);
        }
    }

    private final void add(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] + dArray3[0];
        dArray[1] = dArray2[1] + dArray3[1];
        dArray[2] = dArray2[2] + dArray3[2];
    }

    private final void diff(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
        dArray[2] = dArray2[2] - dArray3[2];
    }

    private final double length(double[] dArray) {
        double d = 0.0;
        d += dArray[0] * dArray[0];
        d += dArray[1] * dArray[1];
        d += dArray[2] * dArray[2];
        d = Math.sqrt(d);
        return d;
    }

    private final void scale(double[] dArray, double[] dArray2, double d) {
        dArray[0] = dArray2[0] * d;
        dArray[1] = dArray2[1] * d;
        dArray[2] = dArray2[2] * d;
    }

    private final double dist(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = dArray[0] - dArray2[0];
        d += d2 * d2;
        d2 = dArray[1] - dArray2[1];
        d += d2 * d2;
        d2 = dArray[2] - dArray2[2];
        d += d2 * d2;
        d = Math.sqrt(d);
        return d;
    }

    private final void normalize(double[] dArray, double[] dArray2) {
        double d = this.length(dArray2);
        this.scale(dArray, dArray2, 1.0 / d);
    }

    private final void printCoordinates(double[] dArray) {
        System.out.println("( " + dArray[0] + " , " + dArray[1] + " , " + dArray[2] + " )");
    }
}

