/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

public class NucleicAcidInfo {
    public static final String[] dna_bases = new String[]{"A", "C", "G", "T"};
    public static final String[] rna_bases = new String[]{"A", "C", "G", "U"};
    private static final String[][] names = new String[][]{{"A", "Adenine"}, {"B", "UNKNOWN"}, {"C", "Cytosine"}, {"D", "UNKNOWN"}, {"E", "UNKNOWN"}, {"F", "UNKNOWN"}, {"G", "Guanine"}, {"H", "UNKNOWN"}, {"I", "UNKNOWN"}, {"J", "UNKNOWN"}, {"K", "UNKNOWN"}, {"L", "UNKNOWN"}, {"M", "UNKNOWN"}, {"N", "UNKNOWN"}, {"O", "UNKNOWN"}, {"P", "UNKNOWN"}, {"Q", "UNKNOWN"}, {"R", "UNKNOWN"}, {"S", "UNKNOWN"}, {"T", "Thymine"}, {"U", "Uracil"}, {"V", "UNKNOWN"}, {"W", "UNKNOWN"}, {"X", "UNKNOWN"}, {"Y", "UNKNOWN"}, {"Z", "UNKNOWN"}};
    private static final int A_INDEX = 0;
    private static final int C_INDEX = 2;
    private static final int G_INDEX = 6;
    private static final int T_INDEX = 19;
    private static final int U_INDEX = 20;

    public static boolean isNucleotide(String string) {
        if (string == null) {
            return false;
        }
        if (names[0][0].equals(string)) {
            return true;
        }
        if (names[2][0].equals(string)) {
            return true;
        }
        if (names[6][0].equals(string)) {
            return true;
        }
        if (names[19][0].equals(string)) {
            return true;
        }
        return names[20][0].equals(string);
    }

    public static int getBaseCount() {
        return 5;
    }

    public static String getNameFromLetter(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() != 1) {
            return null;
        }
        int n = string.charAt(0) - 65;
        if (n < 0) {
            return null;
        }
        if (n > names.length) {
            return null;
        }
        return names[n][1];
    }

    public static String getLetterFromName(String string) {
        if (names[0][1].equals(string)) {
            return names[0][0];
        }
        if (names[2][1].equals(string)) {
            return names[2][0];
        }
        if (names[6][1].equals(string)) {
            return names[6][0];
        }
        if (names[19][1].equals(string)) {
            return names[19][0];
        }
        if (names[20][1].equals(string)) {
            return names[20][0];
        }
        return null;
    }

    public static String getDnaPairing(String string) {
        if (string.equals(names[0][0])) {
            return names[19][0];
        }
        if (string.equals(names[19][0])) {
            return names[0][0];
        }
        if (string.equals(names[6][0])) {
            return names[2][0];
        }
        if (string.equals(names[2][0])) {
            return names[6][0];
        }
        return null;
    }

    public static String getRnaDnaPairing(String string) {
        if (string.equals(names[20][0])) {
            return names[0][0];
        }
        if (string.equals(names[0][0])) {
            return names[19][0];
        }
        if (string.equals(names[6][0])) {
            return names[2][0];
        }
        if (string.equals(names[2][0])) {
            return names[6][0];
        }
        return null;
    }

    public static String getRnaRnaPairing(String string) {
        if (string.equals(names[0][0])) {
            return names[20][0];
        }
        if (string.equals(names[20][0])) {
            return names[0][0];
        }
        if (string.equals(names[6][0])) {
            return names[2][0];
        }
        if (string.equals(names[2][0])) {
            return names[6][0];
        }
        return null;
    }
}

