/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.util.BondInfo;
import edu.sdsc.mbt.util.ExcessiveDivisionException;
import edu.sdsc.mbt.util.OctreeAtomItem;
import edu.sdsc.mbt.util.OctreeDataItem;
import java.util.Vector;

public class Octree {
    private int dimension;
    private int maxNumberOfChildren;
    private int numberOfChildren;
    private int childId;
    private Octree parent = null;
    private Octree root = null;
    private Octree[] children = null;
    private OctreeDataItem[] dataItems = null;
    private double[] firstCorner;
    private double[] secondCorner;
    private double[] geometricalCenter;
    private double[] margin;
    private int weight;
    private int leafCutOff = 1;
    private boolean leaf = false;
    private double[] cellCenter;
    private double cellRadius;
    private double[] size;
    private double[] mid;
    private int majorAxis;
    private int minorAxis;
    private static int countAppBondOp = 0;
    private static int rejectedPaths = 0;
    private String path;
    public static int countChildren = 0;

    public Octree(Octree octree, Octree octree2, int n, OctreeDataItem[] octreeDataItemArray, double[] dArray, double[] dArray2) {
        this.root = octree;
        this.childId = n;
        this.path = octree2.path + n;
        this.dimension = octree.getDimension();
        this.firstCorner = dArray;
        this.secondCorner = dArray2;
        this.parent = octree2;
        this.maxNumberOfChildren = octree.getMaxNumberOfChildren();
        double d = 0.0;
        double d2 = 1000000.0;
        this.size = new double[this.dimension];
        this.mid = new double[this.dimension];
        this.cellRadius = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            this.size[i] = Math.abs(dArray2[i] - dArray[i]);
            this.mid[i] = (dArray2[i] + dArray[i]) / 2.0;
            this.cellRadius += this.size[i] * this.size[i];
            if (this.size[i] > d) {
                d = this.size[i];
                this.majorAxis = i;
            }
            if (!(this.size[i] < d2)) continue;
            d2 = this.size[i];
            this.minorAxis = i;
        }
        this.cellRadius = Math.sqrt(this.cellRadius);
        this.cellRadius /= 2.0;
    }

    public Octree(int n, OctreeDataItem[] octreeDataItemArray, double[] dArray) {
        int n2;
        this.dimension = n;
        this.dataItems = octreeDataItemArray;
        this.weight = octreeDataItemArray.length;
        this.margin = new double[this.dimension];
        this.firstCorner = new double[this.dimension];
        this.secondCorner = new double[this.dimension];
        for (n2 = 0; n2 < this.dimension; ++n2) {
            this.margin[n2] = dArray[n2];
            this.firstCorner[n2] = 1000000.0;
            this.secondCorner[n2] = -1000000.0;
        }
        this.maxNumberOfChildren = 1;
        for (n2 = 0; n2 < this.dimension; ++n2) {
            this.maxNumberOfChildren <<= 1;
        }
        for (int i = 0; i < this.dataItems.length; ++i) {
            double[] dArray2 = this.dataItems[i].getCoordinate();
            for (int j = 0; j < this.dimension; ++j) {
                double d = dArray2[j];
                if (d <= this.firstCorner[j]) {
                    this.firstCorner[j] = d;
                }
                if (!(d >= this.secondCorner[j])) continue;
                this.secondCorner[j] = d;
            }
        }
        double d = 0.0;
        double d2 = 1000000.0;
        this.size = new double[this.dimension];
        this.cellRadius = 0.0;
        this.mid = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            int n3 = i;
            this.firstCorner[n3] = this.firstCorner[n3] - this.margin[i];
            int n4 = i;
            this.secondCorner[n4] = this.secondCorner[n4] + this.margin[i];
            this.size[i] = Math.abs(this.secondCorner[i] - this.firstCorner[i]);
            this.mid[i] = (this.secondCorner[i] + this.firstCorner[i]) / 2.0;
            this.cellRadius += this.size[i] * this.size[i];
            if (this.size[i] > d) {
                d = this.size[i];
                this.majorAxis = i;
            }
            if (!(this.size[i] < d2)) continue;
            d2 = this.size[i];
            this.minorAxis = i;
        }
        this.cellRadius = Math.sqrt(this.cellRadius);
        this.cellRadius /= 2.0;
        this.childId = 0;
        this.path = "" + this.childId;
        this.setRoot(this);
    }

    public void build() throws ExcessiveDivisionException {
        int n;
        Object object;
        int n2;
        int n3;
        ++countChildren;
        this.children = new Octree[this.maxNumberOfChildren];
        Vector[] vectorArray = new Vector[this.maxNumberOfChildren];
        double[] dArray = new double[this.dimension];
        int n4 = 1;
        for (n3 = 0; n3 < this.dimension; ++n3) {
            dArray[n3] = this.size[n3] / 2.0;
        }
        for (n3 = 0; n3 < this.maxNumberOfChildren; ++n3) {
            vectorArray[n3] = new Vector();
        }
        for (n3 = 0; n3 < this.dataItems.length; ++n3) {
            n2 = 0;
            object = this.dataItems[n3].getCoordinate();
            for (n = 0; n < this.dimension; ++n) {
                n2 <<= 1;
                if (!(object[n] <= this.mid[n])) continue;
                n2 |= n4;
            }
            vectorArray[n2].add(this.dataItems[n3]);
        }
        OctreeDataItem[] octreeDataItemArray = null;
        n2 = 0;
        object = null;
        n = 0;
        Object var10_9 = null;
        this.numberOfChildren = 0;
        if (this.dataItems.length > this.leafCutOff) {
            for (int i = 0; i < this.maxNumberOfChildren; ++i) {
                n2 = vectorArray[i].size();
                if (n2 > 0) {
                    n = 0;
                    octreeDataItemArray = new OctreeDataItem[n2];
                    object = vectorArray[i].iterator();
                    while (object.hasNext()) {
                        octreeDataItemArray[n] = (OctreeDataItem)object.next();
                        ++n;
                    }
                    double[] dArray2 = new double[this.dimension];
                    int n5 = 1;
                    for (int j = this.dimension - 1; j >= 0; --j) {
                        dArray2[j] = (i & n5) > 0 ? this.mid[j] - dArray[j] : this.mid[j] + dArray[j];
                        n5 <<= 1;
                    }
                    this.children[i] = new Octree(this.root, this, i, null, this.mid, dArray2);
                    this.children[i].build(octreeDataItemArray);
                }
                ++this.numberOfChildren;
            }
        } else {
            this.setLeafFlag(true);
        }
    }

    public void build(OctreeDataItem[] octreeDataItemArray) throws ExcessiveDivisionException {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        ++countChildren;
        this.weight = octreeDataItemArray.length;
        if (octreeDataItemArray.length <= this.leafCutOff) {
            this.setData(octreeDataItemArray);
            this.leaf = true;
            return;
        }
        this.children = new Octree[this.maxNumberOfChildren];
        Vector[] vectorArray = new Vector[this.maxNumberOfChildren];
        double[] dArray = new double[this.dimension];
        int n5 = 1;
        for (n4 = 0; n4 < this.dimension; ++n4) {
            dArray[n4] = this.size[n4] / 2.0;
        }
        n4 = 1;
        for (n3 = 0; n3 < this.dimension; ++n3) {
            if (!(dArray[n3] > 0.001)) continue;
            n4 = 0;
            break;
        }
        for (n3 = 0; n3 < this.maxNumberOfChildren; ++n3) {
            vectorArray[n3] = new Vector();
        }
        for (n3 = 0; n3 < octreeDataItemArray.length; ++n3) {
            n2 = 0;
            object = octreeDataItemArray[n3].getCoordinate();
            for (n = 0; n < this.dimension; ++n) {
                n2 <<= 1;
                if (!(object[n] <= this.mid[n])) continue;
                n2 |= n5;
            }
            vectorArray[n2].add(octreeDataItemArray[n3]);
        }
        OctreeDataItem[] octreeDataItemArray2 = null;
        n2 = 0;
        object = null;
        n = 0;
        Object var12_11 = null;
        this.numberOfChildren = 0;
        if (n4 != 0) {
            throw new ExcessiveDivisionException("Excessive division of the data bounding box");
        }
        for (int i = 0; i < this.maxNumberOfChildren; ++i) {
            n2 = vectorArray[i].size();
            if (n2 <= 0) continue;
            n = 0;
            octreeDataItemArray2 = new OctreeDataItem[n2];
            object = vectorArray[i].iterator();
            while (object.hasNext()) {
                octreeDataItemArray2[n] = (OctreeDataItem)object.next();
                ++n;
            }
            double[] dArray2 = new double[this.dimension];
            int n6 = 1;
            for (int j = this.dimension - 1; j >= 0; --j) {
                dArray2[j] = (i & n6) > 0 ? this.mid[j] - dArray[j] : this.mid[j] + dArray[j];
                n6 <<= 1;
            }
            this.children[i] = new Octree(this.root, this, i, null, this.mid, dArray2);
            this.children[i].build(octreeDataItemArray2);
            ++this.numberOfChildren;
        }
    }

    private final double getDistance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray2[i] - dArray[i]) * (dArray2[i] - dArray[i]);
        }
        d = Math.sqrt(d);
        return d;
    }

    private final double[] add(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    private final double[] scale(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d * dArray[i];
        }
        return dArray2;
    }

    private void printVector(double[] dArray) {
        System.out.print("(");
        for (int i = 0; i < dArray.length - 1; ++i) {
            System.out.print(" " + dArray[i]);
            System.out.print(",");
        }
        System.out.print(" " + dArray[dArray.length - 1]);
        System.out.println(" )");
    }

    public void setRoot(Octree octree) {
        this.root = octree;
    }

    public void setParent(Octree octree) {
        this.parent = octree;
    }

    public void setData(OctreeDataItem[] octreeDataItemArray) {
        this.dataItems = octreeDataItemArray;
    }

    private void setLeafFlag(boolean bl) {
        this.leaf = bl;
    }

    public void setLeafCutOffCriterion(int n) {
        this.leafCutOff = n;
    }

    public Object[] getBonds(double d) {
        Vector vector = new Vector();
        if (this.dataItems != null) {
            for (int i = 0; i < this.dataItems.length; ++i) {
                this.appendBonds(this.dataItems[i], d, vector);
            }
        }
        vector.trimToSize();
        return vector.toArray();
    }

    public Vector getBondsVector(double d) {
        Vector vector = new Vector();
        double[] dArray = new double[this.dimension];
        if (this.dataItems != null) {
            for (int i = 0; i < this.dataItems.length; ++i) {
                this.appendBonds(this.dataItems[i], d, vector);
            }
        }
        vector.trimToSize();
        return vector;
    }

    public Object[] getHBonds(double d) {
        Vector vector = new Vector();
        if (this.dataItems != null) {
            for (int i = 0; i < this.dataItems.length; ++i) {
                this.appendHBonds(this.dataItems[i], d, 2, vector);
            }
        }
        vector.trimToSize();
        return vector.toArray();
    }

    public Vector getHBondsVector(double d) {
        Vector vector = new Vector();
        if (this.dataItems != null) {
            for (int i = 0; i < this.dataItems.length; ++i) {
                this.appendHBonds(this.dataItems[i], d, 2, vector);
            }
        }
        return vector;
    }

    public Vector getHBondInfoVector(double d) {
        Vector vector = new Vector();
        double[] dArray = new double[this.dimension];
        if (this.dataItems != null) {
            for (int i = 0; i < this.dataItems.length; ++i) {
                dArray = this.dataItems[i].getCoordinate();
                int n = this.dataItems[i].getIndex();
                this.appendHBondInfo(dArray, n, d, 2, vector);
            }
        }
        return vector;
    }

    private void appendHBondInfo(double[] dArray, int n, double d, int n2, Vector vector) {
        ++countAppBondOp;
        double d2 = this.getDistance(dArray, this.mid);
        if ((d2 -= this.cellRadius) <= d) {
            if (this.leaf) {
                for (int i = 0; i < this.dataItems.length; ++i) {
                    int n3;
                    if (!(this.getDistance(this.dataItems[i].getCoordinate(), dArray) <= d) || n >= (n3 = this.dataItems[i].getIndex()) - n2) continue;
                    vector.add(new BondInfo(n, this.dataItems[i].getIndex()));
                }
            } else {
                for (int i = 0; i < this.maxNumberOfChildren; ++i) {
                    if (this.children[i] == null) continue;
                    this.children[i].appendHBondInfo(dArray, n, d, n2, vector);
                }
            }
        } else {
            return;
        }
    }

    private void appendBonds(OctreeDataItem octreeDataItem, double d, Vector vector) {
        ++countAppBondOp;
        double[] dArray = octreeDataItem.getCoordinate();
        int n = octreeDataItem.getIndex();
        double d2 = this.getDistance(dArray, this.mid);
        if ((d2 -= this.cellRadius) > d) {
            return;
        }
        if (this.leaf) {
            for (int i = 0; i < this.dataItems.length; ++i) {
                int n2;
                if (!(this.getDistance(this.dataItems[i].getCoordinate(), dArray) <= d) || n >= (n2 = this.dataItems[i].getIndex())) continue;
                vector.add(new Bond(((OctreeAtomItem)octreeDataItem).getAtom(), ((OctreeAtomItem)this.dataItems[i]).getAtom()));
            }
        } else {
            for (int i = 0; i < this.maxNumberOfChildren; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].appendBonds(octreeDataItem, d, vector);
            }
        }
    }

    private void appendHBonds(OctreeDataItem octreeDataItem, double d, int n, Vector vector) {
        ++countAppBondOp;
        double[] dArray = octreeDataItem.getCoordinate();
        int n2 = octreeDataItem.getIndex();
        double d2 = this.getDistance(dArray, this.mid);
        if ((d2 -= this.cellRadius) > d) {
            return;
        }
        if (this.leaf) {
            for (int i = 0; i < this.dataItems.length; ++i) {
                int n3;
                if (!(this.getDistance(this.dataItems[i].getCoordinate(), dArray) <= d) || n2 >= (n3 = this.dataItems[i].getIndex()) - n) continue;
                vector.add(new Bond(((OctreeAtomItem)octreeDataItem).getAtom(), ((OctreeAtomItem)this.dataItems[i]).getAtom()));
            }
        } else {
            for (int i = 0; i < this.maxNumberOfChildren; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].appendHBonds(octreeDataItem, d, n, vector);
            }
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getMaxNumberOfChildren() {
        return this.maxNumberOfChildren;
    }

    public int getNumberOfChildren() {
        return this.numberOfChildren;
    }

    public int getWeight() {
        return this.weight;
    }

    public void printChildNamingScheme() {
    }
}

