/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.util.Element;
import java.util.Hashtable;

public class PeriodicTable {
    private static final String SBLOCK = "s-block";
    private static final String PBLOCK = "p-block";
    private static final String DBLOCK = "d-block";
    private static final String FBLOCK = "f-block";
    private static final String[] blocks = new String[]{null, "s-block", "p-block", "d-block", "f-block"};
    private static final Element[] elements = new Element[]{new Element("xxx", "xxx", 0, 0.0, 0, "x", 0, "x"), new Element("Hydrogen", "H", 1, 1.00794, 1, "-", 1, "s-block"), new Element("Helium", "He", 2, 4.002602, 18, "Noble gas", 1, "p-block"), new Element("Lithium", "Li", 3, 6.941, 1, "Alkali metal", 2, "s-block"), new Element("Beryllium", "Be", 4, 9.012182, 2, "Alkaline earth metal", 2, "s-block"), new Element("Boron", "B", 5, 10.811, 13, "-", 2, "p-block"), new Element("Carbon", "C", 6, 12.0107, 14, "-", 2, "p-block"), new Element("Nitrogen", "N", 7, 14.0067, 15, "Pnictogen", 2, "p-block"), new Element("Oxygen", "O", 8, 15.9994, 16, "Chalcogen", 2, "p-block"), new Element("Fluorine", "F", 9, 18.9984032, 17, "Halogen", 2, "p-block"), new Element("Neon", "Ne", 10, 20.1797, 18, "Noble gas", 2, "p-block"), new Element("Sodium", "Na", 11, 22.98977, 1, "Alkali metal", 3, "s-block"), new Element("Magnesium", "Mg", 12, 24.305, 2, "Alkaline earth metal", 3, "s-block"), new Element("Aluminum", "Al", 13, 26.981538, 13, "-", 3, "p-block"), new Element("Silicon", "Si", 14, 28.0855, 14, "-", 3, "p-block"), new Element("Phosphorus", "P", 15, 30.973761, 15, "Pnictogen", 3, "p-block"), new Element("Sulfur", "S", 16, 32.065, 16, "Chalcogen", 3, "p-block"), new Element("Chlorine", "Cl", 17, 35.453, 17, "Halogen", 3, "p-block"), new Element("Argon", "Ar", 18, 39.948, 18, "Noble gas", 3, "p-block"), new Element("Potassium", "K", 19, 39.0983, 1, "Alkali metal", 4, "s-block"), new Element("Calcium", "Ca", 20, 40.078, 2, "Alkaline earth metal", 4, "s-block"), new Element("Scandium", "Sc", 21, 44.95591, 3, "-", 4, "d-block"), new Element("Titanium", "Ti", 22, 47.867, 4, "-", 4, "d-block"), new Element("Vanadium", "V", 23, 50.9415, 5, "-", 4, "d-block"), new Element("Chromium", "Cr", 24, 51.9961, 6, "-", 4, "d-block"), new Element("Manganese", "Mn", 25, 54.938049, 7, "-", 4, "d-block"), new Element("Iron", "Fe", 26, 55.845, 8, "-", 4, "d-block"), new Element("Cobalt", "Co", 27, 58.9332, 9, "-", 4, "d-block"), new Element("Nickel", "Ni", 28, 58.6934, 10, "-", 4, "d-block"), new Element("Copper", "Cu", 29, 63.546, 11, "Coinage metal", 4, "d-block"), new Element("Zinc", "Zn", 30, 65.409, 12, "-", 4, "d-block"), new Element("Gallium", "Ga", 31, 69.723, 13, "-", 4, "p-block"), new Element("Germanium", "Ge", 32, 72.64, 14, "-", 4, "p-block"), new Element("Arsenic", "As", 33, 74.9216, 15, "Pnictogen", 4, "p-block"), new Element("Selenium", "Se", 34, 78.96, 16, "Chalcogen", 4, "p-block"), new Element("Bromine", "Br", 35, 79.904, 17, "Halogen", 4, "p-block"), new Element("Krypton", "Kr", 36, 83.798, 18, "Noble gas", 4, "p-block"), new Element("Rubidium", "Rb", 37, 85.4678, 1, "Alkali metal", 5, "s-block"), new Element("Strontium", "Sr", 38, 87.62, 2, "Alkaline earth metal", 5, "s-block"), new Element("Yttrium", "Y", 39, 88.90585, 3, "-", 5, "d-block"), new Element("Zirconium", "Zr", 40, 91.224, 4, "-", 5, "d-block"), new Element("Niobium", "Nb", 41, 92.90638, 5, "-", 5, "d-block"), new Element("Molybdenum", "Mo", 42, 95.94, 6, "-", 5, "d-block"), new Element("Technetium", "Tc", 43, 98.0, 7, "-", 5, "d-block"), new Element("Ruthenium", "Ru", 44, 101.07, 8, "Precious metal", 5, "d-block"), new Element("Rhodium", "Rh", 45, 102.9055, 9, "Precious metal", 5, "d-block"), new Element("Palladium", "Pd", 46, 106.42, 10, "Precious metal", 5, "d-block"), new Element("Silver", "Ag", 47, 107.8682, 11, "Coinage metal", 5, "d-block"), new Element("Cadmium", "Cd", 48, 112.411, 12, "-", 5, "d-block"), new Element("Indium", "In", 49, 114.818, 13, "-", 5, "p-block"), new Element("Tin", "Sn", 50, 118.71, 14, "-", 5, "p-block"), new Element("Antimony", "Sb", 51, 121.76, 15, "Pnictogen", 5, "p-block"), new Element("Tellurium", "Te", 52, 127.6, 16, "Chalcogen", 5, "p-block"), new Element("Iodine", "I", 53, 126.90447, 17, "Halogen", 5, "p-block"), new Element("Xenon", "Xe", 54, 131.293, 18, "Noble gas", 5, "p-block"), new Element("Cesium", "Cs", 55, 132.90545, 1, "Alkali metal", 6, "s-block"), new Element("Barium", "Ba", 56, 137.327, 2, "Alkaline earth metal", 6, "s-block"), new Element("Lanthanum", "La", 57, 138.9055, -1, "Lanthanoid", 6, "f-block"), new Element("Cerium", "Ce", 58, 140.116, -1, "Lanthanoid", 6, "f-block"), new Element("Praseodymium", "Pr", 59, 140.90765, -1, "Lanthanoid", 6, "f-block"), new Element("Neodymium", "Nd", 60, 144.24, -1, "Lanthanoid", 6, "f-block"), new Element("Promethium", "Pm", 61, 145.0, -1, "Lanthanoid", 6, "f-block"), new Element("Samarium", "Sm", 62, 150.36, -1, "Lanthanoid", 6, "f-block"), new Element("Europium", "Eu", 63, 151.964, -1, "Lanthanoid", 6, "f-block"), new Element("Gadolinium", "Gd", 64, 157.25, -1, "Lanthanoid", 6, "f-block"), new Element("Terbium", "Tb", 65, 158.92534, -1, "Lanthanoid", 6, "f-block"), new Element("Dysprosium", "Dy", 66, 162.5, -1, "Lanthanoid", 6, "f-block"), new Element("Holmium", "Ho", 67, 164.93032, -1, "Lanthanoid", 6, "f-block"), new Element("Erbium", "Er", 68, 167.259, -1, "Lanthanoid", 6, "f-block"), new Element("Thulium", "Tm", 69, 168.93421, -1, "Lanthanoid", 6, "f-block"), new Element("Ytterbium", "Yb", 70, 173.04, -1, "Lanthanoid", 6, "f-block"), new Element("Lutetium", "Lu", 71, 174.967, 3, "-", 6, "d-block"), new Element("Hafnium", "Hf", 72, 178.49, 4, "-", 6, "d-block"), new Element("Tantalum", "Ta", 73, 180.9479, 5, "-", 6, "d-block"), new Element("Tungsten", "W", 74, 183.84, 6, "-", 6, "d-block"), new Element("Rhenium", "Re", 75, 186.207, 7, "-", 6, "d-block"), new Element("Osmium", "Os", 76, 190.23, 8, "Precious metal", 6, "d-block"), new Element("Iridium", "Ir", 77, 192.217, 9, "Precious metal", 6, "d-block"), new Element("Platinum", "Pt", 78, 195.078, 10, "Precious metal", 6, "d-block"), new Element("Gold", "Au", 79, 196.96655, 11, "Coinage metal", 6, "d-block"), new Element("Mercury", "Hg", 80, 200.59, 12, "-", 6, "d-block"), new Element("Thallium", "Tl", 81, 204.3833, 13, "-", 6, "p-block"), new Element("Lead", "Pb", 82, 207.2, 14, "-", 6, "p-block"), new Element("Bismuth", "Bi", 83, 208.98038, 15, "Pnictogen", 6, "p-block"), new Element("Polonium", "Po", 84, 209.0, 16, "Chalcogen", 6, "p-block"), new Element("Astatine", "At", 85, 210.0, 17, "Halogen", 6, "p-block"), new Element("Radon", "Rn", 86, 222.0, 18, "Noble Gas", 6, "p-block"), new Element("Francium", "Fr", 87, 223.0, 1, "Alkali Metal", 7, "s-block"), new Element("Radium", "Ra", 88, 226.0, 2, "Alkaline Earth Metal", 7, "s-block"), new Element("Actinium", "Ac", 89, 227.0, -1, "Actinoid", 7, "f-block"), new Element("Thorium", "Th", 90, 232.0381, -1, "Actinoid", 7, "f-block"), new Element("Protactinium", "Pa", 91, 231.03588, -1, "Actinoid", 7, "f-block"), new Element("Uranium", "U", 92, 238.02891, -1, "Actinoid", 7, "f-block"), new Element("Neptunium", "Np", 93, 237.0, -1, "Actinoid", 7, "f-block"), new Element("Plutonium", "Pu", 94, 244.0, -1, "Actdinoid", 7, "f-block"), new Element("Americium", "Am", 95, 243.0, -1, "Actinoid", 7, "f-block"), new Element("Curium", "Cm", 96, 247.0, -1, "Actinoid", 7, "f-block"), new Element("Berkelium", "Bk", 97, 247.0, -1, "Actinoid", 7, "f-block"), new Element("Californium", "Cf", 98, 251.0, -1, "Actinoid", 7, "f-block"), new Element("Einsteinium", "Es", 99, 252.0, -1, "Actinoid", 7, "f-block"), new Element("Fermium", "Fm", 100, 257.0, -1, "Actinoid", 7, "f-block"), new Element("Mendelevium", "Md", 101, 258.0, -1, "Actinoid", 7, "f-block"), new Element("Nobelium", "No", 102, 259.0, -1, "Actinoid", 7, "f-block"), new Element("Lawrencium", "Lr", 103, 262.0, 3, "-", 7, "d-block"), new Element("Rutherfordium", "Rf", 104, 261.0, 4, "-", 7, "d-block"), new Element("Dubnium", "Db", 105, 262.0, 5, "-", 7, "d-block"), new Element("Seaborgium", "Sg", 106, 266.0, 6, "-", 7, "d-block"), new Element("Bohrium", "Bh", 107, 264.0, 7, "-", 7, "d-block"), new Element("Hassium", "Hs", 108, 269.0, 8, "-", 7, "d-block"), new Element("Meitnerium", "Mt", 109, 268.0, 9, "-", 7, "d-block"), new Element("Darmstadtium", "Ds", 110, 271.0, 10, "-", 7, "d-block"), new Element("Unununium", "Uuu", 111, 272.0, 11, "-", 7, "d-block"), new Element("Ununbium", "Uub", 112, 285.0, 12, "-", 7, "d-block"), new Element("Ununtrium", "Uut", 113, 0.0, 0, "-", -1, "p-block"), new Element("Ununquadium", "Uuq", 114, 289.0, 14, "-", 7, "p-block"), new Element("Ununpentium", "Uup", 115, 0.0, 0, "-", -1, "p-block"), new Element("Ununhexium", "Uuh", 116, 292.0, 16, "Chalcogen", -1, "p-block"), new Element("Ununseptium", "Uus", 117, 0.0, 0, "-", -1, "p-block"), new Element("Ununoctium", "Uuo", 118, 0.0, 0, "-", -1, "p-block")};
    private static Hashtable symbolToElementHash = null;

    public static int getElementCount() {
        return elements.length;
    }

    public static Element getElement(int n) {
        if (n < 1) {
            return null;
        }
        if (n >= elements.length) {
            return null;
        }
        return elements[n];
    }

    public static Element getElement(String string) {
        return (Element)symbolToElementHash.get(string);
    }

    public static String getElementName(int n) {
        if (n < 1) {
            return null;
        }
        if (n >= elements.length) {
            return null;
        }
        return PeriodicTable.elements[n].name;
    }

    public static String getElementName(String string) {
        Element element = (Element)symbolToElementHash.get(string);
        if (element == null) {
            return null;
        }
        return element.name;
    }

    public static int getElementNumber(String string) {
        Element element = (Element)symbolToElementHash.get(string);
        if (element == null) {
            return -1;
        }
        return element.atomic_number;
    }

    public static double getElementWeight(int n) {
        if (n < 1) {
            return 0.0;
        }
        if (n >= elements.length) {
            return 0.0;
        }
        return PeriodicTable.elements[n].atomic_weight;
    }

    public static double getElementWeight(String string) {
        Element element = (Element)symbolToElementHash.get(string);
        if (element == null) {
            return 0.0;
        }
        return element.atomic_weight;
    }

    static {
        symbolToElementHash = new Hashtable();
        for (int i = 0; i < elements.length; ++i) {
            symbolToElementHash.put(PeriodicTable.elements[i].symbol, elements[i]);
            symbolToElementHash.put(PeriodicTable.elements[i].symbol.toUpperCase(), elements[i]);
            symbolToElementHash.put(PeriodicTable.elements[i].symbol.toLowerCase(), elements[i]);
        }
    }
}

