/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.util.Algebra;

public class PickUtils {
    public static final int PICK_AUTO = 0;
    public static final int PICK_ATOMS = 1;
    public static final int PICK_RESIDUES = 2;
    public static final int PICK_FRAGMENTS = 3;
    public static final int PICK_CHAINS = 4;
    public static final int PICK_MOLECULES = 5;
    private static final int PICK_MIN = 0;
    private static final int PICK_MAX = 5;
    public static int pickLevel = 0;

    public static void setPickLevel(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("invalid pick level");
        }
        pickLevel = n;
    }

    public static int getPickLevel() {
        return pickLevel;
    }

    public static StructureComponent pickLevelComponent(StructureComponent structureComponent, double[] dArray) {
        if (structureComponent == null) {
            throw new NullPointerException("null StructureComponent");
        }
        if (dArray == null) {
            throw new NullPointerException("null coord");
        }
        StructureComponent structureComponent2 = structureComponent;
        if (pickLevel != 0) {
            String string = structureComponent.getStructureComponentType();
            int n = 0;
            if (string == StructureComponentRegistry.TYPE_ATOM) {
                n = 1;
            } else if (string == StructureComponentRegistry.TYPE_BOND) {
                n = 1;
            } else if (string == StructureComponentRegistry.TYPE_RESIDUE) {
                n = 2;
            } else if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
                n = 3;
            } else if (string == StructureComponentRegistry.TYPE_CHAIN) {
                n = 4;
            }
            if (pickLevel != n) {
                StructureMap structureMap = structureComponent.structure.getStructureMap();
                Atom atom = PickUtils.closestAtom(structureComponent, dArray);
                if (atom == null) {
                    return structureComponent2;
                }
                if (pickLevel == 1) {
                    if (string != StructureComponentRegistry.TYPE_BOND) {
                        structureComponent2 = atom;
                    }
                    return structureComponent2;
                }
                Residue residue = structureMap.getResidue(atom);
                if (residue == null) {
                    return structureComponent2;
                }
                if (pickLevel == 2) {
                    structureComponent2 = residue;
                    return structureComponent2;
                }
                Fragment fragment = residue.getFragment();
                if (fragment == null) {
                    return structureComponent2;
                }
                if (pickLevel == 3) {
                    structureComponent2 = fragment;
                    return structureComponent2;
                }
                Chain chain = fragment.getChain();
                if (chain == null) {
                    return structureComponent2;
                }
                if (pickLevel == 4) {
                    structureComponent2 = chain;
                    return structureComponent2;
                }
            }
        }
        return structureComponent2;
    }

    public static Atom closestAtom(StructureComponent structureComponent, double[] dArray) {
        Atom atom = null;
        String string = structureComponent.getStructureComponentType();
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            atom = (Atom)structureComponent;
        } else if (string == StructureComponentRegistry.TYPE_BOND) {
            double d;
            Bond bond = (Bond)structureComponent;
            Atom atom2 = bond.getAtom(0);
            Atom atom3 = bond.getAtom(1);
            double d2 = Algebra.distance(dArray, atom2.coordinate);
            atom = d2 <= (d = Algebra.distance(dArray, atom3.coordinate)) ? atom2 : atom3;
        } else if (string == StructureComponentRegistry.TYPE_RESIDUE) {
            Residue residue = (Residue)structureComponent;
            double d = 10000.0;
            int n = residue.getAtomCount();
            for (int i = 0; i < n; ++i) {
                Atom atom4 = residue.getAtom(i);
                double d3 = Algebra.distance(dArray, atom4.coordinate);
                if (!(d3 < d)) continue;
                d = d3;
                atom = atom4;
            }
        } else if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
            Fragment fragment = (Fragment)structureComponent;
            double d = 10000.0;
            int n = fragment.getResidueCount();
            for (int i = 0; i < n; ++i) {
                Residue residue = fragment.getResidue(i);
                int n2 = residue.getAtomCount();
                for (int j = 0; j < n2; ++j) {
                    Atom atom5 = residue.getAtom(j);
                    double d4 = Algebra.distance(dArray, atom5.coordinate);
                    if (!(d4 < d)) continue;
                    d = d4;
                    atom = atom5;
                }
            }
        } else if (string == StructureComponentRegistry.TYPE_CHAIN) {
            Chain chain = (Chain)structureComponent;
            double d = 10000.0;
            int n = chain.getResidueCount();
            for (int i = 0; i < n; ++i) {
                Residue residue = chain.getResidue(i);
                int n3 = residue.getAtomCount();
                for (int j = 0; j < n3; ++j) {
                    Atom atom6 = residue.getAtom(j);
                    double d5 = Algebra.distance(dArray, atom6.coordinate);
                    if (!(d5 < d)) continue;
                    d = d5;
                    atom = atom6;
                }
            }
        } else {
            StructureMap structureMap = structureComponent.structure.getStructureMap();
            double d = 10000.0;
            int n = structureMap.getAtomCount();
            for (int i = 0; i < n; ++i) {
                Atom atom7 = structureMap.getAtom(i);
                double d6 = Algebra.distance(dArray, atom7.coordinate);
                if (!(d6 < d)) continue;
                d = d6;
                atom = atom7;
            }
        }
        return atom;
    }
}

