/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import java.util.Hashtable;
import java.util.Vector;

public class RangeMap {
    private int rangeMin = 0;
    private int rangeMax = 0;
    private Vector ranges = new Vector();
    private Hashtable values = new Hashtable();
    private Object defaultValue = null;
    private boolean collapseOn = true;

    public RangeMap(int n, int n2, Object object) {
        this.reset(n, n2, object);
    }

    public int getMin() {
        return this.rangeMin;
    }

    public int getMax() {
        return this.rangeMax;
    }

    public void setCollapseOn(boolean bl) {
        this.collapseOn = bl;
    }

    public boolean getCollapseOn() {
        return this.collapseOn;
    }

    public void setRange(int n, int n2, Object object) {
        if (n > n2) {
            throw new IllegalArgumentException("stop must be >= start");
        }
        if (n < this.rangeMin) {
            throw new IllegalArgumentException("start must be >= min");
        }
        if (n2 > this.rangeMax) {
            throw new IllegalArgumentException("stop must be <= max");
        }
        if (object == null) {
            throw new IllegalArgumentException("value was null");
        }
        int[] nArray = new int[]{n, n2};
        boolean bl = false;
        for (int i = 0; i < this.ranges.size(); ++i) {
            int[] nArray2 = (int[])this.ranges.elementAt(i);
            if (nArray[1] < nArray2[0] || nArray[0] > nArray2[1]) continue;
            if (nArray[0] == nArray2[0] && nArray[1] == nArray2[1]) {
                this.values.put(nArray2, object);
                break;
            }
            if (nArray[0] > nArray2[0] && nArray[1] < nArray2[1]) {
                Object v = this.values.get(nArray2);
                int[] nArray3 = new int[]{nArray[1] + 1, nArray2[1]};
                this.ranges.add(i + 1, nArray3);
                this.values.put(nArray3, v);
                this.ranges.add(i + 1, nArray);
                this.values.put(nArray, object);
                nArray2[1] = nArray[0] - 1;
                break;
            }
            if (nArray[0] <= nArray2[0] && nArray[1] >= nArray2[1]) {
                this.ranges.remove(i);
                this.values.remove(nArray2);
                if (!bl) {
                    bl = true;
                    this.ranges.add(i, nArray);
                    this.values.put(nArray, object);
                    continue;
                }
                --i;
                continue;
            }
            if (nArray[0] > nArray2[0] && nArray[0] <= nArray2[1] && nArray[1] >= nArray2[1]) {
                nArray2[1] = nArray[0] - 1;
                bl = true;
                this.ranges.add(i + 1, nArray);
                this.values.put(nArray, object);
                ++i;
                continue;
            }
            if (nArray[0] > nArray2[0] || nArray[1] >= nArray2[1]) continue;
            if (nArray[0] == nArray2[0]) {
                this.ranges.add(i, nArray);
                this.values.put(nArray, object);
            }
            nArray2[0] = nArray[1] + 1;
            break;
        }
        this.collapse();
    }

    private void collapse() {
        if (!this.collapseOn) {
            return;
        }
        int n = this.ranges.size();
        if (n > 1) {
            int[] nArray = (int[])this.ranges.elementAt(0);
            Object v = this.values.get(nArray);
            for (int i = 1; i < n; ++i) {
                int[] nArray2 = (int[])this.ranges.elementAt(i);
                Object v2 = this.values.get(nArray2);
                if (v2 == v) {
                    nArray[1] = nArray2[1];
                    this.ranges.remove(i);
                    this.values.remove(nArray2);
                    --n;
                    --i;
                    continue;
                }
                nArray = nArray2;
                v = v2;
            }
        }
    }

    public void clearRange(int n, int n2) {
        this.setRange(n, n2, this.defaultValue);
    }

    public void clearAll() {
        this.ranges.clear();
        this.values.clear();
        int[] nArray = new int[]{this.rangeMin, this.rangeMax};
        this.ranges.add(nArray);
        this.values.put(nArray, this.defaultValue);
    }

    public void reset(int n, int n2, Object object) {
        if (n > n2) {
            throw new IllegalArgumentException("min > max");
        }
        if (object == null) {
            throw new IllegalArgumentException("default value was null");
        }
        this.rangeMin = n;
        this.rangeMax = n2;
        this.defaultValue = object;
        this.clearAll();
    }

    public void setDefaultValue(Object object) {
        if (object == this.defaultValue) {
            return;
        }
        if (object == null) {
            return;
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            int[] nArray = (int[])this.ranges.elementAt(i);
            Object v = this.values.get(nArray);
            if (v != this.defaultValue) continue;
            this.values.put(nArray, object);
        }
        this.defaultValue = object;
    }

    private int findRange(int n) {
        if (n < this.rangeMin) {
            throw new IllegalArgumentException("index " + n + " < rangeMin " + this.rangeMin);
        }
        if (n > this.rangeMax) {
            throw new IllegalArgumentException("index " + n + " > rangeMax " + this.rangeMax);
        }
        int n2 = 0;
        int n3 = this.ranges.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int[] nArray = (int[])this.ranges.elementAt(n4);
            if (n >= nArray[0] && n <= nArray[1]) {
                return n4;
            }
            if (n < nArray[0]) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        throw new IllegalArgumentException("RangeMap.findRange did not find a range!");
    }

    public void setValue(int n, Object object) {
        this.setRange(n, n, object);
    }

    public Object getValue(int n) {
        if (n < this.rangeMin) {
            throw new IllegalArgumentException("index " + n + " < rangeMin " + this.rangeMin);
        }
        if (n > this.rangeMax) {
            throw new IllegalArgumentException("index " + n + " > rangeMax " + this.rangeMax);
        }
        int n2 = this.findRange(n);
        int[] nArray = (int[])this.ranges.elementAt(n2);
        if (n >= nArray[0] && n <= nArray[1]) {
            return this.values.get(nArray);
        }
        return null;
    }

    public Object getContiguousValue(int n, int n2) {
        int n3 = this.findRange(n);
        int[] nArray = (int[])this.ranges.elementAt(n3);
        if (nArray == null) {
            return null;
        }
        if (n2 >= nArray[0] && n2 <= nArray[1]) {
            return this.values.get(nArray);
        }
        return null;
    }

    public int getRangeCount() {
        return this.ranges.size();
    }

    public Object getRangeValue(int n) {
        int[] nArray = (int[])this.ranges.elementAt(n);
        return this.values.get(nArray);
    }

    public void setRangeValue(int n, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null value");
        }
        int[] nArray = (int[])this.ranges.elementAt(n);
        this.values.put(nArray, object);
    }

    public int[] getRange(int n) {
        int[] nArray = (int[])this.ranges.elementAt(n);
        int[] nArray2 = new int[]{nArray[0], nArray[1]};
        return nArray2;
    }

    public int getRangeStart(int n) {
        int[] nArray = (int[])this.ranges.elementAt(n);
        return nArray[0];
    }

    public int getRangeEnd(int n) {
        int[] nArray = (int[])this.ranges.elementAt(n);
        return nArray[1];
    }

    public void append(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null value");
        }
        ++this.rangeMax;
        int[] nArray = (int[])this.ranges.elementAt(this.ranges.size() - 1);
        Object v = this.values.get(nArray);
        if (v == object) {
            nArray[1] = nArray[1] + 1;
        } else {
            int[] nArray2 = new int[]{this.rangeMax, this.rangeMax};
            this.ranges.add(nArray2);
            this.values.put(nArray2, object);
        }
    }

    public void remove(int n) {
        if (n < this.rangeMin || n > this.rangeMax) {
            throw new IllegalArgumentException("index out of bounds");
        }
        int n2 = this.findRange(n);
        int[] nArray = (int[])this.ranges.elementAt(n2);
        if (nArray[0] == nArray[1]) {
            this.values.remove(nArray);
            this.ranges.remove(n2);
        } else {
            nArray[1] = nArray[1] - 1;
            ++n2;
        }
        int n3 = this.ranges.size();
        for (int i = n2; i < n3; ++i) {
            nArray = (int[])this.ranges.elementAt(i);
            nArray[0] = nArray[0] - 1;
            nArray[1] = nArray[1] - 1;
        }
        this.collapse();
    }
}

