/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.util;

import edu.sdsc.mbt.util.StatusEvent;
import edu.sdsc.mbt.util.StatusListener;
import java.util.Vector;

public class Status {
    public static final int LEVEL_QUIET = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_REMARK = 3;
    public static final int LEVEL_DEBUG = 4;
    public static final int LEVEL_DUMP = 5;
    private static Vector level_names = null;
    private static int output_level;
    private static Vector statusListeners;
    private static StatusEvent statusEvent;

    public static void addStatusListener(StatusListener statusListener) {
        if (statusListener == null) {
            return;
        }
        if (statusListeners == null) {
            statusListeners = new Vector();
        }
        if (statusEvent == null) {
            statusEvent = new StatusEvent();
        }
        statusListeners.add(statusListener);
    }

    public static void removeStatusListener(StatusListener statusListener) {
        if (statusListener == null) {
            return;
        }
        if (statusListeners == null) {
            return;
        }
        statusListeners.remove(statusListener);
        if (statusListeners.size() <= 0) {
            statusListeners = null;
        }
    }

    public static void setOutputLevel(int n) {
        output_level = n;
    }

    public static void setOutputLevel(String string) {
        int n = Status.getLevelCount();
        for (int i = 0; i < n; ++i) {
            String string2 = Status.getLevelName(i);
            if (!string.equals(string2)) continue;
            Status.setOutputLevel(i);
            break;
        }
    }

    public static int getOutputLevel() {
        return output_level;
    }

    public static int getLevelCount() {
        return level_names.size();
    }

    public static String getLevelName(int n) {
        return (String)level_names.elementAt(n);
    }

    public static void output(int n, String string) {
        if (n <= output_level) {
            if (statusEvent == null || statusListeners == null) {
                if (n == 3) {
                    System.out.println("Status(" + n + "): " + string);
                } else {
                    System.err.println("Status(" + n + "): " + string);
                }
            } else {
                Status.statusEvent.type = 0;
                Status.statusEvent.level = n;
                Status.statusEvent.message = string + "\n";
                Status.statusEvent.percent = 1.0f;
                for (int i = 0; i < statusListeners.size(); ++i) {
                    StatusListener statusListener = (StatusListener)statusListeners.elementAt(i);
                    statusListener.processStatusEvent(statusEvent);
                }
            }
        }
    }

    public static void progress(float f, String string) {
        if (statusListeners == null) {
            return;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (string != null && statusEvent == null || statusListeners == null) {
            if (output_level == 3) {
                System.out.println("Progress(" + f + "): " + string);
            } else {
                System.err.println("Progress(" + f + "): " + string);
            }
        } else {
            Status.statusEvent.type = 1;
            Status.statusEvent.level = output_level;
            Status.statusEvent.message = string == null ? null : string + "\n";
            Status.statusEvent.percent = f;
            for (int i = 0; i < statusListeners.size(); ++i) {
                StatusListener statusListener = (StatusListener)statusListeners.elementAt(i);
                statusListener.processStatusEvent(statusEvent);
            }
        }
    }

    static {
        level_names = new Vector();
        level_names.add("Quiet");
        level_names.add("Error");
        level_names.add("Warning");
        level_names.add("Remark");
        level_names.add("Debug");
        level_names.add("Dump");
        output_level = 3;
        statusListeners = null;
        statusEvent = new StatusEvent();
    }
}

