/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.viewables.AtomColor;
import edu.sdsc.mbt.viewables.ColorMap;
import edu.sdsc.mbt.viewables.InterpolatedColorMap;

public class AtomColorByBFactor
implements AtomColor {
    public static final String NAME = "By B-Factor";
    private static AtomColorByBFactor singleton = null;
    private ColorMap colorMap = new InterpolatedColorMap(2);

    private AtomColorByBFactor() {
    }

    public static AtomColorByBFactor create() {
        if (singleton == null) {
            singleton = new AtomColorByBFactor();
        }
        return singleton;
    }

    public void getAtomColor(Atom atom, float[] fArray) {
        if (atom == null) {
            throw new NullPointerException("null atom");
        }
        if (fArray == null) {
            throw new NullPointerException("null color");
        }
        float f = atom.bfactor / 100.0f;
        this.colorMap.getColor(f, fArray);
    }
}

