/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.util.Element;
import edu.sdsc.mbt.util.PeriodicTable;
import edu.sdsc.mbt.viewables.AtomRadius;
import edu.sdsc.mbt.viewables.ElementStyles;

public class AtomRadiusByScaledCpk
implements AtomRadius {
    public static final String NAME = "By Scaled CPK (Ball-and-Stick)";
    private double scale = 0.2;
    private static AtomRadiusByScaledCpk singleton = null;

    private AtomRadiusByScaledCpk() {
    }

    public static AtomRadiusByScaledCpk create() {
        if (singleton == null) {
            singleton = new AtomRadiusByScaledCpk();
        }
        return singleton;
    }

    public double getAtomRadius(Atom atom) {
        Element element = PeriodicTable.getElement(atom.element);
        if (element == null) {
            return this.scale * 1.0;
        }
        return this.scale * ElementStyles.getElementRadius(element.atomic_number);
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }
}

