/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.viewables.AtomRadius;
import edu.sdsc.mbt.viewables.AtomRadiusByConstant;
import edu.sdsc.mbt.viewables.AtomRadiusByCpk;
import edu.sdsc.mbt.viewables.AtomRadiusByScaledCpk;
import java.util.Enumeration;
import java.util.Hashtable;

public class AtomRadiusRegistry {
    private static Hashtable atomRadiusObjects = new Hashtable();
    private static String defaultName = null;

    public static int count() {
        return atomRadiusObjects.size();
    }

    public static String getDefaultName() {
        return defaultName;
    }

    public static void add(String string, AtomRadius atomRadius) {
        atomRadiusObjects.put(string, atomRadius);
    }

    public static void remove(String string) {
        atomRadiusObjects.remove(string);
    }

    public static AtomRadius get(String string) {
        return (AtomRadius)atomRadiusObjects.get(string);
    }

    public static AtomRadius getDefault() {
        return (AtomRadius)atomRadiusObjects.get(defaultName);
    }

    public static Enumeration names() {
        return atomRadiusObjects.keys();
    }

    static {
        AtomRadiusRegistry.add("By CPK", AtomRadiusByCpk.create());
        AtomRadiusRegistry.add("By Scaled CPK (Ball-and-Stick)", AtomRadiusByScaledCpk.create());
        AtomRadiusRegistry.add("By Constant (Smooth Bonds)", AtomRadiusByConstant.create());
        defaultName = "By Scaled CPK (Ball-and-Stick)";
    }
}

