/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.util.Element;
import edu.sdsc.mbt.util.PeriodicTable;
import edu.sdsc.mbt.viewables.BondColor;
import edu.sdsc.mbt.viewables.ElementStyles;

public class BondColorByElement
implements BondColor {
    public static final String NAME = "By Atom Elements";
    private static BondColorByElement singleton = null;

    private BondColorByElement() {
    }

    public static BondColorByElement create() {
        if (singleton == null) {
            singleton = new BondColorByElement();
        }
        return singleton;
    }

    public void getBondColor(Bond bond, float[] fArray) {
        Atom atom = bond.getAtom(0);
        Element element = PeriodicTable.getElement(atom.element);
        if (element == null) {
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[0] = 0.0f;
            return;
        }
        float[] fArray2 = ElementStyles.getElementColor(element.atomic_number);
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
    }

    public void getSplitBondColor(Bond bond, float[] fArray) {
        Atom atom = bond.getAtom(1);
        Element element = PeriodicTable.getElement(atom.element);
        if (element == null) {
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[0] = 0.0f;
            return;
        }
        float[] fArray2 = ElementStyles.getElementColor(element.atomic_number);
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
    }
}

