/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.viewables.BondRadius;
import edu.sdsc.mbt.viewables.StructureStyles;

public class BondRadiusByAtomRadius
implements BondRadius {
    public static final String NAME = "By Atom Radius (Smooth Bonds)";
    private static BondRadiusByAtomRadius singleton = null;

    private BondRadiusByAtomRadius() {
    }

    public static BondRadiusByAtomRadius create() {
        if (singleton == null) {
            singleton = new BondRadiusByAtomRadius();
        }
        return singleton;
    }

    public double getBondRadius(Bond bond) {
        Atom atom = bond.getAtom(0);
        StructureMap structureMap = atom.structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        return structureStyles.getAtomRadius(atom);
    }

    public double getSplitBondRadius(Bond bond) {
        Atom atom = bond.getAtom(1);
        StructureMap structureMap = atom.structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        return structureStyles.getAtomRadius(atom);
    }
}

