/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.viewables.BondRadius;
import edu.sdsc.mbt.viewables.StructureStyles;

public class BondRadiusByScaledAtomRadius
implements BondRadius {
    public static final String NAME = "By Scaled Atom Radius (Ball-And-Stick)";
    private double scale = 0.3;
    private static BondRadiusByScaledAtomRadius singleton = null;

    private BondRadiusByScaledAtomRadius() {
    }

    public static BondRadiusByScaledAtomRadius create() {
        if (singleton == null) {
            singleton = new BondRadiusByScaledAtomRadius();
        }
        return singleton;
    }

    public double getBondRadius(Bond bond) {
        Atom atom = bond.getAtom(0);
        StructureMap structureMap = atom.structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        return this.scale * structureStyles.getAtomRadius(atom);
    }

    public double getSplitBondRadius(Bond bond) {
        Atom atom = bond.getAtom(1);
        StructureMap structureMap = atom.structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        return this.scale * structureStyles.getAtomRadius(atom);
    }
}

