/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.viewables.BondRadius;
import edu.sdsc.mbt.viewables.BondRadiusAsWire;
import edu.sdsc.mbt.viewables.BondRadiusByAtomRadius;
import edu.sdsc.mbt.viewables.BondRadiusByScaledAtomRadius;
import java.util.Enumeration;
import java.util.Hashtable;

public class BondRadiusRegistry {
    private static Hashtable bondRadiusObjects = new Hashtable();
    private static String defaultName = null;

    public static int count() {
        return bondRadiusObjects.size();
    }

    public static String getDefaultName() {
        return defaultName;
    }

    public static void add(String string, BondRadius bondRadius) {
        bondRadiusObjects.put(string, bondRadius);
    }

    public static void remove(String string) {
        bondRadiusObjects.remove(string);
    }

    public static BondRadius get(String string) {
        return (BondRadius)bondRadiusObjects.get(string);
    }

    public static BondRadius getDefault() {
        return (BondRadius)bondRadiusObjects.get(defaultName);
    }

    public static Enumeration names() {
        return bondRadiusObjects.keys();
    }

    static {
        BondRadiusRegistry.add("By Atom Radius (Smooth Bonds)", BondRadiusByAtomRadius.create());
        BondRadiusRegistry.add("By Scaled Atom Radius (Ball-And-Stick)", BondRadiusByScaledAtomRadius.create());
        BondRadiusRegistry.add("As Wireframe", BondRadiusAsWire.create());
        defaultName = "By Atom Radius (Smooth Bonds)";
    }
}

