/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.viewables.ColorMap;

public class InterpolatedColorMap
implements ColorMap {
    private float[][] knots = null;
    private static final float[][] blackToWhite = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f, 1.0f}};
    private static final float[][] rainbow = new float[][]{{0.0f, 1.0f, 0.0f, 0.0f}, {0.16f, 1.0f, 0.5f, 0.0f}, {0.33f, 1.0f, 1.0f, 0.0f}, {0.5f, 0.0f, 1.0f, 0.0f}, {0.66f, 0.0f, 0.0f, 1.0f}, {0.83f, 0.4f, 0.0f, 0.4f}, {1.0f, 0.93f, 0.51f, 0.93f}};
    private static final float[][] coldToHot = new float[][]{{0.0f, 0.0f, 0.0f, 1.0f}, {0.5f, 0.75f, 0.0f, 0.75f}, {1.0f, 1.0f, 0.0f, 0.0f}};
    private static final float[][] coolToWarm = new float[][]{{0.0f, 0.5f, 0.5f, 1.0f}, {0.5f, 0.75f, 0.5f, 0.75f}, {1.0f, 1.0f, 0.5f, 0.5f}};
    private static final float[][] hsbHues = new float[][]{{0.0f, 1.0f, 0.0f, 0.0f}, {0.16f, 1.0f, 1.0f, 0.0f}, {0.33f, 0.0f, 1.0f, 0.0f}, {0.5f, 0.0f, 1.0f, 1.0f}, {0.66f, 0.0f, 0.0f, 1.0f}, {0.83f, 1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 0.0f, 0.0f}};
    private static final float[][] molscriptRamp = new float[][]{{0.0f, 0.5f, 0.5f, 1.0f}, {0.25f, 0.5f, 1.0f, 1.0f}, {0.5f, 0.5f, 1.0f, 0.5f}, {0.75f, 1.0f, 1.0f, 0.5f}, {1.0f, 1.0f, 0.5f, 0.5f}};
    public static final int BLACK_TO_WHITE = 0;
    public static final int RAINBOW = 1;
    public static final int COLD_TO_HOT = 2;
    public static final int COOL_TO_WARM = 3;
    public static final int HSB_HUES = 4;
    public static final int MOLSCRIPT_RAMP = 5;
    private static final float[][][] predefinedKnots = new float[][][]{blackToWhite, rainbow, coldToHot, coolToWarm, hsbHues, molscriptRamp};

    private InterpolatedColorMap() {
    }

    public InterpolatedColorMap(int n) {
        this.setKnots(n);
    }

    public static void getNiceColor(int n, float[] fArray) throws IllegalArgumentException {
        throw new IllegalArgumentException("not implemented");
    }

    public InterpolatedColorMap(float[][] fArray) {
        this.setKnots(fArray);
    }

    public void setKnots(int n) throws IllegalArgumentException {
        try {
            this.setKnots(predefinedKnots[n]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Unknown predefined knots");
        }
    }

    public void setKnots(float[][] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null knots");
        }
        if (fArray[0].length != 4) {
            throw new IllegalArgumentException("knot element length != 4");
        }
        float[][] fArray2 = new float[fArray.length][4];
        float f = -1.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i][0] < 0.0f) {
                throw new IllegalArgumentException("knot < 0.0");
            }
            if (fArray[i][0] > 1.0f) {
                throw new IllegalArgumentException("knot > 1.0");
            }
            if (f > fArray[i][0]) {
                throw new IllegalArgumentException("unordered weights");
            }
            f = fArray[i][0];
            if (fArray[i][1] < 0.0f) {
                throw new IllegalArgumentException("non-normalized color");
            }
            if (fArray[i][1] > 1.0f) {
                throw new IllegalArgumentException("non-normalized color");
            }
            if (fArray[i][2] < 0.0f) {
                throw new IllegalArgumentException("non-normalized color");
            }
            if (fArray[i][2] > 1.0f) {
                throw new IllegalArgumentException("non-normalized color");
            }
            if (fArray[i][3] < 0.0f) {
                throw new IllegalArgumentException("non-normalized color");
            }
            if (fArray[i][3] > 1.0f) {
                throw new IllegalArgumentException("non-normalized color");
            }
            fArray2[i][0] = fArray[i][0];
            fArray2[i][1] = fArray[i][1];
            fArray2[i][2] = fArray[i][2];
            fArray2[i][3] = fArray[i][3];
        }
        this.knots = fArray2;
    }

    public void getKnots(float[][] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null knots");
        }
        if (fArray[0].length != 4) {
            throw new IllegalArgumentException("knot element length != 4");
        }
        for (int i = 0; i < this.knots.length; ++i) {
            for (int j = 0; j < this.knots[0].length; ++j) {
                fArray[i][j] = this.knots[i][j];
            }
        }
    }

    public int getKnotCount() {
        if (this.knots == null) {
            return 0;
        }
        return this.knots.length;
    }

    public void setKnotColor(int n, float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null color array");
        }
        if (this.knots == null) {
            throw new IllegalArgumentException("null knot list");
        }
        this.knots[n][1] = fArray[0];
        this.knots[n][2] = fArray[1];
        this.knots[n][3] = fArray[2];
    }

    public void getKnotColor(int n, float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null color array");
        }
        if (this.knots == null) {
            throw new IllegalArgumentException("null knot list");
        }
        fArray[0] = this.knots[n][1];
        fArray[1] = this.knots[n][2];
        fArray[2] = this.knots[n][3];
    }

    public float getKnotLocation(int n) throws IllegalArgumentException {
        if (this.knots == null) {
            throw new IllegalArgumentException("null knot list");
        }
        return this.knots[n][0];
    }

    public void setKnotLocation(int n, float f) throws IllegalArgumentException {
        if (this.knots == null) {
            throw new IllegalArgumentException("null knot list");
        }
        if (n == 0) {
            return;
        }
        if (n == this.knots.length - 1) {
            return;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f <= this.knots[n - 1][0]) {
            return;
        }
        if (f >= this.knots[n + 1][0]) {
            return;
        }
        this.knots[n][0] = f;
    }

    public void getColor(float f, float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null color array");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("value < 0.0");
        }
        if (f > 1.0f) {
            throw new IllegalArgumentException("value > 1.0");
        }
        if (this.knots == null || this.knots.length <= 0) {
            fArray[0] = f;
            fArray[1] = f;
            fArray[2] = f;
            return;
        }
        if (this.knots.length == 1) {
            float[] fArray2 = this.knots[0];
            fArray[0] = fArray2[1];
            fArray[1] = fArray2[2];
            fArray[2] = fArray2[3];
            return;
        }
        int n = this.knots.length;
        float[] fArray3 = this.knots[0];
        float[] fArray4 = this.knots[0];
        for (int i = 0; i < n; ++i) {
            float[] fArray5 = this.knots[i];
            if (fArray5[0] == f) {
                fArray[0] = fArray5[1];
                fArray[1] = fArray5[2];
                fArray[2] = fArray5[3];
                return;
            }
            if (fArray5[0] < f) {
                fArray3 = fArray5;
                fArray4 = fArray5;
                continue;
            }
            if (!(fArray5[0] > f)) continue;
            fArray4 = fArray5;
            break;
        }
        float f2 = (f - fArray3[0]) / (fArray4[0] - fArray3[0]);
        float f3 = 1.0f - f2;
        fArray[0] = fArray3[1] * f3 + fArray4[1] * f2;
        fArray[1] = fArray3[2] * f3 + fArray4[2] * f2;
        fArray[2] = fArray3[3] * f3 + fArray4[3] * f2;
    }
}

