/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.viewables.ResidueColor;
import java.util.Hashtable;

public class ResidueColorByFragmentType
implements ResidueColor {
    public static final String NAME = "By Fragment Type";
    private static ResidueColorByFragmentType singleton = null;
    private Hashtable fragmentHash = new Hashtable();

    private ResidueColorByFragmentType() {
        this.fragmentHash.put(StructureComponentRegistry.TYPE_COIL, new float[]{1.0f, 0.5f, 0.5f});
        this.fragmentHash.put(StructureComponentRegistry.TYPE_HELIX, new float[]{0.5f, 1.0f, 0.5f});
        this.fragmentHash.put(StructureComponentRegistry.TYPE_STRAND, new float[]{0.5f, 0.5f, 1.0f});
        this.fragmentHash.put(StructureComponentRegistry.TYPE_TURN, new float[]{0.5f, 1.0f, 1.0f});
        this.fragmentHash.put("UNDEFINED_CONFORMATION", new float[]{0.66f, 0.66f, 0.66f});
    }

    public static ResidueColorByFragmentType create() {
        if (singleton == null) {
            singleton = new ResidueColorByFragmentType();
        }
        return singleton;
    }

    public void getResidueColor(Residue residue, float[] fArray) {
        float[] fArray2 = (float[])this.fragmentHash.get(residue.getConformationType());
        if (fArray2 != null) {
            fArray[0] = fArray2[0];
            fArray[1] = fArray2[1];
            fArray[2] = fArray2[2];
        } else {
            fArray[2] = 0.5f;
            fArray[1] = 0.5f;
            fArray[0] = 0.5f;
        }
    }

    public void setFragmentTypeColor(String string, float[] fArray) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null type");
        }
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        if (fArray.length != 3) {
            throw new IllegalArgumentException("color.length != 3");
        }
        if ((double)fArray[0] < 0.0) {
            throw new IllegalArgumentException("color[0] < 0.0");
        }
        if ((double)fArray[0] > 1.0) {
            throw new IllegalArgumentException("color[0] > 1.0");
        }
        if ((double)fArray[1] < 0.0) {
            throw new IllegalArgumentException("color[1] < 0.0");
        }
        if ((double)fArray[1] > 1.0) {
            throw new IllegalArgumentException("color[1] > 1.0");
        }
        if ((double)fArray[2] < 0.0) {
            throw new IllegalArgumentException("color[2] < 0.0");
        }
        if ((double)fArray[2] > 1.0) {
            throw new IllegalArgumentException("color[2] > 1.0");
        }
        this.fragmentHash.put(string, fArray);
    }

    public float[] getFragmentTypeColor(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null type");
        }
        return (float[])this.fragmentHash.get(string);
    }
}

