/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.viewables.ColorMap;
import edu.sdsc.mbt.viewables.InterpolatedColorMap;
import edu.sdsc.mbt.viewables.ResidueColor;

public class ResidueColorByHydrophobicity
implements ResidueColor {
    public static final String NAME = "By Hydrophobicity";
    private static ResidueColorByHydrophobicity singleton = null;
    private ColorMap colorMap = new InterpolatedColorMap(2);

    private ResidueColorByHydrophobicity() {
    }

    public static ResidueColorByHydrophobicity create() {
        if (singleton == null) {
            singleton = new ResidueColorByHydrophobicity();
        }
        return singleton;
    }

    public void getResidueColor(Residue residue, float[] fArray) {
        float f = residue.getHydrophobicity();
        this.colorMap.getColor(f, fArray);
    }

    public void setColorMap(ColorMap colorMap) throws IllegalArgumentException {
        if (colorMap == null) {
            throw new IllegalArgumentException("null colorMap");
        }
        this.colorMap = colorMap;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }
}

