/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.viewables.ColorMap;
import edu.sdsc.mbt.viewables.InterpolatedColorMap;
import edu.sdsc.mbt.viewables.ResidueColor;

public class ResidueColorByResidueIndex
implements ResidueColor {
    public static final String NAME = "By Index";
    private static ResidueColorByResidueIndex singleton = null;
    private ColorMap colorMap = new InterpolatedColorMap(5);

    private ResidueColorByResidueIndex() {
    }

    public static ResidueColorByResidueIndex create() {
        if (singleton == null) {
            singleton = new ResidueColorByResidueIndex();
        }
        return singleton;
    }

    public void getResidueColor(Residue residue, float[] fArray) {
        StructureMap structureMap = residue.structure.getStructureMap();
        Chain chain = structureMap.getChain(residue.getChainId());
        int n = chain.getResidueCount();
        int n2 = chain.getResidueIndex(residue);
        float f = (float)n2 / (float)n;
        this.colorMap.getColor(f, fArray);
    }

    public void setColorMap(ColorMap colorMap) throws IllegalArgumentException {
        if (colorMap == null) {
            throw new IllegalArgumentException("null colorMap");
        }
        this.colorMap = colorMap;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }
}

