/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.viewables.ResidueColor;
import edu.sdsc.mbt.viewables.ResidueColorByFragmentType;
import edu.sdsc.mbt.viewables.ResidueColorByHydrophobicity;
import edu.sdsc.mbt.viewables.ResidueColorByResidueIndex;
import edu.sdsc.mbt.viewables.ResidueColorByRgb;
import java.util.Enumeration;
import java.util.Hashtable;

public class ResidueColorRegistry {
    private static Hashtable residueColorObjects = new Hashtable();
    private static String defaultName = null;

    public static int count() {
        return residueColorObjects.size();
    }

    public static String getDefaultName() {
        return defaultName;
    }

    public static void add(String string, ResidueColor residueColor) {
        residueColorObjects.put(string, residueColor);
    }

    public static void remove(String string) {
        residueColorObjects.remove(string);
    }

    public static ResidueColor get(String string) {
        return (ResidueColor)residueColorObjects.get(string);
    }

    public static ResidueColor getDefault() {
        return (ResidueColor)residueColorObjects.get(defaultName);
    }

    public static Enumeration names() {
        return residueColorObjects.keys();
    }

    static {
        ResidueColorRegistry.add("By Hydrophobicity", ResidueColorByHydrophobicity.create());
        ResidueColorRegistry.add("By Index", ResidueColorByResidueIndex.create());
        ResidueColorRegistry.add("By Fragment Type", ResidueColorByFragmentType.create());
        ResidueColorRegistry.add("Red", new ResidueColorByRgb(1.0f, 0.0f, 0.0f));
        ResidueColorRegistry.add("Green", new ResidueColorByRgb(0.0f, 1.0f, 0.0f));
        ResidueColorRegistry.add("Blue", new ResidueColorByRgb(0.0f, 0.0f, 1.0f));
        ResidueColorRegistry.add("Cyan", new ResidueColorByRgb(0.0f, 1.0f, 1.0f));
        ResidueColorRegistry.add("Magenta", new ResidueColorByRgb(1.0f, 0.0f, 1.0f));
        ResidueColorRegistry.add("Yellow", new ResidueColorByRgb(1.0f, 1.0f, 0.0f));
        ResidueColorRegistry.add("Gray", new ResidueColorByRgb(0.5f, 0.5f, 0.5f));
        ResidueColorRegistry.add("White", new ResidueColorByRgb(1.0f, 1.0f, 1.0f));
        ResidueColorRegistry.add("Black", new ResidueColorByRgb(0.0f, 0.0f, 0.0f));
        defaultName = "By Index";
    }
}

