/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.viewables.StructureDocumentEvent;
import edu.sdsc.mbt.viewers.Viewer;
import java.util.Vector;

public class StructureDocument {
    private Vector structures = new Vector();
    private Vector viewers = new Vector();

    public void addStructure(Structure structure) throws IllegalArgumentException {
        if (structure == null) {
            throw new IllegalArgumentException("null structure");
        }
        if (this.structures.contains(structure)) {
            throw new IllegalArgumentException("structure already added");
        }
        this.structures.add(structure);
        StructureDocumentEvent structureDocumentEvent = new StructureDocumentEvent();
        structureDocumentEvent.structureDocument = this;
        structureDocumentEvent.structure = structure;
        structureDocumentEvent.viewer = null;
        structureDocumentEvent.type = 1;
        structureDocumentEvent.change = 0;
        this.fireStructureDocumentEvent(structureDocumentEvent);
        structureDocumentEvent.structure = null;
    }

    public void removeStructure(Structure structure) throws IllegalArgumentException {
        if (structure == null) {
            throw new IllegalArgumentException("null structure");
        }
        if (!this.structures.contains(structure)) {
            throw new IllegalArgumentException("structure not found");
        }
        this.structures.remove(structure);
        StructureDocumentEvent structureDocumentEvent = new StructureDocumentEvent();
        structureDocumentEvent.structureDocument = this;
        structureDocumentEvent.structure = structure;
        structureDocumentEvent.viewer = null;
        structureDocumentEvent.type = 1;
        structureDocumentEvent.change = 1;
        this.fireStructureDocumentEvent(structureDocumentEvent);
        structureDocumentEvent.structure = null;
    }

    public void removeAllStructures() {
        int n = this.getStructureCount();
        for (int i = n - 1; i >= 0; --i) {
            this.removeStructure(this.getStructure(i));
        }
    }

    public int getStructureCount() {
        return this.structures.size();
    }

    public Structure getStructure(int n) {
        return (Structure)this.structures.elementAt(n);
    }

    public void addViewer(Viewer viewer) throws IllegalArgumentException {
        if (viewer == null) {
            throw new IllegalArgumentException("null viewer");
        }
        if (this.viewers.contains(viewer)) {
            throw new IllegalArgumentException("viewer already added");
        }
        this.viewers.add(viewer);
        StructureDocumentEvent structureDocumentEvent = new StructureDocumentEvent();
        structureDocumentEvent.structureDocument = this;
        structureDocumentEvent.structure = null;
        structureDocumentEvent.viewer = viewer;
        structureDocumentEvent.type = 0;
        structureDocumentEvent.change = 0;
        viewer.processStructureDocumentEvent(structureDocumentEvent);
        structureDocumentEvent.viewer = null;
    }

    public void removeViewer(Viewer viewer) throws IllegalArgumentException {
        if (viewer == null) {
            throw new IllegalArgumentException("null viewer");
        }
        if (!this.viewers.contains(viewer)) {
            throw new IllegalArgumentException("viewer not found");
        }
        this.viewers.remove(viewer);
        StructureDocumentEvent structureDocumentEvent = new StructureDocumentEvent();
        structureDocumentEvent.structureDocument = this;
        structureDocumentEvent.structure = null;
        structureDocumentEvent.viewer = viewer;
        structureDocumentEvent.type = 0;
        structureDocumentEvent.change = 1;
        viewer.processStructureDocumentEvent(structureDocumentEvent);
        structureDocumentEvent.viewer = null;
    }

    private void fireStructureDocumentEvent(StructureDocumentEvent structureDocumentEvent) {
        for (int i = 0; i < this.viewers.size(); ++i) {
            Viewer viewer = (Viewer)this.viewers.elementAt(i);
            viewer.processStructureDocumentEvent(structureDocumentEvent);
        }
    }
}

