/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewables;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.util.RangeMap;
import edu.sdsc.mbt.viewables.AtomColor;
import edu.sdsc.mbt.viewables.AtomColorRegistry;
import edu.sdsc.mbt.viewables.AtomLabel;
import edu.sdsc.mbt.viewables.AtomLabelRegistry;
import edu.sdsc.mbt.viewables.AtomRadius;
import edu.sdsc.mbt.viewables.AtomRadiusRegistry;
import edu.sdsc.mbt.viewables.BondColor;
import edu.sdsc.mbt.viewables.BondColorRegistry;
import edu.sdsc.mbt.viewables.BondForm;
import edu.sdsc.mbt.viewables.BondFormRegistry;
import edu.sdsc.mbt.viewables.ChainColorRegistry;
import edu.sdsc.mbt.viewables.ResidueColor;
import edu.sdsc.mbt.viewables.ResidueColorRegistry;
import edu.sdsc.mbt.viewables.StructureStylesEvent;
import edu.sdsc.mbt.viewables.StructureStylesEventListener;
import java.util.Vector;

public class StructureStyles {
    private StructureMap structureMap = null;
    private StructureStylesEvent structureStylesEvent = new StructureStylesEvent();
    private float renderingQuality = 0.4f;
    private boolean skipWater = true;
    private RangeMap selection = null;
    private RangeMap bondSelection = null;
    private static final Boolean SELECTED = Boolean.TRUE;
    private static final Boolean UNSELECTED = Boolean.FALSE;
    private static float[] selectionColor = new float[]{1.0f, 1.0f, 0.0f};
    private boolean showAltAtomLocations = false;
    public static final Boolean VISIBLE = Boolean.TRUE;
    public static final Boolean INVISIBLE = Boolean.FALSE;
    private RangeMap atomVisibility = null;
    private RangeMap atomColors = null;
    private RangeMap atomRadii = null;
    private RangeMap atomLabels = null;
    private RangeMap bondVisibility = null;
    private RangeMap bondColors = null;
    private RangeMap bondForms = null;
    private RangeMap residueColors = null;
    private RangeMap fragmentVisibility = null;
    private RangeMap chainVisibility = null;
    private RangeMap chainColors = null;
    public static final int PROPERTY_BULK = -1;
    public static final int PROPERTY_VISIBILITY = 1;
    public static final int PROPERTY_SELECTION = 2;
    public static final int PROPERTY_COLOR = 4;
    public static final int PROPERTY_SIZE = 8;
    public static final int PROPERTY_FORM = 16;
    public static final int PROPERTY_LABEL = 32;
    private Vector sseListeners = new Vector();

    public StructureStyles(StructureMap structureMap) {
        int n;
        int n2;
        int n3;
        int n4;
        if (structureMap == null) {
            throw new IllegalArgumentException("null StructureMap");
        }
        this.structureMap = structureMap;
        int n5 = structureMap.getAtomCount();
        if (n5 > 0) {
            this.atomVisibility = new RangeMap(0, n5 - 1, INVISIBLE);
            this.atomColors = new RangeMap(0, n5 - 1, AtomColorRegistry.getDefault());
            this.atomRadii = new RangeMap(0, n5 - 1, AtomRadiusRegistry.getDefault());
            this.atomLabels = new RangeMap(0, n5 - 1, AtomLabelRegistry.getDefault());
        }
        if (n5 > 0) {
            this.selection = new RangeMap(0, n5 - 1, UNSELECTED);
        }
        if ((n4 = structureMap.getBondCount()) > 0) {
            this.bondVisibility = new RangeMap(0, n4 - 1, INVISIBLE);
            this.bondColors = new RangeMap(0, n4 - 1, BondColorRegistry.getDefault());
            this.bondForms = new RangeMap(0, n4 - 1, BondFormRegistry.getDefault());
            this.bondSelection = new RangeMap(0, n4 - 1, UNSELECTED);
        }
        if ((n3 = structureMap.getResidueCount()) > 0) {
            this.residueColors = new RangeMap(0, n3 - 1, ResidueColorRegistry.getDefault());
        }
        if ((n2 = structureMap.getFragmentCount()) > 0) {
            this.fragmentVisibility = new RangeMap(0, n2 - 1, VISIBLE);
        }
        if ((n = structureMap.getChainCount()) > 0) {
            this.chainVisibility = new RangeMap(0, n - 1, INVISIBLE);
            this.chainColors = new RangeMap(0, n - 1, ChainColorRegistry.getDefault());
        }
        this.showChains(true);
        this.showFragments(true);
        this.showLigandAtoms(true);
        this.showNucleicAcidAtoms(true);
        if (n5 > 0 && n5 < 20) {
            this.setAtomVisibility(0, n5 - 1, true);
        }
        this.showVisibleAtomBonds();
    }

    public StructureMap getStructureMap() {
        return this.structureMap;
    }

    public void setRenderingQuality(float f) {
        this.renderingQuality = (double)f <= 0.0 ? 0.0f : ((double)f >= 1.0 ? 1.0f : f);
    }

    public float getRenderingQuality() {
        return this.renderingQuality;
    }

    public static void setSelectionColor(float[] fArray) {
        if (fArray == null) {
            return;
        }
        if (fArray.length != 3) {
            return;
        }
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f = fArray[i];
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            StructureStyles.selectionColor[i] = f;
        }
    }

    public static void getSelectionColor(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("null color argument");
        }
        if (fArray.length < selectionColor.length) {
            throw new NullPointerException("color length < 3");
        }
        for (int i = 0; i < selectionColor.length; ++i) {
            fArray[i] = selectionColor[i];
        }
    }

    public void selectAll() {
        this.selection.clearAll();
        this.setAtomSelection(this.selection.getMin(), this.selection.getMax(), true);
        this.bondSelection.clearAll();
        this.setBondSelection(this.bondSelection.getMin(), this.bondSelection.getMax(), true);
    }

    public void unselectAll() {
        this.selection.clearAll();
        this.setAtomSelection(this.selection.getMin(), this.selection.getMax(), false);
        this.bondSelection.clearAll();
        this.setBondSelection(this.bondSelection.getMin(), this.bondSelection.getMax(), false);
    }

    public boolean atomsAreSelected() {
        int n = this.structureMap.getAtomCount();
        Object object = this.selection.getContiguousValue(0, n - 1);
        if (object == null) {
            return true;
        }
        return object == SELECTED;
    }

    public boolean bondsAreSelected() {
        int n = this.structureMap.getBondCount();
        Object object = this.bondSelection.getContiguousValue(0, n - 1);
        if (object == null) {
            return true;
        }
        return object == SELECTED;
    }

    public boolean residuesAreSelected() {
        int n = this.structureMap.getResidueCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getResidueSelection(i)) continue;
            return true;
        }
        return false;
    }

    public boolean fragmentsAreSelected() {
        int n = this.structureMap.getFragmentCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getFragmentSelection(i)) continue;
            return true;
        }
        return false;
    }

    public void setAtomSelection(int n, int n2, boolean bl) {
        if (bl) {
            this.selection.setRange(n, n2, SELECTED);
        } else {
            this.selection.setRange(n, n2, UNSELECTED);
        }
        for (int i = n; i <= n2; ++i) {
            Atom atom = this.structureMap.getAtom(i);
            this.structureStylesEvent.structureComponent = this.structureMap.getChain(atom);
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
            this.structureStylesEvent.structureComponent = this.structureMap.getResidue(atom);
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
            this.structureStylesEvent.structureComponent = atom;
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setAtomSelection(int n, boolean bl) {
        this.setAtomSelection(n, n, bl);
    }

    public void setAtomSelection(Atom atom, boolean bl) {
        int n = this.structureMap.getAtomIndex(atom);
        this.setAtomSelection(n, n, bl);
    }

    public boolean getAtomSelection(int n) {
        Boolean bl = (Boolean)this.selection.getValue(n);
        return bl == SELECTED;
    }

    public boolean getAtomSelection(Atom atom) {
        int n = this.structureMap.getAtomIndex(atom);
        Boolean bl = (Boolean)this.selection.getValue(n);
        return bl == SELECTED;
    }

    public void setBondSelection(int n, int n2, boolean bl) {
        if (bl) {
            this.bondSelection.setRange(n, n2, SELECTED);
        } else {
            this.bondSelection.setRange(n, n2, UNSELECTED);
        }
        for (int i = n; i <= n2; ++i) {
            Bond bond = this.structureMap.getBond(i);
            this.structureStylesEvent.structureComponent = bond;
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setBondSelection(int n, boolean bl) {
        this.setBondSelection(n, n, bl);
    }

    public void setBondSelection(Bond bond, boolean bl) {
        int n = this.structureMap.getBondIndex(bond);
        this.setBondSelection(n, n, bl);
    }

    public boolean getBondSelection(int n) {
        Boolean bl = (Boolean)this.bondSelection.getValue(n);
        return bl == SELECTED;
    }

    public boolean getBondSelection(Bond bond) {
        int n = this.structureMap.getBondIndex(bond);
        Boolean bl = (Boolean)this.bondSelection.getValue(n);
        return bl == SELECTED;
    }

    public void setFragmentSelection(int n, int n2, boolean bl) {
        for (int i = n; i <= n2; ++i) {
            Fragment fragment = this.structureMap.getFragment(i);
            Chain chain = fragment.getChain();
            int n3 = fragment.getResidueCount();
            Residue residue = fragment.getResidue(0);
            int n4 = this.structureMap.getResidueIndex(residue);
            int n5 = n4 + n3 - 1;
            this.setResidueSelection(n4, n5, bl);
            this.structureStylesEvent.structureComponent = chain;
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
            this.structureStylesEvent.structureComponent = fragment;
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setFragmentSelection(int n, boolean bl) {
        this.setFragmentSelection(n, n, bl);
    }

    public void setFragmentSelection(Fragment fragment, boolean bl) {
        int n = this.structureMap.getFragmentIndex(fragment);
        this.setFragmentSelection(n, n, bl);
    }

    public boolean getFragmentSelection(int n) {
        Atom atom;
        int n2;
        Fragment fragment = this.structureMap.getFragment(n);
        Chain chain = fragment.getChain();
        int n3 = fragment.getResidueCount();
        Residue residue = fragment.getResidue(0);
        int n4 = this.structureMap.getResidueIndex(residue);
        int n5 = n4 + n3 - 1;
        Residue residue2 = fragment.getResidue(n3 - 1);
        int n6 = residue2.getAtomCount();
        Atom atom2 = residue.getAtom(0);
        int n7 = this.structureMap.getAtomIndex(atom2);
        Boolean bl = (Boolean)this.selection.getContiguousValue(n7, n2 = this.structureMap.getAtomIndex(atom = residue2.getAtom(n6 - 1)));
        if (bl == null) {
            return false;
        }
        return bl == SELECTED;
    }

    public boolean getFragmentSelection(Fragment fragment) {
        int n = this.structureMap.getFragmentIndex(fragment);
        return this.getFragmentSelection(n);
    }

    public void getBondColor(int n, float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        Bond bond = this.structureMap.getBond(n);
        BondColor bondColor = (BondColor)this.bondColors.getValue(n);
        bondColor.getBondColor(bond, fArray);
    }

    public BondColor getBondColorObject(int n) {
        return (BondColor)this.bondColors.getValue(n);
    }

    public void getBondColor(Bond bond, float[] fArray) throws IllegalArgumentException {
        if (bond == null) {
            throw new IllegalArgumentException("null bond");
        }
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        int n = this.structureMap.getBondIndex(bond);
        BondColor bondColor = (BondColor)this.bondColors.getValue(n);
        bondColor.getBondColor(bond, fArray);
    }

    public void getSplitBondColor(int n, float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        Bond bond = this.structureMap.getBond(n);
        BondColor bondColor = (BondColor)this.bondColors.getValue(n);
        bondColor.getSplitBondColor(bond, fArray);
    }

    public void getSplitBondColor(Bond bond, float[] fArray) throws IllegalArgumentException {
        if (bond == null) {
            throw new IllegalArgumentException("null bond");
        }
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        int n = this.structureMap.getBondIndex(bond);
        BondColor bondColor = (BondColor)this.bondColors.getValue(n);
        bondColor.getSplitBondColor(bond, fArray);
    }

    public void setBondColor(Bond bond, BondColor bondColor) throws IllegalArgumentException {
        if (bond == null) {
            throw new IllegalArgumentException("null bond");
        }
        if (bondColor == null) {
            throw new IllegalArgumentException("null bondColor");
        }
        int n = this.structureMap.getBondIndex(bond);
        this.setBondColor(n, n, bondColor);
    }

    public void setBondColor(int n, int n2, BondColor bondColor) {
        this.bondColors.setRange(n, n2, bondColor);
        for (int i = n; i <= n2; ++i) {
            Bond bond = this.structureMap.getBond(i);
            this.structureStylesEvent.structureComponent = bond;
            this.structureStylesEvent.property = 4;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setBondColor(BondColor bondColor) {
        if (this.bondsAreSelected()) {
            int n = this.bondSelection.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.bondSelection.getRangeValue(i);
                if (object != SELECTED) continue;
                int[] nArray = this.bondSelection.getRange(i);
                this.setBondColor(nArray[0], nArray[1], bondColor);
            }
        } else {
            int n = this.bondVisibility.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.bondVisibility.getRangeValue(i);
                if (object != VISIBLE) continue;
                int[] nArray = this.bondVisibility.getRange(i);
                this.setBondColor(nArray[0], nArray[1], bondColor);
            }
        }
    }

    public void updateBondColor(int n) {
        Bond bond = this.structureMap.getBond(n);
        this.structureStylesEvent.structureComponent = bond;
        this.structureStylesEvent.property = 4;
        this.fireStructureStylesEvent(this.structureStylesEvent);
    }

    public int getBondForm(int n) {
        Bond bond = this.structureMap.getBond(n);
        BondForm bondForm = (BondForm)this.bondForms.getValue(n);
        return bondForm.getBondForm(bond);
    }

    public int getBondForm(Bond bond) throws IllegalArgumentException {
        if (bond == null) {
            throw new IllegalArgumentException("null bond");
        }
        int n = this.structureMap.getBondIndex(bond);
        BondForm bondForm = (BondForm)this.bondForms.getValue(n);
        return bondForm.getBondForm(bond);
    }

    public void setBondForm(Bond bond, BondForm bondForm) throws IllegalArgumentException {
        if (bond == null) {
            throw new IllegalArgumentException("null bond");
        }
        if (bondForm == null) {
            throw new IllegalArgumentException("null bondForm");
        }
        int n = this.structureMap.getBondIndex(bond);
        this.setBondForm(n, n, bondForm);
    }

    public void setBondForm(int n, int n2, BondForm bondForm) {
        this.bondForms.setRange(n, n2, bondForm);
        for (int i = n; i <= n2; ++i) {
            Bond bond = this.structureMap.getBond(i);
            this.structureStylesEvent.structureComponent = bond;
            this.structureStylesEvent.property = 16;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setResidueSelection(Residue residue, boolean bl) {
        int n = this.structureMap.getResidueIndex(residue);
        this.setResidueSelection(n, n, bl);
    }

    public void setResidueSelection(int n, boolean bl) {
        this.setResidueSelection(n, n, bl);
    }

    public void setResidueSelection(int n, int n2, boolean bl) {
        for (int i = n; i <= n2; ++i) {
            Residue residue = this.structureMap.getResidue(i);
            int n3 = residue.getAtomCount();
            if (n3 <= 0) {
                return;
            }
            Atom atom = residue.getAtom(0);
            int n4 = this.structureMap.getAtomIndex(atom);
            int n5 = n4 + n3 - 1;
            this.setAtomSelection(n4, n5, bl);
            this.structureStylesEvent.structureComponent = this.structureMap.getChain(atom);
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
            Vector vector = residue.getAtoms();
            Vector vector2 = this.structureMap.getBonds(vector);
            if (vector2 != null) {
                int n6 = vector2.size();
                for (int j = 0; j < n6; ++j) {
                    Bond bond = (Bond)vector2.elementAt(j);
                    this.setBondSelection(bond, bl);
                    this.structureStylesEvent.structureComponent = bond;
                    this.structureStylesEvent.property = 2;
                    this.fireStructureStylesEvent(this.structureStylesEvent);
                }
            }
            this.structureStylesEvent.structureComponent = residue;
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public boolean getResidueSelection(int n) {
        int n2;
        Residue residue = this.structureMap.getResidue(n);
        int n3 = residue.getAtomCount();
        if (n3 <= 0) {
            return false;
        }
        Atom atom = residue.getAtom(0);
        int n4 = this.structureMap.getAtomIndex(atom);
        Boolean bl = (Boolean)this.selection.getContiguousValue(n4, n2 = n4 + n3 - 1);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public boolean getResidueSelection(Residue residue) {
        int n = this.structureMap.getResidueIndex(residue);
        return this.getResidueSelection(n);
    }

    public void setChainSelection(Chain chain, boolean bl) {
        this.setChainSelection(this.structureMap.getChainIndex(chain), bl);
    }

    public void setChainSelection(int n, boolean bl) {
        this.setChainSelection(n, n, bl);
    }

    public void setChainSelection(int n, int n2, boolean bl) {
        for (int i = n; i <= n2; ++i) {
            Chain chain = this.structureMap.getChain(i);
            Residue residue = chain.getResidue(0);
            int n3 = this.structureMap.getResidueIndex(residue);
            int n4 = n3 + chain.getResidueCount() - 1;
            this.setResidueSelection(n3, n4, bl);
            this.structureStylesEvent.structureComponent = chain;
            this.structureStylesEvent.property = 2;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public boolean getChainSelection(Chain chain) {
        return this.getChainSelection(this.structureMap.getChainIndex(chain));
    }

    public boolean getChainSelection(int n) {
        boolean bl;
        Chain chain = this.structureMap.getChain(n);
        Residue residue = chain.getResidue(0);
        Atom atom = residue.getAtom(0);
        int n2 = this.structureMap.getAtomIndex(atom);
        int n3 = n2 + chain.getAtomCount() - 1;
        Boolean bl2 = (Boolean)this.selection.getValue(n2);
        boolean bl3 = bl = this.selection.getContiguousValue(n2, n3) != null;
        return bl2 == SELECTED && bl;
    }

    public boolean getStructureSelection() {
        int n = this.structureMap.getAtomCount();
        Object object = this.selection.getContiguousValue(0, n - 1);
        return object == SELECTED;
    }

    public void showChains(boolean bl) {
        int n = this.structureMap.getChainCount();
        if (n <= 0) {
            return;
        }
        if (bl) {
            this.chainVisibility.setRange(0, n - 1, VISIBLE);
        } else {
            this.chainVisibility.setRange(0, n - 1, INVISIBLE);
        }
        for (int i = 0; i < n; ++i) {
            Chain chain = this.structureMap.getChain(i);
            this.structureStylesEvent.structureComponent = chain;
            this.structureStylesEvent.property = 1;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void showFragments(boolean bl) {
        int n = this.structureMap.getFragmentCount();
        if (n <= 0) {
            return;
        }
        if (bl) {
            this.fragmentVisibility.setRange(0, n - 1, VISIBLE);
        } else {
            this.fragmentVisibility.setRange(0, n - 1, INVISIBLE);
        }
        for (int i = 0; i < n; ++i) {
            Fragment fragment = this.structureMap.getFragment(i);
            this.structureStylesEvent.structureComponent = fragment;
            this.structureStylesEvent.property = 1;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setShowAltAtoms(boolean bl) {
        this.showAltAtomLocations = bl;
    }

    public boolean getShowAltAtoms() {
        return this.showAltAtomLocations;
    }

    public void setSkipWater(boolean bl) {
        this.skipWater = bl;
    }

    public boolean getSkipWater() {
        return this.skipWater;
    }

    public void showLigandAtoms(boolean bl) {
        if (this.structureMap.getAtomCount() <= 0) {
            return;
        }
        int n = this.structureMap.getLigandCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            Residue residue = this.structureMap.getLigandResidue(i);
            if (this.skipWater && residue.getCompoundCode().equals("HOH") || (n2 = residue.getAtomCount()) <= 0) continue;
            Atom atom = residue.getAtom(0);
            int n3 = this.structureMap.getAtomIndex(atom);
            if (!this.showAltAtomLocations && atom.occupancy < 1.0f) {
                String string = "x_X_x";
                for (int j = 0; j < n2; ++j) {
                    int n4 = n3 + j;
                    Atom atom2 = this.structureMap.getAtom(n4);
                    if (atom2.name.equals(string)) {
                        this.setAtomVisibility(n4, n4, false);
                    } else {
                        this.setAtomVisibility(n4, n4, bl);
                    }
                    string = atom2.name;
                }
                continue;
            }
            this.setAtomVisibility(n3, n3 + n2 - 1, bl);
        }
    }

    public void showVisibleAtomBonds() {
        int n = this.structureMap.getBondCount();
        for (int i = 0; i < n; ++i) {
            Bond bond = this.structureMap.getBond(i);
            if (!this.getAtomVisibility(bond.getAtom(0))) {
                this.setBondVisibility(bond, false);
                continue;
            }
            if (!this.getAtomVisibility(bond.getAtom(1))) {
                this.setBondVisibility(bond, false);
                continue;
            }
            this.setBondVisibility(bond, true);
        }
    }

    public void showNucleicAcidAtoms(boolean bl) {
        if (this.structureMap.getAtomCount() <= 0) {
            return;
        }
        int n = this.structureMap.getResidueCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            Residue residue = this.structureMap.getResidue(i);
            if (residue.getClassification() != "Nucleic Acid" || (n2 = residue.getAtomCount()) <= 0) continue;
            Atom atom = residue.getAtom(0);
            int n3 = this.structureMap.getAtomIndex(atom);
            if (!this.showAltAtomLocations && atom.occupancy < 1.0f) {
                String string = "x_X_x";
                for (int j = 0; j < n2; ++j) {
                    int n4 = n3 + j;
                    Atom atom2 = this.structureMap.getAtom(n4);
                    if (atom2.name.equals(string)) {
                        this.setAtomVisibility(n4, n4, false);
                    } else {
                        this.setAtomVisibility(n4, n4, bl);
                    }
                    string = atom2.name;
                }
                continue;
            }
            this.setAtomVisibility(n3, n3 + n2 - 1, bl);
        }
    }

    public boolean getAtomVisibility(Atom atom) throws IllegalArgumentException {
        if (atom == null) {
            throw new IllegalArgumentException("null atom");
        }
        int n = this.structureMap.getAtomIndex(atom);
        if (n < 0) {
            throw new IllegalArgumentException("could not find atom index");
        }
        return this.atomVisibility.getValue(n) == VISIBLE;
    }

    public boolean getAtomVisibility(int n) throws IllegalArgumentException {
        return this.atomVisibility.getValue(n) == VISIBLE;
    }

    public void setAtomVisibility(Atom atom, boolean bl) {
        int n = this.structureMap.getAtomIndex(atom);
        this.setAtomVisibility(n, n, bl);
    }

    public void setAtomVisibility(int n, boolean bl) {
        this.setAtomVisibility(n, n, bl);
    }

    public void setAtomVisibility(int n, int n2, boolean bl) {
        if (this.atomVisibility == null) {
            return;
        }
        if (bl) {
            this.atomVisibility.setRange(n, n2, VISIBLE);
        } else {
            this.atomVisibility.setRange(n, n2, INVISIBLE);
        }
        for (int i = n; i <= n2; ++i) {
            Atom atom = this.structureMap.getAtom(i);
            this.structureStylesEvent.structureComponent = atom;
            this.structureStylesEvent.property = 1;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setAtomVisibility(boolean bl) {
        if (this.atomsAreSelected()) {
            int n = this.selection.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.selection.getRangeValue(i);
                if (object != SELECTED) continue;
                int[] nArray = this.selection.getRange(i);
                this.setAtomVisibility(nArray[0], nArray[1], bl);
            }
        } else {
            this.setAtomVisibility(0, this.structureMap.getAtomCount() - 1, bl);
        }
    }

    public boolean getBondVisibility(int n) {
        return this.bondVisibility.getValue(n) == VISIBLE;
    }

    public boolean getBondVisibility(Bond bond) {
        int n = this.structureMap.getBondIndex(bond);
        return this.getBondVisibility(n);
    }

    public void setBondVisibility(int n, boolean bl) {
        this.setBondVisibility(n, n, bl);
    }

    public void setBondVisibility(Bond bond, boolean bl) {
        int n = this.structureMap.getBondIndex(bond);
        this.setBondVisibility(n, n, bl);
    }

    public void setBondVisibility(int n, int n2, boolean bl) {
        if (bl) {
            this.bondVisibility.setRange(n, n2, VISIBLE);
        } else {
            this.bondVisibility.setRange(n, n2, INVISIBLE);
        }
        for (int i = n; i <= n2; ++i) {
            Bond bond = this.structureMap.getBond(i);
            this.structureStylesEvent.structureComponent = bond;
            this.structureStylesEvent.property = 1;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setBondVisibility(boolean bl) {
        if (this.bondsAreSelected()) {
            int n = this.bondSelection.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.bondSelection.getRangeValue(i);
                if (object != SELECTED) continue;
                int[] nArray = this.bondSelection.getRange(i);
                this.setBondVisibility(nArray[0], nArray[1], bl);
            }
        } else {
            this.setBondVisibility(0, this.structureMap.getBondCount() - 1, bl);
        }
    }

    public void setFragmentVisibility(int n, int n2, boolean bl) {
        if (bl) {
            this.fragmentVisibility.setRange(n, n2, VISIBLE);
        } else {
            this.fragmentVisibility.setRange(n, n2, INVISIBLE);
        }
        for (int i = n; i <= n2; ++i) {
            Fragment fragment = this.structureMap.getFragment(i);
            this.structureStylesEvent.structureComponent = fragment;
            this.structureStylesEvent.property = 1;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setFragmentVisibility(int n, boolean bl) {
        this.setFragmentVisibility(n, n, bl);
    }

    public void setFragmentVisibility(Fragment fragment, boolean bl) {
        int n = this.structureMap.getFragmentIndex(fragment);
        this.setFragmentVisibility(n, n, bl);
    }

    public boolean getFragmentVisibility(Fragment fragment) throws IllegalArgumentException {
        if (fragment == null) {
            throw new IllegalArgumentException("null fragment");
        }
        int n = this.structureMap.getFragmentIndex(fragment);
        if (n < 0) {
            throw new IllegalArgumentException("could not find fragment index");
        }
        return this.fragmentVisibility.getValue(n) == VISIBLE;
    }

    public void setFragmentVisibility(boolean bl) {
        int n = this.structureMap.getFragmentCount();
        if (this.fragmentsAreSelected()) {
            for (int i = 0; i < n; ++i) {
                if (!this.getFragmentSelection(i)) continue;
                this.setFragmentVisibility(i, i, bl);
            }
        } else {
            this.setFragmentVisibility(0, n - 1, bl);
        }
    }

    public void setChainVisibility(int n, int n2, boolean bl) {
        if (bl) {
            this.chainVisibility.setRange(n, n2, VISIBLE);
        } else {
            this.chainVisibility.setRange(n, n2, INVISIBLE);
        }
        for (int i = n; i <= n2; ++i) {
            Chain chain = this.structureMap.getChain(i);
            this.structureStylesEvent.structureComponent = chain;
            this.structureStylesEvent.property = 1;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setChainVisibility(int n, boolean bl) {
        this.setChainVisibility(n, n, bl);
    }

    public void setChainVisibility(Chain chain, boolean bl) {
        int n = this.structureMap.getChainIndex(chain);
        this.setChainVisibility(n, n, bl);
    }

    public boolean getChainVisibility(Chain chain) throws IllegalArgumentException {
        if (chain == null) {
            throw new IllegalArgumentException("null chain");
        }
        int n = this.structureMap.getChainIndex(chain);
        if (n < 0) {
            throw new IllegalArgumentException("could not find chain index");
        }
        return this.chainVisibility.getValue(n) == VISIBLE;
    }

    public boolean getChainVisibility(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("could not find chain index");
        }
        return this.chainVisibility.getValue(n) == VISIBLE;
    }

    public boolean isVisible(StructureComponent structureComponent) {
        String string = structureComponent.getStructureComponentType();
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            return this.getAtomVisibility((Atom)structureComponent);
        }
        if (string == StructureComponentRegistry.TYPE_BOND) {
            return this.getBondVisibility((Bond)structureComponent);
        }
        if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
            return this.getFragmentVisibility((Fragment)structureComponent);
        }
        if (string == StructureComponentRegistry.TYPE_CHAIN) {
            return this.getChainVisibility((Chain)structureComponent);
        }
        throw new IllegalArgumentException("No visibility for " + string);
    }

    public boolean isSelected(StructureComponent structureComponent) {
        String string = structureComponent.getStructureComponentType();
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            return this.getAtomSelection((Atom)structureComponent);
        }
        if (string == StructureComponentRegistry.TYPE_BOND) {
            return this.getBondSelection((Bond)structureComponent);
        }
        if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
            return this.getFragmentSelection((Fragment)structureComponent);
        }
        if (string == StructureComponentRegistry.TYPE_CHAIN) {
            return this.getChainSelection((Chain)structureComponent);
        }
        throw new IllegalArgumentException("No selection for " + string);
    }

    public void setSelected(StructureComponent structureComponent, boolean bl) {
        String string = structureComponent.getStructureComponentType();
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            this.setAtomSelection((Atom)structureComponent, bl);
        } else if (string == StructureComponentRegistry.TYPE_BOND) {
            this.setBondSelection((Bond)structureComponent, bl);
        } else if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
            this.setFragmentSelection((Fragment)structureComponent, bl);
        } else if (string == StructureComponentRegistry.TYPE_CHAIN) {
            this.setChainSelection((Chain)structureComponent, bl);
        } else {
            throw new IllegalArgumentException("No selection for " + string);
        }
    }

    public void getAtomColor(Atom atom, float[] fArray) throws IllegalArgumentException {
        if (atom == null) {
            throw new IllegalArgumentException("null atom");
        }
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        int n = this.structureMap.getAtomIndex(atom);
        this.getAtomColor(n, fArray);
    }

    public void getAtomColor(int n, float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        Atom atom = this.structureMap.getAtom(n);
        AtomColor atomColor = (AtomColor)this.atomColors.getValue(n);
        atomColor.getAtomColor(atom, fArray);
    }

    public AtomColor getAtomColorObject(int n) {
        return (AtomColor)this.atomColors.getValue(n);
    }

    public void setAtomColor(Atom atom, AtomColor atomColor) throws IllegalArgumentException {
        if (atom == null) {
            throw new IllegalArgumentException("null atom");
        }
        if (atomColor == null) {
            throw new IllegalArgumentException("null atomColor");
        }
        int n = this.structureMap.getAtomIndex(atom);
        this.setAtomColor(n, n, atomColor);
    }

    public void setAtomColor(int n, AtomColor atomColor) throws IllegalArgumentException {
        this.setAtomColor(n, n, atomColor);
    }

    public void setAtomColor(int n, int n2, AtomColor atomColor) {
        this.atomColors.setRange(n, n2, atomColor);
        for (int i = n; i <= n2; ++i) {
            Atom atom = this.structureMap.getAtom(i);
            this.structureStylesEvent.structureComponent = atom;
            this.structureStylesEvent.property = 4;
            this.fireStructureStylesEvent(this.structureStylesEvent);
            Vector vector = this.structureMap.getBonds(atom);
            if (vector == null) continue;
            int n3 = vector.size();
            for (int j = 0; j < n3; ++j) {
                this.structureStylesEvent.structureComponent = (Bond)vector.elementAt(j);
                this.fireStructureStylesEvent(this.structureStylesEvent);
            }
        }
    }

    public void setAtomColor(AtomColor atomColor) {
        if (this.atomsAreSelected()) {
            int n = this.selection.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.selection.getRangeValue(i);
                if (object != SELECTED) continue;
                int[] nArray = this.selection.getRange(i);
                this.setAtomColor(nArray[0], nArray[1], atomColor);
            }
        } else {
            int n = this.atomVisibility.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.atomVisibility.getRangeValue(i);
                if (object != VISIBLE) continue;
                int[] nArray = this.atomVisibility.getRange(i);
                this.setAtomColor(nArray[0], nArray[1], atomColor);
            }
        }
    }

    public String getAtomLabel(Atom atom) throws IllegalArgumentException {
        if (atom == null) {
            throw new IllegalArgumentException("null atom");
        }
        int n = this.structureMap.getAtomIndex(atom);
        AtomLabel atomLabel = (AtomLabel)this.atomLabels.getValue(n);
        return atomLabel.getAtomLabel(atom);
    }

    public String getAtomLabel(int n) throws IllegalArgumentException {
        Atom atom = this.structureMap.getAtom(n);
        AtomLabel atomLabel = (AtomLabel)this.atomLabels.getValue(n);
        return atomLabel.getAtomLabel(atom);
    }

    public AtomLabel getAtomLabelObject(int n) {
        return (AtomLabel)this.atomLabels.getValue(n);
    }

    public void setAtomLabel(int n, int n2, AtomLabel atomLabel) throws IllegalArgumentException {
        this.atomLabels.setRange(n, n2, atomLabel);
        for (int i = n; i <= n2; ++i) {
            Atom atom = this.structureMap.getAtom(i);
            this.structureStylesEvent.structureComponent = atom;
            this.structureStylesEvent.property = 32;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setAtomLabel(AtomLabel atomLabel) {
        if (this.atomsAreSelected()) {
            int n = this.selection.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.selection.getRangeValue(i);
                if (object != SELECTED) continue;
                int[] nArray = this.selection.getRange(i);
                this.setAtomLabel(nArray[0], nArray[1], atomLabel);
            }
        } else {
            int n = this.atomVisibility.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.atomVisibility.getRangeValue(i);
                if (object != VISIBLE) continue;
                int[] nArray = this.atomVisibility.getRange(i);
                this.setAtomLabel(nArray[0], nArray[1], atomLabel);
            }
        }
    }

    public void updateAtomColor(int n) {
        Atom atom = this.structureMap.getAtom(n);
        this.structureStylesEvent.structureComponent = atom;
        this.structureStylesEvent.property = 4;
        this.fireStructureStylesEvent(this.structureStylesEvent);
    }

    public double getAtomRadius(Atom atom) {
        int n = this.structureMap.getAtomIndex(atom);
        AtomRadius atomRadius = (AtomRadius)this.atomRadii.getValue(n);
        return atomRadius.getAtomRadius(atom);
    }

    public double getAtomRadius(int n) {
        AtomRadius atomRadius = (AtomRadius)this.atomRadii.getValue(n);
        Atom atom = this.structureMap.getAtom(n);
        return atomRadius.getAtomRadius(atom);
    }

    public AtomRadius getAtomRadiusObject(int n) {
        return (AtomRadius)this.atomRadii.getValue(n);
    }

    public void setAtomRadius(int n, AtomRadius atomRadius) {
        this.setAtomRadius(n, n, atomRadius);
    }

    public void setAtomRadius(Atom atom, AtomRadius atomRadius) {
        int n = this.structureMap.getAtomIndex(atom);
        this.setAtomRadius(n, n, atomRadius);
    }

    public void setAtomRadius(int n, int n2, AtomRadius atomRadius) {
        this.atomRadii.setRange(n, n2, atomRadius);
        for (int i = n; i <= n2; ++i) {
            Atom atom = this.structureMap.getAtom(i);
            this.structureStylesEvent.structureComponent = atom;
            this.structureStylesEvent.property = 8;
            this.fireStructureStylesEvent(this.structureStylesEvent);
        }
    }

    public void setAtomRadius(AtomRadius atomRadius) {
        if (this.atomsAreSelected()) {
            int n = this.selection.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.selection.getRangeValue(i);
                if (object != SELECTED) continue;
                int[] nArray = this.selection.getRange(i);
                this.setAtomRadius(nArray[0], nArray[1], atomRadius);
            }
        } else {
            int n = this.atomVisibility.getRangeCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.atomVisibility.getRangeValue(i);
                if (object != VISIBLE) continue;
                int[] nArray = this.atomVisibility.getRange(i);
                this.setAtomRadius(nArray[0], nArray[1], atomRadius);
            }
        }
    }

    public void getResidueColor(int n, float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        Residue residue = this.structureMap.getResidue(n);
        ResidueColor residueColor = (ResidueColor)this.residueColors.getValue(n);
        residueColor.getResidueColor(residue, fArray);
    }

    public ResidueColor getResidueColorObject(int n) throws IllegalArgumentException {
        return (ResidueColor)this.residueColors.getValue(n);
    }

    public void getResidueColor(Residue residue, float[] fArray) throws IllegalArgumentException {
        if (residue == null) {
            throw new IllegalArgumentException("null residue");
        }
        if (fArray == null) {
            throw new IllegalArgumentException("null color");
        }
        int n = this.structureMap.getResidueIndex(residue);
        ResidueColor residueColor = (ResidueColor)this.residueColors.getValue(n);
        residueColor.getResidueColor(residue, fArray);
    }

    public void setResidueColor(Residue residue, ResidueColor residueColor) throws IllegalArgumentException {
        if (residue == null) {
            throw new IllegalArgumentException("null residue");
        }
        if (residueColor == null) {
            throw new IllegalArgumentException("null residueColor");
        }
        int n = this.structureMap.getResidueIndex(residue);
        this.setResidueColor(n, n, residueColor);
    }

    public void setResidueColor(int n, ResidueColor residueColor) {
        this.setResidueColor(n, residueColor);
    }

    public void setResidueColor(int n, int n2, ResidueColor residueColor) {
        this.residueColors.setRange(n, n2, residueColor);
        for (int i = n; i <= n2; ++i) {
            Residue residue = this.structureMap.getResidue(i);
            this.structureStylesEvent.structureComponent = residue;
            this.structureStylesEvent.property = 4;
            this.fireStructureStylesEvent(this.structureStylesEvent);
            Vector vector = this.structureMap.getBonds(residue.getAtoms());
            if (vector == null) continue;
            int n3 = vector.size();
            for (int j = 0; j < n3; ++j) {
                Bond bond = (Bond)vector.elementAt(j);
                this.structureStylesEvent.structureComponent = bond;
                this.structureStylesEvent.property = 4;
                this.fireStructureStylesEvent(this.structureStylesEvent);
            }
        }
    }

    public void setResidueColor(ResidueColor residueColor) {
        int n = this.structureMap.getResidueCount();
        if (this.residuesAreSelected()) {
            for (int i = 0; i < n; ++i) {
                if (!this.getResidueSelection(i)) continue;
                this.setResidueColor(i, i, residueColor);
            }
        } else {
            this.setResidueColor(0, n - 1, residueColor);
        }
    }

    public void addStructureStylesEventListener(StructureStylesEventListener structureStylesEventListener) {
        if (structureStylesEventListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        if (this.sseListeners.contains(structureStylesEventListener)) {
            throw new IllegalArgumentException("listener already added");
        }
        this.sseListeners.add(structureStylesEventListener);
    }

    public void removeStructureStylesEventListener(StructureStylesEventListener structureStylesEventListener) {
        if (structureStylesEventListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        if (!this.sseListeners.contains(structureStylesEventListener)) {
            throw new IllegalArgumentException("listener does not exist");
        }
        this.sseListeners.remove(structureStylesEventListener);
    }

    private void fireStructureStylesEvent(StructureStylesEvent structureStylesEvent) {
        for (int i = 0; i < this.sseListeners.size(); ++i) {
            StructureStylesEventListener structureStylesEventListener = (StructureStylesEventListener)this.sseListeners.elementAt(i);
            structureStylesEventListener.processStructureStylesEvent(structureStylesEvent);
        }
    }
}

