/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers;

import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.viewables.StructureDocument;
import edu.sdsc.mbt.viewables.StructureDocumentEvent;
import edu.sdsc.mbt.viewers.SequenceViewerPanel;
import edu.sdsc.mbt.viewers.Viewer;
import java.awt.BorderLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class SequenceViewer
extends JPanel
implements Viewer {
    private StructureDocument structureDocument = null;
    private Hashtable sequenceViewerPanels = new Hashtable();
    private int startResidue = 0;
    private int displayRows = 1;
    private int residueMax = 1;
    private JPanel viewersPanel = null;
    private JScrollBar scrollBar = null;

    public SequenceViewer() {
        this.setLayout(new BorderLayout());
        this.viewersPanel = new JPanel();
        this.viewersPanel.setLayout(new BoxLayout(this.viewersPanel, 1));
        this.add("Center", this.viewersPanel);
        this.scrollBar = new JScrollBar(0);
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(0);
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                SequenceViewer.this.setStartResidue(adjustmentEvent.getValue());
            }
        };
        this.scrollBar.addAdjustmentListener(adjustmentListener);
        this.add("South", this.scrollBar);
    }

    public void setStartResidue(int n) {
        Enumeration enumeration = this.sequenceViewerPanels.elements();
        while (enumeration.hasMoreElements()) {
            SequenceViewerPanel sequenceViewerPanel = (SequenceViewerPanel)enumeration.nextElement();
            sequenceViewerPanel.setStartResidue(n);
        }
    }

    public void processStructureDocumentEvent(StructureDocumentEvent structureDocumentEvent) {
        int n = structureDocumentEvent.type;
        int n2 = structureDocumentEvent.change;
        if (n == 0) {
            if (n2 == 0) {
                this.structureDocument = structureDocumentEvent.structureDocument;
                this.viewerAdded(structureDocumentEvent.viewer);
            } else if (n2 == 1) {
                this.structureDocument = null;
                this.viewerRemoved(structureDocumentEvent.viewer);
            }
        } else if (n == 1) {
            if (n2 == 0) {
                this.structureAdded(structureDocumentEvent.structure);
            } else if (n2 == 1) {
                this.structureRemoved(structureDocumentEvent.structure);
            }
        }
    }

    private void viewerAdded(Viewer viewer) {
        if (viewer != this) {
            return;
        }
        int n = this.structureDocument.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            this.structureAdded(structure);
        }
    }

    private void viewerRemoved(Viewer viewer) {
        if (viewer != this) {
            return;
        }
        int n = this.structureDocument.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            this.structureRemoved(structure);
        }
    }

    private void structureAdded(Structure structure) {
        StructureMap structureMap = structure.getStructureMap();
        int n = structureMap.getResidueCount();
        this.residueMax = Math.max(this.residueMax, n);
        this.scrollBar.setMaximum(this.residueMax);
        SequenceViewerPanel sequenceViewerPanel = new SequenceViewerPanel();
        this.sequenceViewerPanels.put(structure, sequenceViewerPanel);
        sequenceViewerPanel.setStructure(structure);
        this.viewersPanel.add(sequenceViewerPanel);
        this.revalidate();
        this.repaint();
    }

    private void structureRemoved(Structure structure) {
        SequenceViewerPanel sequenceViewerPanel = (SequenceViewerPanel)this.sequenceViewerPanels.get(structure);
        this.viewersPanel.remove(sequenceViewerPanel);
        this.sequenceViewerPanels.remove(structure);
        this.revalidate();
        this.repaint();
    }
}

