/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers;

import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.util.AminoAcidInfo;
import edu.sdsc.mbt.viewables.StructureStyles;
import edu.sdsc.mbt.viewables.StructureStylesEvent;
import edu.sdsc.mbt.viewables.StructureStylesEventListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SequenceViewerPanel
extends JPanel
implements StructureStylesEventListener {
    private Graphics myGraphics = null;
    private int fontSize = 18;
    private Font font = null;
    private int cellMargin = 1;
    private int cellWidth = 10;
    private int cellHeight = 40;
    private int fontAscent = 20;
    private int fontDescent = 3;
    private int fontMaxDescent = 4;
    private int visibleColumns = 100;
    private int startResidue = 0;
    private int stopResidue = 0;
    private int displayRows = 1;
    private Structure structure = null;
    private StructureMap structureMap = null;
    private StructureStyles structureStyles = null;
    private int residueCount = 0;
    private float[] rgbColor = new float[3];
    private Color normalCellColor = new Color(0.7f, 0.7f, 0.7f);
    private Color normalTextColor = new Color(0.0f, 0.0f, 0.0f);
    private Color normalBarColor = new Color(0.7f, 0.7f, 0.7f);
    private Point toolTipPoint = new Point();

    public SequenceViewerPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setToolTipText("SequenceViewerPanel");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SequenceViewerPanel.this.doClick(mouseEvent);
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    private void doClick(MouseEvent mouseEvent) {
        int n = this.startResidue + (mouseEvent.getX() - this.getInsets().left) / this.cellWidth;
        if (n < 0) {
            return;
        }
        if (n >= this.residueCount) {
            return;
        }
        Residue residue = this.structureMap.getResidue(n);
        if (residue == null) {
            return;
        }
        boolean bl = !this.structureStyles.getResidueSelection(n);
        this.structureStyles.setResidueSelection(n, bl);
    }

    public void processStructureStylesEvent(StructureStylesEvent structureStylesEvent) {
        StructureComponent structureComponent = structureStylesEvent.structureComponent;
        Structure structure = structureComponent.structure;
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        String string = structureComponent.getStructureComponentType();
        if (string == StructureComponentRegistry.TYPE_RESIDUE && (structureStylesEvent.property == 4 || structureStylesEvent.property == 2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setStructure(Structure structure) {
        if (this.structure != null) {
            this.structureStyles.removeStructureStylesEventListener(this);
            this.structureStyles = null;
            this.structureMap = null;
            this.structure = null;
        }
        if (structure == null) {
            return;
        }
        this.structure = structure;
        this.structureMap = structure.getStructureMap();
        this.structureStyles = this.structureMap.getStructureStyles();
        this.residueCount = this.structureMap.getResidueCount();
        this.structureStyles.addStructureStylesEventListener(this);
    }

    public void setStartResidue(int n) {
        this.startResidue = n;
        this.revalidate();
        this.repaint();
    }

    public void setDisplayRows(int n) {
        this.displayRows = n;
        this.revalidate();
        this.repaint();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        if (n < 6) {
            return;
        }
        if (n > 72) {
            return;
        }
        this.fontSize = n;
        if (this.myGraphics == null) {
            return;
        }
        this.font = new Font("Monospaced", 1, this.fontSize);
        this.myGraphics.setFont(this.font);
        FontMetrics fontMetrics = this.myGraphics.getFontMetrics();
        this.cellWidth = fontMetrics.stringWidth("W") + this.cellMargin * 2 + 1;
        this.cellHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading() + this.cellMargin * 2;
        this.fontAscent = fontMetrics.getAscent();
        this.fontDescent = fontMetrics.getDescent();
        this.fontMaxDescent = fontMetrics.getMaxDescent();
        int n2 = this.cellWidth * this.visibleColumns;
        int n3 = this.cellHeight;
        Dimension dimension = new Dimension(n2, n3);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setSize(n2, n3);
        this.revalidate();
        this.repaint();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        this.toolTipPoint.x = mouseEvent.getX();
        this.toolTipPoint.y = this.cellHeight;
        return this.toolTipPoint;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.startResidue + (mouseEvent.getX() - this.getInsets().left) / this.cellWidth;
        if (n < 0) {
            return null;
        }
        if (n >= this.residueCount) {
            return null;
        }
        Residue residue = this.structureMap.getResidue(n);
        if (residue == null) {
            return null;
        }
        return residue.getCompoundCode() + " " + residue.getResidueId();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.myGraphics == null) {
            this.myGraphics = graphics;
            this.setFontSize(this.fontSize);
        }
        graphics.setFont(this.font);
        Insets insets = this.getInsets();
        this.visibleColumns = this.getWidth() / this.cellWidth;
        this.stopResidue = Math.min(this.startResidue + this.visibleColumns, this.residueCount);
        for (int i = this.startResidue; i < this.stopResidue; ++i) {
            Residue residue = this.structureMap.getResidue(i);
            String string = residue.getCompoundCode();
            String string2 = residue.getClassification();
            String string3 = null;
            string3 = string2 == "Amino Acid" ? AminoAcidInfo.getLetterFromCode(string) : (string2 == "Nucleic Acid" ? string : "*");
            int n = this.cellWidth * (i - this.startResidue) + insets.left;
            Color color = null;
            if (this.structureStyles.getResidueSelection(i)) {
                StructureStyles.getSelectionColor(this.rgbColor);
                color = new Color(this.rgbColor[0], this.rgbColor[1], this.rgbColor[2]);
            } else {
                color = this.normalCellColor;
            }
            graphics.setColor(color);
            graphics.fillRect(n, 0, this.cellWidth, this.cellHeight);
            if (string2 == "Amino Acid") {
                this.structureStyles.getResidueColor(residue, this.rgbColor);
                color = new Color(this.rgbColor[0], this.rgbColor[1], this.rgbColor[2]);
            } else {
                color = this.normalBarColor;
            }
            graphics.setColor(color);
            graphics.fillRect(n, this.cellHeight - this.fontDescent, this.cellWidth, this.cellHeight);
            graphics.setColor(Color.black);
            graphics.drawString(string3, n + this.cellMargin + 1, this.fontAscent);
        }
    }
}

