/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers;

import edu.sdsc.mbt.util.Status;
import edu.sdsc.mbt.util.StatusEvent;
import edu.sdsc.mbt.util.StatusListener;
import edu.sdsc.mbt.viewers.ProgressPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;

public class StatusPanel
extends JPanel
implements StatusListener {
    private JTextArea textArea = new JTextArea();
    private JScrollPane jScrollPane = null;
    private JLabel statusButton = null;
    private ProgressPanel progressPanel = new ProgressPanel();
    private boolean progressVisible = false;

    public StatusPanel() {
        Object object;
        this.setLayout(new BorderLayout());
        this.textArea.setBorder(new EtchedBorder(1));
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(1);
        this.textArea.setBackground(Color.lightGray);
        this.jScrollPane = new JScrollPane(this.textArea);
        this.jScrollPane.setHorizontalScrollBarPolicy(31);
        this.jScrollPane.setVerticalScrollBarPolicy(21);
        this.add("Center", this.jScrollPane);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("1 Line");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusPanel.this.setRows(1);
            }
        };
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("2 Line");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusPanel.this.setRows(2);
            }
        };
        jMenuItem2.addActionListener(actionListener2);
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("3 Line");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusPanel.this.setRows(3);
            }
        };
        jMenuItem3.addActionListener(actionListener3);
        jPopupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("4 Line");
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusPanel.this.setRows(4);
            }
        };
        jMenuItem4.addActionListener(actionListener4);
        jPopupMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("+ Line");
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusPanel.this.setRows(StatusPanel.this.getRows() + 1);
            }
        };
        jMenuItem5.addActionListener(actionListener5);
        jPopupMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("- Line");
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusPanel.this.setRows(StatusPanel.this.getRows() - 1);
            }
        };
        jMenuItem6.addActionListener(actionListener6);
        jPopupMenu.add(jMenuItem6);
        jPopupMenu.add(new JSeparator());
        JMenuItem jMenuItem7 = new JMenuItem("Clear");
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusPanel.this.clear();
            }
        };
        jMenuItem7.addActionListener(actionListener7);
        jPopupMenu.add(jMenuItem7);
        jPopupMenu.add(new JSeparator());
        ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                Status.setOutputLevel(string);
                int n = Status.getOutputLevel();
                string = Status.getLevelName(n);
                Status.output(0, "status Level set to " + string);
            }
        };
        int n = Status.getLevelCount();
        for (int i = 0; i < n; ++i) {
            object = Status.getLevelName(i);
            JMenuItem jMenuItem8 = new JMenuItem((String)object);
            jMenuItem8.addActionListener(actionListener8);
            jPopupMenu.add(jMenuItem8);
        }
        this.statusButton = new JLabel("Status:");
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.statusButton.setBorder(border);
        object = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), 0, 0);
                }
            }
        };
        this.statusButton.addMouseListener((MouseListener)object);
        this.add("West", this.statusButton);
        Status.addStatusListener(this);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 20);
    }

    public int getRows() {
        return this.textArea.getRows();
    }

    public void setRows(int n) {
        if (n <= 0) {
            return;
        }
        if (n == 1) {
            this.jScrollPane.setVerticalScrollBarPolicy(21);
        } else {
            this.jScrollPane.setVerticalScrollBarPolicy(20);
        }
        this.textArea.setRows(n);
        this.showLastLine();
        this.getParent().validate();
    }

    public void clear() {
        this.textArea.setText(null);
    }

    public void processStatusEvent(StatusEvent statusEvent) {
        if (statusEvent.type == 0) {
            this.textArea.append(statusEvent.message);
            this.showLastLine();
        } else if (statusEvent.type == 1) {
            if (statusEvent.message != null) {
                if (!this.progressVisible) {
                    this.progressVisible = true;
                    this.add("North", this.progressPanel);
                    this.getParent().validate();
                }
                this.progressPanel.setText(statusEvent.message);
                this.progressPanel.setPercent(statusEvent.percent);
            } else if (this.progressVisible) {
                this.progressVisible = false;
                this.remove(this.progressPanel);
                this.getParent().validate();
            }
        }
    }

    public void showLastLine() {
        try {
            int n = this.textArea.getLineCount();
            --n;
            int n2 = this.textArea.getLineStartOffset(--n);
            this.textArea.setCaretPosition(n2);
        }
        catch (BadLocationException badLocationException) {
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.textArea != null) {
            this.textArea.setBackground(color);
        }
        if (this.statusButton != null) {
            this.statusButton.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.textArea != null) {
            this.textArea.setForeground(color);
        }
        if (this.statusButton != null) {
            this.statusButton.setForeground(color);
        }
    }
}

