/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureInfo;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.util.AminoAcidInfo;
import edu.sdsc.mbt.util.PeriodicTable;
import edu.sdsc.mbt.viewables.StructureDocument;
import edu.sdsc.mbt.viewables.StructureDocumentEvent;
import edu.sdsc.mbt.viewables.StructureStyles;
import edu.sdsc.mbt.viewables.StructureStylesEvent;
import edu.sdsc.mbt.viewables.StructureStylesEventListener;
import edu.sdsc.mbt.viewers.Viewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class StructureComponentInspector
extends JPanel
implements Viewer,
StructureStylesEventListener {
    private StructureDocument structureDocument = null;
    private int itemCount = 20;
    private JTable table = null;
    private JLabel[][] data = null;
    private String emptyString = "";

    public StructureComponentInspector() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        Object[] objectArray = new String[]{new String("Property"), new String("Value")};
        this.data = new JLabel[this.itemCount][2];
        for (int i = 0; i < this.itemCount; ++i) {
            this.data[i][0] = new JLabel();
            this.data[i][1] = new JLabel();
        }
        this.table = new JTable(this.data, objectArray);
        TableCellRenderer tableCellRenderer = new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return (JLabel)object;
            }
        };
        this.table.setDefaultRenderer(this.table.getColumnClass(0), tableCellRenderer);
        this.table.setDefaultRenderer(this.table.getColumnClass(1), tableCellRenderer);
        this.table.setDefaultEditor(this.table.getColumnClass(0), null);
        this.table.setDefaultEditor(this.table.getColumnClass(1), null);
        this.table.setIntercellSpacing(new Dimension(4, 1));
        int n = 160;
        this.table.getColumnModel().getColumn(0).setPreferredWidth(n);
        this.table.getColumnModel().getColumn(0).setMaxWidth(n);
        this.table.getColumnModel().getColumn(0).setMinWidth(n);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public void processStructureDocumentEvent(StructureDocumentEvent structureDocumentEvent) {
        int n = structureDocumentEvent.type;
        int n2 = structureDocumentEvent.change;
        if (n == 0) {
            if (n2 == 0) {
                this.structureDocument = structureDocumentEvent.structureDocument;
                this.viewerAdded(structureDocumentEvent.viewer);
            } else if (n2 == 1) {
                this.structureDocument = structureDocumentEvent.structureDocument;
                this.viewerRemoved(structureDocumentEvent.viewer);
            }
        } else if (n == 1) {
            if (n2 == 0) {
                this.structureAdded(structureDocumentEvent.structure);
            } else if (n2 == 1) {
                this.structureRemoved(structureDocumentEvent.structure);
            }
        }
    }

    private void viewerAdded(Viewer viewer) {
        if (viewer != this) {
            return;
        }
        int n = this.structureDocument.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            this.structureAdded(structure);
        }
    }

    private void viewerRemoved(Viewer viewer) {
        if (viewer != this) {
            return;
        }
        int n = this.structureDocument.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            this.structureRemoved(structure);
        }
    }

    private void structureAdded(Structure structure) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        structureStyles.addStructureStylesEventListener(this);
    }

    private void structureRemoved(Structure structure) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        structureStyles.removeStructureStylesEventListener(this);
    }

    public void processStructureStylesEvent(StructureStylesEvent structureStylesEvent) {
        if (structureStylesEvent.property == 2) {
            Object object;
            int n;
            StructureComponent structureComponent;
            StructureComponent structureComponent2 = structureStylesEvent.structureComponent;
            Structure structure = structureComponent2.structure;
            StructureMap structureMap = structure.getStructureMap();
            StructureStyles structureStyles = structureMap.getStructureStyles();
            String string = structureComponent2.getStructureComponentType();
            int n2 = 0;
            JLabel jLabel = null;
            jLabel = (JLabel)this.table.getValueAt(n2, 0);
            jLabel.setForeground(Color.blue);
            jLabel.setText("Structure Info");
            jLabel = (JLabel)this.table.getValueAt(n2, 1);
            jLabel.setForeground(Color.black);
            jLabel.setText("");
            ++n2;
            StructureInfo structureInfo = structure.getStructureInfo();
            if (structureInfo != null) {
                jLabel = (JLabel)this.table.getValueAt(n2, 0);
                jLabel.setText("IdCode:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(structureInfo.getIdCode());
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("ShortName:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(structureInfo.getShortName());
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("LongName:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(structureInfo.getLongName());
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("ReleaseDate:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(structureInfo.getReleaseDate());
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("Authors:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(structureInfo.getAuthors());
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("DeterminationMethod:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(structureInfo.getDeterminationMethod());
                ++n2;
            }
            jLabel = (JLabel)this.table.getValueAt(n2, 0);
            jLabel.setText("URL:");
            jLabel = (JLabel)this.table.getValueAt(n2, 1);
            jLabel.setText(structure.getUrlString());
            jLabel = (JLabel)this.table.getValueAt(++n2, 0);
            jLabel.setText("Structure Component");
            jLabel.setForeground(Color.blue);
            jLabel = (JLabel)this.table.getValueAt(n2, 1);
            jLabel.setText("");
            jLabel.setForeground(Color.black);
            ++n2;
            if (string == StructureComponentRegistry.TYPE_ATOM) {
                structureComponent = (Atom)structureComponent2;
                n = structureMap.getAtomIndex((Atom)structureComponent);
                if (structureStyles.getAtomSelection(n)) {
                    jLabel = (JLabel)this.table.getValueAt(n2, 0);
                    jLabel.setText("MBT Type:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(string);
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("MBT Index:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Integer.toString(n));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Number:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Integer.toString(((Atom)structureComponent).number));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Element:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Atom)structureComponent).element + " (" + PeriodicTable.getElementName(((Atom)structureComponent).element) + ")");
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Name:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Atom)structureComponent).name);
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Compound:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Atom)structureComponent).compound);
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Chain:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Atom)structureComponent).chain_id);
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Residue:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Integer.toString(((Atom)structureComponent).residue_id));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Coordinate:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Atom)structureComponent).coordinate[0] + ", " + ((Atom)structureComponent).coordinate[1] + ", " + ((Atom)structureComponent).coordinate[2]);
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Occupancy:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Float.toString(((Atom)structureComponent).occupancy));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("B-Factor:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Float.toString(((Atom)structureComponent).bfactor));
                    ++n2;
                }
            } else if (string == StructureComponentRegistry.TYPE_BOND) {
                structureComponent = (Bond)structureComponent2;
                n = structureMap.getBondIndex((Bond)structureComponent);
                if (structureStyles.getBondSelection(n)) {
                    jLabel = (JLabel)this.table.getValueAt(n2, 0);
                    jLabel.setText("MBT Type:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(string);
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("MBT Index:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Integer.toString(n));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Atoms:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    object = ((Bond)structureComponent).getAtom(0);
                    Atom atom = ((Bond)structureComponent).getAtom(1);
                    jLabel.setText(((Atom)object).element + " (" + ((Atom)object).number + ") - " + atom.element + " (" + atom.number + ")");
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Distance:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Double.toString(((Bond)structureComponent).getDistance()));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Order:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Float.toString(((Bond)structureComponent).getOrder()));
                    ++n2;
                }
            } else if (string == StructureComponentRegistry.TYPE_RESIDUE) {
                structureComponent = (Residue)structureComponent2;
                n = structureMap.getResidueIndex((Residue)structureComponent);
                if (structureStyles.getResidueSelection(n)) {
                    jLabel = (JLabel)this.table.getValueAt(n2, 0);
                    jLabel.setText("MBT Type:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(string);
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("MBT Index:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Integer.toString(n));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Chain ID:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Residue)structureComponent).getChainId());
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Residue ID:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Integer.toString(((Residue)structureComponent).getResidueId()));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Compound:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    object = ((Residue)structureComponent).getCompoundCode();
                    jLabel.setText((String)object + " (" + AminoAcidInfo.getNameFromCode((String)object) + ")");
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Classification:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Residue)structureComponent).getClassification());
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Hydrophobicity:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Float.toString(((Residue)structureComponent).getHydrophobicity()));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Conformation:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Residue)structureComponent).getConformationType());
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Atoms:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Integer.toString(((Residue)structureComponent).getAtomCount()));
                    ++n2;
                }
            } else if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
                structureComponent = (Fragment)structureComponent2;
                n = structureMap.getFragmentIndex((Fragment)structureComponent);
                object = ((Fragment)structureComponent).getChain();
                int n3 = structureMap.getChainIndex((Chain)object);
                if (structureStyles.getFragmentSelection(n)) {
                    jLabel = (JLabel)this.table.getValueAt(n2, 0);
                    jLabel.setText("MBT Type:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(string);
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("MBT Index:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(Integer.toString(n));
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Chain ID:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Chain)object).getChainId());
                    jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                    jLabel.setText("Type:");
                    jLabel = (JLabel)this.table.getValueAt(n2, 1);
                    jLabel.setText(((Fragment)structureComponent).getConformationType());
                    ++n2;
                }
            } else if (string == StructureComponentRegistry.TYPE_CHAIN && structureStyles.getChainSelection(n = structureMap.getChainIndex((Chain)(structureComponent = (Chain)structureComponent2)))) {
                jLabel = (JLabel)this.table.getValueAt(n2, 0);
                jLabel.setText("MBT Type:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(string);
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("MBT Index:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(Integer.toString(n));
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("Chain ID:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(((Chain)structureComponent).getChainId());
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("Classification:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(((Chain)structureComponent).getClassification());
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("Fragments:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(Integer.toString(((Chain)structureComponent).getFragmentCount()));
                jLabel = (JLabel)this.table.getValueAt(++n2, 0);
                jLabel.setText("Residues:");
                jLabel = (JLabel)this.table.getValueAt(n2, 1);
                jLabel.setText(Integer.toString(((Chain)structureComponent).getResidueCount()));
                ++n2;
            }
            for (int i = n2; i < this.itemCount; ++i) {
                jLabel = (JLabel)this.table.getValueAt(i, 0);
                jLabel.setText(this.emptyString);
                jLabel = (JLabel)this.table.getValueAt(i, 1);
                jLabel.setText(this.emptyString);
            }
            this.repaint();
        }
    }
}

