/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.util.Status;
import edu.sdsc.mbt.viewables.StructureDocument;
import edu.sdsc.mbt.viewables.StructureDocumentEvent;
import edu.sdsc.mbt.viewables.StructureStyles;
import edu.sdsc.mbt.viewables.StructureStylesEvent;
import edu.sdsc.mbt.viewables.StructureStylesEventListener;
import edu.sdsc.mbt.viewers.StructureViewerImpl.AtomGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.BondGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionStyle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.FragmentTooShortException;
import edu.sdsc.mbt.viewers.StructureViewerImpl.LabelJ3D;
import edu.sdsc.mbt.viewers.StructureViewerImpl.PsGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.SsGeometry;
import edu.sdsc.mbt.viewers.Viewer;
import edu.sdsc.vis.viewers.GeometryViewer;
import edu.sdsc.vis.viewers.PickEvent;
import edu.sdsc.vis.viewers.PickListener;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class StructureViewer
extends JPanel
implements Viewer,
PickListener,
StructureStylesEventListener {
    private GeometryViewer geometryViewer = null;
    protected Hashtable structureHash = new Hashtable();
    private StructureDocument structureDocument = null;
    public static final int PICK_ATOMS = 0;
    public static final int PICK_RESIDUES = 1;
    public static final int PICK_FRAGMENTS = 2;
    public static final int PICK_CHAINS = 3;
    public static final int PICK_STRUCTURES = 4;
    private int pickLevel = 2;
    public static final int VIEW_COMBO = 0;
    public static final int VIEW_BALL_AND_STICK = 1;
    public static final int VIEW_STICKS = 2;
    public static final int VIEW_BACKBONE_LINE = 3;
    public static final int VIEW_BACKBONE_RIBBON = 4;
    private static int defaultView = 0;
    private int ribbonStyle = 1;
    private int bondSelection = 0;
    private Transform3D scratchTransform3D = new Transform3D();
    private float[] scratchColor = new float[3];
    private float[][] scratchColor1 = new float[1][3];
    private float[][] scratchColor2 = new float[2][3];

    public StructureViewer() {
        this.geometryViewer = new GeometryViewer();
        this.geometryViewer.addPickListener(this);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.geometryViewer);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public BufferedImage getBufferedImage() {
        return this.geometryViewer.getBufferedImage();
    }

    public BufferedImage getBufferedImage(int n, int n2) {
        return this.geometryViewer.getBufferedImage(n, n2);
    }

    public void setStereoEnable(boolean bl) {
        this.geometryViewer.setStereoEnable(bl);
    }

    public boolean getStereoEnable() {
        return this.geometryViewer.getStereoEnable();
    }

    public void setDepthCueEnable(boolean bl) {
        this.geometryViewer.setDepthCueEnable(bl);
    }

    public boolean getDepthCueEnable() {
        return this.geometryViewer.getDepthCueEnable();
    }

    public void setDepthCueFrontDistance(double d) {
        this.geometryViewer.setDepthCueFrontDistance(d);
    }

    public void setDepthCueBackDistance(double d) {
        this.geometryViewer.setDepthCueBackDistance(d);
    }

    public void resetView() {
        this.geometryViewer.resetView();
    }

    public void setBackgroundColor(float[] fArray) {
        Color3f color3f = new Color3f(fArray[0], fArray[1], fArray[2]);
        this.geometryViewer.setBackgroundColor(color3f);
    }

    public void getBackgroundColor(float[] fArray) {
        Color3f color3f = new Color3f();
        this.geometryViewer.getBackgroundColor(color3f);
        fArray[0] = color3f.x;
        fArray[1] = color3f.y;
        fArray[2] = color3f.z;
    }

    public void setViewpoint(double[] dArray) {
        Transform3D transform3D = new Transform3D(dArray);
        this.geometryViewer.setTransform(transform3D);
    }

    public void getViewpoint(double[] dArray) {
        Transform3D transform3D = new Transform3D();
        this.geometryViewer.getTransform(transform3D);
        transform3D.get(dArray);
    }

    public void setNavigationType(int n) {
        this.geometryViewer.setNavigationType(n);
    }

    public int getNavigationType() {
        return this.geometryViewer.getNavigationType();
    }

    public void setPickLevel(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid pick level " + n);
        }
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Sorry, unimplemented pick level " + n);
        }
        this.pickLevel = n;
    }

    public int getPickLevel() {
        return this.pickLevel;
    }

    public void processPickEvent(PickEvent pickEvent) {
        StructureComponent structureComponent = (StructureComponent)pickEvent.userData;
        if (structureComponent == null) {
            return;
        }
        String string = structureComponent.getStructureComponentType();
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            int n;
            Atom atom = (Atom)structureComponent;
            StructureMap structureMap = atom.structure.getStructureMap();
            StructureStyles structureStyles = structureMap.getStructureStyles();
            boolean bl = !structureStyles.getAtomSelection(n = structureMap.getAtomIndex(atom));
            structureStyles.setAtomSelection(n, bl);
        } else if (string == StructureComponentRegistry.TYPE_BOND) {
            int n;
            Bond bond = (Bond)structureComponent;
            StructureMap structureMap = bond.structure.getStructureMap();
            StructureStyles structureStyles = structureMap.getStructureStyles();
            boolean bl = !structureStyles.getBondSelection(n = structureMap.getBondIndex(bond));
            structureStyles.setBondSelection(n, bl);
        } else if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
            Fragment fragment = (Fragment)structureComponent;
            StructureMap structureMap = fragment.structure.getStructureMap();
            StructureStyles structureStyles = structureMap.getStructureStyles();
            int n = structureMap.getFragmentIndex(fragment);
            if (this.pickLevel == 2) {
                boolean bl = !structureStyles.getFragmentSelection(n);
                structureStyles.setFragmentSelection(n, bl);
            } else if (this.pickLevel == 1) {
                Chain chain;
                Residue residue;
                int n2;
                Hashtable hashtable = (Hashtable)this.structureHash.get(structureComponent.structure);
                if (hashtable == null) {
                    return;
                }
                SsGeometry ssGeometry = (SsGeometry)hashtable.get(structureComponent);
                Point3d point3d = pickEvent.point;
                double[] dArray = new double[]{point3d.x, point3d.y, point3d.z};
                int n3 = n2 = ssGeometry.getClosestResidueIndex(dArray);
                Fragment fragment2 = (Fragment)ssGeometry.getUserData();
                int n4 = fragment2.getStartResidueIndex();
                n3 += n4;
                if (ssGeometry.isLeftExtended()) {
                    --n3;
                }
                boolean bl = !structureStyles.getResidueSelection(residue = (chain = fragment2.getChain()).getResidue(n3));
                structureStyles.setResidueSelection(structureMap.getResidueIndex(residue), bl);
            }
        }
    }

    public void processStructureStylesEvent(StructureStylesEvent structureStylesEvent) {
        StructureComponent structureComponent = structureStylesEvent.structureComponent;
        Structure structure = structureComponent.structure;
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        String string = structureComponent.getStructureComponentType();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        if (hashtable == null) {
            return;
        }
        Object v = hashtable.get(structureComponent);
        int n = structureStylesEvent.property;
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            if (v == null) {
                return;
            }
            Atom atom = (Atom)structureComponent;
            int n2 = structureMap.getAtomIndex(atom);
            Object var12_18 = null;
            if (n == 8) {
                ((AtomGeometry)v).updateRadius(structureStyles.getAtomRadius(n2));
            } else if (n == 2 || n == 4) {
                if (structureStyles.getAtomSelection(n2)) {
                    StructureStyles.getSelectionColor(this.scratchColor);
                } else {
                    structureStyles.getAtomColor(atom, this.scratchColor);
                }
                ((AtomGeometry)v).updateColor(this.scratchColor);
            }
        } else if (string == StructureComponentRegistry.TYPE_BOND) {
            if (v == null) {
                return;
            }
            Bond bond = (Bond)structureComponent;
            int n3 = structureMap.getBondIndex(bond);
            BondGeometry bondGeometry = (BondGeometry)v;
            if (n == 2 || n == 4) {
                if (structureStyles.getBondSelection(n3)) {
                    StructureStyles.getSelectionColor(this.scratchColor2[0]);
                    StructureStyles.getSelectionColor(this.scratchColor2[1]);
                } else {
                    structureStyles.getBondColor(n3, this.scratchColor2[0]);
                    structureStyles.getSplitBondColor(n3, this.scratchColor2[1]);
                }
                bondGeometry.updateColorMap(this.scratchColor2);
            }
        } else if (string == StructureComponentRegistry.TYPE_FRAGMENT) {
            if (v == null) {
                return;
            }
            if (this.pickLevel == 1) {
                return;
            }
            Fragment fragment = (Fragment)structureComponent;
            int n4 = structureMap.getFragmentIndex(fragment);
            SsGeometry ssGeometry = null;
            if (v != null) {
                ssGeometry = (SsGeometry)v;
            }
            if (n == 2 || n == 4) {
                if (structureStyles.getFragmentSelection(n4)) {
                    StructureStyles.getSelectionColor(this.scratchColor1[0]);
                    ssGeometry.updateColorMap(this.scratchColor1);
                } else {
                    int n5 = fragment.getStartResidueIndex();
                    int n6 = fragment.getEndResidueIndex();
                    if (ssGeometry.isLeftExtended()) {
                        --n5;
                    }
                    if (ssGeometry.isRightExtended()) {
                        ++n6;
                    }
                    Chain chain = fragment.getChain();
                    float[][] fArray = new float[n6 - n5 + 1][3];
                    for (int i = n5; i <= n6; ++i) {
                        Residue residue = chain.getResidue(i);
                        structureStyles.getResidueColor(residue, fArray[i - n5]);
                    }
                    ssGeometry.updateColorMap(fArray);
                }
            }
        } else if (string == StructureComponentRegistry.TYPE_RESIDUE) {
            Fragment fragment = ((Residue)structureComponent).getFragment();
            SsGeometry ssGeometry = null;
            Chain chain = fragment.getChain();
            int n7 = chain.getResidueIndex((Residue)structureComponent);
            v = hashtable.get(fragment);
            if (v == null) {
                return;
            }
            ssGeometry = (SsGeometry)v;
            if (n == 2 || n == 4) {
                int n8 = fragment.getStartResidueIndex();
                int n9 = fragment.getEndResidueIndex();
                if (ssGeometry.isLeftExtended()) {
                    --n8;
                }
                if (ssGeometry.isRightExtended()) {
                    ++n9;
                }
                float[] fArray = new float[3];
                if (structureStyles.getResidueSelection((Residue)structureComponent)) {
                    StructureStyles.getSelectionColor(fArray);
                    ssGeometry.updateColorMap(fArray, n7 - n8);
                } else {
                    structureStyles.getResidueColor((Residue)structureComponent, fArray);
                    ssGeometry.updateColorMap(fArray, n7 - n8);
                    if (n9 - n7 == 1 && ssGeometry.isRightExtended() && !structureStyles.getResidueSelection(chain.getResidue(n9))) {
                        structureStyles.getResidueColor(chain.getResidue(n9), fArray);
                        ssGeometry.updateColorMap(fArray, n9 - n8);
                    }
                    if (n7 - n8 == 1 && ssGeometry.isLeftExtended() && !structureStyles.getResidueSelection(chain.getResidue(n8))) {
                        structureStyles.getResidueColor(chain.getResidue(n8), fArray);
                        ssGeometry.updateColorMap(fArray, 0);
                    }
                }
            }
        }
    }

    public StructureDocument getStructureDocument() {
        return this.structureDocument;
    }

    public void processStructureDocumentEvent(StructureDocumentEvent structureDocumentEvent) {
        Status.output(4, "StructureViewer.processStructureDocumentEvent: " + structureDocumentEvent);
        int n = structureDocumentEvent.type;
        int n2 = structureDocumentEvent.change;
        if (n == 0) {
            if (n2 == 0) {
                this.structureDocument = structureDocumentEvent.structureDocument;
                this.viewerAdded(structureDocumentEvent.viewer);
            } else if (n2 == 1) {
                this.structureDocument = null;
                this.viewerRemoved(structureDocumentEvent.viewer);
            }
        } else if (n == 1) {
            if (n2 == 0) {
                this.structureAdded(structureDocumentEvent.structure);
            } else if (n2 == 1) {
                this.structureRemoved(structureDocumentEvent.structure);
            }
        }
    }

    private void viewerAdded(Viewer viewer) {
        if (viewer != this) {
            return;
        }
        int n = this.structureDocument.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            this.structureAdded(structure);
        }
        this.resetView();
    }

    private void viewerRemoved(Viewer viewer) {
        if (viewer != this) {
            return;
        }
        int n = this.structureDocument.getStructureCount();
        for (int i = 0; i < n; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            this.structureRemoved(structure);
        }
    }

    private void structureAdded(Structure structure) {
        Status.progress(0.3f, "StructureViewer adding structure...");
        Hashtable<Structure, BranchGroup> hashtable = (Hashtable<Structure, BranchGroup>)this.structureHash.get(structure);
        if (hashtable != null) {
            throw new IllegalArgumentException("structure already added");
        }
        hashtable = new Hashtable<Structure, BranchGroup>();
        this.structureHash.put(structure, hashtable);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(14);
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.setCapability(13);
        hashtable.put(structure, branchGroup);
        Status.progress(0.6f, "StructureViewer obtaining StructureMap...");
        StructureMap structureMap = structure.getStructureMap();
        Status.progress(0.9f, "StructureViewer obtaining StructureStyles...");
        StructureStyles structureStyles = structureMap.getStructureStyles();
        if (structureMap.getAtomCount() < 0) {
            return;
        }
        structureStyles.addStructureStylesEventListener(this);
        int n = structureMap.getResidueCount();
        int n2 = (int)((float)n / 100.0f);
        if (n2 <= 0) {
            n2 = 1;
        }
        boolean bl = false;
        Vector3d vector3d = new Vector3d();
        int n3 = structureMap.getChainCount();
        float[] fArray = new float[3];
        double[] dArray = new double[3];
        Status.progress(0.0f, "Generating geometry...");
        boolean bl2 = false;
        for (int i = 0; i < n3; ++i) {
            Chain chain = structureMap.getChain(i);
            int n4 = chain.getResidueCount();
        }
        this.buildView(structure, branchGroup, defaultView);
        Status.progress(1.0f, null);
        String string = structure.getUrlString();
        try {
            this.geometryViewer.putTree(string, (Group)branchGroup);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.geometryViewer.removeTree(string);
            Status.output(1, "StructureViewer.structureAdded: Not enough memory to render structure " + string);
        }
        this.resetView();
        Status.progress(1.0f, null);
        branchGroup = null;
    }

    public void buildView(int n) {
        int n2 = this.structureDocument.getStructureCount();
        for (int i = 0; i < n2; ++i) {
            Structure structure = this.structureDocument.getStructure(i);
            BranchGroup branchGroup = (BranchGroup)this.geometryViewer.getTree(structure.getUrlString());
            this.cleanScene(structure);
            this.buildView(structure, branchGroup, n);
        }
    }

    public void buildView(Structure structure, int n) {
        BranchGroup branchGroup = (BranchGroup)this.geometryViewer.getTree(structure.getUrlString());
        this.buildView(structure, branchGroup, n);
    }

    private void buildView(Structure structure, BranchGroup branchGroup, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = this.bondSelection;
        int n4 = this.ribbonStyle;
        int n5 = CrossSectionStyle.POINT;
        switch (n) {
            case 0: {
                bl = false;
                n2 = 0;
                n3 = 0;
                n4 = 2;
                n5 = CrossSectionStyle.ROUNDED_TUBE;
                this.addAtoms(structure, branchGroup, n2, bl);
                this.addBonds(structure, branchGroup, n3, n5);
                this.addSs(structure, branchGroup, n4, 0, 2, 2, 0);
                break;
            }
            case 1: {
                n2 = 1;
                n3 = 1;
                n5 = CrossSectionStyle.ROUNDED_TUBE;
                this.addAtoms(structure, branchGroup, n2, bl);
                this.addBonds(structure, branchGroup, n3, n5);
                break;
            }
            case 2: {
                n3 = 1;
                n5 = CrossSectionStyle.POINT;
                this.addBonds(structure, branchGroup, n3, n5);
                break;
            }
            case 3: {
                n4 = 1;
                this.addSs(structure, branchGroup, n4);
                break;
            }
            case 4: {
                n4 = 2;
                this.addSs(structure, branchGroup, n4, 3, 2, 2, 0);
                break;
            }
        }
    }

    private void changeSsRendering(Structure structure, int n) {
        BranchGroup branchGroup = (BranchGroup)this.geometryViewer.getTree(structure.getUrlString());
        this.removeSs(structure, branchGroup);
        this.addSs(structure, branchGroup, n);
    }

    public void addSs(Structure structure, BranchGroup branchGroup, int n) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        Status.progress(0.0f, "Adding secondary structure elements ...");
        if (n == 1) {
            boolean bl = false;
            try {
                SsGeometry.drawSs(branchGroup, structureMap, structureStyles, bl, hashtable);
            }
            catch (FragmentTooShortException fragmentTooShortException) {
                System.err.println(fragmentTooShortException.toString());
            }
        } else if (n == 2) {
            boolean bl = true;
            try {
                SsGeometry.drawSs(branchGroup, structureMap, structureStyles, bl, hashtable);
            }
            catch (FragmentTooShortException fragmentTooShortException) {
                System.err.println(fragmentTooShortException.toString());
            }
        }
        Status.progress(1.0f, null);
    }

    public void addSs(Structure structure, BranchGroup branchGroup, int n, int n2, int n3, int n4, int n5) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        Status.progress(0.0f, "Adding secondary structure elements ...");
        if (n == 1) {
            boolean bl = false;
            try {
                SsGeometry.drawSs(branchGroup, structureMap, structureStyles, bl, hashtable, n2, n3, n4, n5);
            }
            catch (FragmentTooShortException fragmentTooShortException) {
                System.err.println(fragmentTooShortException.toString());
            }
        } else if (n == 2) {
            boolean bl = true;
            try {
                SsGeometry.drawSs(branchGroup, structureMap, structureStyles, bl, hashtable, n2, n3, n4, n5);
            }
            catch (FragmentTooShortException fragmentTooShortException) {
                System.err.println(fragmentTooShortException.toString());
            }
        }
        Status.progress(1.0f, null);
    }

    public void addFragment(Structure structure, Fragment fragment, SsGeometry ssGeometry, BranchGroup branchGroup, int n, int n2, int n3, int n4, int n5) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        Status.progress(0.0f, "Adding secondary structure elements ...");
        if (ssGeometry != null) {
            if (n == 1) {
                ssGeometry.setCrossSectionType(CrossSectionStyle.POINT);
            }
            hashtable.put(fragment, ssGeometry);
            branchGroup.addChild((Node)ssGeometry.generateJ3dGeometry());
            return;
        }
        Status.progress(1.0f, null);
    }

    public void removeSs(Structure structure, BranchGroup branchGroup) {
        StructureMap structureMap = structure.getStructureMap();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        SsGeometry ssGeometry = null;
        Status.progress(0.0f, "Removing secondary structure elements ...");
        int n = structureMap.getChainCount();
        Fragment fragment = null;
        Chain chain = null;
        for (int i = 0; i < n; ++i) {
            chain = structureMap.getChain(i);
            int n2 = chain.getFragmentCount();
            for (int j = 0; j < n2; ++j) {
                fragment = chain.getFragment(j);
                ssGeometry = (SsGeometry)hashtable.get(fragment);
                if (ssGeometry == null) continue;
                int n3 = branchGroup.indexOfChild((Node)ssGeometry.getBranch());
                branchGroup.removeChild(n3);
                hashtable.remove(fragment);
            }
        }
        Status.progress(1.0f, null);
    }

    public SsGeometry removeFragment(Structure structure, Fragment fragment) {
        BranchGroup branchGroup = (BranchGroup)this.geometryViewer.getTree(structure.getUrlString());
        StructureMap structureMap = structure.getStructureMap();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        SsGeometry ssGeometry = null;
        Status.progress(0.0f, "Removing secondary structure elements ...");
        ssGeometry = (SsGeometry)hashtable.get(fragment);
        if (ssGeometry != null) {
            int n = branchGroup.indexOfChild((Node)ssGeometry.getBranch());
            branchGroup.removeChild(n);
            hashtable.remove(fragment);
        }
        Status.progress(1.0f, null);
        return ssGeometry;
    }

    public void addAtoms(Structure structure, BranchGroup branchGroup, int n, boolean bl) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        int n2 = structureMap.getAtomCount();
        int n3 = (int)((float)n2 / 100.0f);
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n == 0) {
            for (int i = 0; i < n2; ++i) {
                if (i % n3 == 0) {
                    Status.progress((float)i / (float)n2, "Generating atom geometry...");
                }
                if (!structureStyles.getAtomVisibility(i)) continue;
                Atom atom = structureMap.getAtom(i);
                AtomGeometry atomGeometry = new AtomGeometry(atom, i);
                if (bl) {
                    String string = structureStyles.getAtomLabel(atom);
                    LabelJ3D labelJ3D = new LabelJ3D(string, atom.coordinate);
                    atomGeometry.setLabel(labelJ3D);
                }
                hashtable.put(atom, atomGeometry);
                branchGroup.addChild((Node)atomGeometry.generateJ3dGeometry());
            }
        } else if (n == 1) {
            for (int i = 0; i < n2; ++i) {
                if (i % n3 == 0) {
                    Status.progress((float)i / (float)n2, "Generating atom geometry...");
                }
                Atom atom = structureMap.getAtom(i);
                AtomGeometry atomGeometry = new AtomGeometry(atom, i);
                if (bl) {
                    String string = structureStyles.getAtomLabel(atom);
                    LabelJ3D labelJ3D = new LabelJ3D(string, atom.coordinate);
                    atomGeometry.setLabel(labelJ3D);
                }
                hashtable.put(atom, atomGeometry);
                branchGroup.addChild((Node)atomGeometry.generateJ3dGeometry());
            }
        } else {
            System.err.println("Atom rendering mode unknown ");
        }
        Status.progress(1.0f, null);
    }

    public void addAtom(Structure structure, Atom atom, BranchGroup branchGroup, int n, boolean bl) {
        this.addAtom(structure, atom, null, branchGroup, n, bl);
    }

    public void addAtom(Structure structure, Atom atom, PsGeometry psGeometry, BranchGroup branchGroup, int n, boolean bl) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        if (psGeometry != null) {
            if (n == 0) {
                if (structureStyles.getAtomVisibility(atom)) {
                    if (bl) {
                        String string = structureStyles.getAtomLabel(atom);
                        LabelJ3D labelJ3D = new LabelJ3D(string, atom.coordinate);
                        psGeometry.setLabel(labelJ3D);
                    }
                    hashtable.put(atom, psGeometry);
                    branchGroup.addChild((Node)psGeometry.generateJ3dGeometry());
                }
            } else if (n == 1) {
                if (bl) {
                    String string = structureStyles.getAtomLabel(atom);
                    LabelJ3D labelJ3D = new LabelJ3D(string, atom.coordinate);
                    psGeometry.setLabel(labelJ3D);
                }
                hashtable.put(atom, psGeometry);
                branchGroup.addChild((Node)psGeometry.generateJ3dGeometry());
            }
            return;
        }
        if (n == 0) {
            if (structureStyles.getAtomVisibility(atom)) {
                AtomGeometry atomGeometry = new AtomGeometry(atom);
                if (bl) {
                    String string = structureStyles.getAtomLabel(atom);
                    LabelJ3D labelJ3D = new LabelJ3D(string, atom.coordinate);
                    atomGeometry.setLabel(labelJ3D);
                }
                hashtable.put(atom, atomGeometry);
                branchGroup.addChild((Node)atomGeometry.generateJ3dGeometry());
            }
        } else if (n == 1) {
            AtomGeometry atomGeometry = new AtomGeometry(atom);
            if (bl) {
                String string = structureStyles.getAtomLabel(atom);
                LabelJ3D labelJ3D = new LabelJ3D(string, atom.coordinate);
                atomGeometry.setLabel(labelJ3D);
            }
            hashtable.put(atom, atomGeometry);
            branchGroup.addChild((Node)atomGeometry.generateJ3dGeometry());
        } else {
            System.err.println("Atom rendering mode unknown ");
        }
    }

    public void removeAtoms(Structure structure, BranchGroup branchGroup) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        AtomGeometry atomGeometry = null;
        int n = structureMap.getAtomCount();
        int n2 = (int)((float)n / 100.0f);
        if (n2 <= 0) {
            n2 = 1;
        }
        for (int i = 0; i < n; ++i) {
            Atom atom;
            if (i % n2 == 0) {
                Status.progress((float)i / (float)n, "Removing atom geometry...");
            }
            if ((atomGeometry = (AtomGeometry)hashtable.get(atom = structureMap.getAtom(i))) == null) continue;
            int n3 = branchGroup.indexOfChild((Node)atomGeometry.getBranch());
            branchGroup.removeChild(n3);
            hashtable.remove(atom);
        }
        Status.progress(1.0f, null);
    }

    public PsGeometry removeAtom(Structure structure, Atom atom) {
        BranchGroup branchGroup = (BranchGroup)this.geometryViewer.getTree(structure.getUrlString());
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        AtomGeometry atomGeometry = null;
        atomGeometry = (AtomGeometry)hashtable.get(atom);
        if (atomGeometry != null) {
            int n = branchGroup.indexOfChild((Node)atomGeometry.getBranch());
            branchGroup.removeChild(n);
            hashtable.remove(atom);
        }
        return atomGeometry;
    }

    private void changeBonds(Structure structure, int n) {
        BranchGroup branchGroup = (BranchGroup)this.geometryViewer.getTree(structure.getUrlString());
        this.removeBonds(structure, branchGroup);
        this.addBonds(structure, branchGroup, n, 6);
    }

    public void addBonds(Structure structure, BranchGroup branchGroup, int n, int n2) {
        int n3;
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        Object var8_8 = null;
        int n4 = structureMap.getBondCount();
        Bond bond = null;
        Status.progress(0.0f, "Generating bond geometry...");
        Vector<Bond> vector = new Vector<Bond>();
        if (n == 0) {
            for (n3 = 0; n3 < n4; ++n3) {
                bond = structureMap.getBond(n3);
                int n5 = structureMap.getBondIndex(bond);
                if (!structureStyles.getBondVisibility(n5)) continue;
                vector.add(bond);
            }
        } else if (n == 1) {
            for (n3 = 0; n3 < n4; ++n3) {
                bond = structureMap.getBond(n3);
                int n6 = structureMap.getBondIndex(bond);
                vector.add(bond);
            }
        }
        float f = 0.8f;
        vector.trimToSize();
        Bond[] bondArray = new Bond[vector.size()];
        vector.toArray(bondArray);
        PsGeometry.drawBonds(branchGroup, bondArray, structureStyles, n2, f, 0, hashtable);
        Status.progress(1.0f, null);
    }

    private void addBond(Structure structure, Bond bond, BondGeometry bondGeometry, BranchGroup branchGroup, int n, int n2) {
        StructureMap structureMap = structure.getStructureMap();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        StructureStyles structureStyles = structureMap.getStructureStyles();
        if (bondGeometry != null) {
            System.err.println("Adding a previously existent bond");
            hashtable.put(bond, bondGeometry);
            BranchGroup branchGroup2 = bondGeometry.generateJ3dGeometry();
            if (branchGroup2 == null) {
                System.err.println(" No figure created ");
            }
            System.err.println("User data: " + branchGroup2.getUserData());
            branchGroup.addChild((Node)branchGroup2);
            return;
        }
        Object var10_11 = null;
        if (n == 0) {
            int n3 = structureMap.getBondIndex(bond);
            if (!structureStyles.getBondVisibility(n3)) {
                return;
            }
        } else if (n == 1) {
            float f = 0.8f;
            Bond[] bondArray = new Bond[]{bond};
            PsGeometry.drawBonds(branchGroup, bondArray, structureStyles, n2, f, 0, hashtable);
        }
    }

    public void removeBonds(Structure structure, BranchGroup branchGroup) {
        StructureMap structureMap = structure.getStructureMap();
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        BondGeometry bondGeometry = null;
        Status.progress(0.0f, "Removing bond geometry...");
        int n = structureMap.getBondCount();
        Bond bond = null;
        for (int i = 0; i < n; ++i) {
            bond = structureMap.getBond(i);
            bondGeometry = (BondGeometry)hashtable.get(bond);
            if (bondGeometry == null) continue;
            int n2 = branchGroup.indexOfChild((Node)bondGeometry.getBranch());
            branchGroup.removeChild(n2);
            hashtable.remove(bond);
        }
        Status.progress(1.0f, null);
    }

    public PsGeometry removeBond(Structure structure, Bond bond) {
        BranchGroup branchGroup = (BranchGroup)this.geometryViewer.getTree(structure.getUrlString());
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        BondGeometry bondGeometry = null;
        bondGeometry = (BondGeometry)hashtable.get(bond);
        if (bondGeometry != null) {
            int n = branchGroup.indexOfChild((Node)bondGeometry.getBranch());
            branchGroup.removeChild(n);
            hashtable.remove(bond);
        }
        return bondGeometry;
    }

    public void cleanScene(Structure structure) {
        BranchGroup branchGroup = (BranchGroup)this.geometryViewer.getTree(structure.getUrlString());
        this.removeAtoms(structure, branchGroup);
        this.removeBonds(structure, branchGroup);
        this.removeSs(structure, branchGroup);
    }

    private void structureRemoved(Structure structure) {
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        structureStyles.removeStructureStylesEventListener(this);
        Hashtable hashtable = (Hashtable)this.structureHash.get(structure);
        hashtable.clear();
        this.structureHash.remove(structure);
        this.geometryViewer.removeTree(structure.getUrlString());
    }
}

