/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.viewers.StructureViewerImpl.FrenetTrihedron;
import edu.sdsc.mbt.viewers.StructureViewerImpl.IntrinsicCrossSection;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class AffineCrossSection {
    private IntrinsicCrossSection intrinsicCS = null;
    private int vertexCount = 0;
    private Point3d[] vertices;
    private Vector3f[] normals = null;
    private Color3f[] color = null;
    private Color3f sideColor = null;
    private FrenetTrihedron frenet = null;

    public AffineCrossSection(IntrinsicCrossSection intrinsicCrossSection, FrenetTrihedron frenetTrihedron) {
        this.intrinsicCS = intrinsicCrossSection;
        this.vertexCount = intrinsicCrossSection.getVertexCount();
        this.frenet = frenetTrihedron;
        this.vertices = this.generatePoints(this.intrinsicCS, frenetTrihedron);
        this.normals = this.generateNormals(this.intrinsicCS, frenetTrihedron);
    }

    public Point3d[] generatePoints(IntrinsicCrossSection intrinsicCrossSection, FrenetTrihedron frenetTrihedron) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d(frenetTrihedron.getOrigin());
        Point3d[] point3dArray = new Point3d[this.vertexCount];
        Vector3d[] vector3dArray = intrinsicCrossSection.getVectorVertices();
        for (int i = 0; i < this.vertexCount; ++i) {
            point3dArray[i] = new Point3d();
            vector3d.add((Tuple3d)this.generateGlobalVector(vector3dArray[i], frenetTrihedron), (Tuple3d)vector3d2);
            point3dArray[i].set((Tuple3d)vector3d);
        }
        return point3dArray;
    }

    public Vector3f[] generateNormals(IntrinsicCrossSection intrinsicCrossSection, FrenetTrihedron frenetTrihedron) {
        Vector3f[] vector3fArray = new Vector3f[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            vector3fArray[i] = new Vector3f();
            Vector3d[] vector3dArray = intrinsicCrossSection.getVectorNormals();
            vector3fArray[i].set((Tuple3d)this.generateGlobalVector(vector3dArray[i], frenetTrihedron));
            vector3fArray[i].normalize();
        }
        return vector3fArray;
    }

    private Vector3d generateGlobalVector(Vector3d vector3d, FrenetTrihedron frenetTrihedron) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d2.set((Tuple3d)frenetTrihedron.getTangent());
        vector3d2.scale(vector3d.x);
        vector3d3.set((Tuple3d)frenetTrihedron.getNormal());
        vector3d3.scale(vector3d.y);
        vector3d4.set((Tuple3d)frenetTrihedron.getBinormal());
        vector3d4.scale(vector3d.z);
        Vector3d vector3d5 = new Vector3d();
        vector3d5.add((Tuple3d)vector3d2, (Tuple3d)vector3d3);
        vector3d5.add((Tuple3d)vector3d4);
        return vector3d5;
    }

    public void scale(Tuple3d tuple3d) {
        IntrinsicCrossSection intrinsicCrossSection = new IntrinsicCrossSection(this.intrinsicCS);
        intrinsicCrossSection.scale(tuple3d);
        this.vertices = this.generatePoints(intrinsicCrossSection, this.frenet);
        this.normals = this.generateNormals(intrinsicCrossSection, this.frenet);
    }

    public void setColors(Color3f[] color3fArray) {
        this.color = color3fArray;
    }

    public void setSideColor(Color3f color3f) {
        this.sideColor = color3f;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public Color3f getSideColor() {
        return this.sideColor;
    }

    public Point3d[] getPointVertices() {
        return this.vertices;
    }

    public Vector3f[] getNormals() {
        return this.normals;
    }

    public Color3f[] getColors() {
        return this.color;
    }

    public FrenetTrihedron getFrenetTrihedron() {
        return this.frenet;
    }
}

