/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.viewables.StructureStyles;
import edu.sdsc.mbt.viewers.StructureViewerImpl.PsGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Sphere;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

public class AtomGeometry
extends PsGeometry {
    private Vector3d coord = null;
    private int diamDivisions = 10;
    private double stickRadius = 0.2;
    private double sphereRadius = 0.2;
    private Appearance sphereApp = null;
    private Object userData;

    public AtomGeometry(Vector3d vector3d, Appearance appearance, float f, double d, Object object) {
        this.coord = vector3d;
        this.sphereApp = appearance;
        this.quality = f;
        this.sphereRadius = d;
        this.userData = object;
    }

    public AtomGeometry(double[] dArray, Appearance appearance, float f, double d, Object object) {
        this.coord = new Vector3d(dArray[0], dArray[1], dArray[2]);
        this.sphereApp = appearance;
        this.quality = f;
        this.sphereRadius = d;
        this.userData = object;
    }

    public AtomGeometry(Atom atom, int n) {
        StructureMap structureMap = atom.structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Material material = new Material();
        float[] fArray = new float[3];
        material.setCapability(0);
        material.setCapability(1);
        if (structureStyles.getAtomSelection(n)) {
            StructureStyles.getSelectionColor(fArray);
        } else {
            structureStyles.getAtomColor(atom, fArray);
        }
        material.setDiffuseColor(fArray[0], fArray[1], fArray[2]);
        this.sphereApp = new Appearance();
        this.sphereApp.setMaterial(material);
        this.sphereApp.setCapability(0);
        this.sphereApp.setCapability(1);
        this.coord = new Vector3d(atom.coordinate[0], atom.coordinate[1], atom.coordinate[2]);
        this.quality = structureStyles.getRenderingQuality();
        this.sphereRadius = structureStyles.getAtomRadius(n);
        this.userData = atom;
    }

    public AtomGeometry(Atom atom) {
        StructureMap structureMap = atom.structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        Material material = new Material();
        float[] fArray = new float[3];
        material.setCapability(0);
        material.setCapability(1);
        if (structureStyles.getAtomSelection(atom)) {
            StructureStyles.getSelectionColor(fArray);
        } else {
            structureStyles.getAtomColor(atom, fArray);
        }
        material.setDiffuseColor(fArray[0], fArray[1], fArray[2]);
        this.sphereApp = new Appearance();
        this.sphereApp.setMaterial(material);
        this.sphereApp.setCapability(0);
        this.sphereApp.setCapability(1);
        this.coord = new Vector3d(atom.coordinate[0], atom.coordinate[1], atom.coordinate[2]);
        this.quality = structureStyles.getRenderingQuality();
        this.sphereRadius = structureStyles.getAtomRadius(atom);
        this.userData = atom;
    }

    public BranchGroup generateJ3dGeometry() {
        this.processQualityInfo(this.quality);
        this.branch = new BranchGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(this.coord);
        transform3D.setScale(this.sphereRadius);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.setCapability(14);
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        Sphere sphere = new Sphere(1.0f, this.diamDivisions, this.sphereApp);
        sphere.setUserData(this.userData);
        transformGroup.addChild((Node)sphere);
        this.branch.addChild((Node)transformGroup);
        if (this.label != null) {
            this.branch.addChild((Node)this.label);
        }
        this.branch.setCapability(14);
        this.branch.setCapability(12);
        this.branch.setCapability(13);
        this.branch.setUserData(this.userData);
        this.branch.setCapability(17);
        return this.branch;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public void setRadius(double d) {
        this.sphereRadius = d;
    }

    public void updateRadius(double d) {
        TransformGroup transformGroup = (TransformGroup)this.branch.getChild(0);
        if (transformGroup != null) {
            Transform3D transform3D = new Transform3D();
            transformGroup.getTransform(transform3D);
            transform3D.setScale(d);
            transformGroup.setTransform(transform3D);
        }
    }

    public Object getUserData(Object object) {
        return object;
    }

    public void updateColor(float[] fArray) {
        if (this.sphereApp != null) {
            this.sphereApp.getMaterial().setDiffuseColor(fArray[0], fArray[1], fArray[2]);
        }
    }

    private void processQualityInfo(float f) {
        int n = 4;
        int n2 = 20;
        this.diamDivisions = f < (float)n / (float)n2 ? n : (int)(f * (float)n2);
    }
}

