/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.viewers.StructureViewerImpl.AffineCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.BondLine;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CovalentBondStick;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionBuilder;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionStyle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.FrenetTrihedron;
import edu.sdsc.mbt.viewers.StructureViewerImpl.IntrinsicCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.PsGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Sphere;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BondGeometry
extends PsGeometry {
    private int bondsCsStyle = CrossSectionStyle.ROUNDED_TUBE;
    private float cutoffDistance = 1.9f;
    private float[][] colors = null;
    private float[][] stickColorMap = null;
    private Vector3d[] coords = null;
    private int facets = 10;
    private int diamDivisions = 10;
    private double stickRadius = 0.2;
    private double sphereRadius = 0.2;
    private boolean splitBond = false;
    private boolean cap1 = true;
    private boolean cap2 = true;
    private Object userData;

    public BondGeometry(Vector3d[] vector3dArray) {
        this.coords = vector3dArray;
    }

    public BondGeometry(Vector3d[] vector3dArray, float[][] fArray, Object object) {
        this.coords = vector3dArray;
        this.colors = fArray;
        this.userData = object;
        this.bondsCsStyle = CrossSectionStyle.ROUNDED_TUBE;
        this.sphereRadius = this.stickRadius;
    }

    public BranchGroup generateJ3dGeometry() {
        this.processQualityInfo(this.quality);
        if (this.bondsCsStyle != CrossSectionStyle.POINT) {
            double[] dArray = new double[]{2.0 * this.stickRadius};
            CrossSectionStyle crossSectionStyle = new CrossSectionStyle(this.bondsCsStyle, dArray);
            crossSectionStyle.setVertexCount(this.facets + 1);
            this.branch = this.getStick(crossSectionStyle, this.coords, this.colors, this.cutoffDistance);
        } else {
            double[] dArray = new double[]{3.0};
            CrossSectionStyle crossSectionStyle = new CrossSectionStyle(this.bondsCsStyle, dArray);
            this.branch = this.getLineStick(crossSectionStyle, this.coords, this.colors, this.cutoffDistance);
        }
        this.branch.setCapability(17);
        return this.branch;
    }

    private BranchGroup getStick(CrossSectionStyle crossSectionStyle, Vector3d[] vector3dArray, float[][] fArray, float f) {
        Sphere sphere = null;
        CovalentBondStick covalentBondStick = null;
        Shape3D shape3D = null;
        IntrinsicCrossSection intrinsicCrossSection = null;
        Vector3d[] vector3dArray2 = null;
        int[] nArray = null;
        FrenetTrihedron[] frenetTrihedronArray = null;
        AffineCrossSection[] affineCrossSectionArray = null;
        TransformGroup transformGroup = null;
        int n = this.facets + 1;
        Appearance appearance = null;
        Appearance appearance2 = null;
        Material material = null;
        Material material2 = null;
        Transform3D transform3D = new Transform3D();
        this.branch = new BranchGroup();
        if (this.cap1) {
            transform3D.set(vector3dArray[0]);
            transformGroup = new TransformGroup(transform3D);
            transformGroup.setCapability(14);
            transformGroup.setCapability(12);
            transformGroup.setCapability(13);
            material = new Material();
            material.setDiffuseColor(fArray[0][0], fArray[0][1], fArray[0][2]);
            material.setCapability(0);
            material.setCapability(1);
            appearance = new Appearance();
            appearance.setMaterial(material);
            appearance.setCapability(0);
            appearance.setCapability(1);
            sphere = new Sphere((float)this.sphereRadius, this.diamDivisions, appearance);
            sphere.setUserData(this.userData);
            transformGroup.addChild((Node)sphere);
            this.branch.addChild((Node)transformGroup);
        }
        if (this.cap2) {
            material2 = new Material();
            material2.setDiffuseColor(fArray[1][0], fArray[1][1], fArray[1][2]);
            material2.setCapability(0);
            material2.setCapability(1);
            appearance2 = new Appearance();
            appearance2.setMaterial(material2);
            appearance2.setCapability(0);
            appearance2.setCapability(1);
            transform3D.set(vector3dArray[1]);
            transformGroup = new TransformGroup(transform3D);
            transformGroup.setCapability(14);
            transformGroup.setCapability(12);
            transformGroup.setCapability(13);
            sphere = new Sphere((float)this.sphereRadius, this.diamDivisions, appearance2);
            sphere.setUserData(this.userData);
            transformGroup.addChild((Node)sphere);
            this.branch.addChild((Node)transformGroup);
        }
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        Appearance appearance3 = null;
        Material material3 = null;
        Vector3d vector3d = new Vector3d();
        intrinsicCrossSection = CrossSectionBuilder.getIntrinsicCrossSection(crossSectionStyle, null);
        material3 = new Material();
        material3.setDiffuseColor(fArray[1][0], fArray[1][1], fArray[1][2]);
        appearance3 = new Appearance();
        appearance3.setMaterial(material3);
        if (fArray[0].equals(fArray[1]) && !this.splitBond) {
            vector3dArray2 = new Vector3d[2];
            vector3dArray2[0] = vector3dArray2[1] = new Vector3d(1.0, 1.0, 1.0);
            frenetTrihedronArray = new FrenetTrihedron[2];
            affineCrossSectionArray = new AffineCrossSection[2];
            frenetTrihedronArray[0] = this.getTrihedron(vector3dArray[0], vector3dArray[1]);
            frenetTrihedronArray[0].setOriginOnly(vector3dArray[0]);
            frenetTrihedronArray[1] = new FrenetTrihedron(frenetTrihedronArray[0]);
            frenetTrihedronArray[1].setOriginOnly(vector3dArray[1]);
            affineCrossSectionArray[0] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[0]);
            affineCrossSectionArray[1] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[1]);
            nArray = new int[]{4 * this.facets};
            this.stickColorMap = new float[2][3];
            this.stickColorMap[1] = fArray[0];
            this.stickColorMap[0] = this.stickColorMap[1];
            covalentBondStick = new CovalentBondStick(2, 0, nArray, affineCrossSectionArray, this.stickColorMap);
            covalentBondStick.setCapability(18);
            covalentBondStick.setCapability(3);
            shape3D = new Shape3D((Geometry)covalentBondStick, appearance3);
            shape3D.setUserData(this.userData);
            shape3D.setCapability(12);
            this.branch.setCapability(12);
            this.branch.addChild((Node)shape3D);
        } else {
            vector3d.interpolate((Tuple3d)vector3dArray[0], (Tuple3d)vector3dArray[1], 0.5);
            vector3dArray2 = new Vector3d[3];
            vector3dArray2[1] = vector3dArray2[2] = new Vector3d(1.0, 1.0, 1.0);
            vector3dArray2[0] = vector3dArray2[2];
            frenetTrihedronArray = new FrenetTrihedron[3];
            affineCrossSectionArray = new AffineCrossSection[3];
            frenetTrihedronArray[0] = this.getTrihedron(vector3dArray[0], vector3dArray[1]);
            frenetTrihedronArray[1] = new FrenetTrihedron(frenetTrihedronArray[0]);
            frenetTrihedronArray[1].setOriginOnly(vector3d);
            frenetTrihedronArray[2] = new FrenetTrihedron(frenetTrihedronArray[0]);
            frenetTrihedronArray[2].setOriginOnly(vector3dArray[1]);
            affineCrossSectionArray[0] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[0]);
            affineCrossSectionArray[1] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[1]);
            affineCrossSectionArray[2] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[2]);
            nArray = new int[2];
            nArray[0] = nArray[1] = 4 * this.facets;
            this.stickColorMap = new float[3][3];
            this.stickColorMap[0] = fArray[0];
            this.stickColorMap[2] = fArray[1];
            this.stickColorMap[1] = this.stickColorMap[2];
            covalentBondStick = new CovalentBondStick(3, 0, nArray, affineCrossSectionArray, this.stickColorMap);
            covalentBondStick.setCapability(18);
            covalentBondStick.setCapability(3);
            shape3D = new Shape3D((Geometry)covalentBondStick, appearance3);
            shape3D.setUserData(this.userData);
            shape3D.setCapability(12);
            this.branch.setCapability(12);
            this.branch.addChild((Node)shape3D);
            this.splitBond = true;
        }
        return this.branch;
    }

    private BranchGroup getLineStick(CrossSectionStyle crossSectionStyle, Vector3d[] vector3dArray, float[][] fArray, float f) {
        this.cap1 = false;
        this.cap2 = false;
        float f2 = (float)crossSectionStyle.getDiameters()[0];
        Shape3D shape3D = null;
        int[] nArray = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Transform3D transform3D = new Transform3D();
        this.branch = new BranchGroup();
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        Appearance appearance = null;
        Material material = null;
        Vector3d vector3d = new Vector3d();
        material = new Material();
        material.setDiffuseColor(fArray[1][0], fArray[1][1], fArray[1][2]);
        appearance = new Appearance();
        appearance.setMaterial(material);
        if (fArray[0].equals(fArray[1]) && !this.splitBond) {
            nArray = new int[]{2};
            BondLine bondLine = new BondLine(nArray[0], nArray, vector3dArray, fArray, this.splitBond);
            appearance.setLineAttributes(new LineAttributes(f2, 0, false));
            bondLine.setCapability(18);
            bondLine.setCapability(3);
            shape3D = new Shape3D((Geometry)bondLine, appearance);
            shape3D.setUserData(this.userData);
            shape3D.setCapability(12);
            this.branch.setCapability(12);
            this.branch.addChild((Node)shape3D);
        } else {
            Vector3d[] vector3dArray2 = new Vector3d[3];
            vector3d.interpolate((Tuple3d)vector3dArray[0], (Tuple3d)vector3dArray[1], 0.5);
            vector3dArray2[0] = vector3dArray[0];
            vector3dArray2[1] = vector3d;
            vector3dArray2[2] = vector3dArray[1];
            nArray = new int[2];
            nArray[1] = 2;
            nArray[0] = 2;
            this.stickColorMap = new float[3][3];
            this.stickColorMap[0] = fArray[0];
            this.stickColorMap[2] = fArray[1];
            this.stickColorMap[1] = this.stickColorMap[2];
            BondLine bondLine = new BondLine(nArray[0] + nArray[1], nArray, vector3dArray, fArray, true);
            appearance.setLineAttributes(new LineAttributes(f2, 0, false));
            bondLine.setCapability(18);
            bondLine.setCapability(3);
            shape3D = new Shape3D((Geometry)bondLine, appearance);
            shape3D.setUserData(this.userData);
            shape3D.setCapability(12);
            this.branch.setCapability(12);
            this.branch.addChild((Node)shape3D);
            this.splitBond = true;
        }
        return this.branch;
    }

    FrenetTrihedron getTrihedron(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(1.0E-7, 1.0E-7, 1.0E-7);
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        Vector3d vector3d7 = new Vector3d();
        if (vector3d.epsilonEquals((Tuple3d)vector3d4, 1.0E-10)) {
            vector3d.add((Tuple3d)vector3d3);
        }
        if (vector3d2.epsilonEquals((Tuple3d)vector3d4, 1.0E-10)) {
            vector3d2.add((Tuple3d)vector3d3);
        }
        vector3d6.sub((Tuple3d)vector3d2, (Tuple3d)vector3d);
        vector3d6.normalize();
        vector3d5.cross(vector3d, vector3d2);
        if (vector3d5.epsilonEquals((Tuple3d)vector3d4, 1.0E-10)) {
            vector3d7.x *= 2.0;
            vector3d5.cross(vector3d7, vector3d2);
            if (vector3d5.epsilonEquals((Tuple3d)vector3d4, 1.0E-10)) {
                vector3d7.y *= 2.0;
                vector3d5.cross(vector3d7, vector3d2);
            }
        }
        double d = vector3d5.dot(vector3d6);
        vector3d7.set((Tuple3d)vector3d6);
        vector3d7.scale(d);
        vector3d5.sub((Tuple3d)vector3d7);
        vector3d5.normalize();
        return new FrenetTrihedron(vector3d, vector3d6, vector3d5);
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public void setSplit(boolean bl) {
        this.splitBond = bl;
    }

    public void setStyle(int n) {
        this.bondsCsStyle = n;
    }

    public void setColor1(float[] fArray) {
        if (this.colors == null) {
            this.colors = this.splitBond ? new float[3][3] : new float[2][3];
        }
        this.colors[0] = fArray;
    }

    public void setColor2(float[] fArray) {
        if (this.colors == null) {
            this.colors = this.splitBond ? new float[3][3] : new float[2][2];
        }
        this.colors[1] = fArray;
    }

    public void setStickRadius(double d) {
        this.stickRadius = d;
    }

    public void setCapsRadius(double d) {
        this.sphereRadius = d;
    }

    public void setCap1(boolean bl) {
        this.cap1 = bl;
    }

    public void setCap2(boolean bl) {
        this.cap2 = bl;
    }

    public double getStickRadius() {
        return this.stickRadius;
    }

    public double setCapsRadius() {
        return this.sphereRadius;
    }

    public Object getUserData(Object object) {
        return object;
    }

    public void updateColorMap(float[][] fArray) {
        this.colors = fArray;
        if (this.splitBond) {
            this.stickColorMap[0] = this.colors[0];
            this.stickColorMap[2] = this.colors[1];
            this.stickColorMap[1] = this.stickColorMap[2];
        } else {
            if (this.stickColorMap == null) {
                System.err.println("First color null ");
            }
            if (this.stickColorMap[1] == null) {
                System.err.println("Second color null ");
            }
            this.stickColorMap[1] = this.colors[0];
            this.stickColorMap[0] = this.stickColorMap[1];
        }
        Shape3D shape3D = null;
        TransformGroup transformGroup = null;
        Group group = null;
        Appearance appearance = null;
        Material material = null;
        int n = 0;
        if (this.cap1) {
            transformGroup = (TransformGroup)this.branch.getChild(n);
            group = (Group)transformGroup.getChild(0);
            shape3D = (Shape3D)group.getChild(0);
            appearance = shape3D.getAppearance();
            material = appearance.getMaterial();
            material.setDiffuseColor(this.colors[0][0], this.colors[0][1], this.colors[0][2]);
            ++n;
        }
        if (this.cap2) {
            transformGroup = (TransformGroup)this.branch.getChild(n);
            group = (Group)transformGroup.getChild(0);
            shape3D = (Shape3D)group.getChild(0);
            appearance = shape3D.getAppearance();
            material = appearance.getMaterial();
            material.setDiffuseColor(this.colors[1][0], this.colors[1][1], this.colors[1][2]);
            ++n;
        }
        shape3D = (Shape3D)this.branch.getChild(n);
        if (this.bondsCsStyle != CrossSectionStyle.POINT) {
            CovalentBondStick covalentBondStick = (CovalentBondStick)shape3D.getGeometry();
            covalentBondStick.setColors(this.stickColorMap);
        } else {
            BondLine bondLine = (BondLine)shape3D.getGeometry();
            bondLine.setColors(this.stickColorMap);
        }
    }

    private void processQualityInfo(float f) {
        int n = 4;
        int n2 = 10;
        this.facets = f < (float)n / (float)n2 ? n : (int)(f * (float)n2);
        int n3 = 10;
        int n4 = 2;
        this.diamDivisions = f < (float)n4 / (float)n3 ? n4 : (int)(f * (float)n3);
    }
}

