/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.viewers.StructureViewerImpl.AffineCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.BackboneLine;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionBuilder;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionStyle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Extrusion;
import edu.sdsc.mbt.viewers.StructureViewerImpl.FrenetTrihedron;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Hermite;
import edu.sdsc.mbt.viewers.StructureViewerImpl.IntrinsicCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.SsGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3d;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3f;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class CoilGeometry
extends SsGeometry {
    private double diameter = 0.6;
    private int facets = 14;
    private static float COIL_HERMITE_FACTOR = 0.7f;
    private int smoothingSteps = 2;
    private int polygonStyle;
    private int[] chainCounts = null;
    private Vector3d[] tangents = null;
    private Vector3d[] normals = null;
    private Shape3D shape = null;

    public CoilGeometry() {
        this.csType = CrossSectionStyle.ROUNDED_TUBE;
        this.uniformColor = true;
        this.polygonStyle = 2;
        this.userData = "Coil or Turn";
        this.facets = 6;
        this.segments = 6;
        this.diameter = coilWidth;
    }

    public BranchGroup generateJ3dGeometry() {
        int n;
        this.processQualityInfo(this.quality);
        Hermite hermite = new Hermite();
        hermite.setKnotWeight(COIL_HERMITE_FACTOR);
        if (this.csStyle == null) {
            double[] dArray = new double[]{this.diameter};
            this.csStyle = new CrossSectionStyle(this.csType, dArray);
            if (this.csType != 6) {
                this.csStyle.setVertexCount(this.facets + 1);
            } else {
                this.csStyle.setVertexCount(1);
            }
        }
        int n2 = (this.coords.length - 1) * this.segments + 1;
        Vector3d[] vector3dArray = new Vector3d[n2];
        FrenetTrihedron[] frenetTrihedronArray = new FrenetTrihedron[n2];
        this.tangents = new Vector3d[this.coords.length];
        this.normals = new Vector3d[this.coords.length];
        this.getAllTangentsAndNormals(this.coords, this.tangents, this.normals);
        Vec3d vec3d = new Vec3d();
        Vec3d vec3d2 = new Vec3d();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vec3d vec3d3 = new Vec3d();
        Vector3d vector3d3 = new Vector3d();
        FrenetTrihedron frenetTrihedron = null;
        FrenetTrihedron frenetTrihedron2 = null;
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        Vector3d vector3d7 = new Vector3d();
        Vector3d vector3d8 = new Vector3d();
        Vector3d vector3d9 = new Vector3d();
        hermite.setKnotWeight(2.0f);
        vector3d7.set((Tuple3d)this.tangents[0]);
        vector3d8.set((Tuple3d)this.tangents[1]);
        vector3d4 = this.normals[0];
        vector3d5 = this.normals[1];
        vector3d7.normalize();
        vector3d8.normalize();
        vector3d9.set((double)this.coords[0].value[0], (double)this.coords[0].value[1], (double)this.coords[0].value[2]);
        frenetTrihedron2 = new FrenetTrihedron(vector3d9, vector3d7, vector3d4);
        double d = 0.0;
        int n3 = -1;
        for (int i = 0; i < this.coords.length - 1; ++i) {
            vector3dArray[++n3] = new Vector3d((double)this.coords[i].value[0], (double)this.coords[i].value[1], (double)this.coords[i].value[2]);
            frenetTrihedronArray[n3] = new FrenetTrihedron(frenetTrihedron2);
            frenetTrihedron = frenetTrihedronArray[n3];
            hermite.set(this.coords[i].toVec3d(), this.coords[i + 1].toVec3d(), vector3d7, vector3d8);
            vector3d7.set((Tuple3d)this.tangents[i + 1]);
            vector3d4 = this.normals[i + 1];
            if (i >= this.coords.length - 2) {
                vector3d8 = vector3d7;
                vector3d5 = vector3d4;
            } else {
                vector3d8.set((Tuple3d)this.tangents[i + 2]);
                vector3d5 = this.normals[i + 2];
            }
            vector3d7.normalize();
            vector3d8.normalize();
            vector3d9.set((double)this.coords[i + 1].value[0], (double)this.coords[i + 1].value[1], (double)this.coords[i + 1].value[2]);
            frenetTrihedron2 = new FrenetTrihedron(vector3d9, vector3d7, vector3d4);
            for (n = 1; n < this.segments; ++n) {
                d = (double)n * (1.0 / (double)this.segments);
                frenetTrihedronArray[++n3] = new FrenetTrihedron();
                frenetTrihedronArray[n3].setTangent(hermite.getTangent(d));
                frenetTrihedronArray[n3].interpolateByBinormal(d, frenetTrihedron, frenetTrihedron2);
                hermite.sample(d, vec3d3);
                vector3d3.set(vec3d3.value[0], vec3d3.value[1], vec3d3.value[2]);
                frenetTrihedronArray[n3].setOriginOnly(vector3d3);
                vector3dArray[n3] = new Vector3d(vec3d3.value[0], vec3d3.value[1], vec3d3.value[2]);
            }
        }
        vector3dArray[++n3] = new Vector3d((double)this.coords[this.coords.length - 1].value[0], (double)this.coords[this.coords.length - 1].value[1], (double)this.coords[this.coords.length - 1].value[2]);
        frenetTrihedronArray[n3] = new FrenetTrihedron(frenetTrihedron2);
        double d2 = System.currentTimeMillis();
        if (this.uniformColor) {
            if (this.ssColor == null) {
                this.ssColor = new Color(1.0f, 0.0f, 0.0f);
            }
            Color3f[] color3fArray = new Color3f[]{new Color3f(this.ssColor)};
            this.csStyle.setVertexColors(color3fArray);
            this.pathColorMap = new float[n2][3];
            for (n = 0; n < n2; ++n) {
                this.pathColorMap[n] = this.ssColor.getColorComponents(null);
            }
        } else {
            this.setPathColor(n2);
        }
        double d3 = System.currentTimeMillis();
        this.branch = this.getFigure(this.csStyle, vector3dArray, frenetTrihedronArray, this.pathColorMap, n2);
        d2 = System.currentTimeMillis();
        this.branch.setCapability(17);
        this.branch.setCapability(12);
        return this.branch;
    }

    public BranchGroup getFigure(CrossSectionStyle crossSectionStyle, Vector3d[] vector3dArray, FrenetTrihedron[] frenetTrihedronArray, float[][] fArray, int n) {
        Material material = new Material();
        Color3f color3f = new Color3f(1.0f, 1.0f, 0.0f);
        Color3f color3f2 = new Color3f(0.7f, 0.7f, 0.7f);
        Color3f color3f3 = new Color3f(0.9f, 0.9f, 0.9f);
        Color3f color3f4 = new Color3f(0.05f, 0.05f, 0.05f);
        material.setSpecularColor(color3f2);
        material.setEmissiveColor(color3f4);
        material.setAmbientColor(color3f3);
        material.setShininess(128.0f);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        ColoringAttributes coloringAttributes = new ColoringAttributes(color3f, 1);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(1);
        polygonAttributes.setPolygonMode(this.polygonStyle);
        appearance.setPolygonAttributes(polygonAttributes);
        LineAttributes lineAttributes = new LineAttributes();
        Object object = null;
        BranchGroup branchGroup = new BranchGroup();
        int n2 = 0;
        int[] nArray = null;
        int n3 = crossSectionStyle.getVertexCount();
        if (this.csType == 6) {
            nArray = new int[]{n};
            object = new BackboneLine(n, nArray, vector3dArray, fArray);
            appearance = new Appearance();
            appearance.setLineAttributes(new LineAttributes(3.0f, 0, false));
        } else if (this.csType == 4) {
            nArray = new int[n + 1];
            nArray[0] = nArray[n] = 2 * n3;
            for (int i = 1; i < n; ++i) {
                nArray[i] = 4 * (crossSectionStyle.getVertexCount() - 1);
            }
            IntrinsicCrossSection intrinsicCrossSection = CrossSectionBuilder.getIntrinsicCrossSection(crossSectionStyle, frenetTrihedronArray[0].getTangent());
            AffineCrossSection[] affineCrossSectionArray = new AffineCrossSection[n];
            for (int i = 0; i < n; ++i) {
                affineCrossSectionArray[i] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[i]);
            }
            object = new Extrusion(n, n2, nArray, affineCrossSectionArray, fArray, n2, this.rounded);
        } else if (this.csType == 5) {
            nArray = new int[n + 1];
            nArray[0] = nArray[n] = 2 * n3;
            for (int i = 1; i < n; ++i) {
                nArray[i] = 4 * (crossSectionStyle.getVertexCount() - 1);
            }
            IntrinsicCrossSection intrinsicCrossSection = CrossSectionBuilder.getIntrinsicCrossSection(crossSectionStyle, frenetTrihedronArray[0].getTangent());
            intrinsicCrossSection.averageNormals();
            AffineCrossSection[] affineCrossSectionArray = new AffineCrossSection[n];
            Color3f color3f5 = new Color3f(1.0f, 1.0f, 1.0f);
            for (int i = 0; i < n; ++i) {
                affineCrossSectionArray[i] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[i]);
            }
            object = new Extrusion(n, n2, nArray, affineCrossSectionArray, fArray, n2, this.rounded);
        }
        object.setCapability(3);
        object.setCapability(3);
        object.setCapability(18);
        object.setCapability(3);
        this.shape = new Shape3D((Geometry)object, appearance);
        this.shape.setCapability(12);
        this.shape.setPickable(true);
        this.shape.setUserData(this.userData);
        branchGroup.addChild((Node)this.shape);
        return branchGroup;
    }

    private void smoothNormals(Vector3d[] vector3dArray, Vector3d[] vector3dArray2, int n) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        for (int i = 0; i < n; ++i) {
            vector3d4 = vector3dArray[0];
            for (int j = 1; j < vector3dArray.length - 1; ++j) {
                vector3d3.set((Tuple3d)vector3dArray[j]);
                vector3dArray[j].add((Tuple3d)vector3d4);
                vector3dArray[j].add((Tuple3d)vector3dArray[j + 1]);
                vector3d2.set((Tuple3d)vector3dArray2[j]);
                vector3d2.normalize();
                vector3d.set((Tuple3d)vector3d2);
                vector3d.scale(vector3dArray[j].dot(vector3d2));
                vector3dArray[j].sub((Tuple3d)vector3d);
                vector3dArray[j].normalize();
                vector3d4 = new Vector3d(vector3d3);
            }
        }
    }

    private void getTangentsAndNormals(int n, Vec3f[] vec3fArray, Vec3d vec3d, Vec3d vec3d2, Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = null;
        Vector3d vector3d4 = null;
        Object var9_9 = null;
        Vector3d vector3d5 = null;
        Vector3d vector3d6 = null;
        Vector3d vector3d7 = null;
        Vector3d vector3d8 = null;
        Vector3d vector3d9 = null;
        Vector3d vector3d10 = null;
        Vector3d vector3d11 = null;
        Vector3d vector3d12 = new Vector3d(0.0, 0.0, 0.0);
        if (vec3fArray.length == 2) {
            if (n == 0) {
                vector3d8 = new Vector3d((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
                vector3d7 = new Vector3d((double)vec3fArray[n].value[0], (double)vec3fArray[n].value[1], (double)vec3fArray[n].value[2]);
                if (this.previousCaCoord == null) {
                    vector3d3 = new Vector3d();
                    vector3d3.sub((Tuple3d)vector3d8, (Tuple3d)vector3d7);
                    vec3d.value[0] = vector3d3.x;
                    vec3d.value[1] = vector3d3.y;
                    vec3d.value[2] = vector3d3.z;
                    vec3d2 = vec3d;
                    vector3d.set((Tuple3d)vector3d3);
                    vector3d3.normalize();
                    if (vector3d.x != 0.0) {
                        vector3d.x *= 2.0;
                        vector3d3.scale(vector3d3.dot(vector3d));
                        vector3d11 = new Vector3d();
                        vector3d11.sub((Tuple3d)vector3d, (Tuple3d)vector3d3);
                        vector3d.set((Tuple3d)vector3d11);
                        if (vector3d.length() < 1.0E-6) {
                            vector3d.y += 1.0;
                        }
                        vector3d.normalize();
                        vector3d2 = vector3d;
                    }
                } else {
                    vector3d5 = new Vector3d((double)this.previousCaCoord.value[0], (double)this.previousCaCoord.value[1], (double)this.previousCaCoord.value[2]);
                    vector3d3 = new Vector3d();
                    vector3d3.sub((Tuple3d)vector3d8, (Tuple3d)vector3d5);
                    vec3d.value[0] = vector3d3.x;
                    vec3d.value[1] = vector3d3.y;
                    vec3d.value[2] = vector3d3.z;
                    if (this.nextCaCoord == null) {
                        vec3d2 = vec3d;
                        vector3d8.sub((Tuple3d)vector3d7);
                        vector3d7.sub((Tuple3d)vector3d5);
                        vector3d8.normalize();
                        vector3d7.normalize();
                        vector3d.sub((Tuple3d)vector3d8, (Tuple3d)vector3d7);
                        vector3d3.normalize();
                        vector3d3.scale(vector3d3.dot(vector3d));
                        vector3d.sub((Tuple3d)vector3d3);
                        vector3d.normalize();
                        vector3d2 = vector3d;
                    } else {
                        vector3d6 = new Vector3d((double)this.nextCaCoord.value[0], (double)this.nextCaCoord.value[1], (double)this.nextCaCoord.value[2]);
                        vector3d4 = new Vector3d();
                        vector3d4.sub((Tuple3d)vector3d6, (Tuple3d)vector3d7);
                        vec3d2.value[0] = vector3d4.x;
                        vec3d2.value[1] = vector3d4.y;
                        vec3d2.value[2] = vector3d4.z;
                        vector3d6.sub((Tuple3d)vector3d8);
                        vector3d8.sub((Tuple3d)vector3d7);
                        vector3d7.sub((Tuple3d)vector3d5);
                        vector3d6.normalize();
                        vector3d8.normalize();
                        vector3d7.normalize();
                        vector3d2.sub((Tuple3d)vector3d6, (Tuple3d)vector3d8);
                        vector3d.sub((Tuple3d)vector3d8, (Tuple3d)vector3d7);
                        vector3d3.normalize();
                        vector3d4.normalize();
                        vector3d3.scale(vector3d3.dot(vector3d));
                        vector3d4.scale(vector3d4.dot(vector3d2));
                        vector3d.sub((Tuple3d)vector3d3);
                        vector3d2.sub((Tuple3d)vector3d4);
                        vector3d2.normalize();
                        vector3d.normalize();
                        if (vector3d2.dot(vector3d) <= 0.0) {
                            vector3d2.negate();
                        }
                    }
                }
            } else if (n == vec3fArray.length - 1) {
                if (this.previousCaCoord != null) {
                    vec3d.value[0] = vec3d2.value[0];
                    vec3d.value[1] = vec3d2.value[1];
                    vec3d.value[2] = vec3d2.value[2];
                    vector3d.set((Tuple3d)vector3d2);
                }
            } else {
                System.out.println("getTangentsAndNormals called with an inconsistent index: out of data range");
            }
            return;
        }
        double d = 1.0;
        if (n == 0) {
            vector3d9 = new Vector3d((double)vec3fArray[n + 2].value[0], (double)vec3fArray[n + 2].value[1], (double)vec3fArray[n + 2].value[2]);
            vector3d8 = new Vector3d((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
            vector3d7 = new Vector3d((double)vec3fArray[n].value[0], (double)vec3fArray[n].value[1], (double)vec3fArray[n].value[2]);
            if (this.previousCaCoord == null) {
                vector3d4 = new Vector3d();
                vector3d4.sub((Tuple3d)vector3d9, (Tuple3d)vector3d7);
                vector3d3 = new Vector3d();
                vector3d3.sub((Tuple3d)vector3d8, (Tuple3d)vector3d7);
                vec3d.value[0] = vector3d3.x;
                vec3d.value[1] = vector3d3.y;
                vec3d.value[2] = vector3d3.z;
                vec3d2.value[0] = vector3d4.x;
                vec3d2.value[1] = vector3d4.y;
                vec3d2.value[2] = vector3d4.z;
                vector3d9.sub((Tuple3d)vector3d8);
                vector3d8.sub((Tuple3d)vector3d7);
                vector3d9.normalize();
                vector3d8.normalize();
                vector3d2.sub((Tuple3d)vector3d9, (Tuple3d)vector3d8);
                vector3d4.normalize();
                vector3d4.scale(vector3d4.dot(vector3d2));
                vector3d2.sub((Tuple3d)vector3d4);
                vector3d2.normalize();
                vector3d.set((Tuple3d)vector3d2);
                d = vector3d.dot(vector3d8);
                vector3d8.scale(d);
                vector3d.sub((Tuple3d)vector3d8);
                vector3d.normalize();
                FrenetTrihedron.setPreviousNormal(vector3d);
                if (vector3d2.dot(FrenetTrihedron.getPreviousNormal()) <= 0.0) {
                    vector3d2.negate();
                }
                FrenetTrihedron.setPreviousNormal(vector3d2);
            } else {
                vector3d5 = new Vector3d((double)this.previousCaCoord.value[0], (double)this.previousCaCoord.value[1], (double)this.previousCaCoord.value[2]);
                vector3d4 = new Vector3d();
                vector3d4.sub((Tuple3d)vector3d9, (Tuple3d)vector3d7);
                vector3d3 = new Vector3d();
                vector3d3.sub((Tuple3d)vector3d8, (Tuple3d)vector3d5);
                vec3d.value[0] = vector3d3.x;
                vec3d.value[1] = vector3d3.y;
                vec3d.value[2] = vector3d3.z;
                vec3d2.value[0] = vector3d4.x;
                vec3d2.value[1] = vector3d4.y;
                vec3d2.value[2] = vector3d4.z;
                vector3d9.sub((Tuple3d)vector3d8);
                vector3d8.sub((Tuple3d)vector3d7);
                vector3d7.sub((Tuple3d)vector3d5);
                vector3d9.normalize();
                vector3d8.normalize();
                vector3d7.normalize();
                vector3d2.sub((Tuple3d)vector3d9, (Tuple3d)vector3d8);
                vector3d.sub((Tuple3d)vector3d8, (Tuple3d)vector3d7);
                vector3d3.normalize();
                vector3d4.normalize();
                vector3d3.scale(vector3d3.dot(vector3d));
                vector3d4.scale(vector3d4.dot(vector3d2));
                vector3d.sub((Tuple3d)vector3d3);
                vector3d2.sub((Tuple3d)vector3d4);
                vector3d2.normalize();
                vector3d.normalize();
                FrenetTrihedron.setPreviousNormal(vector3d);
                if (vector3d2.dot(FrenetTrihedron.getPreviousNormal()) <= 0.0) {
                    vector3d2.negate();
                }
                FrenetTrihedron.setPreviousNormal(vector3d2);
            }
        } else if (n == vec3fArray.length - 2) {
            vector3d8 = new Vector3d((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
            vector3d7 = new Vector3d((double)vec3fArray[n].value[0], (double)vec3fArray[n].value[1], (double)vec3fArray[n].value[2]);
            if (this.nextCaCoord == null) {
                vec3d.value[0] = vec3d2.value[0];
                vec3d.value[1] = vec3d2.value[1];
                vec3d.value[2] = vec3d2.value[2];
                vector3d.set((Tuple3d)vector3d2);
                vector3d4 = new Vector3d();
                vector3d4.sub((Tuple3d)vector3d8, (Tuple3d)vector3d7);
                vec3d2.value[0] = vector3d4.x;
                vec3d2.value[1] = vector3d4.y;
                vec3d2.value[2] = vector3d4.z;
                vector3d8.sub((Tuple3d)vector3d7);
                vector3d8.normalize();
                d = vector3d2.dot(vector3d8);
                vector3d8.scale(d);
                vector3d2.sub((Tuple3d)vector3d8);
                vector3d2.normalize();
                if (vector3d2.dot(FrenetTrihedron.getPreviousNormal()) < 0.0) {
                    vector3d2.negate();
                }
                FrenetTrihedron.setPreviousNormal(vector3d2);
            } else {
                vector3d6 = new Vector3d((double)this.nextCaCoord.value[0], (double)this.nextCaCoord.value[1], (double)this.nextCaCoord.value[2]);
                vec3d.value[0] = vec3d2.value[0];
                vec3d.value[1] = vec3d2.value[1];
                vec3d.value[2] = vec3d2.value[2];
                vector3d.set((Tuple3d)vector3d2);
                vector3d4 = new Vector3d();
                vector3d4.sub((Tuple3d)vector3d6, (Tuple3d)vector3d7);
                vec3d2.value[0] = vector3d4.x;
                vec3d2.value[1] = vector3d4.y;
                vec3d2.value[2] = vector3d4.z;
                vector3d6.sub((Tuple3d)vector3d8);
                vector3d8.sub((Tuple3d)vector3d7);
                vector3d6.normalize();
                vector3d8.normalize();
                vector3d2.sub((Tuple3d)vector3d6, (Tuple3d)vector3d8);
                vector3d4.normalize();
                vector3d4.scale(vector3d4.dot(vector3d2));
                vector3d2.sub((Tuple3d)vector3d4);
                vector3d2.normalize();
                if (vector3d2.dot(FrenetTrihedron.getPreviousNormal()) < 0.0) {
                    vector3d2.negate();
                }
                FrenetTrihedron.setPreviousNormal(vector3d2);
            }
        } else if (n == vec3fArray.length - 1) {
            vec3d.value[0] = vec3d2.value[0];
            vec3d.value[1] = vec3d2.value[1];
            vec3d.value[2] = vec3d2.value[2];
            vector3d.set((Tuple3d)vector3d2);
        } else {
            vec3d.value[0] = vec3d2.value[0];
            vec3d.value[1] = vec3d2.value[1];
            vec3d.value[2] = vec3d2.value[2];
            vector3d.set((Tuple3d)vector3d2);
            vector3d10 = new Vector3d((double)vec3fArray[n + 2].value[0], (double)vec3fArray[n + 2].value[1], (double)vec3fArray[n + 2].value[2]);
            vector3d9 = new Vector3d((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
            vector3d8 = new Vector3d((double)vec3fArray[n].value[0], (double)vec3fArray[n].value[1], (double)vec3fArray[n].value[2]);
            vector3d4 = new Vector3d();
            vector3d4.sub((Tuple3d)vector3d10, (Tuple3d)vector3d8);
            vec3d2.value[0] = vector3d4.x;
            vec3d2.value[1] = vector3d4.y;
            vec3d2.value[2] = vector3d4.z;
            vector3d10.sub((Tuple3d)vector3d9);
            vector3d9.sub((Tuple3d)vector3d8);
            vector3d10.normalize();
            vector3d9.normalize();
            vector3d2.sub((Tuple3d)vector3d10, (Tuple3d)vector3d9);
            vector3d4.normalize();
            vector3d4.scale(vector3d4.dot(vector3d2));
            vector3d2.sub((Tuple3d)vector3d4);
            vector3d2.normalize();
            if (vector3d2.dot(FrenetTrihedron.getPreviousNormal()) < 0.0) {
                vector3d2.negate();
            }
            FrenetTrihedron.setPreviousNormal(vector3d2);
        }
    }

    private void getAllTangentsAndNormals(Vec3f[] vec3fArray, Vector3d[] vector3dArray, Vector3d[] vector3dArray2) {
        int n;
        Vector3d vector3d = null;
        Vector3d vector3d2 = null;
        Object var6_6 = null;
        Vector3d vector3d3 = null;
        Vector3d vector3d4 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Vector3d vector3d5 = null;
        Vector3d vector3d6 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        Vector3d vector3d7 = null;
        Object var16_16 = null;
        Object var17_17 = null;
        Vector3d vector3d8 = null;
        Vector3d vector3d9 = null;
        Object var20_20 = null;
        Object var21_21 = null;
        Vector3d vector3d10 = null;
        Object var23_23 = null;
        Object var26_24 = null;
        Object var27_25 = null;
        Vector3d vector3d11 = new Vector3d(0.0, 0.0, 0.0);
        if (vec3fArray.length == 2) {
            int n2 = 0;
            double d = 1.0;
            vector3d3 = new Vector3d();
            vector3d4 = new Vector3d();
            vector3d7 = new Vector3d((double)vec3fArray[n2 + 1].value[0], (double)vec3fArray[n2 + 1].value[1], (double)vec3fArray[n2 + 1].value[2]);
            vector3d10 = new Vector3d((double)vec3fArray[n2].value[0], (double)vec3fArray[n2].value[1], (double)vec3fArray[n2].value[2]);
            if (this.previousCaCoord != null) {
                vector3d5 = new Vector3d((double)this.previousCaCoord.value[0], (double)this.previousCaCoord.value[1], (double)this.previousCaCoord.value[2]);
            }
            if (this.nextCaCoord != null) {
                vector3d6 = new Vector3d((double)this.nextCaCoord.value[0], (double)this.nextCaCoord.value[1], (double)this.nextCaCoord.value[2]);
            }
            if (this.previousCaCoord == null) {
                vector3d = new Vector3d();
                vector3d.sub((Tuple3d)vector3d7, (Tuple3d)vector3d10);
                vector3dArray[0] = new Vector3d(vector3d);
                if (this.nextCaCoord == null) {
                    vector3dArray[1] = vector3dArray[0];
                    vector3d3.set((Tuple3d)vector3d);
                    vector3d.normalize();
                    if (vector3d3.x != 0.0) {
                        vector3d3.x *= 2.0;
                        vector3d.scale(vector3d.dot(vector3d3));
                        vector3d8 = new Vector3d();
                        vector3d8.sub((Tuple3d)vector3d3, (Tuple3d)vector3d);
                        vector3d3.set((Tuple3d)vector3d8);
                        if (vector3d3.length() < 1.0E-6) {
                            vector3d3.y += 1.0;
                        }
                        vector3d3.normalize();
                        vector3dArray2[0] = new Vector3d(vector3d3);
                        vector3dArray2[1] = vector3dArray2[0];
                    }
                } else {
                    vector3d2 = new Vector3d();
                    vector3d2.sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
                    vector3dArray[1] = new Vector3d(vector3d2);
                    vector3d6.sub((Tuple3d)vector3d7);
                    vector3d7.sub((Tuple3d)vector3d10);
                    vector3d6.normalize();
                    vector3d7.normalize();
                    vector3d4.sub((Tuple3d)vector3d6, (Tuple3d)vector3d7);
                    vector3d2.normalize();
                    vector3d2.scale(vector3d2.dot(vector3d4));
                    vector3d4.sub((Tuple3d)vector3d2);
                    vector3d4.normalize();
                    vector3dArray2[1] = new Vector3d(vector3d4);
                    vector3d.normalize();
                    vector3d.scale(vector3d.dot(vector3d4));
                    vector3d4.sub((Tuple3d)vector3d);
                    vector3d4.normalize();
                    vector3dArray2[0] = new Vector3d(vector3d4);
                }
            } else {
                vector3d = new Vector3d();
                vector3d.sub((Tuple3d)vector3d7, (Tuple3d)vector3d5);
                vector3dArray[0] = new Vector3d(vector3d);
                if (this.nextCaCoord == null) {
                    vector3d7.sub((Tuple3d)vector3d10);
                    vector3dArray[1] = new Vector3d(vector3d7);
                    vector3d10.sub((Tuple3d)vector3d5);
                    vector3d7.normalize();
                    vector3d10.normalize();
                    vector3d3.sub((Tuple3d)vector3d7, (Tuple3d)vector3d10);
                    vector3d.normalize();
                    vector3d.scale(vector3d.dot(vector3d3));
                    vector3d3.sub((Tuple3d)vector3d);
                    vector3d3.normalize();
                    vector3dArray2[0] = new Vector3d(vector3d3);
                    vector3d.set((Tuple3d)vector3dArray[1]);
                    vector3d.normalize();
                    vector3d.scale(vector3d.dot(vector3d3));
                    vector3d3.sub((Tuple3d)vector3d);
                    vector3d3.normalize();
                    vector3dArray2[1] = new Vector3d(vector3d3);
                    d = vector3dArray2[1].dot(vector3dArray2[0]);
                    if (d <= 0.0) {
                        vector3dArray2[1].negate();
                    }
                } else {
                    vector3d2 = new Vector3d();
                    vector3d2.sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
                    vector3dArray[1] = new Vector3d(vector3d2);
                    vector3d6.sub((Tuple3d)vector3d7);
                    vector3d7.sub((Tuple3d)vector3d10);
                    vector3d10.sub((Tuple3d)vector3d5);
                    vector3d6.normalize();
                    vector3d7.normalize();
                    vector3d10.normalize();
                    vector3d4.sub((Tuple3d)vector3d6, (Tuple3d)vector3d7);
                    vector3d3.sub((Tuple3d)vector3d7, (Tuple3d)vector3d10);
                    vector3d.normalize();
                    vector3d2.normalize();
                    vector3d.scale(vector3d.dot(vector3d3));
                    vector3d2.scale(vector3d2.dot(vector3d4));
                    vector3d3.sub((Tuple3d)vector3d);
                    vector3d4.sub((Tuple3d)vector3d2);
                    vector3d4.normalize();
                    vector3d3.normalize();
                    vector3dArray2[0] = new Vector3d(vector3d3);
                    vector3dArray2[1] = new Vector3d(vector3d4);
                    d = vector3dArray2[1].dot(vector3dArray2[0]);
                    if (d <= 0.0) {
                        vector3dArray2[1].negate();
                    }
                }
            }
            return;
        }
        for (n = 1; n < vec3fArray.length - 1; ++n) {
            vector3d6 = new Vector3d((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
            vector3d5 = new Vector3d((double)vec3fArray[n - 1].value[0], (double)vec3fArray[n - 1].value[1], (double)vec3fArray[n - 1].value[2]);
            vector3dArray[n] = new Vector3d();
            vector3dArray[n].sub((Tuple3d)vector3d6, (Tuple3d)vector3d5);
        }
        vector3d6 = new Vector3d((double)vec3fArray[1].value[0], (double)vec3fArray[1].value[1], (double)vec3fArray[1].value[2]);
        vector3d10 = new Vector3d((double)vec3fArray[0].value[0], (double)vec3fArray[0].value[1], (double)vec3fArray[0].value[2]);
        if (this.previousCaCoord != null) {
            vector3d5 = new Vector3d((double)this.previousCaCoord.value[0], (double)this.previousCaCoord.value[1], (double)this.previousCaCoord.value[2]);
            vector3d = new Vector3d(vector3d6);
            vector3d.sub((Tuple3d)vector3d5);
            vector3dArray[0] = new Vector3d(vector3d);
            vector3d6.sub((Tuple3d)vector3d10);
            vector3d10.sub((Tuple3d)vector3d5);
            vector3d6.normalize();
            vector3d10.normalize();
            vector3dArray2[0] = new Vector3d();
            vector3dArray2[0].sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
            vector3d9 = new Vector3d();
            vector3d9.set((Tuple3d)vector3d);
            vector3d9.normalize();
            vector3d8 = new Vector3d();
            vector3d8.set((Tuple3d)vector3d9);
            vector3d8.scale(vector3dArray2[0].dot(vector3d9));
            vector3dArray2[0].sub((Tuple3d)vector3d8);
            vector3dArray2[0].normalize();
        } else {
            vector3d6.sub((Tuple3d)vector3d10);
            vector3dArray[0] = new Vector3d();
            vector3dArray[0].set((Tuple3d)vector3d6);
        }
        vector3d5 = new Vector3d((double)vec3fArray[vec3fArray.length - 2].value[0], (double)vec3fArray[vec3fArray.length - 2].value[1], (double)vec3fArray[vec3fArray.length - 2].value[2]);
        vector3d10 = new Vector3d((double)vec3fArray[vec3fArray.length - 1].value[0], (double)vec3fArray[vec3fArray.length - 1].value[1], (double)vec3fArray[vec3fArray.length - 1].value[2]);
        if (this.nextCaCoord != null) {
            vector3d6 = new Vector3d((double)this.nextCaCoord.value[0], (double)this.nextCaCoord.value[1], (double)this.nextCaCoord.value[2]);
            vector3d2 = new Vector3d(vector3d6);
            vector3d2.sub((Tuple3d)vector3d5);
            vector3dArray[vec3fArray.length - 1] = new Vector3d(vector3d2);
            vector3d6.sub((Tuple3d)vector3d10);
            vector3d10.sub((Tuple3d)vector3d5);
            vector3d6.normalize();
            vector3d10.normalize();
            vector3dArray2[vec3fArray.length - 1] = new Vector3d();
            vector3dArray2[vec3fArray.length - 1].sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
            vector3d2.normalize();
            vector3d2.scale(vector3dArray2[vec3fArray.length - 1].dot(vector3d2));
            vector3dArray2[vec3fArray.length - 1].sub((Tuple3d)vector3d2);
            vector3dArray2[vec3fArray.length - 1].normalize();
        } else {
            vector3dArray[vec3fArray.length - 1] = new Vector3d(vector3d10);
            vector3dArray[vec3fArray.length - 1].sub((Tuple3d)vector3d5);
        }
        vector3d8 = new Vector3d();
        vector3d9 = new Vector3d();
        for (n = 1; n < vec3fArray.length - 1; ++n) {
            vector3d6.set((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
            vector3d10.set((double)vec3fArray[n].value[0], (double)vec3fArray[n].value[1], (double)vec3fArray[n].value[2]);
            vector3d5.set((double)vec3fArray[n - 1].value[0], (double)vec3fArray[n - 1].value[1], (double)vec3fArray[n - 1].value[2]);
            vector3d6.sub((Tuple3d)vector3d10);
            vector3d10.sub((Tuple3d)vector3d5);
            vector3d6.normalize();
            vector3d10.normalize();
            vector3dArray2[n] = new Vector3d();
            vector3dArray2[n].sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
            vector3d9.set((Tuple3d)vector3dArray[n]);
            vector3d9.normalize();
            vector3d8.set((Tuple3d)vector3d9);
            vector3d8.scale(vector3dArray2[n].dot(vector3d9));
            vector3dArray2[n].sub((Tuple3d)vector3d8);
            vector3dArray2[n].normalize();
        }
        if (vector3dArray2[0] == null) {
            vector3dArray2[0] = new Vector3d(vector3dArray2[1]);
            vector3d9.set((Tuple3d)vector3dArray[0]);
            vector3d9.normalize();
            vector3d8.set((Tuple3d)vector3d9);
            vector3d8.scale(vector3dArray2[0].dot(vector3d9));
            vector3dArray2[0].sub((Tuple3d)vector3d8);
            vector3dArray2[0].normalize();
        }
        if (vector3dArray2[vec3fArray.length - 1] == null) {
            vector3dArray2[vec3fArray.length - 1] = new Vector3d(vector3dArray2[vec3fArray.length - 2]);
            vector3d9.set((Tuple3d)vector3dArray[vec3fArray.length - 1]);
            vector3d9.normalize();
            vector3d8.set((Tuple3d)vector3d9);
            vector3d8.scale(vector3dArray2[vec3fArray.length - 1].dot(vector3d9));
            vector3dArray2[vec3fArray.length - 1].sub((Tuple3d)vector3d8);
            vector3dArray2[vec3fArray.length - 1].normalize();
        }
        Vector3d vector3d12 = new Vector3d();
        vector3d12 = vector3dArray2[0];
        double d = 0.0;
        vector3d12 = vector3dArray2[0];
        for (int i = 1; i < vec3fArray.length; ++i) {
            d = vector3dArray2[i].dot(vector3d12);
            if (d < 0.0) {
                vector3dArray2[i].negate();
            }
            vector3d12 = vector3dArray2[i];
        }
        this.smoothNormals(vector3dArray2, vector3dArray, 2);
    }

    public void highlightResidueRegion(int n, float[] fArray) {
        if (this.csType != 6) {
            int n2 = this.csStyle.getVertexCount();
            int n3 = 2 * this.segments * (n2 - 1);
            int n4 = 2 * n2 + 2 * n3 * n;
            int n5 = n > 0 ? n4 - n3 : n4;
            int n6 = n < this.coords.length - 1 ? n4 + n3 : n4;
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            if (!this.highlighted) {
                extrusion.highlight(n5, n6, fArray);
                this.highlighted = true;
            } else {
                extrusion.updateColors(n5, n6, n * this.segments);
                this.highlighted = false;
            }
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            if (!this.highlighted) {
                backboneLine.highlight(n9, n10, fArray);
                this.highlighted = true;
            } else {
                backboneLine.updateColors(n9, n10);
                this.highlighted = false;
            }
        }
    }

    public void highlightResidue(int n, float[] fArray) {
        if (this.csType != 6) {
            int n2 = this.csStyle.getVertexCount();
            int n3 = 2 * this.segments * (n2 - 1);
            int n4 = 2 * n2 + 2 * n3 * n;
            int n5 = n > 0 ? n4 - n3 : n4;
            int n6 = n < this.coords.length - 1 ? n4 + n3 : n4;
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            extrusion.highlight(n5, n6, fArray);
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            backboneLine.updateColors(n9, n10);
        }
    }

    public void resetGeometryColor() {
        Object object;
        if (this.csType != 6) {
            object = (Extrusion)this.shape.getGeometry();
            ((Extrusion)((Object)object)).setColors(this.pathColorMap);
        } else {
            object = (BackboneLine)this.shape.getGeometry();
            ((BackboneLine)((Object)object)).setColors(this.pathColorMap);
        }
        for (int i = 0; i < this.coords.length; ++i) {
            this.resetResidueColor(i);
        }
    }

    public void resetResidueColor(int n) {
        if (this.csType != 6) {
            int n2 = this.csStyle.getVertexCount();
            int n3 = 2 * this.segments * (n2 - 1);
            int n4 = 2 * n2 + 2 * n3 * n;
            int n5 = n > 0 ? n4 - n3 : n4 - 2 * n2;
            int n6 = n < this.coords.length - 1 ? n4 + n3 : n4 + 2 * n2;
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            extrusion.updateColors(n5, n6, n * this.segments);
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            backboneLine.updateColors(n9, n10);
        }
    }

    public void setNormals(Vector3d[] vector3dArray) {
        this.normals = vector3dArray;
    }

    private void setTangents(Vector3d[] vector3dArray) {
        this.tangents = vector3dArray;
    }

    public void setPolygonStyle(int n) {
        this.polygonStyle = n;
    }

    public void setDiameter(double d) {
        this.diameter = d;
    }

    public void setFacetCount(int n) {
        this.facets = n;
    }

    private void processQualityInfo(float f) {
        int n = 10;
        int n2 = 2;
        int n3 = 16;
        int n4 = 4;
        if (f < (float)n2 / (float)n) {
            this.segments = n2;
            this.segments += this.segments % 2;
        } else {
            this.segments = (int)(f * (float)n);
            this.segments += this.segments % 2;
        }
        this.facets = f < (float)n4 / (float)n3 ? n4 : (int)(f * (float)n3);
    }
}

