/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionStyle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.IntrinsicCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3d;
import javax.vecmath.Color3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;

public class CrossSectionBuilder {
    public static IntrinsicCrossSection getIntrinsicCrossSection(CrossSectionStyle crossSectionStyle, Vector3d vector3d) {
        if (crossSectionStyle.getStyleName() == "REGULAR_POLYGON") {
            return CrossSectionBuilder.getIntrinsicRegularPolygon(crossSectionStyle);
        }
        if (crossSectionStyle.getStyleName() == "ROUNDED_TUBE") {
            return CrossSectionBuilder.getIntrinsicRegularPolygon(crossSectionStyle);
        }
        if (crossSectionStyle.getStyleName() == "RECTANGULAR_RIBBON") {
            return CrossSectionBuilder.getIntrinsicRectangle(crossSectionStyle, 5);
        }
        if (crossSectionStyle.getStyleName() == "DOUBLE_FACE") {
            return CrossSectionBuilder.getIntrinsicDoubleFace(crossSectionStyle, 3, vector3d);
        }
        if (crossSectionStyle.getStyleName() == "SINGLE_FACE") {
            return CrossSectionBuilder.getIntrinsicSingleFace(crossSectionStyle, 2, vector3d);
        }
        if (crossSectionStyle.getStyleName() == "OBLONG") {
            return CrossSectionBuilder.getIntrinsicOblong(crossSectionStyle, vector3d);
        }
        return new IntrinsicCrossSection();
    }

    private static IntrinsicCrossSection getIntrinsicRegularPolygon(CrossSectionStyle crossSectionStyle) {
        int n = crossSectionStyle.getVertexCount();
        int n2 = n - 1;
        double d = crossSectionStyle.getDiameters()[0] / 2.0;
        Vector3d vector3d = null;
        Vector3d[] vector3dArray = new Vector3d[n];
        Vec3d[] vec3dArray = new Vec3d[n];
        Vector3d vector3d2 = null;
        Vector3d[] vector3dArray2 = new Vector3d[n];
        vector3d2 = new Vector3d(1.0, 0.0, 0.0);
        vector3d = new Vector3d(vector3d2);
        vector3dArray[0] = new Vector3d(0.0, 2.0, 2.0);
        vector3dArray[0].normalize();
        vector3dArray[0].scale(d);
        Color3f color3f = null;
        if (crossSectionStyle.getVertexColors() != null) {
            color3f = crossSectionStyle.getVertexColors()[0];
        }
        Vector3d vector3d3 = new Vector3d(0.0, 0.0, 0.0);
        vector3dArray2[0] = new Vector3d(vector3d3);
        vector3dArray2[0].add((Tuple3d)vector3dArray[0]);
        vector3dArray2[n - 1] = vector3dArray2[0];
        vec3dArray[0] = new Vec3d();
        vec3dArray[0].value[0] = vector3dArray2[0].x;
        vec3dArray[0].value[1] = vector3dArray2[0].y;
        vec3dArray[0].value[2] = vector3dArray2[0].z;
        vec3dArray[n - 1] = vec3dArray[0];
        double d2 = Math.cos(-Math.PI / (double)n2);
        double d3 = Math.sin(-Math.PI / (double)n2);
        double d4 = d3 * vector3d.x;
        double d5 = d3 * vector3d.y;
        double d6 = d3 * vector3d.z;
        Quat4d quat4d = new Quat4d(d4, d5, d6, d2);
        Quat4d quat4d2 = new Quat4d();
        Quat4d quat4d3 = new Quat4d();
        for (int i = 1; i < n - 1; ++i) {
            quat4d2.set(vector3dArray[i - 1].x, vector3dArray[i - 1].y, vector3dArray[i - 1].z, 0.0);
            quat4d3.set((Tuple4d)quat4d);
            quat4d2.mulInverse(quat4d);
            quat4d3.mul(quat4d2);
            vector3dArray[i] = new Vector3d(quat4d3.x, quat4d3.y, quat4d3.z);
            vector3dArray2[i] = new Vector3d(vector3d3);
            vec3dArray[i] = new Vec3d();
            vector3dArray2[i].add((Tuple3d)vector3dArray[i]);
            vec3dArray[i].value[0] = vector3dArray2[i].x;
            vec3dArray[i].value[1] = vector3dArray2[i].y;
            vec3dArray[i].value[2] = vector3dArray2[i].z;
        }
        IntrinsicCrossSection intrinsicCrossSection = new IntrinsicCrossSection(n, vec3dArray);
        intrinsicCrossSection.setNormalsByVector(vector3d);
        if (color3f != null) {
            Color3f[] color3fArray = new Color3f[n];
            Color3f color3f2 = new Color3f(color3f);
            for (int i = 0; i < n; ++i) {
                color3fArray[i] = color3f2;
            }
            intrinsicCrossSection.setColors(color3fArray);
            intrinsicCrossSection.setSideColor(new Color3f(0.3f, 0.3f, 0.3f));
        }
        return intrinsicCrossSection;
    }

    private static IntrinsicCrossSection getIntrinsicRectangle(CrossSectionStyle crossSectionStyle, int n) {
        Vector3d vector3d = null;
        Vector3d[] vector3dArray = new Vector3d[n];
        Vec3d[] vec3dArray = new Vec3d[n];
        Vector3d vector3d2 = null;
        Vector3d[] vector3dArray2 = new Vector3d[n];
        vector3d2 = new Vector3d(1.0, 0.0, 0.0);
        vector3d = new Vector3d(vector3d2);
        Vector3d vector3d3 = new Vector3d(0.0, 0.0, 0.0);
        double d = crossSectionStyle.getDiameters()[0];
        double d2 = crossSectionStyle.getDiameters()[1];
        Color3f color3f = null;
        if (crossSectionStyle.getVertexColors() != null) {
            color3f = crossSectionStyle.getVertexColors()[0];
        }
        vector3dArray[0] = new Vector3d(0.0, -d2 / 2.0, d / 2.0);
        double d3 = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
        vector3dArray2[0] = new Vector3d(vector3d3);
        vector3dArray2[0].add((Tuple3d)vector3dArray[0]);
        vector3dArray2[n - 1] = vector3dArray2[0];
        vec3dArray[0] = new Vec3d();
        vec3dArray[0].value[0] = vector3dArray2[0].x;
        vec3dArray[0].value[1] = vector3dArray2[0].y;
        vec3dArray[0].value[2] = vector3dArray2[0].z;
        vec3dArray[n - 1] = vec3dArray[0];
        double d4 = -d / d3;
        double d5 = -d4;
        double d6 = -d2 / d3;
        double d7 = -d6;
        double d8 = d6 * vector3d.x;
        double d9 = d6 * vector3d.y;
        double d10 = d6 * vector3d.z;
        Quat4d quat4d = new Quat4d(d8, d9, d10, d5);
        d8 = d4 * vector3d.x;
        d9 = d4 * vector3d.y;
        d10 = d4 * vector3d.z;
        Quat4d quat4d2 = new Quat4d(d8, d9, d10, d7);
        Quat4d quat4d3 = new Quat4d();
        Quat4d quat4d4 = new Quat4d();
        for (int i = 1; i < n - 1; ++i) {
            quat4d3.set(vector3dArray[i - 1].x, vector3dArray[i - 1].y, vector3dArray[i - 1].z, 0.0);
            if (i % 2 == 1) {
                quat4d4.set((Tuple4d)quat4d);
                quat4d3.mulInverse(quat4d);
                quat4d4.mul(quat4d3);
            } else {
                quat4d4.set((Tuple4d)quat4d2);
                quat4d3.mulInverse(quat4d2);
                quat4d4.mul(quat4d3);
            }
            vector3dArray[i] = new Vector3d(quat4d4.x, quat4d4.y, quat4d4.z);
            vector3dArray2[i] = new Vector3d(vector3d3);
            vec3dArray[i] = new Vec3d();
            vector3dArray2[i].add((Tuple3d)vector3dArray[i]);
            vec3dArray[i].value[0] = vector3dArray2[i].x;
            vec3dArray[i].value[1] = vector3dArray2[i].y;
            vec3dArray[i].value[2] = vector3dArray2[i].z;
        }
        IntrinsicCrossSection intrinsicCrossSection = new IntrinsicCrossSection(n, vec3dArray);
        intrinsicCrossSection.setNormalsByVector(vector3d);
        if (color3f != null) {
            Color3f[] color3fArray = new Color3f[n];
            color3fArray[2] = color3fArray[4] = new Color3f(0.3f, 0.3f, 0.3f);
            color3fArray[0] = color3fArray[4];
            color3fArray[1] = color3fArray[3] = new Color3f(color3f);
            intrinsicCrossSection.setColors(color3fArray);
            intrinsicCrossSection.setSideColor(color3fArray[0]);
        }
        return intrinsicCrossSection;
    }

    private static IntrinsicCrossSection getIntrinsicOblong(CrossSectionStyle crossSectionStyle, Vector3d vector3d) {
        int n = 15;
        double d = System.currentTimeMillis();
        Vector3d vector3d2 = null;
        Vector3d vector3d3 = null;
        Vec3d[] vec3dArray = new Vec3d[n];
        Vector3d vector3d4 = null;
        Vector3d[] vector3dArray = new Vector3d[n];
        vector3d4 = new Vector3d(1.0, 0.0, 0.0);
        vector3d2 = new Vector3d(vector3d4);
        Vector3d vector3d5 = new Vector3d(0.0, 0.0, 0.0);
        double d2 = crossSectionStyle.getDiameters()[0];
        double d3 = crossSectionStyle.getDiameters()[1];
        Color3f color3f = null;
        if (crossSectionStyle.getVertexColors()[0] != null) {
            color3f = crossSectionStyle.getVertexColors()[0];
        }
        vector3d3 = new Vector3d(0.0, 0.0, d2 / 2.0);
        double d4 = Math.sqrt(Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
        vector3dArray[0] = new Vector3d(vector3d5);
        vector3dArray[0].add((Tuple3d)vector3d3);
        vector3dArray[n - 1] = vector3dArray[0];
        vec3dArray[0] = new Vec3d();
        vec3dArray[0].value[0] = vector3dArray[0].x;
        vec3dArray[0].value[1] = vector3dArray[0].y;
        vec3dArray[0].value[2] = vector3dArray[0].z;
        vec3dArray[n - 1] = vec3dArray[0];
        vector3d3 = new Vector3d(0.0, 0.2 * d3 / 2.0, 0.9 * d2 / 2.0);
        vector3dArray[1] = new Vector3d(vector3d5);
        vector3dArray[1].add((Tuple3d)vector3d3);
        vec3dArray[1] = new Vec3d();
        vec3dArray[1].value[0] = vector3dArray[1].x;
        vec3dArray[1].value[1] = vector3dArray[1].y;
        vec3dArray[1].value[2] = vector3dArray[1].z;
        vector3dArray[13] = new Vector3d(vector3dArray[1]);
        vector3dArray[13].y = -vector3dArray[13].y;
        vec3dArray[13] = new Vec3d();
        vec3dArray[13].value[0] = vector3dArray[13].x;
        vec3dArray[13].value[1] = vector3dArray[13].y;
        vec3dArray[13].value[2] = vector3dArray[13].z;
        vector3d3 = new Vector3d(0.0, 0.8 * d3 / 2.0, 0.6 * d2 / 2.0);
        vector3dArray[2] = new Vector3d(vector3d5);
        vector3dArray[2].add((Tuple3d)vector3d3);
        vec3dArray[2] = new Vec3d();
        vec3dArray[2].value[0] = vector3dArray[2].x;
        vec3dArray[2].value[1] = vector3dArray[2].y;
        vec3dArray[2].value[2] = vector3dArray[2].z;
        vector3dArray[12] = new Vector3d(vector3dArray[2]);
        vector3dArray[12].y = -vector3dArray[12].y;
        vec3dArray[12] = new Vec3d();
        vec3dArray[12].value[0] = vector3dArray[12].x;
        vec3dArray[12].value[1] = vector3dArray[12].y;
        vec3dArray[12].value[2] = vector3dArray[12].z;
        vector3d3 = new Vector3d(0.0, d3 / 2.0, 0.2 * d2 / 2.0);
        vector3dArray[3] = new Vector3d(vector3d5);
        vector3dArray[3].add((Tuple3d)vector3d3);
        vec3dArray[3] = new Vec3d();
        vec3dArray[3].value[0] = vector3dArray[3].x;
        vec3dArray[3].value[1] = vector3dArray[3].y;
        vec3dArray[3].value[2] = vector3dArray[3].z;
        vector3dArray[11] = new Vector3d(vector3dArray[3]);
        vector3dArray[11].y = -vector3dArray[11].y;
        vec3dArray[11] = new Vec3d();
        vec3dArray[11].value[0] = vector3dArray[11].x;
        vec3dArray[11].value[1] = vector3dArray[11].y;
        vec3dArray[11].value[2] = vector3dArray[11].z;
        vector3d3 = new Vector3d(0.0, d3 / 2.0, -0.2 * d2 / 2.0);
        vector3dArray[4] = new Vector3d(vector3d5);
        vector3dArray[4].add((Tuple3d)vector3d3);
        vec3dArray[4] = new Vec3d();
        vec3dArray[4].value[0] = vector3dArray[4].x;
        vec3dArray[4].value[1] = vector3dArray[4].y;
        vec3dArray[4].value[2] = vector3dArray[4].z;
        vector3dArray[10] = new Vector3d(vector3dArray[4]);
        vector3dArray[10].y = -vector3dArray[10].y;
        vec3dArray[10] = new Vec3d();
        vec3dArray[10].value[0] = vector3dArray[10].x;
        vec3dArray[10].value[1] = vector3dArray[10].y;
        vec3dArray[10].value[2] = vector3dArray[10].z;
        vector3d3 = new Vector3d(0.0, 0.8 * d3 / 2.0, -0.6 * d2 / 2.0);
        vector3dArray[5] = new Vector3d(vector3d5);
        vector3dArray[5].add((Tuple3d)vector3d3);
        vec3dArray[5] = new Vec3d();
        vec3dArray[5].value[0] = vector3dArray[5].x;
        vec3dArray[5].value[1] = vector3dArray[5].y;
        vec3dArray[5].value[2] = vector3dArray[5].z;
        vector3dArray[9] = new Vector3d(vector3dArray[5]);
        vector3dArray[9].y = -vector3dArray[9].y;
        vec3dArray[9] = new Vec3d();
        vec3dArray[9].value[0] = vector3dArray[9].x;
        vec3dArray[9].value[1] = vector3dArray[9].y;
        vec3dArray[9].value[2] = vector3dArray[9].z;
        vector3d3 = new Vector3d(0.0, 0.3 * d3 / 2.0, -0.9 * d2 / 2.0);
        vector3dArray[6] = new Vector3d(vector3d5);
        vector3dArray[6].add((Tuple3d)vector3d3);
        vec3dArray[6] = new Vec3d();
        vec3dArray[6].value[0] = vector3dArray[6].x;
        vec3dArray[6].value[1] = vector3dArray[6].y;
        vec3dArray[6].value[2] = vector3dArray[6].z;
        vector3dArray[8] = new Vector3d(vector3dArray[6]);
        vector3dArray[8].y = -vector3dArray[8].y;
        vec3dArray[8] = new Vec3d();
        vec3dArray[8].value[0] = vector3dArray[8].x;
        vec3dArray[8].value[1] = vector3dArray[8].y;
        vec3dArray[8].value[2] = vector3dArray[8].z;
        vector3d3 = new Vector3d(0.0, 0.0, -d2 / 2.0);
        vector3dArray[7] = new Vector3d(vector3d5);
        vector3dArray[7].add((Tuple3d)vector3d3);
        vector3dArray[n - 1] = new Vector3d(vector3dArray[7]);
        vec3dArray[7] = new Vec3d();
        vec3dArray[7].value[0] = vector3dArray[7].x;
        vec3dArray[7].value[1] = vector3dArray[7].y;
        vec3dArray[7].value[2] = vector3dArray[7].z;
        IntrinsicCrossSection intrinsicCrossSection = new IntrinsicCrossSection(n, vec3dArray);
        intrinsicCrossSection.setNormalsByVector(vector3d2);
        if (color3f != null) {
            Color3f[] color3fArray = new Color3f[n];
            for (int i = 0; i < n; ++i) {
                color3fArray[i] = new Color3f(color3f);
            }
            intrinsicCrossSection.setColors(color3fArray);
            intrinsicCrossSection.setSideColor(color3fArray[0]);
        }
        double d5 = System.currentTimeMillis();
        return intrinsicCrossSection;
    }

    private static IntrinsicCrossSection getIntrinsicDoubleFace(CrossSectionStyle crossSectionStyle, int n, Vector3d vector3d) {
        double d = System.currentTimeMillis();
        Vector3d vector3d2 = null;
        Vector3d[] vector3dArray = new Vector3d[n];
        Vec3d[] vec3dArray = new Vec3d[n];
        Vector3d vector3d3 = null;
        Vector3d[] vector3dArray2 = new Vector3d[n];
        vector3d3 = new Vector3d(1.0, 0.0, 0.0);
        vector3d2 = new Vector3d(vector3d3);
        Vector3d vector3d4 = new Vector3d(0.0, 0.0, 0.0);
        double d2 = crossSectionStyle.getDiameters()[0];
        double d3 = crossSectionStyle.getDiameters()[1];
        Color3f color3f = null;
        if (crossSectionStyle.getVertexColors()[0] != null) {
            color3f = crossSectionStyle.getVertexColors()[0];
        }
        vector3dArray[0] = new Vector3d(0.0, 0.0, d2 / 2.0);
        double d4 = Math.sqrt(Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
        vector3dArray2[0] = new Vector3d(vector3d4);
        vector3dArray2[0].add((Tuple3d)vector3dArray[0]);
        vector3dArray2[n - 1] = vector3dArray2[0];
        vec3dArray[0] = new Vec3d();
        vec3dArray[0].value[0] = vector3dArray2[0].x;
        vec3dArray[0].value[1] = vector3dArray2[0].y;
        vec3dArray[0].value[2] = vector3dArray2[0].z;
        vec3dArray[n - 1] = vec3dArray[0];
        vector3dArray[0].negate();
        vector3dArray2[1] = new Vector3d(vector3d4);
        vector3dArray2[1].add((Tuple3d)vector3dArray[0]);
        vec3dArray[1] = new Vec3d();
        vec3dArray[1].value[0] = vector3dArray2[1].x;
        vec3dArray[1].value[1] = vector3dArray2[1].y;
        vec3dArray[1].value[2] = vector3dArray2[1].z;
        IntrinsicCrossSection intrinsicCrossSection = new IntrinsicCrossSection(n, vec3dArray);
        intrinsicCrossSection.setNormalsByVector(vector3d2);
        if (color3f != null) {
            Color3f[] color3fArray = new Color3f[n];
            color3fArray[0] = color3fArray[2] = new Color3f(0.6f, 0.6f, 0.6f);
            color3fArray[1] = new Color3f(color3f);
            intrinsicCrossSection.setColors(color3fArray);
            intrinsicCrossSection.setSideColor(color3fArray[0]);
        }
        double d5 = System.currentTimeMillis();
        return intrinsicCrossSection;
    }

    private static IntrinsicCrossSection getIntrinsicSingleFace(CrossSectionStyle crossSectionStyle, int n, Vector3d vector3d) {
        double d = System.currentTimeMillis();
        Vector3d vector3d2 = null;
        Vector3d[] vector3dArray = new Vector3d[n];
        Vec3d[] vec3dArray = new Vec3d[n];
        Vector3d vector3d3 = null;
        Vector3d[] vector3dArray2 = new Vector3d[n];
        vector3d3 = new Vector3d(1.0, 0.0, 0.0);
        vector3d2 = new Vector3d(vector3d3);
        Vector3d vector3d4 = new Vector3d(0.0, 0.0, 0.0);
        double d2 = crossSectionStyle.getDiameters()[0];
        double d3 = crossSectionStyle.getDiameters()[1];
        Color3f color3f = null;
        if (crossSectionStyle.getVertexColors() != null) {
            color3f = crossSectionStyle.getVertexColors()[0];
        }
        vector3dArray[0] = new Vector3d(0.0, 0.0, d2 / 2.0);
        double d4 = Math.sqrt(Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
        vector3dArray2[0] = new Vector3d(vector3d4);
        vector3dArray2[0].add((Tuple3d)vector3dArray[0]);
        vec3dArray[0] = new Vec3d();
        vec3dArray[0].value[0] = vector3dArray2[0].x;
        vec3dArray[0].value[1] = vector3dArray2[0].y;
        vec3dArray[0].value[2] = vector3dArray2[0].z;
        vector3dArray[0].negate();
        vector3dArray2[1] = new Vector3d(vector3d4);
        vector3dArray2[1].add((Tuple3d)vector3dArray[0]);
        vec3dArray[1] = new Vec3d();
        vec3dArray[1].value[0] = vector3dArray2[1].x;
        vec3dArray[1].value[1] = vector3dArray2[1].y;
        vec3dArray[1].value[2] = vector3dArray2[1].z;
        IntrinsicCrossSection intrinsicCrossSection = new IntrinsicCrossSection(n, vec3dArray);
        intrinsicCrossSection.setNormalsByVector(vector3d2);
        if (color3f != null) {
            Color3f[] color3fArray = new Color3f[n];
            color3fArray[1] = color3fArray[0] = new Color3f(color3f);
            intrinsicCrossSection.setColors(color3fArray);
            intrinsicCrossSection.setSideColor(color3fArray[0]);
        }
        double d5 = System.currentTimeMillis();
        return intrinsicCrossSection;
    }
}

