/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import javax.vecmath.Color3f;

public class CrossSectionStyle {
    private String styleName = "NONE";
    private int styleType;
    private boolean closedPolygon = true;
    private int vertexCount = 0;
    private double[] diameters;
    private Color3f[] vertexColors;
    public static int RECTANGULAR_RIBBON = 0;
    public static int DOUBLE_FACE = 1;
    public static int SINGLE_FACE = 2;
    public static int OBLONG = 3;
    public static int REGULAR_POLYGON = 4;
    public static int ROUNDED_TUBE = 5;
    public static int POINT = 6;

    public CrossSectionStyle() {
    }

    public CrossSectionStyle(boolean bl, int n, double[] dArray) {
        this.closedPolygon = bl;
        this.vertexCount = n;
        this.diameters = dArray;
    }

    public CrossSectionStyle(int n, double[] dArray) {
        this.styleType = n;
        switch (n) {
            case 0: {
                this.styleName = "RECTANGULAR_RIBBON";
                this.closedPolygon = true;
                this.vertexCount = 5;
                break;
            }
            case 1: {
                this.styleName = "DOUBLE_FACE";
                this.closedPolygon = true;
                this.vertexCount = 3;
                break;
            }
            case 2: {
                this.styleName = "SINGLE_FACE";
                this.closedPolygon = false;
                this.vertexCount = 2;
                break;
            }
            case 3: {
                this.styleName = "OBLONG";
                this.closedPolygon = true;
                this.vertexCount = 15;
                break;
            }
            case 4: 
            case 5: {
                this.styleName = "REGULAR_POLYGON";
                this.closedPolygon = true;
                this.vertexCount = 8;
                break;
            }
            case 6: {
                this.styleName = "POINT";
                this.closedPolygon = false;
                break;
            }
        }
        this.diameters = dArray;
    }

    public void setStyleName(String string) {
        this.styleName = string;
    }

    public void setVertexColors(Color3f[] color3fArray) {
        this.vertexColors = color3fArray;
    }

    public void setClosedFlag(boolean bl) {
        this.closedPolygon = bl;
    }

    public void setVertexCount(int n) {
        this.vertexCount = n;
    }

    public void setDiameters(double[] dArray) {
        this.diameters = dArray;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public int getStyleType() {
        return this.styleType;
    }

    public Color3f[] getVertexColors() {
        return this.vertexColors;
    }

    public boolean getClosedFlag() {
        return this.closedPolygon;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public double[] getDiameters() {
        return this.diameters;
    }
}

