/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class FrenetTrihedron {
    private Vector3d origin = null;
    private Vector3d tangent = null;
    private Vector3d normal = null;
    private Vector3d binormal = null;
    static Vector3d previousNormal = null;

    public FrenetTrihedron() {
    }

    public FrenetTrihedron(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.origin = new Vector3d(vector3d);
        this.tangent = new Vector3d(vector3d2);
        this.normal = new Vector3d(vector3d3);
        this.binormal = new Vector3d();
        this.binormal.cross(this.tangent, this.normal);
        this.binormal.normalize();
    }

    public FrenetTrihedron(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, int n) {
        this.origin = new Vector3d(vector3d);
        this.tangent = new Vector3d(vector3d2);
        this.binormal = new Vector3d(vector3d3);
        this.normal = new Vector3d();
        this.normal.cross(vector3d3, vector3d2);
        this.normal.normalize();
    }

    public FrenetTrihedron(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4) {
        this.origin = new Vector3d(vector3d);
        this.tangent = new Vector3d(vector3d2);
        this.normal = new Vector3d(vector3d3);
        this.binormal = vector3d4;
    }

    public FrenetTrihedron(FrenetTrihedron frenetTrihedron) {
        this.origin = new Vector3d(frenetTrihedron.getOrigin());
        this.tangent = new Vector3d(frenetTrihedron.getTangent());
        this.normal = new Vector3d(frenetTrihedron.getNormal());
        this.binormal = new Vector3d(frenetTrihedron.getBinormal());
    }

    public void setOrigin(Vector3d vector3d) {
        this.origin = new Vector3d(vector3d);
        if (this.tangent != null && this.normal != null) {
            this.binormal = new Vector3d();
            this.binormal.cross(this.tangent, this.normal);
            this.binormal.normalize();
        }
    }

    public void setOriginOnly(Vector3d vector3d) {
        this.origin = new Vector3d(vector3d);
    }

    public void setTangent(Vector3d vector3d) {
        this.tangent = new Vector3d(vector3d);
        if (this.normal != null) {
            this.binormal = new Vector3d();
            this.binormal.cross(this.tangent, this.normal);
            this.binormal.normalize();
        }
    }

    public void setNormal(Vector3d vector3d) {
        this.normal = new Vector3d(vector3d);
        if (this.tangent != null) {
            this.binormal = new Vector3d();
            this.binormal.cross(this.tangent, this.normal);
            this.binormal.normalize();
        }
    }

    public String toString() {
        String string = "Origin: " + this.origin.toString() + "\n Tangent: " + this.tangent.toString() + "\n Normal: " + this.normal.toString() + "\n Binormal: " + this.binormal.toString();
        return string;
    }

    public double distance(FrenetTrihedron frenetTrihedron) {
        Vector3d vector3d = null;
        vector3d = new Vector3d(this.getOrigin());
        vector3d.sub((Tuple3d)frenetTrihedron.getOrigin());
        return vector3d.length();
    }

    public void setBinormal(Vector3d vector3d) {
        this.binormal = new Vector3d(vector3d);
    }

    public void interpolate(double d, FrenetTrihedron frenetTrihedron, FrenetTrihedron frenetTrihedron2) {
        Vector3d vector3d = null;
        Vector3d vector3d2 = null;
        Vector3d vector3d3 = null;
        vector3d = new Vector3d();
        vector3d.interpolate((Tuple3d)frenetTrihedron.getOrigin(), (Tuple3d)frenetTrihedron2.getOrigin(), d);
        this.origin = vector3d;
        vector3d = new Vector3d();
        vector3d.interpolate((Tuple3d)frenetTrihedron.getTangent(), (Tuple3d)frenetTrihedron2.getTangent(), d);
        vector3d.normalize();
        this.tangent = vector3d;
        vector3d2 = new Vector3d();
        vector3d2.interpolate((Tuple3d)frenetTrihedron.getNormal(), (Tuple3d)frenetTrihedron2.getNormal(), d);
        vector3d2.normalize();
        this.normal = vector3d2;
        vector3d3 = new Vector3d();
        vector3d3.cross(this.tangent, this.normal);
        vector3d3.normalize();
        this.binormal = new Vector3d();
        this.binormal.set((Tuple3d)vector3d3);
    }

    public void interpolateByBinormal(double d, FrenetTrihedron frenetTrihedron, FrenetTrihedron frenetTrihedron2) {
        Vector3d vector3d = null;
        Vector3d vector3d2 = null;
        Vector3d vector3d3 = null;
        vector3d = new Vector3d();
        vector3d.interpolate((Tuple3d)frenetTrihedron.getOrigin(), (Tuple3d)frenetTrihedron2.getOrigin(), d);
        this.origin = vector3d;
        vector3d2 = new Vector3d();
        vector3d2.interpolate((Tuple3d)frenetTrihedron.getBinormal(), (Tuple3d)frenetTrihedron2.getBinormal(), d);
        vector3d2.normalize();
        this.binormal = vector3d2;
        vector3d3 = new Vector3d();
        vector3d3.cross(this.binormal, this.tangent);
        vector3d3.normalize();
        this.normal = vector3d3;
    }

    public Vector3d getOrigin() {
        return new Vector3d(this.origin);
    }

    public Vector3d getTangent() {
        return new Vector3d(this.tangent);
    }

    public Vector3d getNormal() {
        return new Vector3d(this.normal);
    }

    public Vector3d getBinormal() {
        return new Vector3d(this.binormal);
    }

    public static Vector3d getPreviousNormal() {
        return new Vector3d(previousNormal);
    }

    public static void setPreviousNormal(Vector3d vector3d) {
        previousNormal = new Vector3d(vector3d);
    }
}

