/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.viewers.StructureViewerImpl.AffineCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.BackboneLine;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionBuilder;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionStyle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Extrusion;
import edu.sdsc.mbt.viewers.StructureViewerImpl.FrenetTrihedron;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Hermite;
import edu.sdsc.mbt.viewers.StructureViewerImpl.IntrinsicCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.SsGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3d;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3f;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class HelixGeometry
extends SsGeometry {
    private static float HELIX_HERMITE_FACTOR = 4.7f;
    private static float HELIX_ALPHA = 0.558f;
    private static float HELIX_BETA = -0.191f;
    private double width = 2.6;
    private double height = 0.8;
    private int facets = 14;
    private int polygonStyle;
    private double start;
    private double end;
    private Vector3d[] tangents = null;
    private Vector3d[] normals = null;
    private Shape3D shape = null;

    public HelixGeometry() {
        this.csType = CrossSectionStyle.REGULAR_POLYGON;
        this.polygonStyle = 2;
        this.uniformColor = false;
        this.userData = "Helix";
        this.segments = 8;
        this.facets = 12;
    }

    public BranchGroup generateJ3dGeometry() {
        int n;
        this.processQualityInfo(this.quality);
        Hermite hermite = new Hermite();
        hermite.setKnotWeight(HELIX_HERMITE_FACTOR);
        if (this.csStyle == null) {
            double[] dArray = new double[]{this.height, this.width};
            this.csStyle = new CrossSectionStyle(this.csType, dArray);
            if (this.csStyle.getVertexCount() == 0) {
                this.csStyle.setVertexCount(this.facets + 1);
            }
            if (this.facets != this.csStyle.getVertexCount() && (this.csType == CrossSectionStyle.ROUNDED_TUBE || this.csType == CrossSectionStyle.REGULAR_POLYGON)) {
                this.csStyle.setVertexCount(this.facets + 1);
            }
        }
        this.csType = this.csStyle.getStyleType();
        int n2 = (this.coords.length - 1) * this.segments + 1;
        Vector3d[] vector3dArray = new Vector3d[n2];
        Vector3d[] vector3dArray2 = new Vector3d[n2];
        FrenetTrihedron[] frenetTrihedronArray = new FrenetTrihedron[n2];
        Vec3d vec3d = new Vec3d();
        Vec3d vec3d2 = new Vec3d();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = null;
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        Vec3d vec3d3 = new Vec3d();
        Vector3d vector3d7 = new Vector3d();
        FrenetTrihedron frenetTrihedron = null;
        FrenetTrihedron frenetTrihedron2 = null;
        this.getTangentsAndBinormals(0, this.coords, vec3d, vec3d2, vector3d4, vector3d5);
        vector3d.set(vec3d.value[0], vec3d.value[1], vec3d.value[2]);
        vector3d6.set((double)this.coords[0].value[0], (double)this.coords[0].value[1], (double)this.coords[0].value[2]);
        frenetTrihedron2 = new FrenetTrihedron(vector3d6, vector3d, vector3d4, 1);
        double d = 0.0;
        int n3 = -1;
        for (int i = 0; i < this.coords.length - 1; ++i) {
            this.getTangentsAndBinormals(i, this.coords, vec3d, vec3d2, vector3d4, vector3d5);
            vector3dArray[++n3] = new Vector3d((double)this.coords[i].value[0], (double)this.coords[i].value[1], (double)this.coords[i].value[2]);
            frenetTrihedronArray[n3] = new FrenetTrihedron(frenetTrihedron2);
            frenetTrihedron = frenetTrihedronArray[n3];
            hermite.set(this.coords[i].toVec3d(), this.coords[i + 1].toVec3d(), vec3d, vec3d2);
            vector3d2.set(vec3d2.value[0], vec3d2.value[1], vec3d2.value[2]);
            vector3d6.set((double)this.coords[i + 1].value[0], (double)this.coords[i + 1].value[1], (double)this.coords[i + 1].value[2]);
            frenetTrihedron2 = new FrenetTrihedron(vector3d6, vector3d2, vector3d5, 1);
            for (n = 1; n < this.segments; ++n) {
                d = (double)n * (1.0 / (double)this.segments);
                frenetTrihedronArray[++n3] = new FrenetTrihedron();
                hermite.sample(d, vec3d3);
                vector3d3 = hermite.getTangent(d);
                vector3d3.normalize();
                frenetTrihedronArray[n3].setTangent(vector3d3);
                frenetTrihedronArray[n3].interpolateByBinormal(d, frenetTrihedron, frenetTrihedron2);
                vector3d7.set(vec3d3.value[0], vec3d3.value[1], vec3d3.value[2]);
                frenetTrihedronArray[n3].setOriginOnly(vector3d7);
                vector3dArray[n3] = new Vector3d(vec3d3.value[0], vec3d3.value[1], vec3d3.value[2]);
            }
        }
        vector3dArray[++n3] = new Vector3d((double)this.coords[this.coords.length - 1].value[0], (double)this.coords[this.coords.length - 1].value[1], (double)this.coords[this.coords.length - 1].value[2]);
        frenetTrihedronArray[n3] = new FrenetTrihedron(frenetTrihedron2);
        vector3dArray2 = this.getTrigScale(n2, this.segments, coilWidth, this.width);
        double d2 = System.currentTimeMillis();
        if (this.uniformColor) {
            if (this.ssColor == null) {
                this.ssColor = new Color(1.0f, 0.0f, 0.0f);
            }
            Color3f[] color3fArray = new Color3f[]{new Color3f(this.ssColor)};
            this.csStyle.setVertexColors(color3fArray);
            this.pathColorMap = new float[n2 + 1][3];
            for (n = 0; n < n2 + 1; ++n) {
                this.pathColorMap[n] = this.ssColor.getColorComponents(null);
            }
        } else {
            this.setPathColor(n2);
        }
        double d3 = System.currentTimeMillis();
        this.branch = this.getFigure(this.csStyle, vector3dArray, vector3dArray2, frenetTrihedronArray, this.pathColorMap, n2);
        d2 = System.currentTimeMillis();
        double d4 = System.currentTimeMillis();
        this.branch.setCapability(17);
        this.branch.setCapability(12);
        return this.branch;
    }

    private BranchGroup getFigure(CrossSectionStyle crossSectionStyle, Vector3d[] vector3dArray, Vector3d[] vector3dArray2, FrenetTrihedron[] frenetTrihedronArray, float[][] fArray, int n) {
        double d = System.currentTimeMillis();
        Material material = new Material();
        Color3f color3f = new Color3f(new Color(1.0f, 1.0f, 0.0f));
        Color3f color3f2 = new Color3f(new Color(0.7f, 0.7f, 0.7f));
        Color3f color3f3 = new Color3f(new Color(0.9f, 0.9f, 0.9f));
        Color3f color3f4 = new Color3f(new Color(0.05f, 0.05f, 0.05f));
        material.setSpecularColor(color3f2);
        material.setAmbientColor(color3f3);
        material.setEmissiveColor(color3f4);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setPolygonMode(this.polygonStyle);
        polygonAttributes.setCullFace(1);
        appearance.setPolygonAttributes(polygonAttributes);
        Shape3D shape3D = new Shape3D();
        Object object = null;
        BranchGroup branchGroup = new BranchGroup();
        int n2 = 0;
        int[] nArray = null;
        int n3 = crossSectionStyle.getVertexCount();
        IntrinsicCrossSection intrinsicCrossSection = null;
        nArray = new int[n + 1];
        nArray[0] = nArray[n] = 2 * n3;
        for (int i = 1; i < n; ++i) {
            nArray[i] = 4 * (crossSectionStyle.getVertexCount() - 1);
        }
        intrinsicCrossSection = CrossSectionBuilder.getIntrinsicCrossSection(crossSectionStyle, frenetTrihedronArray[0].getTangent());
        intrinsicCrossSection.setColors(null);
        switch (this.csType) {
            case 0: {
                this.rounded = false;
                break;
            }
            case 1: {
                this.rounded = false;
                break;
            }
            case 2: {
                polygonAttributes.setBackFaceNormalFlip(true);
                polygonAttributes.setCullFace(0);
                this.rounded = false;
                break;
            }
            case 3: 
            case 4: {
                intrinsicCrossSection.averageNormals();
                this.rounded = true;
                break;
            }
            case 6: {
                nArray = new int[]{n};
                appearance.setLineAttributes(new LineAttributes(3.0f, 0, false));
                break;
            }
        }
        AffineCrossSection[] affineCrossSectionArray = new AffineCrossSection[n];
        if (vector3dArray2 != null) {
            for (int i = 0; i < n; ++i) {
                affineCrossSectionArray[i] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[i]);
                affineCrossSectionArray[i].scale((Tuple3d)vector3dArray2[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                affineCrossSectionArray[i] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[i]);
            }
        }
        object = this.csType != 6 ? new Extrusion(affineCrossSectionArray.length, n2, nArray, affineCrossSectionArray, fArray, n2, this.rounded) : new BackboneLine(n, nArray, vector3dArray, fArray);
        object.setCapability(3);
        object.setCapability(18);
        object.setCapability(3);
        this.shape = new Shape3D((Geometry)object, appearance);
        this.shape.setCapability(12);
        this.shape.setPickable(true);
        this.shape.setUserData(this.userData);
        branchGroup.addChild((Node)this.shape);
        double d2 = System.currentTimeMillis();
        return branchGroup;
    }

    private void getTangentsAndBinormals(int n, Vec3f[] vec3fArray, Vec3d vec3d, Vec3d vec3d2, Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        Vector3d vector3d7 = new Vector3d();
        Vector3d vector3d8 = new Vector3d();
        Vector3d vector3d9 = new Vector3d();
        Vector3d vector3d10 = new Vector3d();
        Vector3d vector3d11 = new Vector3d();
        Vector3d vector3d12 = new Vector3d();
        Vector3d vector3d13 = new Vector3d();
        Vector3d vector3d14 = new Vector3d();
        Vector3d vector3d15 = null;
        if (n == 0) {
            int n2 = n + 1;
            vector3d5.set((double)vec3fArray[n2 + 1].value[0], (double)vec3fArray[n2 + 1].value[1], (double)vec3fArray[n2 + 1].value[2]);
            vector3d6.set((double)vec3fArray[n2 - 1].value[0], (double)vec3fArray[n2 - 1].value[1], (double)vec3fArray[n2 - 1].value[2]);
            vector3d7.set((double)vec3fArray[n2].value[0], (double)vec3fArray[n2].value[1], (double)vec3fArray[n2].value[2]);
            vector3d11.sub((Tuple3d)vector3d5, (Tuple3d)vector3d6);
            vector3d11.normalize();
            vector3d8.set((Tuple3d)vector3d5);
            vector3d8.sub((Tuple3d)vector3d7);
            vector3d9.set((Tuple3d)vector3d7);
            vector3d9.sub((Tuple3d)vector3d6);
            vector3d12.cross(vector3d9, vector3d8);
            vector3d12.normalize();
            vector3d13.set((Tuple3d)vector3d11);
            vector3d14.set((Tuple3d)vector3d12);
            vector3d13.scale(Math.cos(HELIX_BETA));
            vector3d14.scale(Math.sin(HELIX_BETA));
            vector3d4.add((Tuple3d)vector3d13, (Tuple3d)vector3d14);
            if (this.previousCaCoord == null) {
                vector3d3.sub((Tuple3d)vector3d7, (Tuple3d)vector3d6);
                vector3d3.normalize();
            } else {
                Vector3d vector3d16 = new Vector3d((double)this.previousCaCoord.value[0], (double)this.previousCaCoord.value[1], (double)this.previousCaCoord.value[2]);
                vector3d3.sub((Tuple3d)vector3d7, (Tuple3d)vector3d16);
                vector3d7.sub((Tuple3d)vector3d6);
                vector3d7.normalize();
                vector3d6.sub((Tuple3d)vector3d16);
                vector3d6.normalize();
                vector3d7.sub((Tuple3d)vector3d6);
                vector3d3.normalize();
                vector3d15 = new Vector3d(vector3d3);
                vector3d15.scale(vector3d7.dot(vector3d15));
                vector3d7.sub((Tuple3d)vector3d15);
                vector3d7.normalize();
                vector3d.cross(vector3d3, vector3d7);
            }
            vec3d.value[0] = vector3d3.x;
            vec3d.value[1] = vector3d3.y;
            vec3d.value[2] = vector3d3.z;
            vec3d2.value[0] = vector3d4.x;
            vec3d2.value[1] = vector3d4.y;
            vec3d2.value[2] = vector3d4.z;
            vector3d11.scale(Math.sin(HELIX_ALPHA));
            vector3d12.scale(Math.cos(HELIX_ALPHA));
            vector3d2.add((Tuple3d)vector3d11, (Tuple3d)vector3d12);
            if (this.previousCaCoord == null) {
                vector3d.set((Tuple3d)vector3d2);
                vector3d3.scale(vector3d.dot(vector3d3));
                vector3d.sub((Tuple3d)vector3d3);
            }
            return;
        }
        if (n == vec3fArray.length - 2) {
            vec3d.value[0] = vec3d2.value[0];
            vec3d.value[1] = vec3d2.value[1];
            vec3d.value[2] = vec3d2.value[2];
            vector3d.set((Tuple3d)vector3d2);
            vector3d7.set((double)vec3fArray[n].value[0], (double)vec3fArray[n].value[1], (double)vec3fArray[n].value[2]);
            if (this.nextCaCoord == null) {
                vector3d5.set((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
                vector3d4.sub((Tuple3d)vector3d5, (Tuple3d)vector3d7);
                vector3d4.normalize();
                vector3d15 = new Vector3d(vector3d4);
                vector3d15.scale(vector3d15.dot(vector3d2));
                vector3d2.sub((Tuple3d)vector3d15);
            } else {
                Vector3d vector3d17 = new Vector3d((double)this.nextCaCoord.value[0], (double)this.nextCaCoord.value[1], (double)this.nextCaCoord.value[2]);
                vector3d4.sub((Tuple3d)vector3d17, (Tuple3d)vector3d7);
                vector3d4.normalize();
                vector3d5.set((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
                vector3d17.sub((Tuple3d)vector3d5);
                vector3d17.normalize();
                vector3d5.sub((Tuple3d)vector3d7);
                vector3d5.normalize();
                vector3d17.sub((Tuple3d)vector3d5);
                vector3d15 = new Vector3d(vector3d4);
                vector3d15.scale(vector3d17.dot(vector3d15));
                vector3d17.sub((Tuple3d)vector3d15);
                vector3d17.normalize();
                vector3d2.cross(vector3d4, vector3d17);
            }
            vec3d2.value[0] = vector3d4.x;
            vec3d2.value[1] = vector3d4.y;
            vec3d2.value[2] = vector3d4.z;
            return;
        }
        vec3d.value[0] = vec3d2.value[0];
        vec3d.value[1] = vec3d2.value[1];
        vec3d.value[2] = vec3d2.value[2];
        vector3d.set((Tuple3d)vector3d2);
        vector3d5.set((double)vec3fArray[n + 2].value[0], (double)vec3fArray[n + 2].value[1], (double)vec3fArray[n + 2].value[2]);
        vector3d6.set((double)vec3fArray[n].value[0], (double)vec3fArray[n].value[1], (double)vec3fArray[n].value[2]);
        vector3d7.set((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
        vector3d11 = new Vector3d();
        vector3d11.sub((Tuple3d)vector3d5, (Tuple3d)vector3d6);
        vector3d11.normalize();
        vector3d8.set((Tuple3d)vector3d5);
        vector3d8.sub((Tuple3d)vector3d7);
        vector3d9.set((Tuple3d)vector3d7);
        vector3d9.sub((Tuple3d)vector3d6);
        vector3d12 = new Vector3d();
        vector3d12.cross(vector3d9, vector3d8);
        vector3d12.normalize();
        vector3d13.set((Tuple3d)vector3d11);
        vector3d14.set((Tuple3d)vector3d12);
        vector3d13.scale(Math.cos(HELIX_BETA));
        vector3d14.scale(Math.sin(HELIX_BETA));
        vector3d4.add((Tuple3d)vector3d13, (Tuple3d)vector3d14);
        vec3d2.value[0] = vector3d4.x;
        vec3d2.value[1] = vector3d4.y;
        vec3d2.value[2] = vector3d4.z;
        vector3d11.scale(Math.sin(HELIX_ALPHA));
        vector3d12.scale(Math.cos(HELIX_ALPHA));
        vector3d2.add((Tuple3d)vector3d11, (Tuple3d)vector3d12);
    }

    private Vector3d[] getScale(int n, int n2, double d, double d2) {
        int n3;
        Vector3d[] vector3dArray = new Vector3d[n];
        Vector3d vector3d = new Vector3d(1.0, 1.0, 1.0);
        Vector3d vector3d2 = new Vector3d(1.0, 1.0, d2 / d);
        double d3 = (d2 - d) / d;
        vector3dArray[n - 1] = vector3dArray[0] = vector3d;
        for (n3 = 1; n3 < n2; ++n3) {
            double d4 = (double)n3 * (1.0 / (double)n2);
            double d5 = 1.0 + d4 * d3;
            vector3dArray[n - 1 - n3] = vector3dArray[n3] = new Vector3d(1.0, 1.0, d5);
        }
        for (n3 = n2; n3 < n - n2; ++n3) {
            vector3dArray[n3] = vector3d2;
        }
        return vector3dArray;
    }

    private Vector3d[] getTrigScale(int n, int n2, double d, double d2) {
        int n3;
        Vector3d[] vector3dArray = new Vector3d[n];
        Vector3d vector3d = new Vector3d(1.0, 1.0, 1.0);
        Vector3d vector3d2 = new Vector3d(1.0, 1.0, d2 / d);
        double d3 = (d2 - d) / d;
        vector3dArray[n - 1] = vector3dArray[0] = vector3d;
        for (n3 = 1; n3 < n2; ++n3) {
            double d4 = (double)n3 * (1.0 / (double)n2);
            double d5 = 1.0 + Math.sin(Math.PI * d4 / 2.0) * d3;
            vector3dArray[n - 1 - n3] = vector3dArray[n3] = new Vector3d(1.0, 1.0, d5);
        }
        for (n3 = n2; n3 < n - n2; ++n3) {
            vector3dArray[n3] = vector3d2;
        }
        return vector3dArray;
    }

    public void highlightResidueRegion(int n, float[] fArray) {
        if (this.csType != 6) {
            int n2 = this.csStyle.getVertexCount();
            int n3 = 2 * this.segments * (n2 - 1);
            int n4 = 2 * n2 + 2 * n3 * n;
            int n5 = n > 0 ? n4 - n3 : n4;
            int n6 = n < this.coords.length - 1 ? n4 + n3 : n4;
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            if (!this.highlighted) {
                extrusion.highlight(n5, n6, fArray);
                this.highlighted = true;
            } else {
                extrusion.updateColors(n5, n6, n * this.segments);
                this.highlighted = false;
            }
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            if (!this.highlighted) {
                backboneLine.highlight(n9, n10, fArray);
                this.highlighted = true;
            } else {
                backboneLine.updateColors(n9, n10);
                this.highlighted = false;
            }
        }
    }

    public void highlightResidue(int n, float[] fArray) {
        if (this.csType != 6) {
            int n2 = this.csStyle.getVertexCount();
            int n3 = 2 * this.segments * (n2 - 1);
            int n4 = 2 * n2 + 2 * n3 * n;
            int n5 = n > 0 ? n4 - n3 : n4;
            int n6 = n < this.coords.length - 1 ? n4 + n3 : n4;
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            extrusion.highlight(n5, n6, fArray);
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            backboneLine.highlight(n9, n10, fArray);
        }
    }

    public void resetGeometryColor() {
        Object object;
        if (this.csType != 6) {
            object = (Extrusion)this.shape.getGeometry();
            ((Extrusion)((Object)object)).setColors(this.pathColorMap);
        } else {
            object = (BackboneLine)this.shape.getGeometry();
            ((BackboneLine)((Object)object)).setColors(this.pathColorMap);
        }
        for (int i = 0; i < this.coords.length; ++i) {
            this.resetResidueColor(i);
        }
    }

    public void resetResidueColor(int n) {
        if (this.csType != 6) {
            int n2 = this.csStyle.getVertexCount();
            int n3 = 2 * this.segments * (n2 - 1);
            int n4 = 2 * n2 + 2 * n3 * n;
            int n5 = n > 0 ? n4 - n3 : n4 - 2 * n2;
            int n6 = n < this.coords.length - 1 ? n4 + n3 : n4 + 2 * n2;
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            extrusion.updateColors(n5, n6, n * this.segments);
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            backboneLine.updateColors(n9, n10);
        }
    }

    public void setNormals(Vector3d[] vector3dArray) {
        this.normals = vector3dArray;
    }

    public void setTangents(Vector3d[] vector3dArray) {
        this.tangents = vector3dArray;
    }

    public void setPolygonStyle(int n) {
        this.polygonStyle = n;
    }

    private void processQualityInfo(float f) {
        int n = 10;
        int n2 = 2;
        int n3 = 24;
        int n4 = 4;
        if (f < (float)n2 / (float)n) {
            this.segments = n2;
            this.segments += this.segments % 2;
        } else {
            this.segments = (int)(f * (float)n);
            this.segments += this.segments % 2;
        }
        if (this.csType == CrossSectionStyle.REGULAR_POLYGON || this.csType == CrossSectionStyle.ROUNDED_TUBE) {
            this.facets = f < (float)n4 / (float)n3 ? n4 : (int)(f * (float)n3);
        }
    }
}

