/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Hermite {
    private Vec3d[] coords = null;
    private float knotWeight = 1.0f;
    private Vec3d p1 = null;
    private Vec3d p2 = null;
    private Vec3d v1 = null;
    private Vec3d v2 = null;
    private Vector3d n1 = null;
    private Vector3d n2 = null;
    private Vector3d vv1 = null;
    private Vector3d vv2 = null;

    public Hermite() {
    }

    public Hermite(Vec3d[] vec3dArray, float f) {
        this.coords = vec3dArray;
        this.knotWeight = f;
    }

    public void setCoordinates(Vec3d[] vec3dArray) {
        this.coords = vec3dArray;
    }

    public void setEndNormals(Vector3d vector3d, Vector3d vector3d2) {
        this.n1 = new Vector3d(vector3d);
        this.n2 = new Vector3d(vector3d2);
    }

    public boolean fixTanCoeff() {
        if (this.v1 != null && this.v2 != null && this.n1 != null && this.n2 != null) {
            this.vv1 = new Vector3d(this.v1.value[0], this.v1.value[1], this.v1.value[2]);
            this.vv2 = new Vector3d(this.v2.value[0], this.v2.value[1], this.v2.value[2]);
            this.vv1.normalize();
            this.vv2.normalize();
            Vector3d vector3d = new Vector3d();
            Vector3d vector3d2 = new Vector3d();
            vector3d.cross(this.vv1, this.n1);
            vector3d2.cross(this.vv2, this.n2);
            Vector3d vector3d3 = new Vector3d();
            vector3d3.set(this.p2.value[0] - this.p1.value[0], this.p2.value[1] - this.p1.value[1], this.p2.value[2] - this.p1.value[2]);
            System.out.println();
            System.out.println(" The distance is ");
            System.out.println(" " + vector3d3.length());
            System.out.println("First origin (" + this.p1.value[0] + " " + this.p1.value[1] + " " + this.p1.value[2] + " )");
            System.out.println("Second origin (" + this.p2.value[0] + " " + this.p2.value[1] + " " + this.p2.value[2] + " )");
            System.out.println("Distance (" + vector3d3.x + " " + vector3d3.y + " " + vector3d3.z + " )");
            System.out.println("First tangent (" + this.vv1.x + " " + this.vv1.y + " " + this.vv1.z + " )");
            System.out.println("Second tangent (" + this.vv2.x + " " + this.vv2.y + " " + this.vv2.z + " )");
            System.out.println("First normal (" + this.n1.x + " " + this.n1.y + " " + this.n1.z + " )");
            System.out.println("Second normal (" + this.n2.x + " " + this.n2.y + " " + this.n2.z + " )");
            System.out.println("First binormal (" + vector3d.x + " " + vector3d.y + " " + vector3d.z + " )");
            System.out.println("Second binormal (" + vector3d2.x + " " + vector3d2.y + " " + vector3d2.z + " )");
            System.out.println();
            System.out.println("Dot product d.b1 " + vector3d3.dot(vector3d));
            System.out.println("Dot product d.b2 " + vector3d3.dot(vector3d2));
            System.out.println("Dot product t1.b2 " + this.vv1.dot(vector3d2));
            System.out.println("Dot product t2.b1 " + this.vv2.dot(vector3d));
            double d = 3.0 * vector3d3.dot(vector3d2) / this.vv1.dot(vector3d2);
            double d2 = 3.0 * vector3d3.dot(vector3d) / this.vv2.dot(vector3d);
            System.out.println();
            System.out.println(" The scale factors are  ");
            System.out.println("First " + d);
            System.out.println("Second " + d2);
            System.out.println();
            this.vv1.scale(d);
            this.vv2.scale(d2);
            this.v1.value[0] = this.vv1.x;
            this.v1.value[1] = this.vv1.y;
            this.v1.value[2] = this.vv1.z;
            this.v2.value[0] = this.vv2.x;
            this.v2.value[1] = this.vv2.y;
            this.v2.value[2] = this.vv2.z;
            return true;
        }
        return false;
    }

    public Vec3d[] getCoordinates() {
        return this.coords;
    }

    public void setKnotWeight(float f) {
        this.knotWeight = f;
    }

    public float getKnotWeight() {
        return this.knotWeight;
    }

    public void sample(double d, Vec3d vec3d) {
        double d2 = d * d;
        double d3 = d2 * d;
        double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
        double d5 = -2.0 * d3 + 3.0 * d2;
        double d6 = d3 - 2.0 * d2 + d;
        double d7 = d3 - d2;
        vec3d.value[0] = this.p1.value[0] * d4 + this.p2.value[0] * d5 + this.v1.value[0] * d6 + this.v2.value[0] * d7;
        vec3d.value[1] = this.p1.value[1] * d4 + this.p2.value[1] * d5 + this.v1.value[1] * d6 + this.v2.value[1] * d7;
        vec3d.value[2] = this.p1.value[2] * d4 + this.p2.value[2] * d5 + this.v1.value[2] * d6 + this.v2.value[2] * d7;
    }

    public Vector3d getTangent(double d) {
        Vector3d vector3d = new Vector3d();
        double d2 = d * d;
        double d3 = 6.0 * (d2 - d);
        double d4 = -d3;
        double d5 = 3.0 * d2 - 4.0 * d + 1.0;
        double d6 = 3.0 * d2 - 2.0 * d;
        vector3d.x = this.p1.value[0] * d3 + this.p2.value[0] * d4 + this.v1.value[0] * d5 + this.v2.value[0] * d6;
        vector3d.y = this.p1.value[1] * d3 + this.p2.value[1] * d4 + this.v1.value[1] * d5 + this.v2.value[1] * d6;
        vector3d.z = this.p1.value[2] * d3 + this.p2.value[2] * d4 + this.v1.value[2] * d5 + this.v2.value[2] * d6;
        return vector3d;
    }

    public Vector3d getNormal(double d) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        vector3d2 = this.getTangent(d);
        vector3d2.normalize();
        vector3d = this.getSecondDerivative(d);
        vector3d2.scale(vector3d2.dot(vector3d));
        vector3d.sub((Tuple3d)vector3d2);
        return vector3d;
    }

    private Vector3d getSecondDerivative(double d) {
        Vector3d vector3d = new Vector3d();
        double d2 = -12.0 * d + 6.0;
        double d3 = 6.0 * d - 4.0;
        double d4 = 6.0 * d - 2.0;
        vector3d.x = d2 * (this.p2.value[0] - this.p1.value[0]) + d3 * this.v1.value[0] + d4 * this.v2.value[0];
        vector3d.y = d2 * (this.p2.value[1] - this.p1.value[1]) + d3 * this.v1.value[1] + d4 * this.v2.value[1];
        vector3d.z = d2 * (this.p2.value[2] - this.p1.value[2]) + d3 * this.v1.value[2] + d4 * this.v2.value[2];
        return vector3d;
    }

    public void set(Vec3d vec3d, Vec3d vec3d2, Vec3d vec3d3, Vec3d vec3d4) {
        this.p1 = new Vec3d(vec3d.value[0], vec3d.value[1], vec3d.value[2]);
        this.p2 = new Vec3d(vec3d2.value[0], vec3d2.value[1], vec3d2.value[2]);
        this.v1 = new Vec3d(vec3d3.value[0], vec3d3.value[1], vec3d3.value[2]);
        this.v2 = new Vec3d(vec3d4.value[0], vec3d4.value[1], vec3d4.value[2]);
        this.v1.value[0] = this.v1.value[0] * (double)this.knotWeight;
        this.v1.value[1] = this.v1.value[1] * (double)this.knotWeight;
        this.v1.value[2] = this.v1.value[2] * (double)this.knotWeight;
        this.v2.value[0] = this.v2.value[0] * (double)this.knotWeight;
        this.v2.value[1] = this.v2.value[1] * (double)this.knotWeight;
        this.v2.value[2] = this.v2.value[2] * (double)this.knotWeight;
    }

    public void set(Vec3d vec3d, Vec3d vec3d2, Vector3d vector3d, Vector3d vector3d2) {
        this.p1 = new Vec3d(vec3d.value[0], vec3d.value[1], vec3d.value[2]);
        this.p2 = new Vec3d(vec3d2.value[0], vec3d2.value[1], vec3d2.value[2]);
        this.v1 = new Vec3d(vector3d.x, vector3d.y, vector3d.z);
        this.v2 = new Vec3d(vector3d2.x, vector3d2.y, vector3d2.z);
        this.v1.value[0] = this.v1.value[0] * (double)this.knotWeight;
        this.v1.value[1] = this.v1.value[1] * (double)this.knotWeight;
        this.v1.value[2] = this.v1.value[2] * (double)this.knotWeight;
        this.v2.value[0] = this.v2.value[0] * (double)this.knotWeight;
        this.v2.value[1] = this.v2.value[1] * (double)this.knotWeight;
        this.v2.value[2] = this.v2.value[2] * (double)this.knotWeight;
    }
}

