/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.viewers.StructureViewerImpl.FrenetTrihedron;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3d;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;

public class IntrinsicCrossSection {
    private int vertexCount = 0;
    private Vec3d[] vertex = null;
    private Vector3d[] vectorVertex = null;
    private Vec3d[] normal = null;
    private Vector3d[] vectorNormal = null;
    private Color3f[] color = null;
    private Color3f sideColor = null;

    public IntrinsicCrossSection() {
    }

    public IntrinsicCrossSection(int n) {
        this.vertexCount = n;
        this.vertex = new Vec3d[n];
        this.normal = new Vec3d[n];
        this.vectorVertex = new Vector3d[n];
        this.vectorNormal = new Vector3d[n];
    }

    public IntrinsicCrossSection(int n, Vec3d[] vec3dArray) {
        this.vertexCount = n;
        this.vertex = new Vec3d[n];
        this.normal = new Vec3d[n];
        this.vectorVertex = new Vector3d[n];
        this.vectorNormal = new Vector3d[n];
        for (int i = 0; i < n; ++i) {
            this.vertex[i] = new Vec3d();
            this.vertex[i].value[0] = vec3dArray[i].value[0];
            this.vertex[i].value[1] = vec3dArray[i].value[1];
            this.vertex[i].value[2] = vec3dArray[i].value[2];
            this.vectorVertex[i] = new Vector3d(this.vertex[i].value[0], this.vertex[i].value[1], this.vertex[i].value[2]);
        }
    }

    public IntrinsicCrossSection(int n, Vec3d[] vec3dArray, Vec3d[] vec3dArray2) {
        this.vertexCount = n;
        this.vertex = new Vec3d[n];
        this.normal = new Vec3d[n];
        this.vectorVertex = new Vector3d[n];
        this.vectorNormal = new Vector3d[n];
        for (int i = 0; i < n; ++i) {
            this.vertex[i] = new Vec3d();
            this.vertex[i].value[0] = vec3dArray[i].value[0];
            this.vertex[i].value[1] = vec3dArray[i].value[1];
            this.vertex[i].value[2] = vec3dArray[i].value[2];
            this.vectorVertex[i] = new Vector3d(this.vertex[i].value[0], this.vertex[i].value[1], this.vertex[i].value[2]);
            this.normal[i] = new Vec3d();
            this.normal[i].value[0] = vec3dArray2[i].value[0];
            this.normal[i].value[1] = vec3dArray2[i].value[1];
            this.normal[i].value[2] = vec3dArray2[i].value[2];
            this.vectorNormal[i] = new Vector3d(this.normal[i].value[0], this.normal[i].value[1], this.normal[i].value[2]);
        }
    }

    public IntrinsicCrossSection(int n, Vec3d[] vec3dArray, Vec3d[] vec3dArray2, Color3f[] color3fArray) {
        this.vertexCount = n;
        this.vertex = new Vec3d[n];
        this.normal = new Vec3d[n];
        this.color = new Color3f[n];
        this.vectorVertex = new Vector3d[n];
        this.vectorNormal = new Vector3d[n];
        for (int i = 0; i < n; ++i) {
            this.vertex[i] = new Vec3d();
            this.vertex[i].value[0] = vec3dArray[i].value[0];
            this.vertex[i].value[1] = vec3dArray[i].value[1];
            this.vertex[i].value[2] = vec3dArray[i].value[2];
            this.vectorVertex[i] = new Vector3d(this.vertex[i].value[0], this.vertex[i].value[1], this.vertex[i].value[2]);
            this.normal[i] = new Vec3d();
            this.normal[i].value[0] = vec3dArray2[i].value[0];
            this.normal[i].value[1] = vec3dArray2[i].value[1];
            this.normal[i].value[2] = vec3dArray2[i].value[2];
            this.vectorNormal[i] = new Vector3d(this.normal[i].value[0], this.normal[i].value[1], this.normal[i].value[2]);
            this.color[i] = new Color3f(color3fArray[i].x, color3fArray[i].y, color3fArray[i].z);
        }
    }

    public IntrinsicCrossSection(IntrinsicCrossSection intrinsicCrossSection) {
        this.vertexCount = intrinsicCrossSection.getVertexCount();
        this.vertex = new Vec3d[this.vertexCount];
        this.normal = new Vec3d[this.vertexCount];
        this.vectorVertex = new Vector3d[this.vertexCount];
        this.vectorNormal = new Vector3d[this.vertexCount];
        if (intrinsicCrossSection.getColors() != null) {
            this.color = new Color3f[this.vertexCount];
            this.color = (Color3f[])intrinsicCrossSection.getColors().clone();
        }
        for (int i = 0; i < this.vertexCount; ++i) {
            Vec3d vec3d = new Vec3d();
            vec3d = intrinsicCrossSection.getVertices()[i];
            this.vertex[i] = new Vec3d();
            this.vertex[i].value[0] = vec3d.value[0];
            this.vertex[i].value[1] = vec3d.value[1];
            this.vertex[i].value[2] = vec3d.value[2];
            this.vectorVertex[i] = new Vector3d(this.vertex[i].value[0], this.vertex[i].value[1], this.vertex[i].value[2]);
            Vec3d vec3d2 = new Vec3d();
            vec3d2 = intrinsicCrossSection.getNormals()[i];
            this.normal[i] = new Vec3d();
            this.normal[i].value[0] = vec3d2.value[0];
            this.normal[i].value[1] = vec3d2.value[1];
            this.normal[i].value[2] = vec3d2.value[2];
            this.vectorNormal[i] = new Vector3d(this.normal[i].value[0], this.normal[i].value[1], this.normal[i].value[2]);
        }
        this.sideColor = intrinsicCrossSection.getSideColor();
    }

    public void scale(Tuple3d tuple3d) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        for (int i = 0; i < this.vertex.length; ++i) {
            vector3d.set(this.vertex[i].value[0], this.vertex[i].value[1], this.vertex[i].value[2]);
            vector3d2.set(tuple3d.x * vector3d.x, tuple3d.y * vector3d.y, tuple3d.z * vector3d.z);
            this.vertex[i].value[0] = vector3d2.x;
            this.vertex[i].value[1] = vector3d2.y;
            this.vertex[i].value[2] = vector3d2.z;
            this.vectorVertex[i].set((Tuple3d)vector3d2);
        }
    }

    public void rotate(double d, Vec3d vec3d, Vec3d vec3d2) {
        Vector3d vector3d = new Vector3d(vec3d.value[0], vec3d.value[1], vec3d.value[2]);
        Vector3d vector3d2 = new Vector3d(vec3d2.value[0], vec3d2.value[1], vec3d2.value[2]);
        vector3d2.normalize();
        Vector3d vector3d3 = new Vector3d();
        double d2 = Math.cos(d / 2.0);
        double d3 = Math.sin(d / 2.0);
        double d4 = d3 * vector3d2.x;
        double d5 = d3 * vector3d2.y;
        double d6 = d3 * vector3d2.z;
        Quat4d quat4d = new Quat4d();
        quat4d.set(d4, d5, d6, d2);
        Quat4d quat4d2 = new Quat4d();
        Quat4d quat4d3 = new Quat4d();
        Vector3d vector3d4 = new Vector3d();
        for (int i = 0; i < this.vertex.length; ++i) {
            vector3d3.set(this.vertex[i].value[0], this.vertex[i].value[1], this.vertex[i].value[2]);
            vector3d3.sub((Tuple3d)vector3d);
            quat4d2.set(vector3d3.x, vector3d3.y, vector3d3.z, 0.0);
            quat4d3.set((Tuple4d)quat4d);
            quat4d2.mulInverse(quat4d);
            quat4d3.mul(quat4d2);
            vector3d4.set(quat4d3.x, quat4d3.y, quat4d3.z);
            vector3d4.add((Tuple3d)vector3d);
            this.vectorVertex[i].set(vector3d4.x, vector3d4.y, vector3d4.z);
            this.vertex[i].value[0] = vector3d4.x;
            this.vertex[i].value[1] = vector3d4.y;
            this.vertex[i].value[2] = vector3d4.z;
        }
    }

    public void rotate(double d, Vec3d vec3d) {
        this.rotate(d, new Vec3d(0.0, 0.0, 0.0), vec3d);
    }

    public Point3d[] generatePoints(FrenetTrihedron frenetTrihedron) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d(frenetTrihedron.getOrigin());
        Point3d[] point3dArray = new Point3d[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            point3dArray[i] = new Point3d();
            vector3d.add((Tuple3d)this.generateGlobalVector(this.vectorVertex[i], frenetTrihedron), (Tuple3d)vector3d2);
            point3dArray[i].set((Tuple3d)vector3d);
        }
        return point3dArray;
    }

    public Vector3d[] generateNormals(FrenetTrihedron frenetTrihedron) {
        Vector3d[] vector3dArray = new Vector3d[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            vector3dArray[i] = new Vector3d();
            vector3dArray[i].set((Tuple3d)this.generateGlobalVector(this.vectorNormal[i], frenetTrihedron));
        }
        return vector3dArray;
    }

    private Vector3d generateGlobalVector(Vector3d vector3d, FrenetTrihedron frenetTrihedron) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d2.set((Tuple3d)frenetTrihedron.getTangent());
        vector3d2.scale(vector3d.x);
        vector3d3.set((Tuple3d)frenetTrihedron.getNormal());
        vector3d3.scale(vector3d.y);
        vector3d4.set((Tuple3d)frenetTrihedron.getBinormal());
        vector3d4.scale(vector3d.z);
        Vector3d vector3d5 = new Vector3d();
        vector3d5.add((Tuple3d)vector3d2, (Tuple3d)vector3d3);
        vector3d5.add((Tuple3d)vector3d4);
        return vector3d5;
    }

    public void setNormalsByVector(Vec3d vec3d) {
        Vector3d vector3d = new Vector3d();
        vector3d.x = vec3d.value[0];
        vector3d.y = vec3d.value[1];
        vector3d.z = vec3d.value[2];
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        int n = 0;
        int n2 = this.vertexCount - 1;
        if (this.vertexCount <= 2) {
            n2 = this.vertexCount;
        }
        for (int i = 0; i < this.vertex.length; ++i) {
            vector3d2.x = this.vertex[i].value[0];
            vector3d2.y = this.vertex[i].value[1];
            vector3d2.z = this.vertex[i].value[2];
            n = (i + 1) % n2;
            vector3d3.x = this.vertex[n].value[0];
            vector3d3.y = this.vertex[n].value[1];
            vector3d3.z = this.vertex[n].value[2];
            vector3d4.sub((Tuple3d)vector3d3, (Tuple3d)vector3d2);
            vector3d5.cross(vector3d, vector3d4);
            vector3d5.normalize();
            this.normal[i] = new Vec3d();
            this.normal[i].value[0] = vector3d5.x;
            this.normal[i].value[1] = vector3d5.y;
            this.normal[i].value[2] = vector3d5.z;
            this.vectorNormal[i] = new Vector3d(vector3d5.x, vector3d5.y, vector3d5.z);
        }
    }

    public void setNormalsByVector(Vector3d vector3d) {
        Vector3d vector3d2 = vector3d;
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        int n = 0;
        int n2 = this.vertexCount - 1;
        if (this.vertexCount <= 2) {
            n2 = this.vertexCount;
        }
        for (int i = 0; i < this.vertexCount - 1; ++i) {
            vector3d3.x = this.vertex[i].value[0];
            vector3d3.y = this.vertex[i].value[1];
            vector3d3.z = this.vertex[i].value[2];
            n = (i + 1) % n2;
            vector3d4.x = this.vertex[n].value[0];
            vector3d4.y = this.vertex[n].value[1];
            vector3d4.z = this.vertex[n].value[2];
            vector3d5.sub((Tuple3d)vector3d4, (Tuple3d)vector3d3);
            vector3d6.cross(vector3d2, vector3d5);
            vector3d6.normalize();
            this.normal[i] = new Vec3d();
            this.normal[i].value[0] = vector3d6.x;
            this.normal[i].value[1] = vector3d6.y;
            this.normal[i].value[2] = vector3d6.z;
            this.vectorNormal[i] = new Vector3d(vector3d6.x, vector3d6.y, vector3d6.z);
        }
        this.normal[this.vertexCount - 1] = this.normal[0];
        this.vectorNormal[this.vertexCount - 1] = this.vectorNormal[0];
    }

    public void averageNormals() {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        vector3d2.set((Tuple3d)this.vectorNormal[0]);
        this.vectorNormal[0].set((Tuple3d)this.vectorNormal[0]);
        this.vectorNormal[0].add((Tuple3d)this.vectorNormal[this.vertexCount - 1]);
        this.vectorNormal[0].normalize();
        this.normal[0].value[0] = this.vectorNormal[0].x;
        this.normal[0].value[1] = this.vectorNormal[0].y;
        this.normal[0].value[2] = this.vectorNormal[0].z;
        for (int i = 1; i < this.vertexCount - 1; ++i) {
            vector3d.set((Tuple3d)this.vectorNormal[i]);
            vector3d.add((Tuple3d)vector3d2);
            vector3d.normalize();
            vector3d2.set((Tuple3d)this.vectorNormal[i]);
            this.vectorNormal[i].set((Tuple3d)vector3d);
            this.normal[i].value[0] = this.vectorNormal[i].x;
            this.normal[i].value[1] = this.vectorNormal[i].y;
            this.normal[i].value[2] = this.vectorNormal[i].z;
        }
        this.vectorNormal[this.vertexCount - 1] = this.vectorNormal[0];
        this.normal[this.vertexCount - 1] = this.normal[0];
    }

    public void setColors(Color3f[] color3fArray) {
        this.color = color3fArray;
    }

    public void setSideColor(Color3f color3f) {
        this.sideColor = color3f;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public Color3f getSideColor() {
        return this.sideColor;
    }

    public Vec3d[] getVertices() {
        return this.vertex;
    }

    public Vector3d[] getVectorVertices() {
        return this.vectorVertex;
    }

    public Vec3d[] getNormals() {
        return this.normal;
    }

    public Vector3d[] getVectorNormals() {
        return this.vectorNormal;
    }

    public Color3f[] getColors() {
        return this.color;
    }
}

