/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.viewables.StructureStyles;
import edu.sdsc.mbt.viewers.StructureViewerImpl.AtomGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.BondGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionStyle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.GeometryEntity;
import edu.sdsc.mbt.viewers.StructureViewerImpl.LabelJ3D;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;

public class PsGeometry
extends GeometryEntity {
    double covalentCutoffDistance = 1.9;
    double HBondCutoffDistance = 2.5;

    public static void drawBonds(BranchGroup branchGroup, Bond[] bondArray, StructureStyles structureStyles, float f, int n, Hashtable hashtable) {
        BondGeometry bondGeometry;
        Atom atom = null;
        Atom atom2 = null;
        float[][] fArray = new float[2][3];
        Vector3d[] vector3dArray = new Vector3d[2];
        if (bondArray.length == 0) {
            return;
        }
        int n2 = -1;
        for (int i = 0; i < bondArray.length; ++i) {
            atom = bondArray[i].getAtom(0);
            atom2 = bondArray[i].getAtom(1);
            vector3dArray[0] = new Vector3d(atom.coordinate);
            vector3dArray[1] = new Vector3d(atom2.coordinate);
            if (structureStyles.getBondSelection(bondArray[i])) {
                StructureStyles.getSelectionColor(fArray[0]);
                StructureStyles.getSelectionColor(fArray[1]);
            } else {
                structureStyles.getBondColor(bondArray[i], fArray[0]);
                structureStyles.getSplitBondColor(bondArray[i], fArray[1]);
            }
            bondGeometry = new BondGeometry(vector3dArray, fArray, bondArray[i]);
            bondGeometry.setStyle(CrossSectionStyle.POINT);
            if (n == 0) {
                bondGeometry.setCap1(false);
                bondGeometry.setCap2(false);
            }
            bondGeometry.setQuality(f);
            branchGroup.addChild((Node)bondGeometry.generateJ3dGeometry());
            hashtable.put(bondArray[i], bondGeometry);
        }
        bondGeometry = null;
        fArray = null;
        vector3dArray = null;
    }

    public static void drawBonds(BranchGroup branchGroup, Bond[] bondArray, StructureStyles structureStyles, int n, float f, int n2, Hashtable hashtable) {
        BondGeometry bondGeometry;
        Atom atom = null;
        Atom atom2 = null;
        float[][] fArray = new float[2][3];
        Vector3d[] vector3dArray = new Vector3d[2];
        if (bondArray.length == 0) {
            return;
        }
        int n3 = -1;
        for (int i = 0; i < bondArray.length; ++i) {
            atom = bondArray[i].getAtom(0);
            atom2 = bondArray[i].getAtom(1);
            vector3dArray[0] = new Vector3d(atom.coordinate);
            vector3dArray[1] = new Vector3d(atom2.coordinate);
            if (structureStyles.getBondSelection(bondArray[i])) {
                StructureStyles.getSelectionColor(fArray[0]);
                StructureStyles.getSelectionColor(fArray[1]);
            } else {
                structureStyles.getBondColor(bondArray[i], fArray[0]);
                structureStyles.getSplitBondColor(bondArray[i], fArray[1]);
            }
            bondGeometry = new BondGeometry(vector3dArray, fArray, bondArray[i]);
            bondGeometry.setStyle(n);
            if (n2 == 0) {
                bondGeometry.setCap1(false);
                bondGeometry.setCap2(false);
            }
            bondGeometry.setQuality(f);
            branchGroup.addChild((Node)bondGeometry.generateJ3dGeometry());
            hashtable.put(bondArray[i], bondGeometry);
        }
        bondGeometry = null;
        fArray = null;
        vector3dArray = null;
    }

    public static void drawAtoms(BranchGroup branchGroup, Atom[] atomArray, StructureStyles structureStyles, float f, Hashtable hashtable) {
        PsGeometry.drawAtoms(branchGroup, atomArray, structureStyles, f, false, hashtable);
    }

    public static void drawAtoms(BranchGroup branchGroup, Atom[] atomArray, StructureStyles structureStyles, float f, boolean bl, Hashtable hashtable) {
        boolean bl2 = false;
        if (!bl2) {
            Vector3d vector3d = new Vector3d();
            Appearance appearance = null;
            Material material = null;
            Transform3D transform3D = new Transform3D();
            BranchGroup branchGroup2 = new BranchGroup();
            Object var12_12 = null;
            float[] fArray = new float[3];
            double[] dArray = new double[3];
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            for (int i = 0; i < atomArray.length; ++i) {
                double d = structureStyles.getAtomRadius(atomArray[i]);
                vector3d = new Vector3d(atomArray[i].coordinate);
                if (structureStyles.getAtomSelection(atomArray[i])) {
                    StructureStyles.getSelectionColor(fArray);
                } else {
                    structureStyles.getAtomColor(atomArray[i], fArray);
                }
                material = new Material();
                material.setDiffuseColor(fArray[0], fArray[1], fArray[2]);
                material.setCapability(0);
                material.setCapability(1);
                appearance = new Appearance();
                appearance.setMaterial(material);
                appearance.setCapability(0);
                appearance.setCapability(1);
                int n = 2;
                PolygonAttributes polygonAttributes = new PolygonAttributes();
                polygonAttributes.setCullFace(1);
                polygonAttributes.setPolygonMode(n);
                appearance.setPolygonAttributes(polygonAttributes);
                AtomGeometry atomGeometry = new AtomGeometry(vector3d, appearance, f, d, (Object)atomArray[i]);
                if (bl) {
                    atomGeometry.setLabel(new LabelJ3D(structureStyles.getAtomLabel(atomArray[i]), dArray));
                }
                branchGroup.addChild((Node)atomGeometry.generateJ3dGeometry());
                hashtable.put(atomArray[i], atomGeometry);
            }
        }
    }

    public static void drawAtoms(BranchGroup branchGroup, Atom[] atomArray, StructureStyles structureStyles, int n, float f, Hashtable hashtable) {
        boolean bl = false;
        if (!bl) {
            Vector3d vector3d = new Vector3d();
            Appearance appearance = null;
            Material material = null;
            Transform3D transform3D = new Transform3D();
            BranchGroup branchGroup2 = new BranchGroup();
            Object var12_12 = null;
            float[] fArray = new float[3];
            PolygonAttributes polygonAttributes = null;
            if (n == 1) {
                polygonAttributes = new PolygonAttributes();
                polygonAttributes.setCullFace(0);
                polygonAttributes.setBackFaceNormalFlip(true);
                polygonAttributes.setPolygonMode(n);
                f = 0.3f;
            }
            for (int i = 0; i < atomArray.length; ++i) {
                double d = structureStyles.getAtomRadius(atomArray[i]);
                vector3d = new Vector3d(atomArray[i].coordinate);
                if (structureStyles.getAtomSelection(atomArray[i])) {
                    StructureStyles.getSelectionColor(fArray);
                } else {
                    structureStyles.getAtomColor(atomArray[i], fArray);
                }
                material = new Material();
                material.setDiffuseColor(fArray[0], fArray[1], fArray[2]);
                material.setCapability(0);
                material.setCapability(1);
                appearance = new Appearance();
                appearance.setMaterial(material);
                appearance.setCapability(0);
                appearance.setCapability(1);
                appearance.setLineAttributes(new LineAttributes(3.0f, 0, true));
                appearance.setPolygonAttributes(polygonAttributes);
                AtomGeometry atomGeometry = new AtomGeometry(vector3d, appearance, f, d, (Object)atomArray[i]);
                branchGroup.addChild((Node)atomGeometry.generateJ3dGeometry());
                hashtable.put(atomArray[i], atomGeometry);
            }
        }
    }
}

