/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Fragment;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.viewables.StructureStyles;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CoilGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionStyle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.FragmentTooShortException;
import edu.sdsc.mbt.viewers.StructureViewerImpl.GeometryEntity;
import edu.sdsc.mbt.viewers.StructureViewerImpl.HelixGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Priestle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.StrandGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3f;
import java.awt.Color;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;

public class SsGeometry
extends GeometryEntity {
    private int priestleSteps = 2;
    protected Vec3f[] coords = null;
    protected Vec3f previousCaCoord;
    protected Vec3f nextCaCoord;
    protected Color ssColor;
    protected static double coilWidth = 0.8;
    protected float[][] pathColorMap = null;
    protected float[][] colorMap;
    protected boolean uniformColor;
    protected Object userData = null;
    protected int csType;
    protected CrossSectionStyle csStyle = null;
    protected boolean highlighted = false;
    protected int segments;
    protected SsGeometry previousSs = null;
    protected SsGeometry nextSs = null;
    protected boolean leftExtended = false;
    protected boolean rightExtended = false;
    protected boolean rounded = true;

    public static void drawSs(BranchGroup branchGroup, StructureMap structureMap, StructureStyles structureStyles, boolean bl, Hashtable hashtable) throws FragmentTooShortException {
        float f = 0.8f;
        float f2 = 0.8f;
        float f3 = 0.8f;
        float f4 = 0.8f;
        int n = 0;
        int n2 = 2;
        int n3 = 2;
        int n4 = 2;
        int n5 = CrossSectionStyle.REGULAR_POLYGON;
        int n6 = CrossSectionStyle.RECTANGULAR_RIBBON;
        int n7 = CrossSectionStyle.ROUNDED_TUBE;
        int n8 = CrossSectionStyle.ROUNDED_TUBE;
        SsGeometry.drawSs(branchGroup, structureMap, structureStyles, bl, hashtable, f, f4, f3, f2, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static void drawSs(BranchGroup branchGroup, StructureMap structureMap, StructureStyles structureStyles, boolean bl, Hashtable hashtable, int n, int n2, int n3, int n4) throws FragmentTooShortException {
        float f = 0.8f;
        float f2 = 0.8f;
        float f3 = 0.8f;
        float f4 = 0.8f;
        int n5 = CrossSectionStyle.REGULAR_POLYGON;
        int n6 = CrossSectionStyle.RECTANGULAR_RIBBON;
        int n7 = CrossSectionStyle.ROUNDED_TUBE;
        int n8 = CrossSectionStyle.ROUNDED_TUBE;
        SsGeometry.drawSs(branchGroup, structureMap, structureStyles, bl, hashtable, f, f4, f3, f2, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static void drawSs(BranchGroup branchGroup, StructureMap structureMap, StructureStyles structureStyles, boolean bl, Hashtable hashtable, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws FragmentTooShortException {
        Object object;
        int n9 = 0;
        int n10 = 0;
        Atom atom = new Atom();
        Atom atom2 = new Atom();
        Atom atom3 = new Atom();
        Residue residue = null;
        Chain chain = null;
        Vec3f[] vec3fArray = null;
        Vec3f vec3f = null;
        Vec3f vec3f2 = null;
        float[][] fArray = null;
        SsGeometry ssGeometry = null;
        CoilGeometry coilGeometry = null;
        CoilGeometry coilGeometry2 = null;
        StrandGeometry strandGeometry = null;
        HelixGeometry helixGeometry = null;
        double[] dArray = new double[2];
        dArray[0] = 1.0;
        dArray[0] = coilWidth;
        dArray[1] = 0.2;
        CrossSectionStyle crossSectionStyle = new CrossSectionStyle(CrossSectionStyle.REGULAR_POLYGON, dArray);
        CrossSectionStyle crossSectionStyle2 = new CrossSectionStyle(CrossSectionStyle.RECTANGULAR_RIBBON, dArray);
        crossSectionStyle.setVertexCount(10);
        Vector<SsGeometry> vector = new Vector<SsGeometry>();
        int n11 = structureMap.getChainCount();
        Fragment fragment = null;
        int n12 = 0;
        int n13 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n11; ++i) {
            chain = structureMap.getChain(i);
            n9 = chain.getFragmentCount();
            vec3f = null;
            vec3f2 = null;
            ssGeometry = null;
            object = null;
            boolean bl4 = true;
            for (int j = 0; j < n9; ++j) {
                int n14;
                boolean bl5;
                boolean bl6;
                int n15;
                int n16;
                int n17;
                fragment = chain.getFragment(j);
                String string = fragment.getConformationType();
                String string2 = j > 0 ? chain.getFragmentType(j - 1) : "UNDEFINED_CONFORMATION";
                String string3 = j < n9 - 1 ? chain.getFragmentType(j + 1) : "UNDEFINED_CONFORMATION";
                int n18 = n17 = fragment.getStartResidueIndex();
                int n19 = n16 = fragment.getEndResidueIndex();
                if (j > 0 && chain.getFragmentType(j - 1) != "UNDEFINED_CONFORMATION") {
                    n18 = chain.getFragmentEndResidue(j - 1);
                    n12 = chain.getResidue(n18).getResidueId();
                }
                if (j < n9 - 1 && chain.getFragmentType(j + 1) != "UNDEFINED_CONFORMATION") {
                    n19 = chain.getFragmentStartResidue(j + 1);
                    n13 = chain.getResidue(n19).getResidueId();
                }
                bl3 = n12 < chain.getResidue(n17).getResidueId() - 1 || string2 == "NONE";
                bl2 = n13 > chain.getResidue(n16).getResidueId() + 1 || string3 == "NONE";
                n10 = n16 - n17 + 1;
                if (string == "UNDEFINED_CONFORMATION") {
                    object = new String("UNDEFINED: chain -> " + i + "  fragment " + j + " Residues: " + n17 + " - " + n16);
                    continue;
                }
                if (string == "NONE") continue;
                if (string == StructureComponentRegistry.TYPE_COIL) {
                    int n20;
                    n15 = 0;
                    bl6 = false;
                    bl5 = false;
                    coilGeometry = new CoilGeometry();
                    coilGeometry.setPriestleSteps(n4);
                    coilGeometry.setQuality(f4);
                    coilGeometry.setUserData(fragment);
                    if (!bl) {
                        coilGeometry.setCrossSectionType(CrossSectionStyle.POINT);
                    } else {
                        coilGeometry.setCrossSectionType(n8);
                    }
                    n14 = n10;
                    if (n18 < n17 && string2 != "NONE" && !bl3) {
                        residue = chain.getResidue(n18);
                        atom2 = residue.getAlphaAtom();
                        bl6 = true;
                        ++n14;
                        n15 = 1;
                    }
                    if (n19 > n16 && string3 != "NONE" && !bl2) {
                        residue = chain.getResidue(n19);
                        atom3 = residue.getAlphaAtom();
                        bl5 = true;
                        ++n14;
                    }
                    if (n14 < 2) {
                        throw new FragmentTooShortException(string + "  " + n17 + "  " + n16 + " too short, can not handle");
                    }
                    vec3fArray = new Vec3f[n14];
                    fArray = new float[n14][3];
                    if (bl6) {
                        vec3fArray[0] = new Vec3f((float)atom2.coordinate[0], (float)atom2.coordinate[1], (float)atom2.coordinate[2]);
                        structureStyles.getResidueColor(chain.getResidue(n18), fArray[0]);
                        coilGeometry.setLeftExtended(true);
                    }
                    if (bl5) {
                        vec3fArray[n14 - 1] = new Vec3f((float)atom3.coordinate[0], (float)atom3.coordinate[1], (float)atom3.coordinate[2]);
                        structureStyles.getResidueColor(chain.getResidue(n19), fArray[n14 - 1]);
                        coilGeometry.setRightExtended(true);
                    }
                    for (n20 = 0; n20 < n10; ++n20) {
                        residue = chain.getResidue(n17 + n20);
                        atom = residue.getAlphaAtom();
                        vec3fArray[n20 + n15] = new Vec3f((float)atom.coordinate[0], (float)atom.coordinate[1], (float)atom.coordinate[2]);
                        structureStyles.getResidueColor(residue, fArray[n20 + n15]);
                    }
                    for (n20 = 0; n20 < vec3fArray.length; ++n20) {
                    }
                    coilGeometry.setCoordinates(vec3fArray);
                    coilGeometry.setColorMap(fArray);
                    if (ssGeometry != null && !bl3) {
                        vec3f2 = coilGeometry.getNextToFirstCa();
                        ssGeometry.setNextCaCoord(vec3f2);
                        coilGeometry.setPreviousSs(ssGeometry);
                        ssGeometry.setNextSs(coilGeometry);
                    }
                    if (vec3f != null && !bl3) {
                        coilGeometry.setPreviousCaCoord(vec3f);
                    }
                    vec3f = coilGeometry.getPreviousToLastCa();
                    ssGeometry = coilGeometry;
                    vector.add(coilGeometry);
                    continue;
                }
                if (string == StructureComponentRegistry.TYPE_TURN | string == StructureComponentRegistry.TYPE_HELIX & n10 < 3) {
                    n15 = 0;
                    bl6 = false;
                    bl5 = false;
                    coilGeometry2 = new CoilGeometry();
                    coilGeometry2.setPriestleSteps(n3);
                    coilGeometry2.setQuality(f3);
                    coilGeometry2.setUserData(fragment);
                    if (!bl) {
                        coilGeometry2.setCrossSectionType(CrossSectionStyle.POINT);
                    } else {
                        coilGeometry2.setCrossSectionType(n7);
                    }
                    n14 = n10;
                    if (n18 < n17 && !bl3 && string2 != StructureComponentRegistry.TYPE_COIL & string2 != StructureComponentRegistry.TYPE_TURN) {
                        residue = chain.getResidue(n18);
                        atom2 = residue.getAlphaAtom();
                        bl6 = true;
                        ++n14;
                        n15 = 1;
                    }
                    if (n19 > n16 && !bl2 && chain.getFragmentType(j + 1) != StructureComponentRegistry.TYPE_COIL) {
                        residue = chain.getResidue(n19);
                        atom3 = residue.getAlphaAtom();
                        bl5 = true;
                        ++n14;
                    }
                    vec3fArray = new Vec3f[n14];
                    fArray = new float[n14][3];
                    if (bl6) {
                        vec3fArray[0] = new Vec3f((float)atom2.coordinate[0], (float)atom2.coordinate[1], (float)atom2.coordinate[2]);
                        structureStyles.getResidueColor(chain.getResidue(n18), fArray[0]);
                        coilGeometry2.setLeftExtended(true);
                    }
                    if (bl5) {
                        vec3fArray[n14 - 1] = new Vec3f((float)atom3.coordinate[0], (float)atom3.coordinate[1], (float)atom3.coordinate[2]);
                        structureStyles.getResidueColor(chain.getResidue(n19), fArray[n14 - 1]);
                        coilGeometry2.setRightExtended(true);
                    }
                    for (int k = 0; k < n10; ++k) {
                        residue = chain.getResidue(n17 + k);
                        atom = residue.getAlphaAtom();
                        vec3fArray[k + n15] = new Vec3f((float)atom.coordinate[0], (float)atom.coordinate[1], (float)atom.coordinate[2]);
                        structureStyles.getResidueColor(residue, fArray[k + n15]);
                    }
                    if (string == StructureComponentRegistry.TYPE_TURN & n14 < 2 | string == StructureComponentRegistry.TYPE_HELIX & n14 < 3) {
                        throw new FragmentTooShortException(string + " too short, can not handle");
                    }
                    coilGeometry2.setColorMap(fArray);
                    coilGeometry2.setCoordinates(vec3fArray);
                    if (ssGeometry != null && !bl3) {
                        vec3f2 = coilGeometry2.getNextToFirstCa();
                        ssGeometry.setNextCaCoord(vec3f2);
                        coilGeometry2.setPreviousSs(ssGeometry);
                        ssGeometry.setNextSs(coilGeometry2);
                    }
                    if (vec3f != null && !bl3) {
                        coilGeometry2.setPreviousCaCoord(vec3f);
                    }
                    vec3f = coilGeometry2.getPreviousToLastCa();
                    ssGeometry = coilGeometry2;
                    vector.add(coilGeometry2);
                    continue;
                }
                if (string == StructureComponentRegistry.TYPE_STRAND) {
                    n15 = 0;
                    bl5 = false;
                    bl4 = true;
                    strandGeometry = new StrandGeometry();
                    strandGeometry.setPriestleSteps(n2);
                    strandGeometry.setQuality(f2);
                    strandGeometry.setUserData(fragment);
                    strandGeometry.setRoundedShape(false);
                    if (!bl) {
                        strandGeometry.setCrossSectionType(CrossSectionStyle.POINT);
                    } else {
                        strandGeometry.setCrossSectionType(n6);
                    }
                    n14 = n10;
                    if (string3 == StructureComponentRegistry.TYPE_STRAND || string3 == StructureComponentRegistry.TYPE_HELIX && !bl2) {
                        residue = chain.getResidue(n19);
                        atom3 = residue.getAlphaAtom();
                        bl5 = true;
                        ++n14;
                    }
                    if (n14 < 2) {
                        throw new FragmentTooShortException(string + " too short, can not handle");
                    }
                    vec3fArray = new Vec3f[n14];
                    fArray = new float[n14][3];
                    for (int k = 0; k < n10; ++k) {
                        residue = chain.getResidue(n17 + k);
                        atom = residue.getAlphaAtom();
                        vec3fArray[n15 + k] = new Vec3f((float)atom.coordinate[0], (float)atom.coordinate[1], (float)atom.coordinate[2]);
                        structureStyles.getResidueColor(residue, fArray[k]);
                    }
                    if (bl5) {
                        vec3fArray[n14 - 1] = new Vec3f((float)atom3.coordinate[0], (float)atom3.coordinate[1], (float)atom3.coordinate[2]);
                        structureStyles.getResidueColor(chain.getResidue(n19), fArray[n14 - 1]);
                        strandGeometry.setRightExtended(true);
                    }
                    strandGeometry.setColorMap(fArray);
                    strandGeometry.setCoordinates(vec3fArray);
                    if (ssGeometry != null && !bl3) {
                        try {
                            vec3f2 = strandGeometry.getNextToFirstCa();
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            bl4 = false;
                        }
                        ssGeometry.setNextCaCoord(vec3f2);
                        strandGeometry.setPreviousSs(ssGeometry);
                        ssGeometry.setNextSs(strandGeometry);
                    }
                    if (vec3f != null && !bl3) {
                        strandGeometry.setPreviousCaCoord(vec3f);
                    }
                    try {
                        vec3f = strandGeometry.getPreviousToLastCa();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl4 = false;
                    }
                    ssGeometry = strandGeometry;
                    if (!bl4) continue;
                    vector.add(strandGeometry);
                    continue;
                }
                if (string != StructureComponentRegistry.TYPE_HELIX) continue;
                helixGeometry = new HelixGeometry();
                helixGeometry.setPriestleSteps(n);
                n15 = 0;
                bl5 = false;
                helixGeometry.setQuality(f);
                helixGeometry.setUserData(fragment);
                if (!bl) {
                    helixGeometry.setCrossSectionType(CrossSectionStyle.POINT);
                } else {
                    helixGeometry.setCrossSectionType(n5);
                }
                n14 = n10;
                if (string3 == StructureComponentRegistry.TYPE_STRAND || string3 == StructureComponentRegistry.TYPE_HELIX && !bl2) {
                    residue = chain.getResidue(n19);
                    atom3 = residue.getAlphaAtom();
                    bl5 = true;
                    ++n14;
                }
                if (n14 < 3) {
                    throw new FragmentTooShortException(string + " too short, can not handle");
                }
                vec3fArray = new Vec3f[n14];
                fArray = new float[n14][3];
                for (int k = 0; k < n10; ++k) {
                    residue = chain.getResidue(n17 + k);
                    atom = residue.getAlphaAtom();
                    if (atom == null) {
                        System.err.println("No Ca atom returned for residue " + residue);
                    }
                    vec3fArray[k] = new Vec3f((float)atom.coordinate[0], (float)atom.coordinate[1], (float)atom.coordinate[2]);
                    structureStyles.getResidueColor(residue, fArray[k]);
                }
                if (bl5) {
                    vec3fArray[n14 - 1] = new Vec3f((float)atom3.coordinate[0], (float)atom3.coordinate[1], (float)atom3.coordinate[2]);
                    structureStyles.getResidueColor(n19, fArray[n14 - 1]);
                    helixGeometry.setRightExtended(true);
                }
                helixGeometry.setCoordinates(vec3fArray);
                helixGeometry.setColorMap(fArray);
                if (ssGeometry != null && !bl3) {
                    vec3f2 = helixGeometry.getNextToFirstCa();
                    ssGeometry.setNextCaCoord(vec3f2);
                    helixGeometry.setPreviousSs(ssGeometry);
                    ssGeometry.setNextSs(helixGeometry);
                }
                if (vec3f != null && !bl3) {
                    helixGeometry.setPreviousCaCoord(vec3f);
                }
                vec3f = helixGeometry.getPreviousToLastCa();
                ssGeometry = helixGeometry;
                vector.add(helixGeometry);
            }
        }
        ListIterator listIterator = vector.listIterator();
        object = null;
        while (listIterator.hasNext()) {
            object = (SsGeometry)listIterator.next();
            branchGroup.addChild((Node)((GeometryEntity)object).generateJ3dGeometry());
            hashtable.put(((SsGeometry)object).getUserData(), object);
        }
    }

    public static void drawRibbon(BranchGroup branchGroup, Atom[] atomArray, StructureStyles structureStyles, Hashtable hashtable) {
        Vec3f[] vec3fArray = new Vec3f[atomArray.length];
        StrandGeometry strandGeometry = null;
        strandGeometry = new StrandGeometry();
        strandGeometry.setPriestleSteps(0);
        for (int i = 0; i < atomArray.length; ++i) {
            vec3fArray[i] = new Vec3f((float)atomArray[i].coordinate[0], (float)atomArray[i].coordinate[1], (float)atomArray[i].coordinate[2]);
        }
        strandGeometry.setCoordinates(vec3fArray);
        branchGroup.addChild((Node)((GeometryEntity)strandGeometry).generateJ3dGeometry());
    }

    public static void drawRibbon(BranchGroup branchGroup, StructureMap structureMap, StructureStyles structureStyles, boolean bl, Hashtable hashtable) throws FragmentTooShortException {
        Vec3f[] vec3fArray = null;
        int n = structureMap.getChainCount();
        int n2 = 0;
        Atom atom = new Atom();
        Residue residue = null;
        float[][] fArray = null;
        System.err.println("Chain count " + n);
        n = 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            Chain chain = structureMap.getChain(i);
            int n4 = chain.getResidueCount();
            System.err.println("Chain  " + i + "  Residue count " + n4);
            n2 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                residue = chain.getResidue(n3);
                atom = residue.getAlphaAtom();
                if (atom == null) continue;
                ++n2;
            }
            vec3fArray = new Vec3f[n2];
            for (n3 = 0; n3 < n4; ++n3) {
                residue = chain.getResidue(n3);
                atom = residue.getAlphaAtom();
                if (atom == null) continue;
                ++n2;
                vec3fArray[n3] = new Vec3f((float)atom.coordinate[0], (float)atom.coordinate[1], (float)atom.coordinate[2]);
            }
            fArray = new float[n4][3];
            for (n3 = 0; n3 < n4; ++n3) {
                residue = chain.getResidue(n3);
                structureStyles.getResidueColor(residue, fArray[n3]);
            }
        }
    }

    public void setCrossSectionType(int n) {
        this.csType = n;
    }

    public void setCrossSectionStyle(CrossSectionStyle crossSectionStyle) {
        this.csStyle = crossSectionStyle;
    }

    public void setRoundedShape(boolean bl) {
        this.rounded = bl;
    }

    public void setSegmentCount(int n) {
        this.segments = n <= 0 ? 1 : n;
    }

    public void setCoordinates(Vec3f[] vec3fArray) {
        this.coords = vec3fArray;
        Priestle.smooth(vec3fArray, this.getPriestleSteps());
    }

    public void setCoordinates(double[][] dArray) {
        this.coords = new Vec3f[dArray.length];
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = new Vec3f((float)dArray[i][0], (float)dArray[i][1], (float)dArray[i][2]);
        }
        Priestle.smooth(this.coords, this.getPriestleSteps());
    }

    public void setPreviousSs(SsGeometry ssGeometry) {
        this.previousSs = ssGeometry;
    }

    public void setNextSs(SsGeometry ssGeometry) {
        this.nextSs = ssGeometry;
    }

    public void setLeftExtended(boolean bl) {
        this.leftExtended = bl;
    }

    public void setRightExtended(boolean bl) {
        this.rightExtended = bl;
    }

    public void setPreviousCaCoord(Vec3f vec3f) {
        this.previousCaCoord = new Vec3f();
        this.previousCaCoord.value[0] = vec3f.value[0];
        this.previousCaCoord.value[1] = vec3f.value[1];
        this.previousCaCoord.value[2] = vec3f.value[2];
    }

    public void setPreviousCaCoord(double[] dArray) {
        this.previousCaCoord = new Vec3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
    }

    public void setNextCaCoord(Vec3f vec3f) {
        this.nextCaCoord = new Vec3f();
        this.nextCaCoord.value[0] = vec3f.value[0];
        this.nextCaCoord.value[1] = vec3f.value[1];
        this.nextCaCoord.value[2] = vec3f.value[2];
    }

    public void setNextCaCoord(double[] dArray) {
        this.nextCaCoord = new Vec3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
    }

    public void setColorMap(Color[] colorArray) {
        this.colorMap = new float[colorArray.length][3];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i].getColorComponents(this.colorMap[i]);
        }
        this.uniformColor = false;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public void setColorMap(float[][] fArray) {
        if (this.colorMap == null) {
            this.colorMap = fArray;
        } else {
            int n = fArray.length;
            if (this.colorMap.length != fArray.length) {
                for (int i = 0; i < this.colorMap.length; ++i) {
                    this.colorMap[i] = fArray[i % n];
                }
            } else {
                this.colorMap = fArray;
            }
        }
        this.uniformColor = false;
    }

    public void updateColorMap(float[][] fArray) {
        this.setColorMap(fArray);
        this.setPathColor(this.pathColorMap.length);
        this.resetGeometryColor();
    }

    public void updateColorMap(float[] fArray, int n) {
        this.updateColorMap(fArray, n, true);
    }

    public void updateColorMap(float[] fArray, int n, boolean bl) {
        this.colorMap[n] = fArray;
        this.setPathColor(this.pathColorMap.length, n);
        this.resetResidueColor(n);
        if (bl) {
            SsGeometry ssGeometry;
            if (n == this.colorMap.length - 1) {
                ssGeometry = this.getNextSs();
                if (ssGeometry == null) {
                    return;
                }
                if (ssGeometry.isLeftExtended()) {
                    ssGeometry.updateColorMap(fArray, 0, false);
                }
            }
            if (n == 0) {
                ssGeometry = this.getPreviousSs();
                if (ssGeometry == null) {
                    return;
                }
                if (ssGeometry.isRightExtended()) {
                    int n2 = ssGeometry.getColorMap().length;
                    ssGeometry.updateColorMap(fArray, n2 - 1, false);
                }
            }
        }
    }

    protected void setPathColor(int n) {
        int n2;
        if (this.pathColorMap == null) {
            this.pathColorMap = new float[n][3];
        }
        int n3 = this.segments / 2;
        int n4 = 0;
        for (n2 = 0; n2 <= n3; ++n2) {
            this.pathColorMap[n2] = this.colorMap[0];
        }
        n4 = this.colorMap.length - 1;
        for (n2 = n4 * this.segments - n3 + 1; n2 <= n4 * this.segments; ++n2) {
            this.pathColorMap[n2] = this.colorMap[n4];
        }
        for (n4 = 1; n4 < this.colorMap.length - 1; ++n4) {
            for (n2 = n4 * this.segments - n3 + 1; n2 <= n4 * this.segments + n3; ++n2) {
                this.pathColorMap[n2] = this.colorMap[n4];
            }
        }
    }

    protected void setPathColor(int n, int n2) {
        if (this.pathColorMap == null) {
            this.pathColorMap = new float[n][3];
        }
        int n3 = this.segments / 2;
        if (n2 == this.colorMap.length - 1) {
            for (int i = this.segments * n2 - n3 + 1; i <= this.segments * n2; ++i) {
                this.pathColorMap[i] = this.colorMap[n2];
            }
            return;
        }
        if (n2 == 0) {
            for (int i = 0; i <= n3; ++i) {
                this.pathColorMap[i] = this.colorMap[n2];
            }
            return;
        }
        for (int i = this.segments * n2 - n3 + 1; i <= this.segments * n2 + n3; ++i) {
            this.pathColorMap[i] = this.colorMap[n2];
        }
    }

    protected void setPathColorDebug(int n) {
        if (this.pathColorMap == null) {
            this.pathColorMap = new float[n][3];
        }
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f};
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f};
        int n2 = -1;
        for (int i = 0; i < this.coords.length - 1; ++i) {
            this.pathColorMap[++n2] = fArray;
            for (int j = 1; j < this.segments; ++j) {
                this.pathColorMap[++n2] = fArray2;
            }
        }
        this.pathColorMap[++n2] = fArray;
    }

    public void resetGeometryColor() {
        for (int i = 0; i < this.coords.length - 2; ++i) {
            this.resetResidueColor(i);
        }
    }

    public int getClosestResidueIndex(double[] dArray) {
        Vec3f vec3f = new Vec3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        float f = 1.0E10f;
        int n = 0;
        for (int i = 0; i < this.coords.length; ++i) {
            float f2;
            float f3 = this.distance(vec3f, this.coords[i]);
            if (!(f2 <= f)) continue;
            f = f3;
            n = i;
        }
        return n;
    }

    public void highlightClosestResidue(double[] dArray, float[] fArray) {
        Vec3f vec3f = new Vec3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        float f = 1.0E10f;
        int n = 0;
        for (int i = 0; i < this.coords.length; ++i) {
            float f2;
            float f3 = this.distance(vec3f, this.coords[i]);
            if (!(f2 <= f)) continue;
            f = f3;
            n = i;
        }
        this.highlightResidueRegion(n, fArray);
    }

    public void highlight(float[] fArray) {
        for (int i = 0; i < this.coords.length; ++i) {
            this.highlightResidue(i, fArray);
        }
    }

    public void resetColor() {
        for (int i = 0; i < this.coords.length; ++i) {
            this.resetResidueColor(i);
        }
    }

    public float[][] getColorMap() {
        return this.colorMap;
    }

    public SsGeometry getPreviousSs() {
        return this.previousSs;
    }

    public SsGeometry getNextSs() {
        return this.nextSs;
    }

    public boolean getHighlightState() {
        return this.highlighted;
    }

    public void highlightResidueRegion(int n, float[] fArray) {
    }

    public void highlightResidue(int n, float[] fArray) {
    }

    public void resetResidueColor(int n) {
    }

    public Object getUserData() {
        return this.userData;
    }

    public boolean isLeftExtended() {
        return this.leftExtended;
    }

    public boolean isRightExtended() {
        return this.rightExtended;
    }

    public Vec3f getNextToFirstCa() {
        return this.coords[1];
    }

    public double[] getNextToFirstCaCoord() {
        double[] dArray = new double[]{this.coords[1].value[0], this.coords[1].value[1], this.coords[1].value[2]};
        return dArray;
    }

    public Vec3f getPreviousToLastCa() {
        return this.coords[this.coords.length - 2];
    }

    public double[] getPreviousToLastCaCoord() {
        double[] dArray = new double[]{this.coords[this.coords.length - 2].value[0], this.coords[this.coords.length - 2].value[1], this.coords[this.coords.length - 2].value[2]};
        return dArray;
    }

    public void setPriestleSteps(int n) {
        this.priestleSteps = n;
    }

    public int getPriestleSteps() {
        return this.priestleSteps;
    }

    private float distance(Vec3f vec3f, Vec3f vec3f2) {
        float f = 0.0f;
        f += (vec3f2.value[0] - vec3f.value[0]) * (vec3f2.value[0] - vec3f.value[0]);
        f += (vec3f2.value[1] - vec3f.value[1]) * (vec3f2.value[1] - vec3f.value[1]);
        f += (vec3f2.value[2] - vec3f.value[2]) * (vec3f2.value[2] - vec3f.value[2]);
        f = (float)Math.sqrt(f);
        return f;
    }
}

