/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.StructureViewerImpl;

import edu.sdsc.mbt.viewers.StructureViewerImpl.AffineCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.BackboneLine;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionBuilder;
import edu.sdsc.mbt.viewers.StructureViewerImpl.CrossSectionStyle;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Extrusion;
import edu.sdsc.mbt.viewers.StructureViewerImpl.FrenetTrihedron;
import edu.sdsc.mbt.viewers.StructureViewerImpl.Hermite;
import edu.sdsc.mbt.viewers.StructureViewerImpl.IntrinsicCrossSection;
import edu.sdsc.mbt.viewers.StructureViewerImpl.SsGeometry;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3d;
import edu.sdsc.mbt.viewers.StructureViewerImpl.vec.Vec3f;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class StrandGeometry
extends SsGeometry {
    private static float STRAND_HERMITE_FACTOR = 0.5f;
    private int polygonStyle;
    private boolean drawArrow = true;
    private Vector3d[] tangents = null;
    private Vector3d[] normals = null;
    private Shape3D shape = null;

    public StrandGeometry() {
        this.csType = CrossSectionStyle.RECTANGULAR_RIBBON;
        this.polygonStyle = 2;
        this.uniformColor = true;
        this.segments = 6;
        this.userData = "StrandGeometry";
    }

    public BranchGroup generateJ3dGeometry() {
        int n;
        this.processQualityInfo(this.quality);
        Hermite hermite = new Hermite();
        hermite.setKnotWeight(STRAND_HERMITE_FACTOR);
        if (this.csStyle == null) {
            double[] dArray = new double[]{2.0, 0.2};
            this.csStyle = new CrossSectionStyle(this.csType, dArray);
        }
        int n2 = (this.coords.length - 1) * this.segments + 1;
        Vector3d[] vector3dArray = new Vector3d[n2];
        FrenetTrihedron[] frenetTrihedronArray = new FrenetTrihedron[n2];
        this.tangents = new Vector3d[this.coords.length];
        this.normals = new Vector3d[this.coords.length];
        this.getAllTangentsAndNormals(this.coords, this.tangents, this.normals);
        Vec3d vec3d = new Vec3d();
        Vec3d vec3d2 = new Vec3d();
        Vec3d vec3d3 = new Vec3d();
        Vector3d vector3d = new Vector3d();
        FrenetTrihedron frenetTrihedron = null;
        FrenetTrihedron frenetTrihedron2 = null;
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        vector3d4 = this.tangents[0];
        vector3d5 = this.tangents[1];
        vector3d2 = this.normals[0];
        vector3d3 = this.normals[1];
        vector3d4.normalize();
        vector3d5.normalize();
        hermite.setKnotWeight(2.0f);
        vector3d6.set((double)this.coords[0].value[0], (double)this.coords[0].value[1], (double)this.coords[0].value[2]);
        frenetTrihedron2 = new FrenetTrihedron(vector3d6, vector3d4, vector3d2);
        double d = 0.0;
        int n3 = -1;
        for (n = 0; n < this.coords.length - 1; ++n) {
            vector3dArray[++n3] = new Vector3d((double)this.coords[n].value[0], (double)this.coords[n].value[1], (double)this.coords[n].value[2]);
            frenetTrihedronArray[n3] = new FrenetTrihedron(frenetTrihedron2);
            frenetTrihedron = frenetTrihedronArray[n3];
            hermite.set(this.coords[n].toVec3d(), this.coords[n + 1].toVec3d(), vector3d4, vector3d5);
            vector3d4 = this.tangents[n + 1];
            vector3d2 = this.normals[n + 1];
            if (n >= this.coords.length - 2) {
                vector3d5 = vector3d4;
                vector3d3 = vector3d2;
            } else {
                vector3d5 = this.tangents[n + 2];
                vector3d3 = this.normals[n + 2];
            }
            vector3d4.normalize();
            vector3d5.normalize();
            vector3d6.set((double)this.coords[n + 1].value[0], (double)this.coords[n + 1].value[1], (double)this.coords[n + 1].value[2]);
            frenetTrihedron2 = new FrenetTrihedron(vector3d6, vector3d4, vector3d2);
            for (int i = 1; i < this.segments; ++i) {
                d = (double)i * (1.0 / (double)this.segments);
                frenetTrihedronArray[++n3] = new FrenetTrihedron();
                frenetTrihedronArray[n3].interpolate(d, frenetTrihedron, frenetTrihedron2);
                hermite.sample(d, vec3d3);
                vector3d.set(vec3d3.value[0], vec3d3.value[1], vec3d3.value[2]);
                frenetTrihedronArray[n3].setOriginOnly(vector3d);
                vector3dArray[n3] = new Vector3d(vec3d3.value[0], vec3d3.value[1], vec3d3.value[2]);
            }
        }
        vector3dArray[++n3] = new Vector3d((double)this.coords[this.coords.length - 1].value[0], (double)this.coords[this.coords.length - 1].value[1], (double)this.coords[this.coords.length - 1].value[2]);
        frenetTrihedronArray[n3] = new FrenetTrihedron(frenetTrihedron2);
        n = vector3dArray.length - 1;
        Vector3d[] vector3dArray2 = new Vector3d[3];
        vector3dArray2[0] = new Vector3d(1.0, 1.0, 1.5);
        vector3dArray2[2] = new Vector3d(1.0, 1.0, 0.0);
        Vector3d vector3d7 = new Vector3d(vector3dArray[n]);
        Vector3d vector3d8 = new Vector3d(vector3dArray[n - 1]);
        Vector3d vector3d9 = new Vector3d(vector3dArray[n - 2]);
        vector3d9.sub((Tuple3d)vector3d7);
        double d2 = 1.5 / vector3d9.length();
        vector3d8.sub((Tuple3d)vector3d7);
        vector3dArray2[1] = new Vector3d(1.0, 1.0, d2 * vector3d8.length());
        if (this.uniformColor) {
            if (this.ssColor == null) {
                this.ssColor = new Color(1.0f, 0.0f, 0.0f);
            }
            Color3f[] color3fArray = new Color3f[]{new Color3f(this.ssColor)};
            this.csStyle.setVertexColors(color3fArray);
            this.pathColorMap = new float[n2][3];
            for (int i = 0; i < n2; ++i) {
                this.pathColorMap[i] = this.ssColor.getColorComponents(null);
            }
        } else {
            this.setPathColor(n2);
        }
        this.branch = this.getFigure(this.csStyle, vector3dArray2, vector3dArray, frenetTrihedronArray, this.pathColorMap, n2);
        this.branch.setCapability(17);
        this.branch.setCapability(12);
        return this.branch;
    }

    public BranchGroup getFigure(CrossSectionStyle crossSectionStyle, Vector3d[] vector3dArray, Vector3d[] vector3dArray2, FrenetTrihedron[] frenetTrihedronArray, float[][] fArray, int n) {
        int n2;
        Material material = new Material();
        Color3f color3f = new Color3f(new Color(1.0f, 1.0f, 0.0f));
        Color3f color3f2 = new Color3f(new Color(0.7f, 0.7f, 0.7f));
        Color3f color3f3 = new Color3f(new Color(0.9f, 0.9f, 0.9f));
        Color3f color3f4 = new Color3f(new Color(0.05f, 0.05f, 0.05f));
        material.setShininess(128.0f);
        material.setSpecularColor(color3f2);
        material.setEmissiveColor(color3f4);
        material.setAmbientColor(color3f3);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        ColoringAttributes coloringAttributes = new ColoringAttributes(color3f, 1);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(1);
        polygonAttributes.setPolygonMode(this.polygonStyle);
        appearance.setPolygonAttributes(polygonAttributes);
        Shape3D shape3D = new Shape3D();
        Shape3D shape3D2 = new Shape3D();
        Object object = null;
        Object var18_18 = null;
        BranchGroup branchGroup = new BranchGroup();
        int n3 = 0;
        int[] nArray = null;
        int n4 = crossSectionStyle.getVertexCount();
        Object var23_23 = null;
        int n5 = n4 - 1;
        IntrinsicCrossSection intrinsicCrossSection = null;
        AffineCrossSection[] affineCrossSectionArray = null;
        if (this.drawArrow) {
            affineCrossSectionArray = new AffineCrossSection[n + 1];
            nArray = new int[n + 2];
        } else {
            affineCrossSectionArray = new AffineCrossSection[n];
            nArray = new int[n + 1];
        }
        int n6 = n - 3;
        if (this.csType == 0) {
            int n7 = 2 * n4;
            nArray[nArray.length - 1] = n7;
            nArray[0] = n7;
            for (n2 = 1; n2 < nArray.length - 1; ++n2) {
                nArray[n2] = 4 * n5;
            }
            intrinsicCrossSection = CrossSectionBuilder.getIntrinsicCrossSection(crossSectionStyle, null);
        } else if (this.csType == 1) {
            int n8 = 2 * n4;
            nArray[nArray.length - 1] = n8;
            nArray[0] = n8;
            for (n2 = 1; n2 < nArray.length - 1; ++n2) {
                nArray[n2] = 4 * n5;
            }
            intrinsicCrossSection = CrossSectionBuilder.getIntrinsicCrossSection(crossSectionStyle, frenetTrihedronArray[0].getTangent());
        } else if (this.csType == 2) {
            int n9 = 2 * n4;
            nArray[nArray.length - 1] = n9;
            nArray[0] = n9;
            for (n2 = 1; n2 < nArray.length - 1; ++n2) {
                nArray[n2] = 4 * n5;
            }
            polygonAttributes.setBackFaceNormalFlip(true);
            polygonAttributes.setCullFace(0);
            intrinsicCrossSection = CrossSectionBuilder.getIntrinsicCrossSection(crossSectionStyle, frenetTrihedronArray[0].getTangent());
            this.rounded = false;
        } else if (this.csType == 3) {
            int n10 = 2 * n4;
            nArray[nArray.length - 1] = n10;
            nArray[0] = n10;
            for (n2 = 1; n2 < nArray.length - 1; ++n2) {
                nArray[n2] = 4 * n5;
            }
            intrinsicCrossSection = CrossSectionBuilder.getIntrinsicCrossSection(crossSectionStyle, frenetTrihedronArray[0].getTangent());
            intrinsicCrossSection.averageNormals();
            this.rounded = true;
        } else if (this.csType == 6) {
            nArray = new int[]{n};
            appearance.setLineAttributes(new LineAttributes(3.0f, 0, false));
        }
        if (this.csType != 6) {
            intrinsicCrossSection.setColors(null);
            if (this.drawArrow) {
                for (n2 = 0; n2 <= n6; ++n2) {
                    affineCrossSectionArray[n2] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[n2]);
                }
                for (n2 = n6 + 1; n2 <= n; ++n2) {
                    affineCrossSectionArray[n2] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[n2 - 1]);
                }
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    affineCrossSectionArray[n2] = new AffineCrossSection(intrinsicCrossSection, frenetTrihedronArray[n2]);
                }
            }
            if (this.drawArrow) {
                n2 = 0;
                for (int i = n6 + 1; i < affineCrossSectionArray.length; ++i) {
                    affineCrossSectionArray[i].scale((Tuple3d)vector3dArray[n2]);
                    ++n2;
                }
            }
            object = new Extrusion(affineCrossSectionArray.length, n3, nArray, affineCrossSectionArray, fArray, n3, this.rounded);
        } else {
            object = new BackboneLine(n, nArray, vector3dArray2, fArray);
        }
        object.setCapability(3);
        object.setCapability(18);
        object.setCapability(3);
        this.shape = new Shape3D((Geometry)object, appearance);
        this.shape.setCapability(12);
        this.shape.setPickable(true);
        this.shape.setUserData(this.userData);
        branchGroup.addChild((Node)this.shape);
        object.setCapability(3);
        return branchGroup;
    }

    public void setNormals(Vector3d[] vector3dArray) {
        this.normals = vector3dArray;
    }

    private void smoothNormals(Vector3d[] vector3dArray, Vector3d[] vector3dArray2, int n) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        for (int i = 0; i < n; ++i) {
            vector3d4 = vector3dArray[0];
            for (int j = 1; j < vector3dArray.length - 1; ++j) {
                vector3d3.set((Tuple3d)vector3dArray[j]);
                vector3dArray[j].add((Tuple3d)vector3d4);
                vector3dArray[j].add((Tuple3d)vector3dArray[j + 1]);
                vector3d2.set((Tuple3d)vector3dArray2[j]);
                vector3d2.normalize();
                vector3d.set((Tuple3d)vector3d2);
                vector3d.scale(vector3dArray[j].dot(vector3d2));
                vector3dArray[j].sub((Tuple3d)vector3d);
                vector3dArray[j].normalize();
                vector3d4 = new Vector3d(vector3d3);
            }
        }
    }

    private void getAllTangentsAndNormals(Vec3f[] vec3fArray, Vector3d[] vector3dArray, Vector3d[] vector3dArray2) {
        int n;
        Vector3d vector3d = null;
        Vector3d vector3d2 = null;
        Object var6_6 = null;
        Vector3d vector3d3 = null;
        Vector3d vector3d4 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Vector3d vector3d5 = null;
        Vector3d vector3d6 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        Vector3d vector3d7 = null;
        Object var16_16 = null;
        Object var17_17 = null;
        Vector3d vector3d8 = null;
        Vector3d vector3d9 = null;
        Object var20_20 = null;
        Object var21_21 = null;
        Vector3d vector3d10 = null;
        Object var23_23 = null;
        Object var26_24 = null;
        Object var27_25 = null;
        Vector3d vector3d11 = new Vector3d(0.0, 0.0, 0.0);
        if (vec3fArray.length == 2) {
            int n2 = 0;
            double d = 1.0;
            vector3d3 = new Vector3d();
            vector3d4 = new Vector3d();
            vector3d7 = new Vector3d((double)vec3fArray[n2 + 1].value[0], (double)vec3fArray[n2 + 1].value[1], (double)vec3fArray[n2 + 1].value[2]);
            vector3d10 = new Vector3d((double)vec3fArray[n2].value[0], (double)vec3fArray[n2].value[1], (double)vec3fArray[n2].value[2]);
            if (this.previousCaCoord != null) {
                vector3d5 = new Vector3d((double)this.previousCaCoord.value[0], (double)this.previousCaCoord.value[1], (double)this.previousCaCoord.value[2]);
            }
            if (this.nextCaCoord != null) {
                vector3d6 = new Vector3d((double)this.nextCaCoord.value[0], (double)this.nextCaCoord.value[1], (double)this.nextCaCoord.value[2]);
            }
            if (this.previousCaCoord == null) {
                vector3d = new Vector3d();
                vector3d.sub((Tuple3d)vector3d7, (Tuple3d)vector3d10);
                vector3dArray[0] = new Vector3d(vector3d);
                if (this.nextCaCoord == null) {
                    vector3dArray[1] = vector3dArray[0];
                    vector3d3.set((Tuple3d)vector3d);
                    vector3d.normalize();
                    if (vector3d3.x != 0.0) {
                        vector3d3.x *= 2.0;
                        vector3d.scale(vector3d.dot(vector3d3));
                        vector3d8 = new Vector3d();
                        vector3d8.sub((Tuple3d)vector3d3, (Tuple3d)vector3d);
                        vector3d3.set((Tuple3d)vector3d8);
                        if (vector3d3.length() < 1.0E-6) {
                            vector3d3.y += 1.0;
                        }
                        vector3d3.normalize();
                        vector3dArray2[0] = new Vector3d(vector3d3);
                        vector3dArray2[1] = vector3dArray2[0];
                    }
                } else {
                    vector3d2 = new Vector3d();
                    vector3d2.sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
                    vector3dArray[1] = new Vector3d(vector3d2);
                    vector3d6.sub((Tuple3d)vector3d7);
                    vector3d7.sub((Tuple3d)vector3d10);
                    vector3d6.normalize();
                    vector3d7.normalize();
                    vector3d4.sub((Tuple3d)vector3d6, (Tuple3d)vector3d7);
                    vector3d2.normalize();
                    vector3d2.scale(vector3d2.dot(vector3d4));
                    vector3d4.sub((Tuple3d)vector3d2);
                    vector3d4.normalize();
                    vector3dArray2[1] = new Vector3d(vector3d4);
                    vector3d.normalize();
                    vector3d.scale(vector3d.dot(vector3d4));
                    vector3d4.sub((Tuple3d)vector3d);
                    vector3d4.normalize();
                    vector3dArray2[0] = new Vector3d(vector3d4);
                }
            } else {
                vector3d = new Vector3d();
                vector3d.sub((Tuple3d)vector3d7, (Tuple3d)vector3d5);
                vector3dArray[0] = new Vector3d(vector3d);
                if (this.nextCaCoord == null) {
                    vector3d7.sub((Tuple3d)vector3d10);
                    vector3dArray[1] = new Vector3d(vector3d7);
                    vector3d10.sub((Tuple3d)vector3d5);
                    vector3d7.normalize();
                    vector3d10.normalize();
                    vector3d3.sub((Tuple3d)vector3d7, (Tuple3d)vector3d10);
                    vector3d.normalize();
                    vector3d.scale(vector3d.dot(vector3d3));
                    vector3d3.sub((Tuple3d)vector3d);
                    vector3d3.normalize();
                    vector3dArray2[0] = new Vector3d(vector3d3);
                    vector3d.set((Tuple3d)vector3dArray[1]);
                    vector3d.normalize();
                    vector3d.scale(vector3d.dot(vector3d3));
                    vector3d3.sub((Tuple3d)vector3d);
                    vector3d3.normalize();
                    vector3dArray2[1] = new Vector3d(vector3d3);
                    d = vector3dArray2[1].dot(vector3dArray2[0]);
                    if (d <= 0.0) {
                        vector3dArray2[1].negate();
                    }
                } else {
                    vector3d6 = new Vector3d((double)this.nextCaCoord.value[0], (double)this.nextCaCoord.value[1], (double)this.nextCaCoord.value[2]);
                    vector3d2 = new Vector3d();
                    vector3d2.sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
                    vector3dArray[1] = new Vector3d(vector3d2);
                    vector3d6.sub((Tuple3d)vector3d7);
                    vector3d7.sub((Tuple3d)vector3d10);
                    vector3d10.sub((Tuple3d)vector3d5);
                    vector3d6.normalize();
                    vector3d7.normalize();
                    vector3d10.normalize();
                    vector3d4.sub((Tuple3d)vector3d6, (Tuple3d)vector3d7);
                    vector3d3.sub((Tuple3d)vector3d7, (Tuple3d)vector3d10);
                    vector3d.normalize();
                    vector3d2.normalize();
                    vector3d.scale(vector3d.dot(vector3d3));
                    vector3d2.scale(vector3d2.dot(vector3d4));
                    vector3d3.sub((Tuple3d)vector3d);
                    vector3d4.sub((Tuple3d)vector3d2);
                    vector3d4.normalize();
                    vector3d3.normalize();
                    vector3dArray2[0] = new Vector3d(vector3d3);
                    vector3dArray2[1] = new Vector3d(vector3d4);
                    d = vector3dArray2[1].dot(vector3dArray2[0]);
                    if (d <= 0.0) {
                        vector3dArray2[1].negate();
                    }
                }
            }
            return;
        }
        for (n = 1; n < vec3fArray.length - 1; ++n) {
            vector3d6 = new Vector3d((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
            vector3d5 = new Vector3d((double)vec3fArray[n - 1].value[0], (double)vec3fArray[n - 1].value[1], (double)vec3fArray[n - 1].value[2]);
            vector3dArray[n] = new Vector3d();
            vector3dArray[n].sub((Tuple3d)vector3d6, (Tuple3d)vector3d5);
        }
        vector3d6 = new Vector3d((double)vec3fArray[1].value[0], (double)vec3fArray[1].value[1], (double)vec3fArray[1].value[2]);
        vector3d10 = new Vector3d((double)vec3fArray[0].value[0], (double)vec3fArray[0].value[1], (double)vec3fArray[0].value[2]);
        if (this.previousCaCoord != null) {
            vector3d5 = new Vector3d((double)this.previousCaCoord.value[0], (double)this.previousCaCoord.value[1], (double)this.previousCaCoord.value[2]);
            vector3d = new Vector3d(vector3d6);
            vector3d.sub((Tuple3d)vector3d5);
            vector3dArray[0] = new Vector3d(vector3d);
            vector3d6.sub((Tuple3d)vector3d10);
            vector3d10.sub((Tuple3d)vector3d5);
            vector3d6.normalize();
            vector3d10.normalize();
            vector3dArray2[0] = new Vector3d();
            vector3dArray2[0].sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
            vector3d9 = new Vector3d();
            vector3d9.set((Tuple3d)vector3d);
            vector3d9.normalize();
            vector3d8 = new Vector3d();
            vector3d8.set((Tuple3d)vector3d9);
            vector3d8.scale(vector3dArray2[0].dot(vector3d9));
            vector3dArray2[0].sub((Tuple3d)vector3d8);
            vector3dArray2[0].normalize();
        } else {
            vector3d6.sub((Tuple3d)vector3d10);
            vector3dArray[0] = new Vector3d();
            vector3dArray[0].set((Tuple3d)vector3d6);
        }
        vector3d5 = new Vector3d((double)vec3fArray[vec3fArray.length - 2].value[0], (double)vec3fArray[vec3fArray.length - 2].value[1], (double)vec3fArray[vec3fArray.length - 2].value[2]);
        vector3d10 = new Vector3d((double)vec3fArray[vec3fArray.length - 1].value[0], (double)vec3fArray[vec3fArray.length - 1].value[1], (double)vec3fArray[vec3fArray.length - 1].value[2]);
        if (this.nextCaCoord != null) {
            vector3d6 = new Vector3d((double)this.nextCaCoord.value[0], (double)this.nextCaCoord.value[1], (double)this.nextCaCoord.value[2]);
            vector3d2 = new Vector3d(vector3d6);
            vector3d2.sub((Tuple3d)vector3d5);
            vector3dArray[vec3fArray.length - 1] = new Vector3d(vector3d2);
            vector3d6.sub((Tuple3d)vector3d10);
            vector3d10.sub((Tuple3d)vector3d5);
            vector3d6.normalize();
            vector3d10.normalize();
            vector3dArray2[vec3fArray.length - 1] = new Vector3d();
            vector3dArray2[vec3fArray.length - 1].sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
            vector3d2.normalize();
            vector3d2.scale(vector3dArray2[vec3fArray.length - 1].dot(vector3d2));
            vector3dArray2[vec3fArray.length - 1].sub((Tuple3d)vector3d2);
            vector3dArray2[vec3fArray.length - 1].normalize();
        } else {
            vector3dArray[vec3fArray.length - 1] = new Vector3d(vector3d10);
            vector3dArray[vec3fArray.length - 1].sub((Tuple3d)vector3d5);
        }
        vector3d8 = new Vector3d();
        vector3d9 = new Vector3d();
        for (n = 1; n < vec3fArray.length - 1; ++n) {
            vector3d6.set((double)vec3fArray[n + 1].value[0], (double)vec3fArray[n + 1].value[1], (double)vec3fArray[n + 1].value[2]);
            vector3d10.set((double)vec3fArray[n].value[0], (double)vec3fArray[n].value[1], (double)vec3fArray[n].value[2]);
            vector3d5.set((double)vec3fArray[n - 1].value[0], (double)vec3fArray[n - 1].value[1], (double)vec3fArray[n - 1].value[2]);
            vector3d6.sub((Tuple3d)vector3d10);
            vector3d10.sub((Tuple3d)vector3d5);
            vector3d6.normalize();
            vector3d10.normalize();
            vector3dArray2[n] = new Vector3d();
            vector3dArray2[n].sub((Tuple3d)vector3d6, (Tuple3d)vector3d10);
            vector3d9.set((Tuple3d)vector3dArray[n]);
            vector3d9.normalize();
            vector3d8.set((Tuple3d)vector3d9);
            vector3d8.scale(vector3dArray2[n].dot(vector3d9));
            vector3dArray2[n].sub((Tuple3d)vector3d8);
            vector3dArray2[n].normalize();
        }
        if (vector3dArray2[0] == null) {
            vector3dArray2[0] = new Vector3d(vector3dArray2[1]);
            vector3d9.set((Tuple3d)vector3dArray[0]);
            vector3d9.normalize();
            vector3d8.set((Tuple3d)vector3d9);
            vector3d8.scale(vector3dArray2[0].dot(vector3d9));
            vector3dArray2[0].sub((Tuple3d)vector3d8);
            vector3dArray2[0].normalize();
        }
        if (vector3dArray2[vec3fArray.length - 1] == null) {
            vector3dArray2[vec3fArray.length - 1] = new Vector3d(vector3dArray2[vec3fArray.length - 2]);
            vector3d9.set((Tuple3d)vector3dArray[vec3fArray.length - 1]);
            vector3d9.normalize();
            vector3d8.set((Tuple3d)vector3d9);
            vector3d8.scale(vector3dArray2[vec3fArray.length - 1].dot(vector3d9));
            vector3dArray2[vec3fArray.length - 1].sub((Tuple3d)vector3d8);
            vector3dArray2[vec3fArray.length - 1].normalize();
        }
        Vector3d vector3d12 = new Vector3d();
        vector3d12 = vector3dArray2[0];
        double d = 0.0;
        vector3d12 = vector3dArray2[0];
        for (int i = 1; i < vec3fArray.length; ++i) {
            d = vector3dArray2[i].dot(vector3d12);
            if (d < 0.0) {
                vector3dArray2[i].negate();
            }
            vector3d12 = vector3dArray2[i];
        }
        this.smoothNormals(vector3dArray2, vector3dArray, 2);
    }

    public void highlightResidueRegion(int n, float[] fArray) {
        if (this.csType != 6) {
            int n2;
            int n3 = this.csStyle.getVertexCount();
            int n4 = 2 * this.segments * (n3 - 1);
            int n5 = 2 * n3 + 2 * n4 * n;
            int n6 = n > 0 ? n5 - n4 : n5;
            if (n < this.coords.length - 1) {
                n2 = n5 + n4;
            } else {
                n2 = n5;
                if (this.drawArrow) {
                    n2 += 4 * (n3 - 1);
                }
            }
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            if (!this.highlighted) {
                extrusion.highlight(n6, n2, fArray);
                this.highlighted = true;
            } else {
                extrusion.updateColors(n6, n2, n * this.segments);
                this.highlighted = false;
            }
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            if (!this.highlighted) {
                backboneLine.highlight(n9, n10, fArray);
                this.highlighted = true;
            } else {
                backboneLine.updateColors(n9, n10);
                this.highlighted = false;
            }
        }
    }

    public void highlightResidue(int n, float[] fArray) {
        if (this.csType != 6) {
            int n2;
            int n3 = this.csStyle.getVertexCount();
            int n4 = 2 * this.segments * (n3 - 1);
            int n5 = 2 * n3 + 2 * n4 * n;
            int n6 = n > 0 ? n5 - n4 : n5;
            if (n < this.coords.length - 1) {
                n2 = n5 + n4;
            } else {
                n2 = n5;
                if (this.drawArrow) {
                    n2 += 4 * (n3 - 1);
                }
            }
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            extrusion.highlight(n6, n2, fArray);
            this.highlighted = true;
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            backboneLine.highlight(n9, n10, fArray);
        }
    }

    public void resetGeometryColor() {
        Object object;
        if (this.csType != 6) {
            object = (Extrusion)this.shape.getGeometry();
            ((Extrusion)((Object)object)).setColors(this.pathColorMap);
        } else {
            object = (BackboneLine)this.shape.getGeometry();
            ((BackboneLine)((Object)object)).setColors(this.pathColorMap);
        }
        for (int i = 0; i < this.coords.length; ++i) {
            this.resetResidueColor(i);
        }
    }

    public void resetResidueColor(int n) {
        if (this.csType != 6) {
            int n2;
            int n3 = this.csStyle.getVertexCount();
            int n4 = 2 * this.segments * (n3 - 1);
            int n5 = 2 * n3 + 2 * n4 * n;
            int n6 = n > 0 ? n5 - n4 : n5 - 2 * n3;
            if (n < this.coords.length - 1) {
                n2 = n5 + n4;
            } else {
                n2 = n5 + 2 * n3;
                if (this.drawArrow) {
                    n2 += 4 * (n3 - 1);
                }
            }
            Extrusion extrusion = (Extrusion)this.shape.getGeometry();
            extrusion.updateColors(n6, n2, n * this.segments);
        } else {
            int n7 = this.segments / 2;
            int n8 = n * this.segments;
            int n9 = n > 0 ? n8 - n7 : n8;
            int n10 = n < this.coords.length - 1 ? n8 + n7 : n8;
            BackboneLine backboneLine = (BackboneLine)this.shape.getGeometry();
            backboneLine.updateColors(n9, n10);
        }
    }

    public void setTangents(Vector3d[] vector3dArray) {
        this.tangents = vector3dArray;
    }

    public void setDrawArrow(boolean bl) {
        this.drawArrow = bl;
    }

    public void setPolygonStyle(int n) {
        this.polygonStyle = n;
    }

    private void processQualityInfo(float f) {
        int n = 1;
        int n2 = 10;
        if (f < (float)n / (float)n2) {
            this.segments = n;
            this.segments += this.segments % 2;
        } else {
            this.segments = (int)(f * (float)n2);
            this.segments += this.segments % 2;
        }
    }
}

