/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Bond;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureInfo;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.viewables.StructureDocument;
import edu.sdsc.mbt.viewables.StructureDocumentEvent;
import edu.sdsc.mbt.viewables.StructureStyles;
import edu.sdsc.mbt.viewables.StructureStylesEvent;
import edu.sdsc.mbt.viewables.StructureStylesEventListener;
import edu.sdsc.mbt.viewers.TreeViewerImpl.TreeViewerModel;
import edu.sdsc.mbt.viewers.Viewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeViewer
extends JPanel
implements Viewer,
TreeSelectionListener,
StructureStylesEventListener {
    private JTree tree = null;
    private TreeViewerModel treeViewerModel = new TreeViewerModel();
    private JScrollPane scrollPane = null;
    private StructureDocument structureDocument = null;

    public TreeViewer() {
        this.tree = new JTree(this.treeViewerModel);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){
            private ImageIcon atomIcon;
            private ImageIcon residueIcon;
            private ImageIcon chainIcon;
            private ImageIcon conformationIcon;
            private ImageIcon bondIcon;
            private ImageIcon structureIcon;
            private ImageIcon documentIcon;
            {
                float[] fArray = new float[3];
                StructureStyles.getSelectionColor(fArray);
                this.backgroundSelectionColor = new Color(fArray[0], fArray[1], fArray[2]);
                this.atomIcon = new ImageIcon(this.getClass().getResource("TreeViewerImpl/atom_16.jpg"));
                this.residueIcon = new ImageIcon(this.getClass().getResource("TreeViewerImpl/residue_16.jpg"));
                this.chainIcon = new ImageIcon(this.getClass().getResource("TreeViewerImpl/chain_16.jpg"));
                this.conformationIcon = new ImageIcon(this.getClass().getResource("TreeViewerImpl/helix_16.jpg"));
                this.bondIcon = new ImageIcon(this.getClass().getResource("TreeViewerImpl/bonds_16.jpg"));
                this.structureIcon = new ImageIcon(this.getClass().getResource("TreeViewerImpl/structure_16.jpg"));
                this.documentIcon = new ImageIcon(this.getClass().getResource("TreeViewerImpl/document_16.jpg"));
            }

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                ImageIcon imageIcon = null;
                String string = null;
                if (object instanceof StructureDocument) {
                    string = "Document";
                    imageIcon = this.documentIcon;
                } else if (object instanceof Structure) {
                    int n2;
                    Structure structure = (Structure)object;
                    StructureInfo structureInfo = structure.getStructureInfo();
                    if (structureInfo != null) {
                        if (string == null) {
                            string = structureInfo.getIdCode();
                        }
                        if (string == null) {
                            string = structureInfo.getShortName();
                        }
                        if (string == null) {
                            string = structureInfo.getLongName();
                        }
                    }
                    if (string == null) {
                        string = structure.getUrlString();
                    }
                    if (string != null && (n2 = string.length()) > 20) {
                        string = string.substring(0, 5) + " ... " + string.substring(n2 - 15, n2);
                    }
                    imageIcon = this.structureIcon;
                } else if (object instanceof StructureComponent) {
                    String string2;
                    StructureComponent structureComponent = (StructureComponent)object;
                    string = string2 = structureComponent.getStructureComponentType();
                    if (string2 == StructureComponentRegistry.TYPE_ATOM) {
                        Atom atom = (Atom)structureComponent;
                        string = atom.number + " " + atom.name;
                        imageIcon = this.atomIcon;
                        StructureMap structureMap = atom.structure.getStructureMap();
                        StructureStyles structureStyles = structureMap.getStructureStyles();
                        if (structureStyles.getAtomVisibility(atom)) {
                            component.setForeground(Color.black);
                        } else {
                            component.setForeground(Color.lightGray);
                        }
                    } else if (string2 == StructureComponentRegistry.TYPE_RESIDUE) {
                        Residue residue = (Residue)object;
                        string = residue.getResidueId() + " " + residue.getCompoundCode();
                        imageIcon = this.residueIcon;
                    } else if (string2 == StructureComponentRegistry.TYPE_CHAIN) {
                        Chain chain = (Chain)object;
                        string = chain.getChainId();
                        imageIcon = this.chainIcon;
                    } else if (string2 == StructureComponentRegistry.TYPE_BOND) {
                        Bond bond = (Bond)object;
                        Atom atom = bond.getAtom(0);
                        Atom atom2 = bond.getAtom(1);
                        string = atom.number + " " + atom.name + " - " + atom2.number + " " + atom2.name;
                        imageIcon = this.bondIcon;
                    }
                }
                if (string != null) {
                    this.setText(string);
                }
                if (imageIcon != null) {
                    this.setIcon(imageIcon);
                }
                return component;
            }
        };
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.tree.addTreeSelectionListener(this);
        this.setLayout(new GridLayout(1, 1));
        this.scrollPane = new JScrollPane(this.tree);
        this.add(this.scrollPane);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            int n;
            StructureComponent structureComponent;
            Object object = treePathArray[i].getLastPathComponent();
            if (object == null) {
                return;
            }
            boolean bl = this.tree.isPathSelected(treePathArray[i]);
            if (object instanceof StructureDocument || object instanceof Structure || !(object instanceof StructureComponent)) continue;
            StructureComponent structureComponent2 = (StructureComponent)object;
            String string = structureComponent2.getStructureComponentType();
            Structure structure = structureComponent2.structure;
            StructureMap structureMap = structure.getStructureMap();
            StructureStyles structureStyles = structureMap.getStructureStyles();
            if (string == StructureComponentRegistry.TYPE_ATOM) {
                structureComponent = (Atom)structureComponent2;
                n = structureMap.getAtomIndex((Atom)structureComponent);
                structureStyles.setAtomSelection(n, bl);
                continue;
            }
            if (string == StructureComponentRegistry.TYPE_RESIDUE) {
                structureComponent = (Residue)structureComponent2;
                n = structureMap.getResidueIndex((Residue)structureComponent);
                structureStyles.setResidueSelection(n, bl);
                continue;
            }
            if (string != StructureComponentRegistry.TYPE_CHAIN) continue;
            structureComponent = (Chain)structureComponent2;
            n = structureMap.getChainIndex((Chain)structureComponent);
            structureStyles.setChainSelection(n, bl);
        }
    }

    public void processStructureStylesEvent(StructureStylesEvent structureStylesEvent) {
        StructureComponent structureComponent = structureStylesEvent.structureComponent;
        Structure structure = structureComponent.structure;
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        String string = structureComponent.getStructureComponentType();
        if (string == StructureComponentRegistry.TYPE_ATOM) {
            if (structureStylesEvent.property == 2) {
                this.tree.removeTreeSelectionListener(this);
                Atom atom = (Atom)structureComponent;
                Residue residue = structureMap.getResidue(atom);
                Chain chain = structureMap.getChain(atom);
                TreePath treePath = new TreePath(new Object[]{this.structureDocument, structure, chain, residue, atom});
                int n = structureMap.getAtomIndex(atom);
                boolean bl = structureStyles.getAtomSelection(n);
                boolean bl2 = this.tree.isPathSelected(treePath);
                if (bl && !bl2) {
                    this.tree.addSelectionPath(treePath);
                } else if (!bl && bl2) {
                    this.tree.removeSelectionPath(treePath);
                }
                this.tree.addTreeSelectionListener(this);
            }
        } else if (string == StructureComponentRegistry.TYPE_RESIDUE) {
            if (structureStylesEvent.property == 2) {
                this.tree.removeTreeSelectionListener(this);
                Residue residue = (Residue)structureComponent;
                Atom atom = residue.getAtom(0);
                Chain chain = structureMap.getChain(atom);
                TreePath treePath = new TreePath(new Object[]{this.structureDocument, structure, chain, residue});
                boolean bl = structureStyles.getResidueSelection(residue);
                boolean bl3 = this.tree.isPathSelected(treePath);
                if (bl && !bl3) {
                    this.tree.addSelectionPath(treePath);
                } else if (!bl && bl3) {
                    this.tree.removeSelectionPath(treePath);
                }
                this.tree.addTreeSelectionListener(this);
            }
        } else if (string == StructureComponentRegistry.TYPE_CHAIN) {
            if (structureStylesEvent.property == 2) {
                this.tree.removeTreeSelectionListener(this);
                Chain chain = (Chain)structureComponent;
                TreePath treePath = new TreePath(new Object[]{this.structureDocument, structure, chain});
                int n = structureMap.getChainIndex(chain);
                boolean bl = structureStyles.getChainSelection(n);
                boolean bl4 = this.tree.isPathSelected(treePath);
                if (bl && !bl4) {
                    this.tree.addSelectionPath(treePath);
                } else if (!bl && bl4) {
                    this.tree.removeSelectionPath(treePath);
                }
                this.tree.addTreeSelectionListener(this);
            }
        } else if (string != StructureComponentRegistry.TYPE_STRUCTURE || structureStylesEvent.property == 2) {
            // empty if block
        }
    }

    public void processStructureDocumentEvent(StructureDocumentEvent structureDocumentEvent) {
        int n = structureDocumentEvent.type;
        int n2 = structureDocumentEvent.change;
        if (n == 0) {
            if (n2 == 0) {
                if (structureDocumentEvent.structureDocument != null) {
                    this.structureDocument = structureDocumentEvent.structureDocument;
                }
                this.viewerAdded(structureDocumentEvent.viewer);
            } else if (n2 == 1) {
                this.structureDocument = null;
                this.viewerRemoved(structureDocumentEvent.viewer);
            }
        } else if (n == 1) {
            if (n2 == 0) {
                this.structureAdded(structureDocumentEvent.structure);
            } else if (n2 == 1) {
                this.structureRemoved(structureDocumentEvent.structure);
            }
        }
    }

    private void viewerAdded(Viewer viewer) {
        if (viewer == null) {
            return;
        }
        if (viewer != this) {
            return;
        }
        if (this.structureDocument != null) {
            this.treeViewerModel.setRoot(this.structureDocument);
            this.tree.expandRow(1);
        }
    }

    private void viewerRemoved(Viewer viewer) {
        if (viewer == null) {
            return;
        }
        if (viewer != this) {
            return;
        }
        this.treeViewerModel.setRoot(null);
    }

    private void structureAdded(Structure structure) {
        if (structure == null) {
            return;
        }
        this.treeViewerModel.setRoot((StructureDocument)this.treeViewerModel.getRoot());
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        structureStyles.addStructureStylesEventListener(this);
        TreePath treePath = new TreePath(new Object[]{this.structureDocument, structure});
        this.tree.expandPath(treePath);
        int n = structureMap.getChainCount();
        block0: for (int i = 0; i < n; ++i) {
            Chain chain = structureMap.getChain(i);
            if (chain.getClassification() != "Ligand") continue;
            int n2 = chain.getResidueCount();
            String string = "HOH";
            for (int j = 0; j < n2; ++j) {
                Residue residue = chain.getResidue(j);
                if (string.equals(residue.getCompoundCode())) continue;
                treePath = new TreePath(new Object[]{this.structureDocument, structure, chain});
                this.tree.expandPath(treePath);
                continue block0;
            }
        }
    }

    private void structureRemoved(Structure structure) {
        if (structure == null) {
            return;
        }
        this.treeViewerModel.setRoot((StructureDocument)this.treeViewerModel.getRoot());
        StructureMap structureMap = structure.getStructureMap();
        StructureStyles structureStyles = structureMap.getStructureStyles();
        structureStyles.removeStructureStylesEventListener(this);
    }
}

