/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.mbt.viewers.TreeViewerImpl;

import edu.sdsc.mbt.Atom;
import edu.sdsc.mbt.Chain;
import edu.sdsc.mbt.Residue;
import edu.sdsc.mbt.Structure;
import edu.sdsc.mbt.StructureComponent;
import edu.sdsc.mbt.StructureComponentRegistry;
import edu.sdsc.mbt.StructureMap;
import edu.sdsc.mbt.viewables.StructureDocument;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeViewerModel
implements TreeModel {
    private Vector treeModelListeners = new Vector();
    private StructureDocument structureDocument = null;

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.addElement(treeModelListener);
    }

    public Object getChild(Object object, int n) {
        if (object instanceof StructureDocument) {
            StructureDocument structureDocument = (StructureDocument)object;
            return structureDocument.getStructure(n);
        }
        if (object instanceof Structure) {
            Structure structure = (Structure)object;
            StructureMap structureMap = structure.getStructureMap();
            return structureMap.getChain(n);
        }
        if (object instanceof StructureComponent) {
            StructureComponent structureComponent = (StructureComponent)object;
            String string = structureComponent.getStructureComponentType();
            if (string == StructureComponentRegistry.TYPE_CHAIN) {
                Chain chain = (Chain)structureComponent;
                return chain.getResidue(n);
            }
            if (string == StructureComponentRegistry.TYPE_RESIDUE) {
                Residue residue = (Residue)structureComponent;
                return residue.getAtom(n);
            }
            return null;
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof StructureDocument) {
            StructureDocument structureDocument = (StructureDocument)object;
            return structureDocument.getStructureCount();
        }
        if (object instanceof Structure) {
            Structure structure = (Structure)object;
            StructureMap structureMap = structure.getStructureMap();
            return structureMap.getChainCount();
        }
        if (object instanceof StructureComponent) {
            StructureComponent structureComponent = (StructureComponent)object;
            String string = structureComponent.getStructureComponentType();
            if (string == StructureComponentRegistry.TYPE_CHAIN) {
                Chain chain = (Chain)structureComponent;
                return chain.getResidueCount();
            }
            if (string == StructureComponentRegistry.TYPE_RESIDUE) {
                Residue residue = (Residue)structureComponent;
                return residue.getAtomCount();
            }
            return 0;
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof StructureDocument) {
            StructureDocument structureDocument = (StructureDocument)object;
            int n = structureDocument.getStructureCount();
            for (int i = 0; i < n; ++i) {
                if (structureDocument.getStructure(i) != object2) continue;
                return i;
            }
            return -1;
        }
        if (object instanceof Structure) {
            Structure structure = (Structure)object;
            StructureMap structureMap = structure.getStructureMap();
            Chain chain = (Chain)object2;
            return structureMap.getChainIndex(chain);
        }
        if (object instanceof StructureComponent) {
            StructureComponent structureComponent = (StructureComponent)object;
            String string = structureComponent.getStructureComponentType();
            if (string == StructureComponentRegistry.TYPE_CHAIN) {
                Chain chain = (Chain)structureComponent;
                int n = chain.getResidueCount();
                for (int i = 0; i < n; ++i) {
                    if (chain.getResidue(i) != object2) continue;
                    return i;
                }
                return -1;
            }
            if (string == StructureComponentRegistry.TYPE_RESIDUE) {
                Residue residue = (Residue)structureComponent;
                int n = residue.getAtomCount();
                for (int i = 0; i < n; ++i) {
                    if (residue.getAtom(i) != object2) continue;
                    return i;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }

    public Object getRoot() {
        return this.structureDocument;
    }

    public void setRoot(StructureDocument structureDocument) {
        StructureDocument structureDocument2 = this.structureDocument;
        this.structureDocument = structureDocument;
        if (structureDocument2 == null) {
            return;
        }
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)structureDocument, new Object[]{structureDocument2});
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(treeModelEvent);
        }
    }

    public boolean isLeaf(Object object) {
        return object instanceof Atom;
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.removeElement(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new IllegalArgumentException("TreeViewerModel.valueForPathChanged: Not implemented!");
    }
}

