/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.vis.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageUtils {
    public static BufferedImage autoCropAndScale(Image image, int n, int n2) {
        int n3;
        int n4;
        int n5;
        double d;
        double d2 = (double)n / (double)n2;
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        double d3 = (double)n6 / (double)n7;
        int[] nArray = ImageUtils.getPixels(image);
        int n8 = 0;
        int n9 = 0;
        int n10 = n6 - 1;
        int n11 = n7 - 1;
        int n12 = 0;
        int n13 = 0;
        int n14 = n - 1;
        int n15 = n2 - 1;
        int[] nArray2 = ImageUtils.findEdges(nArray, n6, n7);
        if (nArray2 != null) {
            n8 = nArray2[0];
            n9 = nArray2[1];
            n10 = nArray2[2];
            n11 = nArray2[3];
        }
        if (d2 < (d = (double)(n10 - n8) / (double)(n11 - n9))) {
            n5 = (int)((double)n / d);
            n4 = n2 - n5;
            n13 = n3 = (int)((double)n4 / 2.0);
            n15 = n13 + n5;
        } else {
            n5 = (int)((double)n2 * d);
            n4 = n - n5;
            n12 = n3 = (int)((double)n4 / 2.0);
            n14 = n12 + n5;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        n3 = ImageUtils.getPixel(nArray, n, 0, 0);
        graphics2D.setColor(new Color(n3, true));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.drawImage(image, n12, n13, n14, n15, n8, n9, n10, n11, null);
        return bufferedImage;
    }

    public static int[] getPixels(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            return null;
        }
        return nArray;
    }

    public static int getPixel(int[] nArray, int n, int n2, int n3) {
        return nArray[n3 * n + n2];
    }

    public static int[] findEdges(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = ImageUtils.getPixel(nArray, n, 0, 0);
        int[] nArray2 = new int[4];
        boolean bl = false;
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                if (ImageUtils.getPixel(nArray, n, n3, n4) == n5) continue;
                nArray2[1] = n4;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            return null;
        }
        bl = false;
        for (n4 = n2 - 1; n4 >= 0; --n4) {
            for (n3 = 0; n3 < n; ++n3) {
                if (ImageUtils.getPixel(nArray, n, n3, n4) == n5) continue;
                nArray2[3] = n4;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            return null;
        }
        bl = false;
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                if (ImageUtils.getPixel(nArray, n, n4, n3) == n5) continue;
                nArray2[0] = n4;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            return null;
        }
        bl = false;
        for (n4 = n - 1; n4 >= 0; --n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                if (ImageUtils.getPixel(nArray, n, n4, n3) == n5) continue;
                nArray2[2] = n4;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            return null;
        }
        return nArray2;
    }

    public static void main(String[] stringArray) {
        Image image = Toolkit.getDefaultToolkit().getImage(stringArray[0]);
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
        int n = Integer.parseInt(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        BufferedImage bufferedImage = ImageUtils.autoCropAndScale(image, n, n2);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(stringArray[1]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
        int n3 = 100;
        n3 = Math.max(0, Math.min(n3, 100));
        jPEGEncodeParam.setQuality((float)n3 / 100.0f, false);
        jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
        try {
            jPEGImageEncoder.encode(bufferedImage);
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

