/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.vis.viewers;

import edu.sdsc.vis.viewers.ViewerBehavior;
import edu.sdsc.vis.viewers.VirtualSphere;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ExamineViewerBehavior
extends ViewerBehavior {
    protected int previousX = 0;
    protected int previousY = 0;
    protected Cursor savedCursor = null;
    protected VirtualSphere vs = null;
    private int key_nav_rate = 20;
    private int vs_x = 0;
    private int vs_y = 0;
    private static Vector3d cameraOffset = new Vector3d(0.0, 0.0, 0.0);
    private static Vector3d cameraOffsetInv = new Vector3d(0.0, 0.0, 0.0);

    public ExamineViewerBehavior() {
        this.setup();
    }

    public ExamineViewerBehavior(Component component) {
        super(component);
        this.setup();
    }

    public ExamineViewerBehavior(TransformGroup transformGroup) {
        this.subjectTransformGroup = transformGroup;
        this.setup();
    }

    public ExamineViewerBehavior(TransformGroup transformGroup, Component component) {
        super(component);
        this.subjectTransformGroup = transformGroup;
        this.setup();
    }

    public void setup() {
        this.vs = new VirtualSphere();
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = ExamineViewerBehavior.this.parentComponent.getWidth();
                int n2 = ExamineViewerBehavior.this.parentComponent.getHeight();
                int n3 = (int)(Math.sqrt(n * n + n2 * n2) / 2.0) - 10;
                ExamineViewerBehavior.this.setCircle(n / 2, n2 / 2, n3);
            }
        };
        this.parentComponent.addComponentListener(componentAdapter);
    }

    public void setCircle(int n, int n2, int n3) {
        if (this.vs == null) {
            return;
        }
        this.vs_x = n;
        this.vs_y = n2;
        this.vs.setCircle(n, n2, n3);
    }

    public Vector3d getCameraOffset() {
        return cameraOffset;
    }

    public void setCameraOffset() {
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.invert();
        this.currentTransform.get(this.matrix);
        cameraOffset.set(0.0, 0.0, -this.matrix.m23);
        cameraOffsetInv.set(0.0, 0.0, this.matrix.m23);
    }

    public void setCameraOffset(Vector3d vector3d) {
        cameraOffset.set((Tuple3d)vector3d);
        vector3d.negate();
        cameraOffsetInv.set((Tuple3d)vector3d);
    }

    public void onButton1(MouseEvent mouseEvent) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getID() == 501) {
            this.previousX = n;
            this.previousY = n2;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(12));
            }
            return;
        }
        if (mouseEvent.getID() == 502) {
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        int n3 = n - this.previousX;
        int n4 = n2 - this.previousY;
        if (n3 > 400 || n3 < -400 || n4 > 400 || n4 < -400) {
            return;
        }
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.transform1.set(cameraOffsetInv);
        this.currentTransform.mul(this.transform1);
        this.vs.compute(n, n2, this.previousX, this.previousY);
        this.vs.t3d.invert();
        this.currentTransform.mul(this.vs.t3d);
        this.transform1.set(cameraOffset);
        this.currentTransform.mul(this.transform1);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.previousX = n;
        this.previousY = n2;
        this.fireTransform(this.currentTransform);
    }

    public void onButton2(MouseEvent mouseEvent) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getID() == 501) {
            this.previousX = n;
            this.previousY = n2;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(13));
            }
            return;
        }
        if (mouseEvent.getID() == 502) {
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        int n3 = n2 - this.previousY;
        if (n3 > 400 || n3 < -400) {
            return;
        }
        double d = (double)n3 * this.ZTranslationFactor;
        this.translate.set(0.0, 0.0, -d);
        this.transform3.set(this.translate);
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.mul(this.transform3);
        this.translate.set(0.0, 0.0, d);
        cameraOffset.sub((Tuple3d)this.translate);
        cameraOffsetInv.add((Tuple3d)this.translate);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.previousX = n;
        this.previousY = n2;
        this.fireTransform(this.currentTransform);
    }

    public void onButton3(MouseEvent mouseEvent) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getID() == 501) {
            this.previousX = n;
            this.previousY = n2;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(13));
            }
            return;
        }
        if (mouseEvent.getID() == 502) {
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        int n3 = n - this.previousX;
        int n4 = n2 - this.previousY;
        if (n3 > 400 || n3 < -400 || n4 > 400 || n4 < -400) {
            return;
        }
        double d = (double)n3 * this.XTranslationFactor;
        double d2 = (double)(-n4) * this.YTranslationFactor;
        this.translate.set(-d, -d2, 0.0);
        this.transform3.set(this.translate);
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.mul(this.transform3);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.previousX = n;
        this.previousY = n2;
        this.fireTransform(this.currentTransform);
    }

    public void onElapsedFrames(WakeupOnElapsedFrames wakeupOnElapsedFrames) {
    }
}

