/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.vis.viewers;

import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import edu.sdsc.vis.viewers.ExamineViewerBehavior;
import edu.sdsc.vis.viewers.GroupManager;
import edu.sdsc.vis.viewers.NoneViewerBehavior;
import edu.sdsc.vis.viewers.PickEvent;
import edu.sdsc.vis.viewers.PickListener;
import edu.sdsc.vis.viewers.Picker;
import edu.sdsc.vis.viewers.T3DListener;
import edu.sdsc.vis.viewers.T3DSender;
import edu.sdsc.vis.viewers.ViewerBehavior;
import edu.sdsc.vis.viewers.WalkViewerBehavior;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LinearFog;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.Raster;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class GeometryViewer
extends JPanel
implements T3DSender {
    public static final int Examine = 0;
    public static final int Walk = 1;
    public static final int None = 2;
    private int navigationType = 0;
    private boolean headlightOnOff = true;
    private DirectionalLight headlight = null;
    private Vector viewerBehaviors = new Vector();
    private ExamineViewerBehavior examineBehavior = null;
    private Background background = null;
    private Color3f backgroundColor = null;
    protected Canvas3D canvas3d = null;
    private GraphicsConfiguration graphicsConfiguration = null;
    protected BranchGroup sceneRoot = null;
    private GroupManager groupManager = null;
    private TransformGroup sceneTransform = null;
    private TransformGroup viewTransform = null;
    private SimpleUniverse universe = null;
    private Vector awtListeners = null;
    private Vector t3dListeners = null;
    private Vector pickListeners = null;
    private Picker picker = null;
    private AWTEventListener pickAwtEventListener = null;
    private PickEvent pickEvent = null;
    private Point pickPoint = null;
    private LinearFog fog = null;
    private BranchGroup fogGroup = null;
    private double fogFrontDistance = 0.0;
    private double fogBackDistance = 0.0;

    public GeometryViewer() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 1));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        graphicsConfigTemplate3D.setStereo(2);
        this.graphicsConfiguration = graphicsConfigTemplate3D.getBestConfiguration(graphicsConfigurationArray);
        this.canvas3d = new Canvas3D(this.graphicsConfiguration);
        this.add((Component)this.canvas3d);
        this.universe = new SimpleUniverse(this.canvas3d);
        ViewingPlatform viewingPlatform = this.universe.getViewingPlatform();
        this.viewTransform = viewingPlatform.getViewPlatformTransform();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
        View view = this.canvas3d.getView();
        view.setBackClipDistance(100000.0);
        PlatformGeometry platformGeometry = new PlatformGeometry();
        this.headlight = new DirectionalLight();
        this.headlight.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        this.headlight.setDirection(new Vector3f(0.0f, 0.0f, -1.0f));
        this.headlight.setInfluencingBounds((Bounds)boundingSphere);
        this.headlight.setCapability(13);
        platformGeometry.addChild((Node)this.headlight);
        viewingPlatform.setPlatformGeometry(platformGeometry);
        this.sceneRoot = new BranchGroup();
        this.sceneRoot.setBoundsAutoCompute(true);
        this.sceneRoot.setCapability(3);
        this.sceneRoot.setCapability(17);
        this.sceneTransform = new TransformGroup();
        this.sceneTransform.setCapability(17);
        this.sceneTransform.setCapability(18);
        this.sceneTransform.setCapability(14);
        this.sceneTransform.setCapability(12);
        this.sceneTransform.setCapability(13);
        this.sceneRoot.addChild((Node)this.sceneTransform);
        AWTEventListener aWTEventListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent aWTEvent) {
                GeometryViewer.this.fireAwtEvent(aWTEvent);
            }
        };
        T3DListener t3DListener = new T3DListener(){

            public void transformDispatched(Transform3D transform3D) {
                GeometryViewer.this.fireTransform(transform3D);
            }
        };
        this.examineBehavior = new ExamineViewerBehavior(this.viewTransform, (Component)this.canvas3d);
        this.examineBehavior.setSchedulingBounds((Bounds)boundingSphere);
        this.sceneRoot.addChild((Node)this.examineBehavior);
        this.examineBehavior.addEventListener(aWTEventListener);
        this.examineBehavior.addT3DListener(t3DListener);
        this.viewerBehaviors.add(this.examineBehavior);
        WalkViewerBehavior walkViewerBehavior = new WalkViewerBehavior(this.viewTransform, (Component)this.canvas3d);
        walkViewerBehavior.setSchedulingBounds((Bounds)boundingSphere);
        this.sceneRoot.addChild((Node)walkViewerBehavior);
        walkViewerBehavior.addEventListener(aWTEventListener);
        walkViewerBehavior.addT3DListener(t3DListener);
        this.viewerBehaviors.add(walkViewerBehavior);
        NoneViewerBehavior noneViewerBehavior = new NoneViewerBehavior(this.viewTransform, (Component)this.canvas3d);
        noneViewerBehavior.setSchedulingBounds((Bounds)boundingSphere);
        this.sceneRoot.addChild((Node)noneViewerBehavior);
        noneViewerBehavior.addEventListener(aWTEventListener);
        this.viewerBehaviors.add(noneViewerBehavior);
        this.setNavigationType(this.navigationType);
        this.backgroundColor = new Color3f(0.0f, 0.0f, 0.0f);
        this.background = new Background(this.backgroundColor);
        this.background.setCapability(17);
        this.background.setCapability(16);
        this.background.setApplicationBounds((Bounds)boundingSphere);
        this.sceneRoot.addChild((Node)this.background);
        this.universe.addBranchGraph(this.sceneRoot);
        this.groupManager = new GroupManager((Group)this.sceneTransform);
        this.setStereoEnable(false);
        this.setStereoEyeOffset(0.001);
        this.resetView();
    }

    public void destructor() {
    }

    private void fireAwtEvent(AWTEvent aWTEvent) {
        if (this.awtListeners == null) {
            return;
        }
        if (aWTEvent == null) {
            return;
        }
        for (int i = 0; i < this.awtListeners.size(); ++i) {
            AWTEventListener aWTEventListener = (AWTEventListener)this.awtListeners.elementAt(i);
            aWTEventListener.eventDispatched(aWTEvent);
        }
    }

    public void addViewerEventListener(AWTEventListener aWTEventListener) {
        if (this.awtListeners == null) {
            this.awtListeners = new Vector();
        }
        this.awtListeners.add(aWTEventListener);
    }

    public void removeViewerEventListener(AWTEventListener aWTEventListener) {
        this.awtListeners.remove(aWTEventListener);
        if (this.awtListeners.size() <= 0) {
            this.awtListeners = null;
        }
    }

    public void fireTransform(Transform3D transform3D) {
        if (this.t3dListeners == null) {
            return;
        }
        if (transform3D == null) {
            return;
        }
        for (int i = 0; i < this.t3dListeners.size(); ++i) {
            T3DListener t3DListener = (T3DListener)this.t3dListeners.elementAt(i);
            t3DListener.transformDispatched(transform3D);
        }
    }

    public void addT3DListener(T3DListener t3DListener) {
        if (this.t3dListeners == null) {
            this.t3dListeners = new Vector();
        }
        this.t3dListeners.addElement(t3DListener);
    }

    public void removeT3DListener(T3DListener t3DListener) {
        if (this.t3dListeners == null) {
            return;
        }
        this.t3dListeners.removeElement(t3DListener);
        if (this.t3dListeners.size() <= 0) {
            this.t3dListeners = null;
        }
    }

    public void firePickEvent(PickEvent pickEvent) {
        if (this.pickListeners == null) {
            return;
        }
        if (pickEvent == null) {
            return;
        }
        for (int i = 0; i < this.pickListeners.size(); ++i) {
            PickListener pickListener = (PickListener)this.pickListeners.elementAt(i);
            pickListener.processPickEvent(pickEvent);
        }
    }

    public void addPickListener(PickListener pickListener) {
        if (this.picker == null) {
            this.picker = new Picker(this.canvas3d, this.sceneRoot);
            this.pickEvent = new PickEvent();
            this.pickAwtEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent aWTEvent) {
                    GeometryViewer.this.doPick(aWTEvent);
                }
            };
            this.addViewerEventListener(this.pickAwtEventListener);
        }
        if (this.pickListeners == null) {
            this.pickListeners = new Vector();
        }
        this.pickListeners.addElement(pickListener);
    }

    public void doPick(AWTEvent aWTEvent) {
        if (aWTEvent == null) {
            return;
        }
        long l = aWTEvent.getID();
        if (l == 506L) {
            return;
        }
        if (l == 501L) {
            this.pickPoint = ((MouseEvent)aWTEvent).getPoint();
            return;
        }
        if (l == 502L && !this.pickPoint.equals(((MouseEvent)aWTEvent).getPoint())) {
            return;
        }
        SceneGraphPath sceneGraphPath = this.picker.pickClosest(this.pickPoint.x, this.pickPoint.y, 256);
        if (sceneGraphPath == null) {
            return;
        }
        Node node = sceneGraphPath.getObject();
        Point3d point3d = this.picker.getPickPoint();
        this.pickEvent.node = node;
        this.pickEvent.userData = node.getUserData();
        this.pickEvent.point = point3d;
        this.firePickEvent(this.pickEvent);
    }

    public void removePickListener(PickListener pickListener) {
        if (this.pickListeners == null) {
            return;
        }
        this.pickListeners.removeElement(pickListener);
        if (this.pickListeners.size() <= 0) {
            this.pickListeners = null;
            this.removeViewerEventListener(this.pickAwtEventListener);
            this.pickAwtEventListener = null;
        }
    }

    public void setStereoEyeOffset(double d) {
        PhysicalBody physicalBody = this.canvas3d.getView().getPhysicalBody();
        physicalBody.setLeftEyePosition(new Point3d(d, 0.0, 0.0));
        physicalBody.setRightEyePosition(new Point3d(-d, 0.0, 0.0));
    }

    public void setStereoEnable(boolean bl) {
        this.canvas3d.setStereoEnable(bl);
    }

    public boolean getStereoEnable() {
        return this.canvas3d.getStereoEnable();
    }

    private void initFog() {
        if (this.fog == null) {
            this.fog = new LinearFog(this.backgroundColor, this.fogFrontDistance, this.fogBackDistance);
            this.fog.setCapability(14);
            this.fog.setCapability(15);
            this.fog.setCapability(16);
            this.fog.setCapability(17);
            this.fog.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10000.0));
            this.fogGroup = new BranchGroup();
            this.fogGroup.setCapability(17);
            this.fogGroup.addChild((Node)this.fog);
        }
    }

    public void setDepthCueEnable(boolean bl) {
        if (bl) {
            if (this.getDepthCueEnable()) {
                return;
            }
            this.initFog();
            this.putTree("fog", (Group)this.fogGroup);
        } else {
            if (!this.getDepthCueEnable()) {
                return;
            }
            this.removeTree("fog");
        }
    }

    public boolean getDepthCueEnable() {
        return this.getTree("fog") != null;
    }

    public double getDepthCueFrontDistance() {
        return this.fogFrontDistance;
    }

    public void setDepthCueFrontDistance(double d) {
        this.initFog();
        this.fog.setFrontDistance(d);
        this.fogFrontDistance = d;
    }

    public double getDepthCueBackDistance() {
        return this.fogBackDistance;
    }

    public void setDepthCueBackDistance(double d) {
        this.initFog();
        this.fog.setBackDistance(d);
        this.fogBackDistance = d;
    }

    public BufferedImage getBufferedImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage);
        imageComponent2D.setCapability(4);
        Raster raster = new Raster(new Point3f(-1.0f, -1.0f, -1.0f), 1, 0, 0, n, n2, imageComponent2D, null);
        raster.setCapability(5);
        Canvas3D canvas3D = new Canvas3D(this.graphicsConfiguration, true);
        canvas3D.setOffScreenBuffer(imageComponent2D);
        canvas3D.setOffScreenLocation(0, 0);
        Screen3D screen3D = canvas3D.getScreen3D();
        screen3D.setSize(n, n2);
        screen3D.setPhysicalScreenWidth((double)n * 0.0254 / 90.0);
        screen3D.setPhysicalScreenHeight((double)n2 * 0.0254 / 90.0);
        View view = this.canvas3d.getView();
        view.stopView();
        view.addCanvas3D(canvas3D);
        view.startView();
        canvas3D.renderOffScreenBuffer();
        canvas3D.waitForOffScreenRendering();
        view.removeCanvas3D(canvas3D);
        return imageComponent2D.getImage();
    }

    public BufferedImage getBufferedImage() {
        return this.getBufferedImage(this.canvas3d.getWidth(), this.canvas3d.getHeight());
    }

    public void setHeadlightState(boolean bl) {
        this.headlightOnOff = bl;
        this.headlight.setEnable(this.headlightOnOff);
    }

    public boolean getHeadlightState() {
        return this.headlightOnOff;
    }

    public void setNavigationType(int n) {
        if (n < 0) {
            return;
        }
        int n2 = this.viewerBehaviors.size();
        if (n >= n2) {
            return;
        }
        this.navigationType = n;
        for (int i = 0; i < n2; ++i) {
            ((ViewerBehavior)((Object)this.viewerBehaviors.elementAt(i))).setEnable(false);
        }
        ((ViewerBehavior)((Object)this.viewerBehaviors.elementAt(n))).setEnable(true);
    }

    public int getNavigationType() {
        return this.navigationType;
    }

    public void setTransform(Transform3D transform3D) {
        this.viewTransform.setTransform(transform3D);
        this.fireTransform(transform3D);
    }

    public void getTransform(Transform3D transform3D) {
        this.viewTransform.getTransform(transform3D);
    }

    public void setBackgroundColor(Color3f color3f) {
        if (color3f == null) {
            this.backgroundColor.x = 0.0f;
            this.backgroundColor.y = 0.0f;
            this.backgroundColor.z = 0.0f;
        } else {
            this.backgroundColor.x = color3f.x;
            this.backgroundColor.y = color3f.y;
            this.backgroundColor.z = color3f.z;
        }
        this.background.setColor(this.backgroundColor);
        if (this.fog != null) {
            this.fog.setColor(this.backgroundColor);
        }
    }

    public void getBackgroundColor(Color3f color3f) {
        if (color3f == null) {
            color3f.x = 0.0f;
            color3f.y = 0.0f;
            color3f.z = 0.0f;
        } else {
            color3f.x = this.backgroundColor.x;
            color3f.y = this.backgroundColor.y;
            color3f.z = this.backgroundColor.z;
        }
    }

    public void resetView() {
        this.resetView((BoundingSphere)this.sceneRoot.getBounds());
    }

    public void resetView(BoundingSphere boundingSphere) {
        if (boundingSphere == null) {
            throw new NullPointerException("null BoundingSphere");
        }
        double d = boundingSphere.getRadius();
        if (d < 0.0) {
            return;
        }
        Point3d point3d = new Point3d();
        boundingSphere.getCenter(point3d);
        View view = this.canvas3d.getView();
        double d2 = view.getFieldOfView();
        double d3 = d / Math.sin(d2 / 2.0);
        double d4 = point3d.z + d3;
        Transform3D transform3D = new Transform3D();
        this.sceneTransform.setTransform(transform3D);
        transform3D.set(new Vector3d(point3d.x, point3d.y, d4));
        this.viewTransform.setTransform(transform3D);
        this.examineBehavior.setCameraOffset(new Vector3d(0.0, 0.0, d3));
        this.fireTransform(transform3D);
    }

    public void putTree(String string, Group group) {
        if (string == null) {
            return;
        }
        if (group == null) {
            return;
        }
        this.groupManager.put(string, group);
    }

    public void removeTree(String string) {
        if (string == null) {
            return;
        }
        this.groupManager.remove(string);
        if (this.groupManager.count() <= 0) {
            // empty if block
        }
    }

    public Group getTree(String string) {
        if (string == null) {
            return null;
        }
        return this.groupManager.get(string);
    }
}

