/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.vis.viewers;

import edu.sdsc.vis.viewers.T3DListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public abstract class ViewerBehavior
extends Behavior {
    public static final double DEFAULT_XROTATION_FACTOR = 0.02;
    public static final double DEFAULT_YROTATION_FACTOR = 0.005;
    public static final double DEFAULT_XTRANSLATION_FACTOR = 0.02;
    public static final double DEFAULT_YTRANSLATION_FACTOR = 0.02;
    public static final double DEFAULT_ZTRANSLATION_FACTOR = 0.1;
    protected double XRotationFactor = 0.02;
    protected double YRotationFactor = 0.005;
    protected double XTranslationFactor = 0.02;
    protected double YTranslationFactor = 0.02;
    protected double ZTranslationFactor = 0.1;
    protected TransformGroup subjectTransformGroup = null;
    protected WakeupCriterion[] wakeupCriterion = new WakeupCriterion[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(502)};
    protected WakeupOr wakeupConditions = new WakeupOr(this.wakeupCriterion);
    protected static final int BUTTONNONE = -1;
    protected static final int BUTTON1 = 0;
    protected static final int BUTTON2 = 1;
    protected static final int BUTTON3 = 2;
    protected int buttonPressed = -1;
    protected Transform3D currentTransform = new Transform3D();
    protected Transform3D transform1 = new Transform3D();
    protected Transform3D transform2 = new Transform3D();
    protected Transform3D transform3 = new Transform3D();
    protected Matrix4d matrix = new Matrix4d();
    protected Vector3d origin = new Vector3d(0.0, 0.0, 0.0);
    protected Vector3d translate = new Vector3d(0.0, 0.0, 0.0);
    protected static final int UNUSUAL_XDELTA = 400;
    protected static final int UNUSUAL_YDELTA = 400;
    protected Component parentComponent = null;
    protected Vector awtListeners = null;
    protected Vector t3dListeners = null;

    public ViewerBehavior() {
    }

    public ViewerBehavior(Component component) {
        this.parentComponent = component;
    }

    public ViewerBehavior(TransformGroup transformGroup) {
        this.subjectTransformGroup = transformGroup;
    }

    public ViewerBehavior(TransformGroup transformGroup, Component component) {
        this.subjectTransformGroup = transformGroup;
        this.parentComponent = component;
    }

    public void setTransformGroup(TransformGroup transformGroup) {
        this.subjectTransformGroup = transformGroup;
    }

    public TransformGroup getTransformGroup() {
        return this.subjectTransformGroup;
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.wakeupConditions);
    }

    public void processStimulus(Enumeration enumeration) {
        WakeupCriterion wakeupCriterion = null;
        AWTEvent[] aWTEventArray = null;
        int n = -1;
        while (enumeration.hasMoreElements()) {
            wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (wakeupCriterion instanceof WakeupOnAWTEvent) {
                aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent();
                for (int i = 0; i < aWTEventArray.length; ++i) {
                    int n2;
                    if (!(aWTEventArray[i] instanceof MouseEvent) || (n2 = aWTEventArray[i].getID()) == 501 && this.buttonPressed != -1 || n2 == 502 && this.buttonPressed == -1 || n2 == 506 && this.buttonPressed == -1) continue;
                    MouseEvent mouseEvent = (MouseEvent)aWTEventArray[i];
                    int n3 = mouseEvent.getModifiers();
                    if (this.buttonPressed == -1) {
                        n = (n3 & 4) != 0 || (n3 & 0x10) != 0 && (n3 & 2) == 2 ? 2 : ((n3 & 8) != 0 ? 1 : 0);
                        if (n2 == 501) {
                            this.buttonPressed = n;
                        }
                    } else {
                        n = this.buttonPressed;
                    }
                    switch (n) {
                        case 0: {
                            this.onButton1(mouseEvent);
                            break;
                        }
                        case 1: {
                            this.onButton2(mouseEvent);
                            break;
                        }
                        case 2: {
                            this.onButton3(mouseEvent);
                            break;
                        }
                    }
                    if (n2 == 502) {
                        this.buttonPressed = -1;
                    }
                    if (((long)n2 & 0x10L) == 0L) continue;
                    this.fireEvent(aWTEventArray[i]);
                }
                continue;
            }
            if (!(wakeupCriterion instanceof WakeupOnElapsedFrames)) continue;
            this.onElapsedFrames((WakeupOnElapsedFrames)wakeupCriterion);
        }
        this.wakeupOn((WakeupCondition)this.wakeupConditions);
    }

    public void fireEvent(AWTEvent aWTEvent) {
        if (this.awtListeners == null) {
            return;
        }
        if (aWTEvent == null) {
            return;
        }
        for (int i = 0; i < this.awtListeners.size(); ++i) {
            AWTEventListener aWTEventListener = (AWTEventListener)this.awtListeners.elementAt(i);
            aWTEventListener.eventDispatched(aWTEvent);
        }
    }

    public void addEventListener(AWTEventListener aWTEventListener) {
        if (this.awtListeners == null) {
            this.awtListeners = new Vector();
        }
        this.awtListeners.addElement(aWTEventListener);
    }

    public void removeEventListener(AWTEventListener aWTEventListener) {
        this.awtListeners.removeElement(aWTEventListener);
        if (this.awtListeners.size() <= 0) {
            this.awtListeners = null;
        }
    }

    public void fireTransform(Transform3D transform3D) {
        if (this.t3dListeners == null) {
            return;
        }
        if (transform3D == null) {
            return;
        }
        for (int i = 0; i < this.t3dListeners.size(); ++i) {
            T3DListener t3DListener = (T3DListener)this.t3dListeners.elementAt(i);
            t3DListener.transformDispatched(transform3D);
        }
    }

    public void addT3DListener(T3DListener t3DListener) {
        if (this.t3dListeners == null) {
            this.t3dListeners = new Vector();
        }
        this.t3dListeners.addElement(t3DListener);
    }

    public void removeT3DListener(T3DListener t3DListener) {
        if (this.t3dListeners == null) {
            return;
        }
        this.t3dListeners.removeElement(t3DListener);
        if (this.t3dListeners.size() <= 0) {
            this.t3dListeners = null;
        }
    }

    public void setXRotationFactor(double d) {
        this.XRotationFactor = d;
    }

    public double getXRotationFactor() {
        return this.XRotationFactor;
    }

    public void setYRotationFactor(double d) {
        this.YRotationFactor = d;
    }

    public double getYRotationFactor() {
        return this.YRotationFactor;
    }

    public void setXTranslationFactor(double d) {
        this.XTranslationFactor = d;
    }

    public double getXTranslationFactor() {
        return this.XTranslationFactor;
    }

    public void setYTranslationFactor(double d) {
        this.YTranslationFactor = d;
    }

    public double getYTranslationFactor() {
        return this.YTranslationFactor;
    }

    public void setZTranslationFactor(double d) {
        this.ZTranslationFactor = d;
    }

    public double getZTranslationFactor() {
        return this.ZTranslationFactor;
    }

    public abstract void onButton1(MouseEvent var1);

    public abstract void onButton2(MouseEvent var1);

    public abstract void onButton3(MouseEvent var1);

    public abstract void onElapsedFrames(WakeupOnElapsedFrames var1);
}

